/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray.template;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.annotations.semantic.reachability.LiveValue;
import rebound.annotations.semantic.temporal.ConstantReturnValue;
import rebound.bits.DataEncodingUtilities;
import rebound.exceptions.BinarySyntaxException;
import rebound.jagent.lib.pray.template.FileBlockInPrayTemplate;
import rebound.jagent.lib.pray.template.Group;
import rebound.text.StringUtilities;
import rebound.util.collections.CollectionUtilities;

public class PrayTemplate {
    protected List<FileBlockInPrayTemplate> fileBlocks = new ArrayList<FileBlockInPrayTemplate>();
    protected List<Group> groups = new ArrayList<Group>();
    protected File dir;
    protected String desiredOutputFile;

    public PrayTemplate() {
    }

    public PrayTemplate(File dir) {
        this();
        this.dir = dir;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PrayTemplate)) {
            return false;
        }
        PrayTemplate o = (PrayTemplate)obj;
        return CollectionUtilities.eqv(this.fileBlocks, o.fileBlocks) && CollectionUtilities.eqv(this.groups, o.groups);
    }

    @WritableValue
    @ConstantReturnValue
    @LiveValue
    public List<FileBlockInPrayTemplate> getFileBlocks() {
        return this.fileBlocks;
    }

    @WritableValue
    @ConstantReturnValue
    @LiveValue
    public List<Group> getGroups() {
        return this.groups;
    }

    public void addGroup(Group g) {
        g.setDir(this.getDir());
        this.getGroups().add(g);
    }

    public void addInline(String id, String realFilename, String prayFilename) {
        byte[] idBytes = StringUtilities.encodeTextToByteArrayReportingUnchecked(id, StandardCharsets.ISO_8859_1);
        if (idBytes.length != 4) {
            throw BinarySyntaxException.inst("Inline file block id is not 4 bytes!: " + StringUtilities.repr(id) + " \u2192 " + DataEncodingUtilities.encodeHex(idBytes, 7, " "));
        }
        this.getFileBlocks().add(new FileBlockInPrayTemplate(realFilename, idBytes, prayFilename, false));
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Group getGroup(int index) {
        return this.groups.get(index);
    }

    public int getInlineFilesCount() {
        return this.getFileBlocks().size();
    }

    public void setDir(File dir) {
        this.dir = dir;
        int i = 0;
        while (i < this.groups.size()) {
            this.groups.get(i).setDir(dir);
            ++i;
        }
    }

    public File getDir() {
        return this.dir;
    }

    public String getDesiredOutputFile() {
        return this.desiredOutputFile;
    }

    public void setDesiredOutputFile(String desiredOutputFile) {
        this.desiredOutputFile = desiredOutputFile;
    }
}

