/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray.blocks.makers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rebound.io.util.JRECompatIOUtilities;
import rebound.jagent.lib.PathBoss;
import rebound.jagent.lib.archive.CreaturesArchiveFormat;
import rebound.jagent.lib.pray.BlockHeader;
import rebound.jagent.lib.pray.InvalidNameException;
import rebound.jagent.lib.pray.JagentRecognizedPrayChunkBlockIds;
import rebound.jagent.lib.pray.blocks.MetaBlockMaker;
import rebound.jagent.lib.pray.blocks.parsers.FileBlockParser;

public class FileBlockMaker {
    public static void make(OutputStream out, File sourceFile, byte[] prayID, String prayName, boolean archiveFormatInPray) throws IOException, InvalidNameException {
        if (FileBlockParser.isNormalFileTypeBlock(JagentRecognizedPrayChunkBlockIds.lookup(prayID)) && !PathBoss.getInstance().isNameCrossplatformFriendly(prayName)) {
            throw new InvalidNameException(prayName, "characters in the name are illegal on some platforms");
        }
        File tempArchiveFile = null;
        try {
            Throwable throwable;
            if (archiveFormatInPray) {
                tempArchiveFile = File.createTempFile(sourceFile.getName(), ".creaturesarchive");
                Throwable throwable2 = null;
                throwable = null;
                try (FileInputStream filein = new FileInputStream(sourceFile);){
                    Throwable throwable3 = null;
                    Object var10_15 = null;
                    try (FileOutputStream fileout = new FileOutputStream(tempArchiveFile);){
                        CreaturesArchiveFormat.compress(filein, fileout, 9);
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
                sourceFile = tempArchiveFile;
            }
            BlockHeader header = new BlockHeader();
            header.setCompressed(false);
            header.setOriginalLength((int)sourceFile.length());
            header.setLengthInFile((int)sourceFile.length());
            header.setName(prayName);
            header.setId(prayID);
            MetaBlockMaker.writeHeader(out, header);
            throwable = null;
            Object var8_11 = null;
            try (FileInputStream filein = new FileInputStream(sourceFile);){
                JRECompatIOUtilities.pump((InputStream)filein, out);
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        finally {
            if (tempArchiveFile != null) {
                tempArchiveFile.delete();
            }
        }
    }
}

