/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterInputStream;
import rebound.bits.Bytes;
import rebound.io.util.JRECompatIOUtilities;
import rebound.jagent.lib.FormatMismatchException;
import rebound.jagent.lib.pray.Block;
import rebound.jagent.lib.pray.BlockHeader;
import rebound.jagent.lib.pray.blocks.MetaBlockParser;
import rebound.jagent.lib.pray.template.PrayTemplate;
import rebound.text.StringUtilities;

public class PrayParser {
    protected InputStream in;
    protected MetaBlockParser blars = new MetaBlockParser();
    protected PrayTemplate template = new PrayTemplate();
    protected String originalFile;
    protected static final byte[] PRAYMAGIC = new byte[]{80, 82, 65, 89};

    public void parse() throws IOException, EOFException, FileNotFoundException, FormatMismatchException {
        byte[] magic = new byte[PRAYMAGIC.length];
        try {
            JRECompatIOUtilities.readFully(this.in, magic);
        }
        catch (EOFException exc) {
            throw new FormatMismatchException("File is not a PRAY file: wrong magic.");
        }
        if (!Arrays.equals(magic, PRAYMAGIC)) {
            throw new FormatMismatchException("File is not a PRAY file: wrong magic.");
        }
        this.template = new PrayTemplate(this.template.getDir());
        BlockHeader currBlock = null;
        while ((currBlock = PrayParser.readBlockHeader(this.in)) != null) {
            ProtectiveInputStream vishnishtee = null;
            InputStream blockDataStream = null;
            vishnishtee = new ProtectiveInputStream(this.in, currBlock.getLengthInFile());
            blockDataStream = currBlock.compressed ? PrayParser.newInflaterInputStream(vishnishtee) : vishnishtee;
            this.blars.parseBlock(currBlock, blockDataStream, this.template);
            if (vishnishtee.getTally() != (long)currBlock.getLengthInFile()) {
                System.err.println("Warning: Less block data was read than is present in file.  " + currBlock.getIdTextBestEffort() + " block \"" + currBlock.getName() + "\"  specified that " + currBlock.lengthInFile + " bytes were present in the file" + (currBlock.isCompressed() ? " (" + currBlock.originalLength + " before compression)" : "") + ", but only " + vishnishtee.getTally() + " were read.  This is either a bug in Jagent, or the block (if compressed) has extra data (and thus a mismatch between the Uncompressed-Length and the true length of the data once decompressed).");
            }
            JRECompatIOUtilities.skipFully(this.in, (long)currBlock.lengthInFile - vishnishtee.getTally());
        }
    }

    public static List<Block> parseSimply(InputStream in) throws IOException, EOFException, FileNotFoundException, FormatMismatchException {
        BlockHeader header;
        byte[] magic = new byte[PRAYMAGIC.length];
        try {
            JRECompatIOUtilities.readFully(in, magic);
        }
        catch (EOFException exc) {
            throw new FormatMismatchException("File is not a PRAY file: wrong magic.");
        }
        if (!Arrays.equals(magic, PRAYMAGIC)) {
            throw new FormatMismatchException("File is not a PRAY file: wrong magic.");
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        while ((header = PrayParser.readBlockHeader(in)) != null) {
            byte[] data = new byte[header.getLengthInFile()];
            JRECompatIOUtilities.readFully(in, data);
            blocks.add(new Block(header, data));
        }
        return blocks;
    }

    public static BlockHeader readBlockHeader(InputStream in) throws IOException, FormatMismatchException {
        BlockHeader b = new BlockHeader();
        b.id = new byte[4];
        int c = in.read();
        if (c == -1) {
            return null;
        }
        b.id[0] = (byte)c;
        JRECompatIOUtilities.readFully(in, b.id, 1, 3);
        byte[] rawname = new byte[128];
        JRECompatIOUtilities.readFully(in, rawname);
        int actualLen = 128;
        int i = 0;
        while (i < 128) {
            if (rawname[i] == 0) {
                actualLen = i;
                break;
            }
            ++i;
        }
        try {
            b.name = StringUtilities.decodeTextToStringReporting(rawname, 0, actualLen, StandardCharsets.ISO_8859_1);
        }
        catch (CharacterCodingException exc) {
            b.name = StringUtilities.decodeTextToStringReplacing(rawname, 0, actualLen, StandardCharsets.ISO_8859_1);
            System.err.println("Warning: malformed or non-UTF8 block name: " + StringUtilities.repr(b.name));
        }
        b.lengthInFile = Bytes.getLittleInt(in);
        b.originalLength = Bytes.getLittleInt(in);
        int flags = Bytes.getLittleInt(in);
        b.compressed = (flags & 1) != 0;
        return b;
    }

    public static InputStream newInflaterInputStream(InputStream in) {
        return new InflaterInputStream(in);
    }

    public static InputStream newDeflaterInputStream(InputStream in) {
        return new DeflaterInputStream(in);
    }

    public InputStream getIn() {
        return this.in;
    }

    public void setIn(InputStream in) {
        this.in = in;
    }

    public void setIn(File file) throws FileNotFoundException {
        if (this.getDir() == null) {
            this.setDir(file.getAbsoluteFile().getParentFile());
        }
        this.setIn(new FileInputStream(file));
        this.originalFile = file.getName();
    }

    public void setIn(String file) throws FileNotFoundException {
        this.setIn(new File(file));
    }

    public void setDir(File dir) {
        this.getTemplate().setDir(dir);
    }

    public File getDir() {
        return this.getTemplate().getDir();
    }

    public PrayTemplate getTemplate() {
        return this.template;
    }

    protected static class ProtectiveInputStream
    extends FilterInputStream {
        protected long tally = 0L;
        protected long limit;

        public ProtectiveInputStream(InputStream in, long limit) {
            super(in);
            this.limit = limit;
        }

        @Override
        public int read() throws IOException {
            if (this.tally >= this.limit) {
                return -1;
            }
            int c = super.read();
            ++this.tally;
            return c;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.tally >= this.limit) {
                return -1;
            }
            if (this.tally + (long)len > this.limit) {
                len = (int)(this.limit - this.tally);
            }
            int amt = super.read(b, off, len);
            this.tally += (long)amt;
            return amt;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public long getTally() {
            return this.tally;
        }
    }
}

