/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.caos2pray.scanner;

import java.io.File;
import java.util.ArrayList;
import rebound.jagent.lib.caos2pray.exc.C2PSyntaxException;

public class C2PCosFile {
    protected File thisfile;
    protected ArrayList<String> stagNames;
    protected ArrayList<String> itagNames;
    protected ArrayList<String> stagVals;
    protected ArrayList<String> commands = new ArrayList();
    protected ArrayList<String[]> commandArgs = new ArrayList();
    protected ArrayList<Integer> itagVals;
    protected String caosRemoveScript;

    public C2PCosFile() {
        this.stagNames = new ArrayList();
        this.itagNames = new ArrayList();
        this.stagVals = new ArrayList();
        this.itagVals = new ArrayList();
    }

    public void addStringTag(String name, String value) {
        this.stagNames.add(name);
        this.stagVals.add(value);
    }

    public void addIntegerTag(String name, int val) {
        this.itagNames.add(name);
        this.itagVals.add(val);
    }

    public void addCommand(String cmd, String[] args) {
        this.commands.add(cmd);
        this.commandArgs.add(args);
    }

    public void setCAOSRemoveScript(String scr) {
        this.caosRemoveScript = scr;
    }

    public void removeStringTag(int index) {
        this.stagNames.remove(index);
        this.stagVals.remove(index);
    }

    public void removeIntegerTag(int index) {
        this.itagNames.remove(index);
        this.itagVals.remove(index);
    }

    public void removeCommand(int index) {
        this.commands.remove(index);
        this.commandArgs.remove(index);
    }

    public void replaceTagName(String given, String needed) {
        int i = 0;
        while (i < this.stagNames.size()) {
            if (this.stagNames.get(i).equalsIgnoreCase(given)) {
                this.stagNames.set(i, needed);
            }
            ++i;
        }
        i = 0;
        while (i < this.itagNames.size()) {
            if (this.itagNames.get(i).equalsIgnoreCase(given)) {
                this.itagNames.set(i, needed);
            }
            ++i;
        }
    }

    public int[] findCommands(String cmd) {
        int[] whole = new int[this.getCommandCount()];
        int count = 0;
        int i = 0;
        while (i < whole.length) {
            if (cmd.equalsIgnoreCase(this.getCommand(i))) {
                whole[count++] = i;
            }
            ++i;
        }
        int[] shrunk = new int[count];
        System.arraycopy(whole, 0, shrunk, 0, count);
        return shrunk;
    }

    public int getSingletonCommandIndexOf(String cmd) throws C2PSyntaxException {
        int[] cmds = this.findCommands(cmd);
        if (cmds.length == 0) {
            return -1;
        }
        if (cmds.length == 1) {
            return cmds[0];
        }
        throw new C2PSyntaxException("It is illegal to have multiple instances of the command '" + cmd + "'");
    }

    public String getCommandSingletonArg(int index) throws C2PSyntaxException {
        String[] args = this.getCommandArgs(index);
        if (args.length != 1) {
            throw new C2PSyntaxException("The " + this.getCommand(index) + " command takes exactly 1 argument.");
        }
        return args[0];
    }

    public String getCAOSRemoveScript() {
        return this.caosRemoveScript;
    }

    public int getIntegerTagCount() {
        return this.itagNames.size();
    }

    public int getStringTagCount() {
        return this.stagNames.size();
    }

    public int getIndexOfIntegerTag(String name) {
        return this.itagNames.indexOf(name);
    }

    public int getIndexOfStringTag(String name) {
        return this.stagNames.indexOf(name);
    }

    public String getIntegerTagName(int index) {
        return this.itagNames.get(index);
    }

    public String getStringTagName(int index) {
        return this.stagNames.get(index);
    }

    public int getIntegerTagValue(int index) {
        return this.itagVals.get(index);
    }

    public String getStringTagValue(int index) {
        return this.stagVals.get(index);
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    public String getCommand(int index) {
        return this.commands.get(index);
    }

    public String[] getCommandArgs(int index) {
        return this.commandArgs.get(index);
    }

    public File getThisFile() {
        return this.thisfile;
    }

    public void setThisFile(File thisfile) {
        this.thisfile = thisfile;
    }
}

