/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import rebound.exceptions.BinarySyntaxIOException;
import rebound.io.util.JRECompatIOUtilities;

public class CreaturesArchiveFormat {
    public static final byte[] HEADER = new byte[]{67, 114, 101, 97, 116, 117, 114, 101, 115, 32, 69, 118, 111, 108, 117, 116, 105, 111, 110, 32, 69, 110, 103, 105, 110, 101, 32, 45, 32, 65, 114, 99, 104, 105, 118, 101, 100, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 102, 105, 108, 101, 46, 32, 122, 76, 105, 98, 32, 49, 46, 49, 51, 32, 99, 111, 109, 112, 114, 101, 115, 115, 101, 100, 46, 26, 4};
    public static final int LEVEL_DEFAULT = 9;
    public static final int LEVEL_CAOS_SYNTAX = 6;
    public static final int LEVEL_WORLD = 5;
    public static final int LEVEL_GLST = 6;

    public static void uncompress(InputStream in, OutputStream out) throws IOException, BinarySyntaxIOException {
        byte[] h = JRECompatIOUtilities.readFullyToNew(in, HEADER.length);
        if (!Arrays.equals(h, HEADER)) {
            throw BinarySyntaxIOException.inst("CreaturesArchive File Format error, wrong magic number/string.");
        }
        InflaterInputStream inflater = new InflaterInputStream(in, new Inflater(false));
        JRECompatIOUtilities.pump((InputStream)inflater, out);
    }

    public static void compress(InputStream in, OutputStream out, int level) throws IOException {
        out.write(HEADER);
        DeflaterOutputStream deflater = new DeflaterOutputStream(out, new Deflater(level, false));
        JRECompatIOUtilities.pump(in, (OutputStream)deflater);
        deflater.finish();
        deflater.flush();
    }
}

