/*
 * Decompiled with CFR 0.152.
 */
package rebound.dataformats.json.rpslflexparser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import rebound.dataformats.json.JSONOptions;
import rebound.dataformats.json.JSONParser;
import rebound.dataformats.json.JSONParserFactory;
import rebound.dataformats.json.rpslflexparser.JSONPostScanningOperations;
import rebound.exceptions.StopIterationReturnPath;
import rebound.exceptions.TextSyntaxCheckedException;
import rebound.exceptions.TextSyntaxException;
import rebound.exceptions.UnsupportedOptionException;
import rebound.formats.json.rpslflexparser.SLFlexGeneratedJSONWCLenientBasicScanner;
import rebound.text.StringUtilities;
import rebound.text.lexing.apis.tokenless.SimpleLexerToTokenStreamAdapter;
import rebound.text.lexing.apis.tokenstream.flat.FlatlyTypedWherefulToken;
import rebound.text.lexing.apis.tokenstream.flat.util.ContiguousTokensMergingToSimpleTokenStreamDecorator;
import rebound.util.collections.SimpleIterator;

public class SLFlexBasedJSONWCParserFactory
implements JSONParserFactory {
    public static final SLFlexBasedJSONWCParserFactory Instance = new SLFlexBasedJSONWCParserFactory();

    @Override
    public JSONOptions.DecodeBigIntegersAs getDefaultBigIntegerDecoding() {
        return JSONOptions.DecodeBigIntegersAs.BigIntegers;
    }

    @Override
    public JSONParser newParser(JSONOptions nonstandardOptionsRequired) throws UnsupportedOptionException {
        return new SLFlexBasedJSONWCParser(nonstandardOptionsRequired);
    }

    public static class SLFlexBasedJSONWCParser
    implements JSONParser {
        protected final JSONOptions options;
        protected SimpleIterator<FlatlyTypedWherefulToken<SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType>> tokenStream;
        protected FlatlyTypedWherefulToken<SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType> lastTokenForErrorsInfo;

        public SLFlexBasedJSONWCParser(JSONOptions options) {
            this.options = options;
        }

        @Override
        public JSONOptions getOptions() {
            return this.options;
        }

        @Override
        public Object parse(Reader input) throws IOException, TextSyntaxCheckedException {
            try {
                SLFlexGeneratedJSONWCLenientBasicScanner rawScanner = new SLFlexGeneratedJSONWCLenientBasicScanner();
                rawScanner.setSourceAndReset(input);
                SimpleLexerToTokenStreamAdapter<SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType> sl2Raw = new SimpleLexerToTokenStreamAdapter<SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType>(rawScanner);
                EnumSet<SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType> tokenTypesToMerge = EnumSet.of(SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.String, SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.Number, SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.Whitespace, SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.SingleLineComment, SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.MultiLineComment);
                ContiguousTokensMergingToSimpleTokenStreamDecorator<Object> merging = new ContiguousTokensMergingToSimpleTokenStreamDecorator<Object>(sl2Raw, tokenTypesToMerge::contains);
                this.tokenStream = merging;
                try {
                    Object object = this.readAnyObject();
                    return object;
                }
                catch (TextSyntaxException exc) {
                    throw TextSyntaxCheckedException.inst(exc);
                }
            }
            finally {
                this.tokenStream = null;
                this.lastTokenForErrorsInfo = null;
            }
        }

        protected FlatlyTypedWherefulToken<SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType> read1() throws TextSyntaxCheckedException {
            try {
                FlatlyTypedWherefulToken<SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType> token = this.tokenStream.nextrp();
                this.lastTokenForErrorsInfo = token;
                return token;
            }
            catch (StopIterationReturnPath exc) {
                throw TextSyntaxCheckedException.inst("Premature EOF!!", exc.toException());
            }
        }

        protected Object readAnyObject() throws TextSyntaxCheckedException {
            return this.readAnyObjectPossiblyAllowingOtherwiseIllegalToken(null)[0];
        }

        protected Object[] readAnyObjectPossiblyAllowingOtherwiseIllegalToken(@Nullable SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType allowedAlienTokenType) throws TextSyntaxCheckedException {
            FlatlyTypedWherefulToken<SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType> token;
            SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType tokenType;
            do {
                if ((tokenType = (SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType)((Object)(token = this.read1()).getTokenType())) == SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.MapOpener) {
                    return new Object[]{this.readMapAfterOpener()};
                }
                if (tokenType == SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.ListOpener) {
                    return new Object[]{this.readListAfterOpener()};
                }
                if (tokenType == SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.Number) {
                    try {
                        return new Object[]{JSONPostScanningOperations.parseJSONNumber(token.getMaskedSource(), this.options.isStartingDigitlessNumbersAllowed(), this.options.isInfinitiesSupported(), this.options.isNansSupported(), this.options.getDecodeBigIntegersAs())};
                    }
                    catch (TextSyntaxCheckedException exc) {
                        throw TextSyntaxCheckedException.instPos("Syntax error parsing JSON number " + StringUtilities.repr(token.getMaskedSource()), token, exc);
                    }
                }
                if (tokenType == SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.String) {
                    try {
                        return new Object[]{JSONPostScanningOperations.descapeJSONStringContentsSurroundedByQuotes(token.getMaskedSource(), this.options.isTabsInStringsAllowed(), this.options.isMultilineStringsAllowed(), this.options.isUcs4EscapesSupported())};
                    }
                    catch (TextSyntaxCheckedException exc) {
                        throw TextSyntaxCheckedException.instPos("Syntax error parsing JSON string " + StringUtilities.repr(token.getMaskedSource()), token, exc);
                    }
                }
                if (tokenType == SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.Null) {
                    return new Object[1];
                }
                if (tokenType == SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.True) {
                    return new Object[]{true};
                }
                if (tokenType != SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.False) continue;
                return new Object[]{false};
            } while (this.checkSkippable(tokenType));
            if (tokenType == allowedAlienTokenType) {
                return new Object[]{false, allowedAlienTokenType};
            }
            throw TextSyntaxCheckedException.instPos("Illegal token encountered: " + StringUtilities.repr(token.getMaskedSource()), token);
        }

        protected boolean checkSkippable(SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType tokenType) throws TextSyntaxCheckedException {
            if (tokenType == SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.Whitespace) {
                return true;
            }
            if (tokenType == SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.MultiLineComment || tokenType == SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.SingleLineComment) {
                if (this.options.isJsonwcTypeCommentsSupported()) {
                    return true;
                }
                throw TextSyntaxCheckedException.instPos("(Valid) JSONWC Comment found, but comments are disabled!!", this.lastTokenForErrorsInfo);
            }
            return false;
        }

        protected Map<String, Object> readMapAfterOpener() throws TextSyntaxCheckedException {
            Object[] r;
            HashMap<String, Object> map = new HashMap<String, Object>();
            boolean first = true;
            block0: while ((r = this.readAnyObjectPossiblyAllowingOtherwiseIllegalToken(first || this.options.isExtraneousCommasAllowed() ? SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.MapCloser : null)).length != 2) {
                FlatlyTypedWherefulToken<SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType> token;
                SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType tokenType;
                FlatlyTypedWherefulToken<SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType> token2;
                SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType tokenType2;
                first = false;
                Object keyU = r[0];
                if (!(keyU instanceof String)) {
                    throw TextSyntaxCheckedException.instPos("Illegal token encountered in a map/dict/object, a non-String key!!: " + StringUtilities.repr(this.lastTokenForErrorsInfo.getMaskedSource()), this.lastTokenForErrorsInfo);
                }
                String key = (String)keyU;
                if (map.containsKey(key)) {
                    throw TextSyntaxCheckedException.instPos("Duplicate map/dict/object key encountered!!: " + StringUtilities.repr(key), this.lastTokenForErrorsInfo);
                }
                while ((tokenType2 = (SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType)((Object)(token2 = this.read1()).getTokenType())) != SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.MapKeyValueSeparator) {
                    if (this.checkSkippable(tokenType2)) continue;
                    throw TextSyntaxCheckedException.instPos("Illegal token encountered in a map/dict/object where a colon was expected!!: " + StringUtilities.repr(token2.getMaskedSource()), token2);
                }
                Object value = this.readAnyObject();
                map.put(key, value);
                while ((tokenType = (SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType)((Object)(token = this.read1()).getTokenType())) != SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.MapCloser) {
                    if (tokenType == SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.NonscalarDelimiter) continue block0;
                    if (this.checkSkippable(tokenType)) continue;
                    throw TextSyntaxCheckedException.instPos("Illegal token encountered in a map: " + StringUtilities.repr(token.getMaskedSource()), token);
                }
                break block0;
            }
            return map;
        }

        protected List<Object> readListAfterOpener() throws TextSyntaxCheckedException {
            Object[] r;
            ArrayList<Object> list = new ArrayList<Object>();
            boolean first = true;
            block0: while ((r = this.readAnyObjectPossiblyAllowingOtherwiseIllegalToken(first || this.options.isExtraneousCommasAllowed() ? SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.ListCloser : null)).length == 1) {
                FlatlyTypedWherefulToken<SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType> token;
                SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType tokenType;
                Object element = r[0];
                list.add(element);
                first = false;
                while ((tokenType = (SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType)((Object)(token = this.read1()).getTokenType())) != SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.ListCloser) {
                    if (tokenType == SLFlexGeneratedJSONWCLenientBasicScanner.SLFlexGeneratedJSONWCLenientBasicTokenType.NonscalarDelimiter) continue block0;
                    if (this.checkSkippable(tokenType)) continue;
                    throw TextSyntaxCheckedException.instPos("Illegal token encountered in a list: " + StringUtilities.repr(token.getMaskedSource()), token);
                }
                break block0;
            }
            return list;
        }
    }
}

