/*
 * Decompiled with CFR 0.152.
 */
package rebound.dataformats.json.rpslflexparser;

import java.math.BigInteger;
import rebound.dataformats.json.JSONOptions;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.TextSyntaxCheckedException;
import rebound.text.StringUtilities;
import rebound.util.BasicExceptionUtilities;
import rebound.util.functional.FunctionInterfaces;

public class JSONPostScanningOperations {
    public static String descapeJSONStringContentsSurroundedByQuotes(String rawStringContents, boolean tabsInStringsSupported, boolean multilineStringsSupported, boolean ucs4EscapesSupported) throws TextSyntaxCheckedException {
        if (!rawStringContents.startsWith("\"")) {
            throw TextSyntaxCheckedException.inst("Expected leading double-quote");
        }
        if (!rawStringContents.endsWith("\"")) {
            throw TextSyntaxCheckedException.inst("Expected trailing double-quote");
        }
        if (rawStringContents.length() < 2) {
            throw TextSyntaxCheckedException.inst("Expected both leading *and* trailing double-quotes!");
        }
        return JSONPostScanningOperations.descapeJSONStringContents(rawStringContents.substring(1, rawStringContents.length() - 1), tabsInStringsSupported, multilineStringsSupported, ucs4EscapesSupported);
    }

    public static String descapeJSONStringContents(String rawStringContents, boolean tabsInStringsSupported, boolean multilineStringsSupported, boolean ucs4EscapesSupported) throws TextSyntaxCheckedException {
        FunctionInterfaces.UnaryFunctionCharToBoolean validControlCharsPredicate = c -> tabsInStringsSupported && c == '\t' || multilineStringsSupported && (c == '\r' || c == '\n');
        FunctionInterfaces.UnaryFunctionCharToBoolean validityPredicateNotCountingEscapes = c -> c != '\"' && (c >= ' ' || validControlCharsPredicate.f(c));
        if (rawStringContents.indexOf(92) == -1) {
            if (!StringUtilities.isUniform((Object)rawStringContents, validityPredicateNotCountingEscapes)) {
                throw TextSyntaxCheckedException.inst("Invalid characters in JSON string!!");
            }
            return rawStringContents;
        }
        StringBuilder buff = new StringBuilder();
        int n = rawStringContents.length();
        boolean inEscape = false;
        int i = 0;
        while (i < n) {
            int v;
            String codeStr;
            char c2 = rawStringContents.charAt(i);
            if (!inEscape) {
                if (c2 == '\\') {
                    inEscape = true;
                } else {
                    if (!validityPredicateNotCountingEscapes.f(c2)) {
                        throw TextSyntaxCheckedException.inst("Invalid characters in JSON string!!");
                    }
                    buff.append(c2);
                }
                ++i;
                continue;
            }
            if (c2 == '\"' || c2 == '\\' || c2 == '/') {
                buff.append(c2);
                inEscape = false;
                ++i;
                continue;
            }
            if (c2 == 'b') {
                buff.append('\b');
                inEscape = false;
                ++i;
                continue;
            }
            if (c2 == 'f') {
                buff.append('\f');
                inEscape = false;
                ++i;
                continue;
            }
            if (c2 == 'n') {
                buff.append('\n');
                inEscape = false;
                ++i;
                continue;
            }
            if (c2 == 'r') {
                buff.append('\r');
                inEscape = false;
                ++i;
                continue;
            }
            if (c2 == 't') {
                buff.append('\t');
                inEscape = false;
                ++i;
                continue;
            }
            if (c2 == 'u') {
                if (++i + 4 > n) {
                    throw TextSyntaxCheckedException.inst("String ended in the middle of a \\u#### escape!!");
                }
                codeStr = rawStringContents.substring(i, i + 4);
                i += 4;
                try {
                    v = Integer.parseInt(codeStr, 16);
                }
                catch (NumberFormatException exc) {
                    throw TextSyntaxCheckedException.inst("Invalid hexadecimal #### in a \\u#### escape!!: " + StringUtilities.repr(codeStr));
                }
                buff.append((char)v);
                inEscape = false;
                continue;
            }
            if (c2 == 'U' && ucs4EscapesSupported) {
                if (++i + 8 > n) {
                    throw TextSyntaxCheckedException.inst("String ended in the middle of a \\U######## escape!!");
                }
                codeStr = rawStringContents.substring(i, i + 8);
                i += 8;
                try {
                    v = Integer.parseInt(codeStr, 16);
                }
                catch (NumberFormatException exc) {
                    throw TextSyntaxCheckedException.inst("Invalid hexadecimal ######## in a \\U######## escape!!: " + StringUtilities.repr(codeStr));
                }
                buff.appendCodePoint(v);
                inEscape = false;
                continue;
            }
            throw TextSyntaxCheckedException.inst("Invalid escape code!!: " + StringUtilities.repr("\\" + c2));
        }
        return buff.toString();
    }

    public static Object parseJSONNumber(String s, boolean startingDigitlessNumbersAllowed, boolean infinitiesAllowed, boolean nansAllowed, JSONOptions.DecodeBigIntegersAs decodeBigIntegersAs) throws TextSyntaxCheckedException {
        double v;
        block18: {
            if ("nan".equalsIgnoreCase(s = s.trim())) {
                if (nansAllowed) {
                    return Double.NaN;
                }
                throw TextSyntaxCheckedException.inst("NaN's are not allowed!!");
            }
            if ("inf".equalsIgnoreCase(s) || "+inf".equalsIgnoreCase(s) || "infinity".equalsIgnoreCase(s) || "+infinity".equalsIgnoreCase(s) || "\u221e".equals(s) || "+\u221e".equals(s)) {
                if (infinitiesAllowed) {
                    return Double.POSITIVE_INFINITY;
                }
                throw TextSyntaxCheckedException.inst("Infinities are not allowed!!");
            }
            if ("-inf".equalsIgnoreCase(s) || "-infinity".equalsIgnoreCase(s) || "-\u221e".equals(s)) {
                if (infinitiesAllowed) {
                    return Double.NEGATIVE_INFINITY;
                }
                throw TextSyntaxCheckedException.inst("Infinities are not allowed!!");
            }
            if (!StringUtilities.isUniform(s, "0123456789eE-+.")) {
                throw TextSyntaxCheckedException.inst("Invalid JSON number!!: " + StringUtilities.repr(s));
            }
            if (!startingDigitlessNumbersAllowed && (s.startsWith(".") || s.startsWith("-.") || s.startsWith("+."))) {
                throw TextSyntaxCheckedException.inst("Invalid JSON number, lack of initial digit before the '.' is not allowed!!: " + StringUtilities.repr(s));
            }
            if (s.startsWith("e") || s.startsWith("-e") || s.startsWith("+e") || s.startsWith("E") || s.startsWith("-E") || s.startsWith("+E")) {
                throw TextSyntaxCheckedException.inst("Invalid JSON number, lack of initial digit before the 'e'/'E' is not allowed!!: " + StringUtilities.repr(s));
            }
            if (StringUtilities.isUniform(s, "0123456789") || (s.startsWith("-") || s.startsWith("+")) && StringUtilities.isUniform(s.substring(1), "0123456789")) {
                try {
                    long v2 = Long.parseLong(s);
                    return v2;
                }
                catch (NumberFormatException exc) {
                    if (decodeBigIntegersAs == JSONOptions.DecodeBigIntegersAs.BigIntegers) {
                        return new BigInteger(s);
                    }
                    if (decodeBigIntegersAs == JSONOptions.DecodeBigIntegersAs.FloatingPoints) break block18;
                    if (decodeBigIntegersAs == JSONOptions.DecodeBigIntegersAs.SyntaxError) {
                        throw TextSyntaxCheckedException.inst("Overflow when trying to parse integer into a 64-bit two's-complement signed integer!!! O,O     (given!: " + StringUtilities.repr(s) + ")");
                    }
                    throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)decodeBigIntegersAs);
                }
            }
        }
        try {
            v = Double.parseDouble(s);
        }
        catch (NumberFormatException exc) {
            throw TextSyntaxCheckedException.inst(exc);
        }
        if (Double.isInfinite(v)) {
            throw TextSyntaxCheckedException.inst("Overflow when trying to parse into a 64-bit IEEE754 Floating-Point number!!! O,O     (given!: " + StringUtilities.repr(s) + ")");
        }
        if (Double.isNaN(v)) {
            throw new ImpossibleException();
        }
        return v;
    }
}

