/*
 * Decompiled with CFR 0.152.
 */
package rebound.dataformats.json.contrib_rpmod_stringtree;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import rebound.dataformats.json.contrib_rpmod_stringtree.JSONWriter;
import rebound.util.collections.CollectionUtilities;
import rebound.util.objectutil.BasicObjectUtilities;

public class JSONPrettyWriter
extends JSONWriter {
    private final String indent;
    private int level = 0;

    protected boolean shouldBeCompact(Object x) {
        if (x == null || x instanceof Number || x instanceof Boolean) {
            return true;
        }
        if (x instanceof CharSequence) {
            return ((CharSequence)x).length() < 60;
        }
        if (x instanceof Collection) {
            return CollectionUtilities.forAll(c -> c instanceof Number, (Collection)x) || ((Collection)x).size() < 10 && CollectionUtilities.forAll(c -> this.shouldBeCompact(c), (Collection)x);
        }
        if (x instanceof Map) {
            return ((Map)x).size() <= 2 && CollectionUtilities.forAll(c -> this.shouldBeCompact(c.getKey()) && this.shouldBeCompact(c.getValue()), ((Map)x).entrySet());
        }
        return false;
    }

    public JSONPrettyWriter(boolean emitClassName, String indent) {
        super(emitClassName);
        this.indent = indent;
    }

    public JSONPrettyWriter(String indent) {
        super(false);
        this.indent = indent;
    }

    private void indent() {
        int i = 0;
        while (i < this.level) {
            this.add(this.indent);
            ++i;
        }
    }

    private void nl() {
        this.add("\n");
        this.indent();
    }

    private void indentationIncrement() {
        ++this.level;
        this.nl();
    }

    private void indentationDecrement() {
        --this.level;
        this.nl();
    }

    @Override
    public String write(Object object) {
        this.buf.setLength(0);
        this.value(object);
        return String.valueOf(this.buf.toString().trim()) + "\n";
    }

    @Override
    protected void map(Map<String, Object> map) {
        boolean compact = this.shouldBeCompact(map);
        this.add("{");
        if (!compact) {
            this.indentationIncrement();
        }
        Set<Map.Entry<String, Object>> s = map.entrySet();
        Map.Entry[] entries = s.toArray(new Map.Entry[s.size()]);
        Arrays.sort(entries, (a, b) -> BasicObjectUtilities.cmp2(a.getKey(), b.getKey()));
        boolean first = true;
        Map.Entry[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry e = entryArray[n2];
            if (!first) {
                this.add(compact ? ", " : ",");
                if (!compact) {
                    this.nl();
                }
            } else {
                first = false;
            }
            this.value(e.getKey());
            this.add(compact ? ":" : ": ");
            this.value(e.getValue());
            ++n2;
        }
        if (!compact) {
            this.indentationDecrement();
        }
        this.add("}");
    }

    @Override
    protected void array(Collection<?> c) {
        boolean compact = this.shouldBeCompact(c);
        this.add("[");
        if (!compact) {
            this.indentationIncrement();
        }
        boolean first = true;
        for (Object e : c) {
            if (!first) {
                this.add(compact ? ", " : ",");
                if (!compact) {
                    this.nl();
                }
            } else {
                first = false;
            }
            this.value(e);
        }
        if (!compact) {
            this.indentationDecrement();
        }
        this.add("]");
    }
}

