/*
 * Decompiled with CFR 0.152.
 */
package rebound.dataformats.json;

import javax.annotation.Nonnull;
import rebound.dataformats.json.JSONOptions;
import rebound.dataformats.json.JSONParser;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.UnsupportedOptionException;

public interface JSONParserFactory {
    public JSONParser newParser(@Nonnull JSONOptions var1) throws UnsupportedOptionException;

    default public JSONParser newStandardParser() {
        try {
            return this.newParser(this.getStandardDefaultOptions());
        }
        catch (UnsupportedOptionException exc) {
            throw new ImpossibleException(exc);
        }
    }

    default public JSONOptions getStandardDefaultOptions() {
        return JSONOptions.getStandardOptions(this.getDefaultBigIntegerDecoding());
    }

    public JSONOptions.DecodeBigIntegersAs getDefaultBigIntegerDecoding();
}

