/*
 * Decompiled with CFR 0.152.
 */
package rebound.dataformats.json;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import rebound.dataformats.json.JSONOptions;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.TextSyntaxCheckedException;
import rebound.exceptions.TextSyntaxException;

public interface JSONParser {
    public JSONOptions getOptions();

    public Object parse(Reader var1) throws IOException, TextSyntaxCheckedException;

    default public Object parse(String input) throws TextSyntaxCheckedException {
        try {
            return this.parse(new StringReader(input));
        }
        catch (TextSyntaxException exc) {
            throw new ImpossibleException("Bad JSONParser impl!! (" + this.getClass().getName() + "):   " + TextSyntaxCheckedException.class.getName() + " must be used, not " + TextSyntaxException.class.getName() + "!!", exc);
        }
        catch (EOFException exc) {
            throw new ImpossibleException("Bad JSONParser impl!! (" + this.getClass().getName() + "):   EOF's *must* be reported as a syntax exception not an EOFException (which is a subclass of IOException!!)", exc);
        }
        catch (IOException exc) {
            throw new ImpossibleException(exc);
        }
    }
}

