/*
 * Decompiled with CFR 0.152.
 */
package rebound.concurrency;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import rebound.GlobalCodeMetastuffContext;
import rebound.concurrency.ConcurrencyUtilities;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.text.StringUtilities;
import rebound.util.functional.throwing.FunctionalInterfacesThrowingCheckedExceptionsStandard;

public class SimpleBackgroundThreadImpl
extends Thread
implements ConcurrencyUtilities.SimpleBackgroundThread {
    protected final FunctionalInterfacesThrowingCheckedExceptionsStandard.RunnableThrowingAnything task;
    protected final BlockingQueue<Signal> messageQueue = new ArrayBlockingQueue<Signal>(25);
    protected volatile boolean probablyRunning = false;

    public SimpleBackgroundThreadImpl(FunctionalInterfacesThrowingCheckedExceptionsStandard.RunnableThrowingAnything task) {
        this.task = task;
    }

    @Override
    public void run() {
        while (true) {
            Signal m;
            try {
                m = this.messageQueue.take();
            }
            catch (InterruptedException exc) {
                exc.printStackTrace();
                continue;
            }
            if (m == Signal.RunItAgain) {
                this.probablyRunning = true;
                try {
                    this.task.run();
                }
                catch (Throwable exc) {
                    exc.printStackTrace();
                }
                this.probablyRunning = false;
                continue;
            }
            if (m == Signal.Shutdown) {
                return;
            }
            GlobalCodeMetastuffContext.logBug(StringUtilities.repr((Object)m));
        }
    }

    @Override
    public boolean isTaskProbablyInProgress() {
        return this.probablyRunning;
    }

    @Override
    public void runAgainOrQueueThisMessageIfAlreadyRunning() {
        try {
            this.messageQueue.put(Signal.RunItAgain);
        }
        catch (InterruptedException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    @Override
    public void shutdownCleanlyWhenFinished() {
        try {
            this.messageQueue.put(Signal.Shutdown);
        }
        catch (InterruptedException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    protected static enum Signal {
        Shutdown,
        RunItAgain;

    }
}

