/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import javax.annotation.Nonnull;
import rebound.util.collections.Interval;

public final class Slice<A>
extends Interval<Slice<A>> {
    @Nonnull
    protected final A underlying;

    public Slice(@Nonnull A underlying, int offset, int length) {
        super(offset, length);
        if (underlying == null) {
            throw new NullPointerException();
        }
        this.underlying = underlying;
    }

    public static <E> Slice<E> fromRange(E underlying, int startInclusive, int endExclusive) {
        return new Slice<E>(underlying, startInclusive, endExclusive - startInclusive);
    }

    @Nonnull
    public A getUnderlying() {
        return this.underlying;
    }

    @Override
    protected Slice<A> subslice0(int offset, int length) {
        return new Slice<A>(this.underlying, this.offset + offset, length);
    }
}

