/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.classhacking.jre;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.UnreachableCodeException;
import rebound.testing.WidespreadTestingUtilities;
import rebound.util.AngryReflectionUtility;
import rebound.util.BasicExceptionUtilities;

public class ClasshackingCleaner {
    protected static final Object defaultCleaner;
    protected static final Method register;
    protected static final Method clean;

    static {
        Class cleaner = AngryReflectionUtility.forName("java.lang.ref.Cleaner");
        if (cleaner != null) {
            Class cleanable = AngryReflectionUtility.forName("java.lang.ref.Cleaner$Cleanable");
            Method create = AngryReflectionUtility.getMethod(cleaner, "create", new Class[0]);
            register = AngryReflectionUtility.getMethod(cleaner, "register", new Class[]{Object.class, Runnable.class});
            clean = AngryReflectionUtility.getMethod(cleanable, "clean", new Class[0]);
            WidespreadTestingUtilities.asrt(Modifier.isPublic(create.getModifiers()));
            WidespreadTestingUtilities.asrt(Modifier.isPublic(register.getModifiers()));
            WidespreadTestingUtilities.asrt(Modifier.isPublic(clean.getModifiers()));
            WidespreadTestingUtilities.asrt(Modifier.isStatic(create.getModifiers()));
            WidespreadTestingUtilities.asrt(!Modifier.isStatic(register.getModifiers()));
            WidespreadTestingUtilities.asrt(!Modifier.isStatic(clean.getModifiers()));
            try {
                defaultCleaner = create.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException exc) {
                throw new ImpossibleException(exc);
            }
            catch (IllegalArgumentException exc) {
                throw new ImpossibleException(exc);
            }
            catch (InvocationTargetException exc) {
                BasicExceptionUtilities.rethrowSafe(exc);
                throw new UnreachableCodeException();
            }
        } else {
            Class c = AngryReflectionUtility.forName("sun.misc.Cleaner");
            if (c != null) {
                register = AngryReflectionUtility.getMethod(c, "create", new Class[]{Object.class, Runnable.class});
                clean = AngryReflectionUtility.getMethod(c, "clean", new Class[0]);
                WidespreadTestingUtilities.asrt(Modifier.isPublic(register.getModifiers()));
                WidespreadTestingUtilities.asrt(Modifier.isPublic(clean.getModifiers()));
                WidespreadTestingUtilities.asrt(Modifier.isStatic(register.getModifiers()));
                WidespreadTestingUtilities.asrt(!Modifier.isStatic(clean.getModifiers()));
                defaultCleaner = null;
            } else {
                throw new ImpossibleException("Neither the old sun.misc.Cleaner nor the new java.lang.ref.Cleaner were found!");
            }
        }
    }

    public static Runnable register(Object referent, Runnable action) {
        Object cleanable;
        try {
            cleanable = register.invoke(defaultCleaner, referent, action);
        }
        catch (IllegalAccessException exc) {
            throw new ImpossibleException(exc);
        }
        catch (IllegalArgumentException exc) {
            throw new ImpossibleException(exc);
        }
        catch (InvocationTargetException exc) {
            BasicExceptionUtilities.rethrowSafe(exc);
            throw new UnreachableCodeException();
        }
        return () -> {
            try {
                clean.invoke(cleanable, new Object[0]);
            }
            catch (IllegalAccessException exc) {
                throw new ImpossibleException(exc);
            }
            catch (IllegalArgumentException exc) {
                throw new ImpossibleException(exc);
            }
            catch (InvocationTargetException exc) {
                BasicExceptionUtilities.rethrowSafe(exc);
                throw new UnreachableCodeException();
            }
        };
    }
}

