/*
 * Decompiled with CFR 0.152.
 */
package rebound.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import rebound.util.objectutil.JavaNamespace;

public class Compass
implements JavaNamespace {
    public static File getLocalHabitat(Class c) {
        File local = Compass.getLocalClassFile(c);
        if (local != null) {
            File habitat = local.getParentFile();
            int packageCount = Compass.countChar(c.getName(), '.');
            int i = 0;
            while (i < packageCount) {
                habitat = habitat.getParentFile();
                ++i;
            }
            return habitat;
        }
        URL u = Compass.getClassFile(c);
        if (u != null && u.getProtocol().equalsIgnoreCase("jar")) {
            String body = u.getPath();
            String jar = null;
            int ex = body.indexOf("!");
            jar = ex != -1 ? body.substring(0, ex) : body;
            if (jar.toLowerCase().startsWith("file:")) {
                jar = jar.substring(5);
            }
            try {
                jar = URLDecoder.decode(jar, "UTF-8");
            }
            catch (UnsupportedEncodingException exc) {
                throw new AssertionError((Object)"UTF-8 unsupported");
            }
            try {
                File jarfile = new File(jar);
                return jarfile.getParentFile();
            }
            catch (Exception exc) {
                return null;
            }
        }
        return null;
    }

    public static File getJarFile(Class c) {
        URL u = Compass.getClassFile(c);
        if (u != null && u.getProtocol().equalsIgnoreCase("jar")) {
            String body = u.getPath();
            String jar = null;
            int ex = body.indexOf("!");
            jar = ex != -1 ? body.substring(0, ex) : body;
            if (!jar.toLowerCase().startsWith("file:")) {
                return null;
            }
            jar = jar.substring(5);
            try {
                jar = URLDecoder.decode(jar, "UTF-8");
            }
            catch (UnsupportedEncodingException exc) {
                throw new AssertionError((Object)"UTF-8 unsupported");
            }
            try {
                return new File(jar);
            }
            catch (Exception exc) {
                return null;
            }
        }
        return null;
    }

    public static File getLocalClassFile(Class c) {
        try {
            return new File(Compass.getClassFile(c).toURI()).getCanonicalFile();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static File getLocalClassFileOrLocalJarFile(Class c) {
        File f = Compass.getJarFile(c);
        if (f == null) {
            f = Compass.getLocalClassFile(c);
        }
        return f;
    }

    public static boolean isInJar(Class c) {
        URL u = Compass.getClassFile(c);
        if (u == null) {
            return false;
        }
        return u.getProtocol().equalsIgnoreCase("jar");
    }

    public static boolean isLocal(Class c) {
        URL u = Compass.getClassFile(c);
        String protocol = u.getProtocol();
        if (protocol.equalsIgnoreCase("file")) {
            return true;
        }
        if (protocol.equalsIgnoreCase("jar")) {
            String body = u.getPath();
            String jarurl = null;
            int ex = body.indexOf("!");
            jarurl = ex != -1 ? body.substring(0, ex) : body;
            try {
                return new URL(jarurl).getProtocol().equalsIgnoreCase("file");
            }
            catch (MalformedURLException exc) {
                return jarurl.startsWith("file");
            }
        }
        return false;
    }

    public static URL getRemoteHabitat(Class c) {
        URL u = Compass.getClassFile(c);
        if (u != null && u.getProtocol().equalsIgnoreCase("jar")) {
            String body = u.getPath();
            String jarurl = null;
            int ex = body.indexOf("!");
            jarurl = ex != -1 ? body.substring(0, ex) : body;
            int lastSlash = jarurl.lastIndexOf("/");
            if (lastSlash == -1) {
                lastSlash = jarurl.lastIndexOf("\\");
            }
            String parentU = null;
            parentU = lastSlash != -1 ? jarurl.substring(0, lastSlash + 1) : jarurl;
            try {
                return new URL(parentU);
            }
            catch (MalformedURLException exc) {
                return null;
            }
        }
        return null;
    }

    public static URL getClassFile(Class c) {
        return c.getResource(String.valueOf(c.getSimpleName()) + ".class");
    }

    public static File getLocalHabitat(File classFile, String packageName) {
        File local = classFile;
        File habitat = local.getParentFile();
        int packageCount = Compass.countChar(packageName, '.') + 1;
        int i = 0;
        while (i < packageCount) {
            habitat = habitat.getParentFile();
            ++i;
        }
        return habitat;
    }

    private static int countChar(String str, char c) {
        int count = 0;
        if (str != null) {
            int i = 0;
            while (i < str.length()) {
                if (str.charAt(i) == c) {
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }
}

