/*
 * Decompiled with CFR 0.152.
 */
package rebound.util;

import java.nio.Buffer;
import rebound.util.PlatformNIOBufferUtilities;

public enum BufferAllocationType {
    JAVAHEAP,
    PREFERABLY_DIRECT,
    NECESSARILY_DIRECT_POSSIBLYEXCESSSIZE_PAGEALIGNED_GARBAGECOLLECTED,
    NECESSARILY_DIRECT_EXACTSIZE_NOTPAGEALIGNED_GARBAGECOLLECTED,
    NECESSARILY_DIRECT_EXACTSIZE_NOTPAGEALIGNED_NOTGARBAGECOLLECTED;


    public boolean isDirect() {
        return this != JAVAHEAP;
    }

    public boolean isNecessarilyDirect() {
        return this != JAVAHEAP && this != PREFERABLY_DIRECT;
    }

    public boolean isGarbageCollected() {
        return this != NECESSARILY_DIRECT_EXACTSIZE_NOTPAGEALIGNED_NOTGARBAGECOLLECTED;
    }

    public static boolean isCompatibleForPassThroughAndCopyIsNotNeeded(BufferAllocationType sourceType, BufferAllocationType requestedOutputType) {
        if (requestedOutputType == JAVAHEAP || requestedOutputType == NECESSARILY_DIRECT_EXACTSIZE_NOTPAGEALIGNED_GARBAGECOLLECTED || requestedOutputType == NECESSARILY_DIRECT_EXACTSIZE_NOTPAGEALIGNED_NOTGARBAGECOLLECTED) {
            return sourceType == requestedOutputType;
        }
        if (requestedOutputType == PREFERABLY_DIRECT) {
            return sourceType != NECESSARILY_DIRECT_EXACTSIZE_NOTPAGEALIGNED_NOTGARBAGECOLLECTED;
        }
        if (requestedOutputType == NECESSARILY_DIRECT_POSSIBLYEXCESSSIZE_PAGEALIGNED_GARBAGECOLLECTED) {
            return sourceType == requestedOutputType || sourceType == NECESSARILY_DIRECT_EXACTSIZE_NOTPAGEALIGNED_GARBAGECOLLECTED;
        }
        throw new AssertionError((Object)requestedOutputType);
    }

    public static boolean isCompatibleForPassThroughAndCopyIsNotNeeded(Buffer source, BufferAllocationType requestedOutputType) {
        return BufferAllocationType.isCompatibleForPassThroughAndCopyIsNotNeeded(PlatformNIOBufferUtilities.getBufferAllocationType(source), requestedOutputType);
    }
}

