/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.blk;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBufferUShort;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import rebound.bits.Bytes;
import rebound.exceptions.ImpossibleException;
import rebound.io.iio.RandomAccessBytes;
import rebound.io.iio.sio.RandomAccessFileWrapper;
import rebound.jagent.lib.FormatMismatchException;
import rebound.jagent.lib.blk.DataMap;
import rebound.jagent.lib.blk.ToBLKNotifee;
import rebound.util.collections.ArrayUtilities;

public class ToBLKConverter {
    protected boolean bits565 = false;
    protected BufferedImage background;
    protected ToBLKNotifee notifee;

    public int getWidthInBlocks() {
        int w = this.background.getWidth();
        int bw = w / 128;
        if (w % 128 != 0) {
            ++bw;
        }
        return bw;
    }

    public int getHeightInBlocks() {
        int h = this.background.getHeight();
        int bh = h / 128;
        if (h % 128 != 0) {
            ++bh;
        }
        return bh;
    }

    public int getBlockCount() {
        return this.getWidthInBlocks() * this.getHeightInBlocks();
    }

    public void write(File path) throws IOException, FormatMismatchException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RandomAccessFileWrapper file = new RandomAccessFileWrapper(new RandomAccessFile(path, "rw"));){
            this.write(file);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void write(RandomAccessBytes file) throws IOException, FormatMismatchException {
        this.normalizeBackground();
        if (this.notifee != null) {
            this.notifee.startBLKWriting();
        }
        DataMap map = new DataMap();
        file.setLength(0L);
        this.writeImageData(file, map);
        file.seek(0L);
        this.writeHeaders(file, map);
    }

    protected void writeHeaders(RandomAccessBytes file, DataMap map) throws IOException, FormatMismatchException {
        if (this.getWidthInBlocks() >= 65536) {
            throw new FormatMismatchException("Image is too wide (" + this.getWidthInBlocks() + " blocks) to store in a BLK (max: 65535 or 32767)");
        }
        if (this.getHeightInBlocks() >= 65536) {
            throw new FormatMismatchException("Image is too tall (" + this.getHeightInBlocks() + " blocks) to store in a BLK (max: 65535 or 32767)");
        }
        if (this.getBlockCount() >= 65536) {
            throw new FormatMismatchException("Image is too large (" + this.getWidthInBlocks() + "x" + this.getHeightInBlocks() + "=" + this.getBlockCount() + " blocks total) to store in a BLK (max: 65535 or 32767)");
        }
        int flags = 0;
        if (this.bits565) {
            flags |= 1;
        }
        Bytes.putLittleInt(file, flags);
        Bytes.putLittleShort(file, (short)this.getWidthInBlocks());
        Bytes.putLittleShort(file, (short)this.getHeightInBlocks());
        int count = this.getBlockCount();
        Bytes.putLittleShort(file, (short)count);
        int i = 0;
        while (i < count) {
            this.writeBlockHeader(file, i, map);
            ++i;
        }
    }

    protected void writeBlockHeader(RandomAccessBytes file, int blockIndex, DataMap map) throws IOException {
        int offset0 = map.offsets[blockIndex] - 4;
        Bytes.putLittleInt(file, offset0);
        short width = 128;
        short height = 128;
        Bytes.putLittleShort(file, width);
        Bytes.putLittleShort(file, height);
    }

    protected void calculateHeaderLen(DataMap map) {
        map.headersLength = 4;
        map.headersLength += 2;
        map.headersLength += 2;
        map.headersLength += 2;
        int i = 0;
        while (i < this.getBlockCount()) {
            map.headersLength += 4;
            map.headersLength += 2;
            map.headersLength += 2;
            ++i;
        }
    }

    protected void writeImageData(RandomAccessBytes file, DataMap map) throws IOException {
        this.calculateHeaderLen(map);
        file.seek(map.headersLength);
        map.offsets = new int[this.getBlockCount()];
        int i = 0;
        int blockx = 0;
        while (blockx < this.getWidthInBlocks()) {
            int blocky = 0;
            while (blocky < this.getHeightInBlocks()) {
                map.offsets[i] = (int)file.getFilePointer();
                this.writeBlock(file, blockx, blocky);
                if (this.notifee != null) {
                    this.notifee.finBLKWritingBlock(blocky * this.getWidthInBlocks() + blockx);
                }
                ++i;
                ++blocky;
            }
            ++blockx;
        }
        if (this.notifee != null) {
            this.notifee.finBLKWriting();
        }
    }

    protected void writeBlock(RandomAccessBytes file, int blockx, int blocky) throws IOException {
        int blockwidth = 0;
        int blockheight = 0;
        blockwidth = this.background.getWidth() % 128 == 0 ? 128 : (blockx == this.background.getWidth() / 128 ? this.background.getWidth() % 128 : 128);
        blockheight = this.background.getHeight() % 128 == 0 ? 128 : (blocky == this.background.getHeight() / 128 ? this.background.getHeight() % 128 : 128);
        short[] data = null;
        if (!(this.background.getRaster().getSampleModel() instanceof SinglePixelPackedSampleModel)) {
            throw new ImpossibleException("A BufferedImage of 565/555 does not have a SinglePixelPackedSampleModel?!");
        }
        DataBufferUShort db = (DataBufferUShort)this.background.getRaster().getDataBuffer();
        data = db.getData();
        byte[] rowPadding = blockwidth < 128 ? new byte[(128 - blockwidth) * 2] : null;
        int row = 0;
        while (row < blockheight) {
            int offset = (blocky * 128 + row) * this.background.getWidth() + blockx * 128;
            byte[] splitData = ArrayUtilities.splitElements16to8LE(data, offset, blockwidth);
            file.write(splitData);
            if (blockwidth < 128) {
                file.write(rowPadding);
            }
            ++row;
        }
        if (blockheight < 128) {
            byte[] bottomPadding = new byte[(128 - blockheight) * 128 * 2];
            file.write(bottomPadding);
        }
    }

    protected boolean isImageOnRightMode(BufferedImage img) {
        return this.bits565 && img.getType() == 8 || !this.bits565 && img.getType() == 9;
    }

    protected void normalizeBackground() {
        if (!this.isImageOnRightMode(this.background) || this.background.getRaster().getDataBuffer().getOffset() != 0) {
            ColorConvertOp converter = new ColorConvertOp(ColorSpace.getInstance(1000), null);
            BufferedImage converted = new BufferedImage(this.background.getWidth(), this.background.getHeight(), this.isBits565() ? 8 : 9);
            converter.filter(this.background, converted);
            this.background = converted;
        }
    }

    public boolean isBits565() {
        return this.bits565;
    }

    public void setBits565(boolean bits565) {
        this.bits565 = bits565;
    }

    public void setBackground(BufferedImage background) {
        this.background = background;
    }

    public ToBLKNotifee getNotifee() {
        return this.notifee;
    }

    public void setNotifee(ToBLKNotifee notifee) {
        this.notifee = notifee;
    }
}

