/*
 * Decompiled with CFR 0.152.
 */
package rebound.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.util.collections.ArrayListWithIdentity;
import rebound.util.collections.CollectionUtilities;
import rebound.util.collections.HashSetWithIdentity;
import rebound.util.collections.SimpleTable;
import rebound.util.collections.maps.HashMapWithIdentity;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.objectutil.JavaNamespace;

public class StandardExternalizationFormats
implements JavaNamespace {
    public static void checkExternalizedFormatVersion(int actualVersionNumber, int expectedVersionNumber) throws IOException {
        if (actualVersionNumber != expectedVersionNumber) {
            throw new InvalidExternalizationFormatDeserializationException("Got version " + actualVersionNumber + ", Expected version " + expectedVersionNumber + "  xP");
        }
    }

    public static void writeExternalList(@ReadonlyValue List list, ObjectOutput out) throws IOException {
        StandardExternalizationFormats.writeExternalCollectionUncompacted(list, out);
    }

    public static void readExternalList(@WritableValue List list, ObjectInput in) throws IOException, ClassNotFoundException {
        StandardExternalizationFormats.readExternalCollectionUncompacted(list, in);
    }

    public static void writeExternalSet(@ReadonlyValue Set set, ObjectOutput out) throws IOException {
        StandardExternalizationFormats.writeExternalCollectionUncompacted(set, out);
    }

    public static void readExternalSet(@WritableValue Set set, ObjectInput in) throws IOException, ClassNotFoundException {
        StandardExternalizationFormats.readExternalCollectionUncompacted(set, in);
    }

    public static void writeExternalCollectionUncompacted(@ReadonlyValue Collection collection, ObjectOutput out) throws IOException {
        Object[] array = collection.toArray();
        int n = array.length;
        out.writeInt(n);
        int i = 0;
        while (i < n) {
            out.writeObject(array[i]);
            ++i;
        }
    }

    public static void readExternalCollectionUncompacted(@WritableValue Collection collection, ObjectInput in) throws IOException, ClassNotFoundException {
        collection.clear();
        int size = in.readInt();
        if (size < 0) {
            throw new IllegalArgumentException("Negative collection/list element count!!");
        }
        int i = 0;
        while (i < size) {
            collection.add(in.readObject());
            ++i;
        }
    }

    public static void writeExternalMap(@ReadonlyValue Map map, ObjectOutput out) throws IOException {
        Object[] entries = map.entrySet().toArray();
        int n = entries.length;
        out.writeInt(n);
        int i = 0;
        while (i < n) {
            Map.Entry e = (Map.Entry)entries[i];
            out.writeObject(e.getKey());
            out.writeObject(e.getValue());
            ++i;
        }
    }

    public static void readExternalMap(@WritableValue Map map, ObjectInput in) throws IOException, ClassNotFoundException {
        StandardExternalizationFormats.readExternalMap(map, in, map::put);
    }

    public static void readExternalMap(@WritableValue Map map, ObjectInput in, FunctionInterfaces.BinaryProcedure<Object, Object> put) throws IOException, ClassNotFoundException {
        map.clear();
        int size = in.readInt();
        if (size < 0) {
            throw new IllegalArgumentException("Negative map entry count!!");
        }
        int i = 0;
        while (i < size) {
            put.f(in.readObject(), in.readObject());
            ++i;
        }
    }

    public static void writeExternalTable(@ReadonlyValue SimpleTable table, ObjectOutput out) throws IOException {
        out.writeInt(table.getNumberOfColumns());
        out.writeInt(table.getNumberOfRows());
        int r = 0;
        while (r < table.getNumberOfRows()) {
            int c = 0;
            while (c < table.getNumberOfColumns()) {
                out.writeObject(table.getCellContents(c, r));
                ++c;
            }
            ++r;
        }
    }

    public static void readExternalTable(@WritableValue SimpleTable table, ObjectInput in) throws IOException, ClassNotFoundException {
        int numberOfColumns = in.readInt();
        int numberOfRows = in.readInt();
        table.clearAndRedim(numberOfColumns, numberOfRows);
        int r = 0;
        while (r < numberOfRows) {
            int c = 0;
            while (c < numberOfColumns) {
                table.setCellContents(c, r, in.readObject());
                ++c;
            }
            ++r;
        }
    }

    public static List readExternalListToNewDefault(ObjectInput in) throws IOException, ClassNotFoundException {
        ArrayListWithIdentity l = new ArrayListWithIdentity();
        StandardExternalizationFormats.readExternalList(l, in);
        return l;
    }

    public static Set readExternalSetToNewDefault(ObjectInput in) throws IOException, ClassNotFoundException {
        HashSetWithIdentity s = new HashSetWithIdentity();
        StandardExternalizationFormats.readExternalSet(s, in);
        return s;
    }

    public static Collection readExternalCollectionUncompactedToNewDefault(ObjectInput in) throws IOException, ClassNotFoundException {
        ArrayListWithIdentity c = new ArrayListWithIdentity();
        StandardExternalizationFormats.readExternalCollectionUncompacted(c, in);
        return c;
    }

    public static Map readExternalMapToNewDefaultMap(ObjectInput in) throws IOException, ClassNotFoundException {
        HashMapWithIdentity m = new HashMapWithIdentity();
        StandardExternalizationFormats.readExternalMap(m, in);
        return m;
    }

    public static SimpleTable readExternalTableToNewDefault(ObjectInput in) throws IOException, ClassNotFoundException {
        SimpleTable table = CollectionUtilities.newTable();
        StandardExternalizationFormats.readExternalTable(table, in);
        return table;
    }

    public static class InvalidExternalizationFormatDeserializationException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public InvalidExternalizationFormatDeserializationException() {
        }

        public InvalidExternalizationFormatDeserializationException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidExternalizationFormatDeserializationException(String message) {
            super(message);
        }

        public InvalidExternalizationFormatDeserializationException(Throwable cause) {
            super(cause);
        }
    }
}

