/*
 * Decompiled with CFR 0.152.
 */
package rebound.bits;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Base64;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.bits.InvalidInputCharacterException;
import rebound.bits.InvalidInputCharacterExceptionWithPosition;
import rebound.exceptions.ImpossibleException;
import rebound.text.StringUtilities;
import rebound.util.collections.Slice;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.objectutil.JavaNamespace;

public class DataEncodingUtilities
implements JavaNamespace {
    public static final int HEX_UPPERCASE = 7;
    public static final int HEX_LOWERCASE = 39;

    public static boolean isHexDigit(char c) {
        return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    public static void decodeHex(@ReadonlyValue @Nonnull char[] source, int sourceOffset, int sourceLength, @WritableValue @Nonnull byte[] dest, int destOffset, int destLength, int delimiterSize) throws EOFException, InvalidInputCharacterException {
        DataEncodingUtilities.decodeHex(PrimitiveCollections.charArrayAsList(source, sourceOffset, sourceLength), PrimitiveCollections.byteArrayAsList(dest, destOffset, destLength), delimiterSize);
    }

    public static void decodeHex(@ReadonlyValue @Nonnull PrimitiveCollections.CharacterListRO source, @WritableValue @Nonnull PrimitiveCollections.ByteList dest, int delimiterSize) throws EOFException, InvalidInputCharacterException {
        int sourceLength = source.size();
        int destLength = dest.size();
        int sourcePointer = 0;
        ++delimiterSize;
        int destIndex = 0;
        char c = '\u0000';
        while (destIndex < destLength) {
            if (sourcePointer + 1 >= sourceLength) {
                throw new EOFException();
            }
            c = source.getChar(sourcePointer);
            c = (char)(c - ((c & 0x40) >> 6) * 55);
            if ((c = (char)(c << 4)) < '\u0010') {
                throw new InvalidInputCharacterExceptionWithPosition(sourcePointer);
            }
            dest.setByte(destIndex, (byte)c);
            c = source.getChar(++sourcePointer);
            c = (char)(c & 0xFFFFFFCF);
            c = (char)(c - ((c & 0x40) >> 6) * 55);
            if (c >= '\u0010') {
                throw new InvalidInputCharacterExceptionWithPosition(sourcePointer);
            }
            dest.setByte(destIndex, (byte)(dest.get(destIndex) | c));
            ++destIndex;
            sourcePointer += delimiterSize;
        }
    }

    public static void decodeHex(Reader in, OutputStream out) throws InvalidInputCharacterException, IOException {
        int v0;
        while ((v0 = in.read()) >= 0) {
            int d1;
            int d0;
            char c0 = (char)v0;
            if (c0 >= '0' && c0 <= '9') {
                d0 = c0 - 48;
            } else if (c0 >= 'a' && c0 <= 'f') {
                d0 = c0 - 97 + 10;
            } else {
                if (c0 < 'A' || c0 > 'F') continue;
                d0 = c0 - 65 + 10;
            }
            int v1 = in.read();
            char c1 = (char)v1;
            if (c1 >= '0' && c1 <= '9') {
                d1 = c1 - 48;
            } else if (c1 >= 'a' && c1 <= 'f') {
                d1 = c1 - 97 + 10;
            } else if (c1 >= 'A' && c1 <= 'F') {
                d1 = c1 - 65 + 10;
            } else {
                throw new InvalidInputCharacterException();
            }
            byte b = (byte)(d1 | d0 << 4);
            out.write(b);
        }
        return;
    }

    public static void encodeHex(byte[] source, int sourceOffset, int sourceLength, char[] dest, int destOffset, int destLength, int hexcase, int delimiterSize) {
        DataEncodingUtilities.encodeHex(PrimitiveCollections.byteArrayAsList(source, sourceOffset, sourceLength), PrimitiveCollections.charArrayAsList(dest, destOffset, destLength), hexcase, delimiterSize);
    }

    public static void encodeHex(PrimitiveCollections.ByteListRO source, @WritableValue PrimitiveCollections.CharacterList dest, int hexcase, int delimiterSize) {
        int sourceLength = source.size();
        ++delimiterSize;
        int sourceIndex = 0;
        int destIndex = 0;
        char c = '\u0000';
        while (sourceIndex < sourceLength) {
            c = (char)(source.getByte(sourceIndex) & 0xF0);
            c = (char)(c / 160 * hexcase + 48 + (c >> 4));
            dest.setChar(destIndex, c);
            c = (char)(source.getByte(sourceIndex) & 0xF);
            c = (char)(c / 10 * hexcase + 48 + c);
            dest.setChar(++destIndex, c);
            destIndex += delimiterSize;
            ++sourceIndex;
        }
    }

    public static byte[] decodeQuotedPrintable(char[] source, int offset, int length) throws InvalidInputCharacterException {
        byte[] dest = new byte[length];
        int sourceIndex = offset;
        int destIndex = 0;
        char currChar = '\u0000';
        char nextChar = '\u0000';
        char nextNextChar = '\u0000';
        while (sourceIndex - offset < length) {
            currChar = source[sourceIndex];
            if (currChar == '=') {
                if (sourceIndex + 1 - offset < length) {
                    nextChar = source[sourceIndex + 1];
                    if (nextChar == '\r') {
                        if (sourceIndex + 2 - offset < length) {
                            nextNextChar = source[sourceIndex + 2];
                            if (nextNextChar == '\n') {
                                sourceIndex += 3;
                                continue;
                            }
                            sourceIndex += 2;
                            continue;
                        }
                        sourceIndex += 2;
                        continue;
                    }
                    if (nextChar == '\n') {
                        sourceIndex += 2;
                        continue;
                    }
                    if (sourceIndex + 2 - offset < length) {
                        nextNextChar = source[sourceIndex + 2];
                        if (((nextChar = (char)(nextChar & 0xFFFFFFCF)) & 0x40) != 0) {
                            nextChar = (char)(nextChar - 55);
                        }
                        if (nextChar >= '\u0010') {
                            throw new InvalidInputCharacterExceptionWithPosition(sourceIndex + 2);
                        }
                        int n = destIndex;
                        dest[n] = (byte)(dest[n] | nextChar << 4);
                        if (((nextNextChar = (char)(nextNextChar & 0xFFFFFFCF)) & 0x40) != 0) {
                            nextNextChar = (char)(nextNextChar - 55);
                        }
                        if (nextNextChar >= '\u0010') {
                            throw new InvalidInputCharacterExceptionWithPosition(sourceIndex + 2);
                        }
                        int n2 = destIndex++;
                        dest[n2] = (byte)(dest[n2] | nextNextChar);
                        sourceIndex += 3;
                        continue;
                    }
                    sourceIndex += 2;
                    continue;
                }
                ++sourceIndex;
                continue;
            }
            if (currChar > '\u007f') {
                throw new InvalidInputCharacterExceptionWithPosition(sourceIndex);
            }
            dest[destIndex] = (byte)(currChar & 0x7F);
            ++destIndex;
            ++sourceIndex;
        }
        byte[] packed = null;
        packed = new byte[destIndex];
        System.arraycopy(dest, 0, packed, 0, destIndex);
        return packed;
    }

    public static String encodeBinary(byte[] data, int dataOffsetInBytes, int dataLengthInBytes, int lengthInBits, String byteDelimiter) {
        if (lengthInBits > data.length * 8) {
            throw new IllegalArgumentException("more bits specified than there is data!");
        }
        StringBuilder buff = new StringBuilder();
        int len = 0;
        int i = 0;
        while (i < dataLengthInBytes) {
            int b = 0;
            while (b < 8) {
                if (len >= lengthInBits) {
                    return buff.toString();
                }
                boolean bit = (data[dataOffsetInBytes + i] & 1 << b) != 0;
                buff.append(bit ? (char)'1' : '0');
                ++len;
                ++b;
            }
            if (byteDelimiter != null && byteDelimiter.length() != 0 && i < dataLengthInBytes - 1) {
                buff.append(byteDelimiter);
            }
            ++i;
        }
        if (len < lengthInBits) {
            throw new AssertionError();
        }
        return buff.toString();
    }

    public static String encodeBinary(byte[] data, int dataOffsetInBytes, int dataLengthInBytes, String byteDelimiter) {
        return DataEncodingUtilities.encodeBinary(data, dataOffsetInBytes, dataLengthInBytes, dataLengthInBytes * 8, byteDelimiter);
    }

    public static String encodeBinary(byte[] data, int dataOffsetInBytes, int dataLengthInBytes) {
        return DataEncodingUtilities.encodeBinary(data, dataOffsetInBytes, dataLengthInBytes, dataLengthInBytes * 8, " ");
    }

    public static String encodeBinary(byte[] data, int lengthInBits, String byteDelimiter) {
        return DataEncodingUtilities.encodeBinary(data, 0, data.length, lengthInBits, byteDelimiter);
    }

    public static String encodeBinary(byte[] data, int lengthInBits) {
        return DataEncodingUtilities.encodeBinary(data, lengthInBits, " ");
    }

    public static String encodeBinary(byte[] data) {
        return DataEncodingUtilities.encodeBinary(data, data.length * 8);
    }

    public static String encodeBinary(Iterable<Boolean> data) {
        return StringUtilities.mapToString(b -> Character.valueOf(b != false ? (char)'1' : (char)'0'), data);
    }

    public static PrimitiveCollections.BooleanList decodeBinary(String encoded) {
        PrimitiveCollections.BooleanList l = PrimitiveCollections.newBooleanList();
        StringUtilities.forEach(c -> {
            if (c == '0') {
                l.add(false);
            } else if (c == '1') {
                l.add(true);
            }
        }, encoded);
        return l;
    }

    public static String encodeHexNoDelimiter(Slice<byte[]> source, int hexcase) {
        return DataEncodingUtilities.encodeHexNoDelimiter(PrimitiveCollections.byteArrayAsList(source), hexcase);
    }

    public static String encodeHex(Slice<byte[]> source, int hexcase, @Nullable String delimiter) {
        return DataEncodingUtilities.encodeHex(PrimitiveCollections.byteArrayAsList(source), hexcase, delimiter);
    }

    public static String encodeHex(Slice<byte[]> source, int hexcase, @Nullable char[] delimiter) {
        return DataEncodingUtilities.encodeHex(PrimitiveCollections.byteArrayAsList(source), hexcase, delimiter);
    }

    public static String encodeHexNoDelimiter(PrimitiveCollections.ByteList source, int hexcase) {
        return DataEncodingUtilities.encodeHex(source, hexcase, null);
    }

    public static String encodeHex(PrimitiveCollections.ByteList source, int hexcase, @Nullable String delimiter) {
        return DataEncodingUtilities.encodeHex(source, hexcase, delimiter == null ? null : delimiter.toCharArray());
    }

    public static String encodeHex(PrimitiveCollections.ByteList source, int hexcase, @Nullable char[] delimiter) {
        PrimitiveCollections.CharacterList dest;
        block3: {
            int delimiterSize;
            int sourceLength;
            block2: {
                sourceLength = source.size();
                delimiterSize = delimiter == null ? 0 : delimiter.length;
                dest = PrimitiveCollections.charArrayAsList(new char[DataEncodingUtilities.getHexTextlenFromDatalen(sourceLength, delimiterSize)]);
                DataEncodingUtilities.encodeHex(source, dest, hexcase, delimiterSize);
                if (delimiterSize <= 1) break block2;
                int i = 0;
                while (i < sourceLength - 1) {
                    System.arraycopy(delimiter, 0, dest, i * (2 + delimiterSize) + 2, delimiter.length);
                    ++i;
                }
                break block3;
            }
            if (delimiterSize != 1) break block3;
            char delimiterChar = delimiter[0];
            int i = 0;
            while (i < sourceLength - 1) {
                dest.setChar(i * (2 + delimiterSize) + 2, delimiterChar);
                ++i;
            }
        }
        return StringUtilities.newString(dest.toCharArraySlicePossiblyLive());
    }

    public static PrimitiveCollections.ImmutableByteArrayList decodeHex(@Nonnull PrimitiveCollections.CharacterList source, int delimiterSize) throws EOFException, InvalidInputCharacterException {
        int length = DataEncodingUtilities.getHexDatalenFromTextlen(source.size(), delimiterSize);
        byte[] a = new byte[length];
        DataEncodingUtilities.decodeHex(source, PrimitiveCollections.byteArrayAsList(a), delimiterSize);
        return PrimitiveCollections.ImmutableByteArrayList.newLIVE(a);
    }

    public static PrimitiveCollections.ImmutableByteArrayList decodeHexToList(@Nonnull String source, int delimiterSize) throws EOFException, InvalidInputCharacterException {
        return DataEncodingUtilities.decodeHex(PrimitiveCollections.stringToList(source), delimiterSize);
    }

    public static PrimitiveCollections.ImmutableByteArrayList decodeHexMandatoryToList(String source, int delimiterSize) throws ImpossibleException {
        try {
            return DataEncodingUtilities.decodeHexToList(source, delimiterSize);
        }
        catch (EOFException exc) {
            throw new ImpossibleException(exc);
        }
        catch (InvalidInputCharacterException exc) {
            throw new ImpossibleException(exc);
        }
    }

    public static String encodeHexNoDelimiter(byte[] source, int hexcase) {
        return DataEncodingUtilities.encodeHex(source, 0, source.length, hexcase, null);
    }

    public static String encodeHexNoDelimiter(byte[] source, int sourceOffset, int sourceLength, int hexcase) {
        return DataEncodingUtilities.encodeHex(source, sourceOffset, sourceLength, hexcase, null);
    }

    public static String encodeHex(byte[] source, int hexcase, @Nullable String delimiter) {
        return DataEncodingUtilities.encodeHex(source, 0, source.length, hexcase, delimiter);
    }

    public static String encodeHex(byte[] source, int sourceOffset, int sourceLength, int hexcase, @Nullable String delimiter) {
        return DataEncodingUtilities.encodeHex(source, sourceOffset, sourceLength, hexcase, delimiter == null ? null : delimiter.toCharArray());
    }

    public static String encodeHex(byte[] source, int hexcase, @Nullable char[] delimiter) {
        return DataEncodingUtilities.encodeHex(source, 0, source.length, hexcase, delimiter);
    }

    public static String encodeHex(byte[] source, int sourceOffset, int sourceLength, int hexcase, @Nullable char[] delimiter) {
        char[] dest;
        block3: {
            int delimiterSize;
            block2: {
                delimiterSize = delimiter == null ? 0 : delimiter.length;
                dest = new char[DataEncodingUtilities.getHexTextlenFromDatalen(sourceLength, delimiterSize)];
                DataEncodingUtilities.encodeHex(source, sourceOffset, sourceLength, dest, 0, dest.length, hexcase, delimiterSize);
                if (delimiterSize <= 1) break block2;
                int i = 0;
                while (i < sourceLength - 1) {
                    System.arraycopy(delimiter, 0, dest, i * (2 + delimiterSize) + 2, delimiter.length);
                    ++i;
                }
                break block3;
            }
            if (delimiterSize != 1) break block3;
            char delimiterChar = delimiter[0];
            int i = 0;
            while (i < sourceLength - 1) {
                dest[i * (2 + delimiterSize) + 2] = delimiterChar;
                ++i;
            }
        }
        return new String(dest);
    }

    public static byte[] decodeHex(@Nonnull char[] source, int sourceOffset, int sourceLength, int delimiterSize) throws EOFException, InvalidInputCharacterException {
        int length = DataEncodingUtilities.getHexDatalenFromTextlen(sourceLength, delimiterSize);
        byte[] dest = new byte[length];
        DataEncodingUtilities.decodeHex(source, sourceOffset, sourceLength, dest, 0, length, delimiterSize);
        return dest;
    }

    public static byte[] decodeHex(@Nonnull String source, int delimiterSize) throws EOFException, InvalidInputCharacterException {
        return DataEncodingUtilities.decodeHex(source.toCharArray(), 0, source.length(), delimiterSize);
    }

    public static byte[] decodeHexMandatory(String source, int delimiterSize) throws ImpossibleException {
        try {
            return DataEncodingUtilities.decodeHex(source, delimiterSize);
        }
        catch (EOFException exc) {
            throw new ImpossibleException(exc);
        }
        catch (InvalidInputCharacterException exc) {
            throw new ImpossibleException(exc);
        }
    }

    public static byte[] decodeHexNoDelimiter(@Nonnull String source) throws EOFException, InvalidInputCharacterException {
        return DataEncodingUtilities.decodeHex(source, 0);
    }

    public static byte[] decodeHexMandatoryNoDelimiter(String source) throws ImpossibleException {
        return DataEncodingUtilities.decodeHexMandatory(source, 0);
    }

    public static PrimitiveCollections.ImmutableByteArrayList decodeHexMandatoryNoDelimiterToList(String source) throws ImpossibleException {
        return DataEncodingUtilities.decodeHexMandatoryToList(source, 0);
    }

    public static byte[] decodeQuotedPrintable(String source) throws InvalidInputCharacterException {
        char[] charArray = source.toCharArray();
        return DataEncodingUtilities.decodeQuotedPrintable(charArray, 0, charArray.length);
    }

    public static int getHexDatalenFromTextlen(int textLength, int delimiterSize) {
        return textLength / (2 + delimiterSize) + (textLength % (2 + delimiterSize) == 0 ? 0 : 1);
    }

    public static int getHexTextlenFromDatalen(int dataLength, int delimiterSize) {
        return dataLength == 0 ? 0 : dataLength * (2 + delimiterSize) - delimiterSize;
    }

    protected static String getUnicodeEscape(char c) {
        char[] escape = new char[]{'\\', 'u', Character.forDigit((c & 0xF000) >> 12, 16), Character.forDigit((c & 0xF00) >> 8, 16), Character.forDigit((c & 0xF0) >> 4, 16), Character.forDigit((c & 0xF) >> 0, 16)};
        return new String(escape);
    }

    public static String encodeBase64Standard(PrimitiveCollections.ByteList bytes) {
        return DataEncodingUtilities.encodeBase64(Base64.getEncoder(), bytes);
    }

    public static PrimitiveCollections.ImmutableByteArrayList decodeBase64Standard(String str) {
        return DataEncodingUtilities.decodeBase64(Base64.getDecoder(), str);
    }

    public static String encodeBase64URL(PrimitiveCollections.ByteList bytes) {
        return DataEncodingUtilities.encodeBase64(Base64.getUrlEncoder(), bytes);
    }

    public static PrimitiveCollections.ImmutableByteArrayList decodeBase64URL(String str) {
        return DataEncodingUtilities.decodeBase64(Base64.getUrlDecoder(), str);
    }

    public static String encodeBase64MIME(PrimitiveCollections.ByteList bytes) {
        return DataEncodingUtilities.encodeBase64(Base64.getMimeEncoder(), bytes);
    }

    public static PrimitiveCollections.ImmutableByteArrayList decodeBase64MIME(String str) {
        return DataEncodingUtilities.decodeBase64(Base64.getMimeDecoder(), str);
    }

    public static String encodeBase64(Base64.Encoder coder, PrimitiveCollections.ByteList bytes) {
        if (bytes instanceof PrimitiveCollections.ImmutableByteArrayList) {
            return coder.encodeToString(((PrimitiveCollections.ImmutableByteArrayList)bytes).getREADONLYLiveWholeArrayBackingUNSAFE());
        }
        return coder.encodeToString(bytes.toByteArrayPossiblyLive());
    }

    public static PrimitiveCollections.ImmutableByteArrayList decodeBase64(Base64.Decoder coder, String s) {
        return PrimitiveCollections.ImmutableByteArrayList.newLIVE(coder.decode(s));
    }
}

