/*
 * Decompiled with CFR 0.152.
 */
package rebound.bits;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import rebound.bits.BitUtilities;
import rebound.bits.Endianness;
import rebound.io.iio.InputByteStream;
import rebound.io.iio.OutputByteStream;
import rebound.io.streaming.api.StreamAPIs;
import rebound.util.BasicExceptionUtilities;
import rebound.util.collections.Slice;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.objectutil.JavaNamespace;

public class Bytes
implements JavaNamespace {
    public static byte getByte(InputStream source) throws IOException, EOFException {
        int v = source.read();
        if (v == -1) {
            throw new EOFException();
        }
        return (byte)v;
    }

    public static byte getByte(InputByteStream source) throws IOException, EOFException {
        int v = source.read();
        if (v == -1) {
            throw new EOFException();
        }
        return (byte)v;
    }

    public static byte getByte(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        byte v = source.read();
        if (v == -1) {
            throw new EOFException();
        }
        return v;
    }

    public static char getLittleChar(byte[] source) {
        char rv = '\u0000';
        rv = (char)(rv | (source[0] & 0xFF) << 0);
        rv = (char)(rv | (source[1] & 0xFF) << 8);
        return rv;
    }

    public static char getLittleChar(byte[] source, int offset) {
        char rv = '\u0000';
        rv = (char)(rv | (source[offset + 0] & 0xFF) << 0);
        rv = (char)(rv | (source[offset + 1] & 0xFF) << 8);
        return rv;
    }

    public static char getLittleChar(Slice<byte[]> source) {
        char rv = '\u0000';
        rv = (char)(rv | (source.getUnderlying()[source.getOffset() + 0] & 0xFF) << 0);
        rv = (char)(rv | (source.getUnderlying()[source.getOffset() + 1] & 0xFF) << 8);
        return rv;
    }

    public static char getLittleChar(Slice<byte[]> source, int offset) {
        char rv = '\u0000';
        rv = (char)(rv | (source.getUnderlying()[source.getOffset() + offset + 0] & 0xFF) << 0);
        rv = (char)(rv | (source.getUnderlying()[source.getOffset() + offset + 1] & 0xFF) << 8);
        return rv;
    }

    public static char getLittleChar(PrimitiveCollections.ByteList source) {
        char rv = '\u0000';
        rv = (char)(rv | (source.getByte(0) & 0xFF) << 0);
        rv = (char)(rv | (source.getByte(1) & 0xFF) << 8);
        return rv;
    }

    public static char getLittleChar(PrimitiveCollections.ByteList source, int offset) {
        char rv = '\u0000';
        rv = (char)(rv | (source.getByte(offset + 0) & 0xFF) << 0);
        rv = (char)(rv | (source.getByte(offset + 1) & 0xFF) << 8);
        return rv;
    }

    public static char getLittleChar(InputStream source) throws IOException, EOFException {
        char rv = '\u0000';
        rv = (char)(rv | (Bytes.getByte(source) & 0xFF) << 0);
        rv = (char)(rv | (Bytes.getByte(source) & 0xFF) << 8);
        return rv;
    }

    public static char getLittleChar(InputByteStream source) throws IOException, EOFException {
        char rv = '\u0000';
        rv = (char)(rv | (Bytes.getByte(source) & 0xFF) << 0);
        rv = (char)(rv | (Bytes.getByte(source) & 0xFF) << 8);
        return rv;
    }

    public static char getLittleChar(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        char rv = '\u0000';
        rv = (char)(rv | (Bytes.getByte(source) & 0xFF) << 0);
        rv = (char)(rv | (Bytes.getByte(source) & 0xFF) << 8);
        return rv;
    }

    public static short getLittleShort(byte[] source) {
        short rv = 0;
        rv = (short)(rv | (source[0] & 0xFF) << 0);
        rv = (short)(rv | (source[1] & 0xFF) << 8);
        return rv;
    }

    public static short getLittleShort(byte[] source, int offset) {
        short rv = 0;
        rv = (short)(rv | (source[offset + 0] & 0xFF) << 0);
        rv = (short)(rv | (source[offset + 1] & 0xFF) << 8);
        return rv;
    }

    public static short getLittleShort(Slice<byte[]> source) {
        short rv = 0;
        rv = (short)(rv | (source.getUnderlying()[source.getOffset() + 0] & 0xFF) << 0);
        rv = (short)(rv | (source.getUnderlying()[source.getOffset() + 1] & 0xFF) << 8);
        return rv;
    }

    public static short getLittleShort(Slice<byte[]> source, int offset) {
        short rv = 0;
        rv = (short)(rv | (source.getUnderlying()[source.getOffset() + offset + 0] & 0xFF) << 0);
        rv = (short)(rv | (source.getUnderlying()[source.getOffset() + offset + 1] & 0xFF) << 8);
        return rv;
    }

    public static short getLittleShort(PrimitiveCollections.ByteList source) {
        short rv = 0;
        rv = (short)(rv | (source.getByte(0) & 0xFF) << 0);
        rv = (short)(rv | (source.getByte(1) & 0xFF) << 8);
        return rv;
    }

    public static short getLittleShort(PrimitiveCollections.ByteList source, int offset) {
        short rv = 0;
        rv = (short)(rv | (source.getByte(offset + 0) & 0xFF) << 0);
        rv = (short)(rv | (source.getByte(offset + 1) & 0xFF) << 8);
        return rv;
    }

    public static short getLittleShort(InputStream source) throws IOException, EOFException {
        short rv = 0;
        rv = (short)(rv | (Bytes.getByte(source) & 0xFF) << 0);
        rv = (short)(rv | (Bytes.getByte(source) & 0xFF) << 8);
        return rv;
    }

    public static short getLittleShort(InputByteStream source) throws IOException, EOFException {
        short rv = 0;
        rv = (short)(rv | (Bytes.getByte(source) & 0xFF) << 0);
        rv = (short)(rv | (Bytes.getByte(source) & 0xFF) << 8);
        return rv;
    }

    public static short getLittleShort(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        short rv = 0;
        rv = (short)(rv | (Bytes.getByte(source) & 0xFF) << 0);
        rv = (short)(rv | (Bytes.getByte(source) & 0xFF) << 8);
        return rv;
    }

    public static int getLittleUInt24(byte[] source) {
        int rv = 0;
        rv |= (source[0] & 0xFF) << 0;
        rv |= (source[1] & 0xFF) << 8;
        return rv |= (source[2] & 0xFF) << 16;
    }

    public static int getLittleUInt24(byte[] source, int offset) {
        int rv = 0;
        rv |= (source[offset + 0] & 0xFF) << 0;
        rv |= (source[offset + 1] & 0xFF) << 8;
        return rv |= (source[offset + 2] & 0xFF) << 16;
    }

    public static int getLittleUInt24(Slice<byte[]> source) {
        int rv = 0;
        rv |= (source.getUnderlying()[source.getOffset() + 0] & 0xFF) << 0;
        rv |= (source.getUnderlying()[source.getOffset() + 1] & 0xFF) << 8;
        return rv |= (source.getUnderlying()[source.getOffset() + 2] & 0xFF) << 16;
    }

    public static int getLittleUInt24(Slice<byte[]> source, int offset) {
        int rv = 0;
        rv |= (source.getUnderlying()[source.getOffset() + offset + 0] & 0xFF) << 0;
        rv |= (source.getUnderlying()[source.getOffset() + offset + 1] & 0xFF) << 8;
        return rv |= (source.getUnderlying()[source.getOffset() + offset + 2] & 0xFF) << 16;
    }

    public static int getLittleUInt24(PrimitiveCollections.ByteList source) {
        int rv = 0;
        rv |= (source.getByte(0) & 0xFF) << 0;
        rv |= (source.getByte(1) & 0xFF) << 8;
        return rv |= (source.getByte(2) & 0xFF) << 16;
    }

    public static int getLittleUInt24(PrimitiveCollections.ByteList source, int offset) {
        int rv = 0;
        rv |= (source.getByte(offset + 0) & 0xFF) << 0;
        rv |= (source.getByte(offset + 1) & 0xFF) << 8;
        return rv |= (source.getByte(offset + 2) & 0xFF) << 16;
    }

    public static int getLittleUInt24(InputStream source) throws IOException, EOFException {
        int rv = 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 8;
        return rv |= (Bytes.getByte(source) & 0xFF) << 16;
    }

    public static int getLittleUInt24(InputByteStream source) throws IOException, EOFException {
        int rv = 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 8;
        return rv |= (Bytes.getByte(source) & 0xFF) << 16;
    }

    public static int getLittleUInt24(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        int rv = 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 8;
        return rv |= (Bytes.getByte(source) & 0xFF) << 16;
    }

    public static int getLittleInt(byte[] source) {
        int rv = 0;
        rv |= (source[0] & 0xFF) << 0;
        rv |= (source[1] & 0xFF) << 8;
        rv |= (source[2] & 0xFF) << 16;
        return rv |= (source[3] & 0xFF) << 24;
    }

    public static int getLittleInt(byte[] source, int offset) {
        int rv = 0;
        rv |= (source[offset + 0] & 0xFF) << 0;
        rv |= (source[offset + 1] & 0xFF) << 8;
        rv |= (source[offset + 2] & 0xFF) << 16;
        return rv |= (source[offset + 3] & 0xFF) << 24;
    }

    public static int getLittleInt(Slice<byte[]> source) {
        int rv = 0;
        rv |= (source.getUnderlying()[source.getOffset() + 0] & 0xFF) << 0;
        rv |= (source.getUnderlying()[source.getOffset() + 1] & 0xFF) << 8;
        rv |= (source.getUnderlying()[source.getOffset() + 2] & 0xFF) << 16;
        return rv |= (source.getUnderlying()[source.getOffset() + 3] & 0xFF) << 24;
    }

    public static int getLittleInt(Slice<byte[]> source, int offset) {
        int rv = 0;
        rv |= (source.getUnderlying()[source.getOffset() + offset + 0] & 0xFF) << 0;
        rv |= (source.getUnderlying()[source.getOffset() + offset + 1] & 0xFF) << 8;
        rv |= (source.getUnderlying()[source.getOffset() + offset + 2] & 0xFF) << 16;
        return rv |= (source.getUnderlying()[source.getOffset() + offset + 3] & 0xFF) << 24;
    }

    public static int getLittleInt(PrimitiveCollections.ByteList source) {
        int rv = 0;
        rv |= (source.getByte(0) & 0xFF) << 0;
        rv |= (source.getByte(1) & 0xFF) << 8;
        rv |= (source.getByte(2) & 0xFF) << 16;
        return rv |= (source.getByte(3) & 0xFF) << 24;
    }

    public static int getLittleInt(PrimitiveCollections.ByteList source, int offset) {
        int rv = 0;
        rv |= (source.getByte(offset + 0) & 0xFF) << 0;
        rv |= (source.getByte(offset + 1) & 0xFF) << 8;
        rv |= (source.getByte(offset + 2) & 0xFF) << 16;
        return rv |= (source.getByte(offset + 3) & 0xFF) << 24;
    }

    public static int getLittleInt(InputStream source) throws IOException, EOFException {
        int rv = 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 8;
        rv |= (Bytes.getByte(source) & 0xFF) << 16;
        return rv |= (Bytes.getByte(source) & 0xFF) << 24;
    }

    public static int getLittleInt(InputByteStream source) throws IOException, EOFException {
        int rv = 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 8;
        rv |= (Bytes.getByte(source) & 0xFF) << 16;
        return rv |= (Bytes.getByte(source) & 0xFF) << 24;
    }

    public static int getLittleInt(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        int rv = 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 8;
        rv |= (Bytes.getByte(source) & 0xFF) << 16;
        return rv |= (Bytes.getByte(source) & 0xFF) << 24;
    }

    public static long getLittleULong40(byte[] source) {
        long rv = 0L;
        rv |= ((long)source[0] & 0xFFL) << 0;
        rv |= ((long)source[1] & 0xFFL) << 8;
        rv |= ((long)source[2] & 0xFFL) << 16;
        rv |= ((long)source[3] & 0xFFL) << 24;
        return rv |= ((long)source[4] & 0xFFL) << 32;
    }

    public static long getLittleULong40(byte[] source, int offset) {
        long rv = 0L;
        rv |= ((long)source[offset + 0] & 0xFFL) << 0;
        rv |= ((long)source[offset + 1] & 0xFFL) << 8;
        rv |= ((long)source[offset + 2] & 0xFFL) << 16;
        rv |= ((long)source[offset + 3] & 0xFFL) << 24;
        return rv |= ((long)source[offset + 4] & 0xFFL) << 32;
    }

    public static long getLittleULong40(Slice<byte[]> source) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 0] & 0xFFL) << 0;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 1] & 0xFFL) << 8;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 2] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 3] & 0xFFL) << 24;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + 4] & 0xFFL) << 32;
    }

    public static long getLittleULong40(Slice<byte[]> source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 0] & 0xFFL) << 0;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 1] & 0xFFL) << 8;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 2] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 3] & 0xFFL) << 24;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 4] & 0xFFL) << 32;
    }

    public static long getLittleULong40(PrimitiveCollections.ByteList source) {
        long rv = 0L;
        rv |= ((long)source.getByte(0) & 0xFFL) << 0;
        rv |= ((long)source.getByte(1) & 0xFFL) << 8;
        rv |= ((long)source.getByte(2) & 0xFFL) << 16;
        rv |= ((long)source.getByte(3) & 0xFFL) << 24;
        return rv |= ((long)source.getByte(4) & 0xFFL) << 32;
    }

    public static long getLittleULong40(PrimitiveCollections.ByteList source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getByte(offset + 0) & 0xFFL) << 0;
        rv |= ((long)source.getByte(offset + 1) & 0xFFL) << 8;
        rv |= ((long)source.getByte(offset + 2) & 0xFFL) << 16;
        rv |= ((long)source.getByte(offset + 3) & 0xFFL) << 24;
        return rv |= ((long)source.getByte(offset + 4) & 0xFFL) << 32;
    }

    public static long getLittleULong40(InputStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
    }

    public static long getLittleULong40(InputByteStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
    }

    public static long getLittleULong40(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
    }

    public static long getLittleULong48(byte[] source) {
        long rv = 0L;
        rv |= ((long)source[0] & 0xFFL) << 0;
        rv |= ((long)source[1] & 0xFFL) << 8;
        rv |= ((long)source[2] & 0xFFL) << 16;
        rv |= ((long)source[3] & 0xFFL) << 24;
        rv |= ((long)source[4] & 0xFFL) << 32;
        return rv |= ((long)source[5] & 0xFFL) << 40;
    }

    public static long getLittleULong48(byte[] source, int offset) {
        long rv = 0L;
        rv |= ((long)source[offset + 0] & 0xFFL) << 0;
        rv |= ((long)source[offset + 1] & 0xFFL) << 8;
        rv |= ((long)source[offset + 2] & 0xFFL) << 16;
        rv |= ((long)source[offset + 3] & 0xFFL) << 24;
        rv |= ((long)source[offset + 4] & 0xFFL) << 32;
        return rv |= ((long)source[offset + 5] & 0xFFL) << 40;
    }

    public static long getLittleULong48(Slice<byte[]> source) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 0] & 0xFFL) << 0;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 1] & 0xFFL) << 8;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 2] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 3] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 4] & 0xFFL) << 32;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + 5] & 0xFFL) << 40;
    }

    public static long getLittleULong48(Slice<byte[]> source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 0] & 0xFFL) << 0;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 1] & 0xFFL) << 8;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 2] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 3] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 4] & 0xFFL) << 32;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 5] & 0xFFL) << 40;
    }

    public static long getLittleULong48(PrimitiveCollections.ByteList source) {
        long rv = 0L;
        rv |= ((long)source.getByte(0) & 0xFFL) << 0;
        rv |= ((long)source.getByte(1) & 0xFFL) << 8;
        rv |= ((long)source.getByte(2) & 0xFFL) << 16;
        rv |= ((long)source.getByte(3) & 0xFFL) << 24;
        rv |= ((long)source.getByte(4) & 0xFFL) << 32;
        return rv |= ((long)source.getByte(5) & 0xFFL) << 40;
    }

    public static long getLittleULong48(PrimitiveCollections.ByteList source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getByte(offset + 0) & 0xFFL) << 0;
        rv |= ((long)source.getByte(offset + 1) & 0xFFL) << 8;
        rv |= ((long)source.getByte(offset + 2) & 0xFFL) << 16;
        rv |= ((long)source.getByte(offset + 3) & 0xFFL) << 24;
        rv |= ((long)source.getByte(offset + 4) & 0xFFL) << 32;
        return rv |= ((long)source.getByte(offset + 5) & 0xFFL) << 40;
    }

    public static long getLittleULong48(InputStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
    }

    public static long getLittleULong48(InputByteStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
    }

    public static long getLittleULong48(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
    }

    public static long getLittleULong56(byte[] source) {
        long rv = 0L;
        rv |= ((long)source[0] & 0xFFL) << 0;
        rv |= ((long)source[1] & 0xFFL) << 8;
        rv |= ((long)source[2] & 0xFFL) << 16;
        rv |= ((long)source[3] & 0xFFL) << 24;
        rv |= ((long)source[4] & 0xFFL) << 32;
        rv |= ((long)source[5] & 0xFFL) << 40;
        return rv |= ((long)source[6] & 0xFFL) << 48;
    }

    public static long getLittleULong56(byte[] source, int offset) {
        long rv = 0L;
        rv |= ((long)source[offset + 0] & 0xFFL) << 0;
        rv |= ((long)source[offset + 1] & 0xFFL) << 8;
        rv |= ((long)source[offset + 2] & 0xFFL) << 16;
        rv |= ((long)source[offset + 3] & 0xFFL) << 24;
        rv |= ((long)source[offset + 4] & 0xFFL) << 32;
        rv |= ((long)source[offset + 5] & 0xFFL) << 40;
        return rv |= ((long)source[offset + 6] & 0xFFL) << 48;
    }

    public static long getLittleULong56(Slice<byte[]> source) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 0] & 0xFFL) << 0;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 1] & 0xFFL) << 8;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 2] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 3] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 4] & 0xFFL) << 32;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 5] & 0xFFL) << 40;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + 6] & 0xFFL) << 48;
    }

    public static long getLittleULong56(Slice<byte[]> source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 0] & 0xFFL) << 0;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 1] & 0xFFL) << 8;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 2] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 3] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 4] & 0xFFL) << 32;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 5] & 0xFFL) << 40;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 6] & 0xFFL) << 48;
    }

    public static long getLittleULong56(PrimitiveCollections.ByteList source) {
        long rv = 0L;
        rv |= ((long)source.getByte(0) & 0xFFL) << 0;
        rv |= ((long)source.getByte(1) & 0xFFL) << 8;
        rv |= ((long)source.getByte(2) & 0xFFL) << 16;
        rv |= ((long)source.getByte(3) & 0xFFL) << 24;
        rv |= ((long)source.getByte(4) & 0xFFL) << 32;
        rv |= ((long)source.getByte(5) & 0xFFL) << 40;
        return rv |= ((long)source.getByte(6) & 0xFFL) << 48;
    }

    public static long getLittleULong56(PrimitiveCollections.ByteList source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getByte(offset + 0) & 0xFFL) << 0;
        rv |= ((long)source.getByte(offset + 1) & 0xFFL) << 8;
        rv |= ((long)source.getByte(offset + 2) & 0xFFL) << 16;
        rv |= ((long)source.getByte(offset + 3) & 0xFFL) << 24;
        rv |= ((long)source.getByte(offset + 4) & 0xFFL) << 32;
        rv |= ((long)source.getByte(offset + 5) & 0xFFL) << 40;
        return rv |= ((long)source.getByte(offset + 6) & 0xFFL) << 48;
    }

    public static long getLittleULong56(InputStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 48;
    }

    public static long getLittleULong56(InputByteStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 48;
    }

    public static long getLittleULong56(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 48;
    }

    public static long getLittleLong(byte[] source) {
        long rv = 0L;
        rv |= ((long)source[0] & 0xFFL) << 0;
        rv |= ((long)source[1] & 0xFFL) << 8;
        rv |= ((long)source[2] & 0xFFL) << 16;
        rv |= ((long)source[3] & 0xFFL) << 24;
        rv |= ((long)source[4] & 0xFFL) << 32;
        rv |= ((long)source[5] & 0xFFL) << 40;
        rv |= ((long)source[6] & 0xFFL) << 48;
        return rv |= ((long)source[7] & 0xFFL) << 56;
    }

    public static long getLittleLong(byte[] source, int offset) {
        long rv = 0L;
        rv |= ((long)source[offset + 0] & 0xFFL) << 0;
        rv |= ((long)source[offset + 1] & 0xFFL) << 8;
        rv |= ((long)source[offset + 2] & 0xFFL) << 16;
        rv |= ((long)source[offset + 3] & 0xFFL) << 24;
        rv |= ((long)source[offset + 4] & 0xFFL) << 32;
        rv |= ((long)source[offset + 5] & 0xFFL) << 40;
        rv |= ((long)source[offset + 6] & 0xFFL) << 48;
        return rv |= ((long)source[offset + 7] & 0xFFL) << 56;
    }

    public static long getLittleLong(Slice<byte[]> source) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 0] & 0xFFL) << 0;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 1] & 0xFFL) << 8;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 2] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 3] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 4] & 0xFFL) << 32;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 5] & 0xFFL) << 40;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 6] & 0xFFL) << 48;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + 7] & 0xFFL) << 56;
    }

    public static long getLittleLong(Slice<byte[]> source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 0] & 0xFFL) << 0;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 1] & 0xFFL) << 8;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 2] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 3] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 4] & 0xFFL) << 32;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 5] & 0xFFL) << 40;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 6] & 0xFFL) << 48;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 7] & 0xFFL) << 56;
    }

    public static long getLittleLong(PrimitiveCollections.ByteList source) {
        long rv = 0L;
        rv |= ((long)source.getByte(0) & 0xFFL) << 0;
        rv |= ((long)source.getByte(1) & 0xFFL) << 8;
        rv |= ((long)source.getByte(2) & 0xFFL) << 16;
        rv |= ((long)source.getByte(3) & 0xFFL) << 24;
        rv |= ((long)source.getByte(4) & 0xFFL) << 32;
        rv |= ((long)source.getByte(5) & 0xFFL) << 40;
        rv |= ((long)source.getByte(6) & 0xFFL) << 48;
        return rv |= ((long)source.getByte(7) & 0xFFL) << 56;
    }

    public static long getLittleLong(PrimitiveCollections.ByteList source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getByte(offset + 0) & 0xFFL) << 0;
        rv |= ((long)source.getByte(offset + 1) & 0xFFL) << 8;
        rv |= ((long)source.getByte(offset + 2) & 0xFFL) << 16;
        rv |= ((long)source.getByte(offset + 3) & 0xFFL) << 24;
        rv |= ((long)source.getByte(offset + 4) & 0xFFL) << 32;
        rv |= ((long)source.getByte(offset + 5) & 0xFFL) << 40;
        rv |= ((long)source.getByte(offset + 6) & 0xFFL) << 48;
        return rv |= ((long)source.getByte(offset + 7) & 0xFFL) << 56;
    }

    public static long getLittleLong(InputStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 48;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 56;
    }

    public static long getLittleLong(InputByteStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 48;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 56;
    }

    public static long getLittleLong(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 48;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 56;
    }

    public static void putLittleChar(byte[] dest, char value) {
        dest[0] = (byte)(value >>> 0 & 0xFF);
        dest[1] = (byte)(value >>> 8 & 0xFF);
    }

    public static void putLittleChar(byte[] dest, int offset, char value) {
        dest[offset + 0] = (byte)(value >>> 0 & 0xFF);
        dest[offset + 1] = (byte)(value >>> 8 & 0xFF);
    }

    public static void putLittleChar(Slice<byte[]> dest, char value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 0 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 8 & 0xFF);
    }

    public static void putLittleChar(Slice<byte[]> dest, int offset, char value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 0 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 8 & 0xFF);
    }

    public static void setLittleChar(PrimitiveCollections.ByteList dest, char value) {
        dest.setByte(0, (byte)(value >>> 0 & 0xFF));
        dest.setByte(1, (byte)(value >>> 8 & 0xFF));
    }

    public static void putLittleChar(PrimitiveCollections.ByteList dest, int offset, char value) {
        dest.setByte(offset + 0, (byte)(value >>> 0 & 0xFF));
        dest.setByte(offset + 1, (byte)(value >>> 8 & 0xFF));
    }

    public static void addLittleChar(PrimitiveCollections.ByteList dest, char value) {
        dest.addByte((byte)(value >>> 0 & 0xFF));
        dest.addByte((byte)(value >>> 8 & 0xFF));
    }

    public static void addLittleChar(PrimitiveCollections.ByteList dest, int offset, char value) {
        dest.insertByte(offset + 0, (byte)(value >>> 0 & 0xFF));
        dest.insertByte(offset + 1, (byte)(value >>> 8 & 0xFF));
    }

    public static void putLittleChar(OutputStream dest, char value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
    }

    public static void putLittleChar(OutputByteStream dest, char value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
    }

    public static void putLittleChar(StreamAPIs.ByteBlockWriteStream dest, char value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
    }

    public static void putLittleShort(byte[] dest, short value) {
        dest[0] = (byte)(value >>> 0 & 0xFF);
        dest[1] = (byte)(value >>> 8 & 0xFF);
    }

    public static void putLittleShort(byte[] dest, int offset, short value) {
        dest[offset + 0] = (byte)(value >>> 0 & 0xFF);
        dest[offset + 1] = (byte)(value >>> 8 & 0xFF);
    }

    public static void putLittleShort(Slice<byte[]> dest, short value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 0 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 8 & 0xFF);
    }

    public static void putLittleShort(Slice<byte[]> dest, int offset, short value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 0 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 8 & 0xFF);
    }

    public static void setLittleShort(PrimitiveCollections.ByteList dest, short value) {
        dest.setByte(0, (byte)(value >>> 0 & 0xFF));
        dest.setByte(1, (byte)(value >>> 8 & 0xFF));
    }

    public static void putLittleShort(PrimitiveCollections.ByteList dest, int offset, short value) {
        dest.setByte(offset + 0, (byte)(value >>> 0 & 0xFF));
        dest.setByte(offset + 1, (byte)(value >>> 8 & 0xFF));
    }

    public static void addLittleShort(PrimitiveCollections.ByteList dest, short value) {
        dest.addByte((byte)(value >>> 0 & 0xFF));
        dest.addByte((byte)(value >>> 8 & 0xFF));
    }

    public static void addLittleShort(PrimitiveCollections.ByteList dest, int offset, short value) {
        dest.insertByte(offset + 0, (byte)(value >>> 0 & 0xFF));
        dest.insertByte(offset + 1, (byte)(value >>> 8 & 0xFF));
    }

    public static void putLittleShort(OutputStream dest, short value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
    }

    public static void putLittleShort(OutputByteStream dest, short value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
    }

    public static void putLittleShort(StreamAPIs.ByteBlockWriteStream dest, short value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
    }

    public static void putLittleInt24(byte[] dest, int value) {
        dest[0] = (byte)(value >>> 0 & 0xFF);
        dest[1] = (byte)(value >>> 8 & 0xFF);
        dest[2] = (byte)(value >>> 16 & 0xFF);
    }

    public static void putLittleInt24(byte[] dest, int offset, int value) {
        dest[offset + 0] = (byte)(value >>> 0 & 0xFF);
        dest[offset + 1] = (byte)(value >>> 8 & 0xFF);
        dest[offset + 2] = (byte)(value >>> 16 & 0xFF);
    }

    public static void putLittleInt24(Slice<byte[]> dest, int value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 0 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 8 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 2] = (byte)(value >>> 16 & 0xFF);
    }

    public static void putLittleInt24(Slice<byte[]> dest, int offset, int value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 0 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 8 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 2] = (byte)(value >>> 16 & 0xFF);
    }

    public static void setLittleInt24(PrimitiveCollections.ByteList dest, int value) {
        dest.setByte(0, (byte)(value >>> 0 & 0xFF));
        dest.setByte(1, (byte)(value >>> 8 & 0xFF));
        dest.setByte(2, (byte)(value >>> 16 & 0xFF));
    }

    public static void putLittleInt24(PrimitiveCollections.ByteList dest, int offset, int value) {
        dest.setByte(offset + 0, (byte)(value >>> 0 & 0xFF));
        dest.setByte(offset + 1, (byte)(value >>> 8 & 0xFF));
        dest.setByte(offset + 2, (byte)(value >>> 16 & 0xFF));
    }

    public static void addLittleInt24(PrimitiveCollections.ByteList dest, int value) {
        dest.addByte((byte)(value >>> 0 & 0xFF));
        dest.addByte((byte)(value >>> 8 & 0xFF));
        dest.addByte((byte)(value >>> 16 & 0xFF));
    }

    public static void addLittleInt24(PrimitiveCollections.ByteList dest, int offset, int value) {
        dest.insertByte(offset + 0, (byte)(value >>> 0 & 0xFF));
        dest.insertByte(offset + 1, (byte)(value >>> 8 & 0xFF));
        dest.insertByte(offset + 2, (byte)(value >>> 16 & 0xFF));
    }

    public static void putLittleInt24(OutputStream dest, int value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 16 & 0xFF));
    }

    public static void putLittleInt24(OutputByteStream dest, int value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 16 & 0xFF));
    }

    public static void putLittleInt24(StreamAPIs.ByteBlockWriteStream dest, int value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 16 & 0xFF));
    }

    public static void putLittleInt(byte[] dest, int value) {
        dest[0] = (byte)(value >>> 0 & 0xFF);
        dest[1] = (byte)(value >>> 8 & 0xFF);
        dest[2] = (byte)(value >>> 16 & 0xFF);
        dest[3] = (byte)(value >>> 24 & 0xFF);
    }

    public static void putLittleInt(byte[] dest, int offset, int value) {
        dest[offset + 0] = (byte)(value >>> 0 & 0xFF);
        dest[offset + 1] = (byte)(value >>> 8 & 0xFF);
        dest[offset + 2] = (byte)(value >>> 16 & 0xFF);
        dest[offset + 3] = (byte)(value >>> 24 & 0xFF);
    }

    public static void putLittleInt(Slice<byte[]> dest, int value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 0 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 8 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 2] = (byte)(value >>> 16 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 3] = (byte)(value >>> 24 & 0xFF);
    }

    public static void putLittleInt(Slice<byte[]> dest, int offset, int value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 0 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 8 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 2] = (byte)(value >>> 16 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 3] = (byte)(value >>> 24 & 0xFF);
    }

    public static void setLittleInt(PrimitiveCollections.ByteList dest, int value) {
        dest.setByte(0, (byte)(value >>> 0 & 0xFF));
        dest.setByte(1, (byte)(value >>> 8 & 0xFF));
        dest.setByte(2, (byte)(value >>> 16 & 0xFF));
        dest.setByte(3, (byte)(value >>> 24 & 0xFF));
    }

    public static void putLittleInt(PrimitiveCollections.ByteList dest, int offset, int value) {
        dest.setByte(offset + 0, (byte)(value >>> 0 & 0xFF));
        dest.setByte(offset + 1, (byte)(value >>> 8 & 0xFF));
        dest.setByte(offset + 2, (byte)(value >>> 16 & 0xFF));
        dest.setByte(offset + 3, (byte)(value >>> 24 & 0xFF));
    }

    public static void addLittleInt(PrimitiveCollections.ByteList dest, int value) {
        dest.addByte((byte)(value >>> 0 & 0xFF));
        dest.addByte((byte)(value >>> 8 & 0xFF));
        dest.addByte((byte)(value >>> 16 & 0xFF));
        dest.addByte((byte)(value >>> 24 & 0xFF));
    }

    public static void addLittleInt(PrimitiveCollections.ByteList dest, int offset, int value) {
        dest.insertByte(offset + 0, (byte)(value >>> 0 & 0xFF));
        dest.insertByte(offset + 1, (byte)(value >>> 8 & 0xFF));
        dest.insertByte(offset + 2, (byte)(value >>> 16 & 0xFF));
        dest.insertByte(offset + 3, (byte)(value >>> 24 & 0xFF));
    }

    public static void putLittleInt(OutputStream dest, int value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 16 & 0xFF));
        dest.write((byte)(value >>> 24 & 0xFF));
    }

    public static void putLittleInt(OutputByteStream dest, int value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 16 & 0xFF));
        dest.write((byte)(value >>> 24 & 0xFF));
    }

    public static void putLittleInt(StreamAPIs.ByteBlockWriteStream dest, int value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 16 & 0xFF));
        dest.write((byte)(value >>> 24 & 0xFF));
    }

    public static void putLittleLong40(byte[] dest, long value) {
        dest[0] = (byte)(value >>> 0 & 0xFFL);
        dest[1] = (byte)(value >>> 8 & 0xFFL);
        dest[2] = (byte)(value >>> 16 & 0xFFL);
        dest[3] = (byte)(value >>> 24 & 0xFFL);
        dest[4] = (byte)(value >>> 32 & 0xFFL);
    }

    public static void putLittleLong40(byte[] dest, int offset, long value) {
        dest[offset + 0] = (byte)(value >>> 0 & 0xFFL);
        dest[offset + 1] = (byte)(value >>> 8 & 0xFFL);
        dest[offset + 2] = (byte)(value >>> 16 & 0xFFL);
        dest[offset + 3] = (byte)(value >>> 24 & 0xFFL);
        dest[offset + 4] = (byte)(value >>> 32 & 0xFFL);
    }

    public static void putLittleLong40(Slice<byte[]> dest, long value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 0 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 2] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 3] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 4] = (byte)(value >>> 32 & 0xFFL);
    }

    public static void putLittleLong40(Slice<byte[]> dest, int offset, long value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 0 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 2] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 3] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 4] = (byte)(value >>> 32 & 0xFFL);
    }

    public static void setLittleLong40(PrimitiveCollections.ByteList dest, long value) {
        dest.setByte(0, (byte)(value >>> 0 & 0xFFL));
        dest.setByte(1, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(2, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(3, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(4, (byte)(value >>> 32 & 0xFFL));
    }

    public static void putLittleLong40(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.setByte(offset + 0, (byte)(value >>> 0 & 0xFFL));
        dest.setByte(offset + 1, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(offset + 2, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(offset + 3, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(offset + 4, (byte)(value >>> 32 & 0xFFL));
    }

    public static void addLittleLong40(PrimitiveCollections.ByteList dest, long value) {
        dest.addByte((byte)(value >>> 0 & 0xFFL));
        dest.addByte((byte)(value >>> 8 & 0xFFL));
        dest.addByte((byte)(value >>> 16 & 0xFFL));
        dest.addByte((byte)(value >>> 24 & 0xFFL));
        dest.addByte((byte)(value >>> 32 & 0xFFL));
    }

    public static void addLittleLong40(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.insertByte(offset + 0, (byte)(value >>> 0 & 0xFFL));
        dest.insertByte(offset + 1, (byte)(value >>> 8 & 0xFFL));
        dest.insertByte(offset + 2, (byte)(value >>> 16 & 0xFFL));
        dest.insertByte(offset + 3, (byte)(value >>> 24 & 0xFFL));
        dest.insertByte(offset + 4, (byte)(value >>> 32 & 0xFFL));
    }

    public static void putLittleLong40(OutputStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
    }

    public static void putLittleLong40(OutputByteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
    }

    public static void putLittleLong40(StreamAPIs.ByteBlockWriteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
    }

    public static void putLittleLong48(byte[] dest, long value) {
        dest[0] = (byte)(value >>> 0 & 0xFFL);
        dest[1] = (byte)(value >>> 8 & 0xFFL);
        dest[2] = (byte)(value >>> 16 & 0xFFL);
        dest[3] = (byte)(value >>> 24 & 0xFFL);
        dest[4] = (byte)(value >>> 32 & 0xFFL);
        dest[5] = (byte)(value >>> 40 & 0xFFL);
    }

    public static void putLittleLong48(byte[] dest, int offset, long value) {
        dest[offset + 0] = (byte)(value >>> 0 & 0xFFL);
        dest[offset + 1] = (byte)(value >>> 8 & 0xFFL);
        dest[offset + 2] = (byte)(value >>> 16 & 0xFFL);
        dest[offset + 3] = (byte)(value >>> 24 & 0xFFL);
        dest[offset + 4] = (byte)(value >>> 32 & 0xFFL);
        dest[offset + 5] = (byte)(value >>> 40 & 0xFFL);
    }

    public static void putLittleLong48(Slice<byte[]> dest, long value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 0 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 2] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 3] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 4] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 5] = (byte)(value >>> 40 & 0xFFL);
    }

    public static void putLittleLong48(Slice<byte[]> dest, int offset, long value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 0 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 2] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 3] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 4] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 5] = (byte)(value >>> 40 & 0xFFL);
    }

    public static void setLittleLong48(PrimitiveCollections.ByteList dest, long value) {
        dest.setByte(0, (byte)(value >>> 0 & 0xFFL));
        dest.setByte(1, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(2, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(3, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(4, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(5, (byte)(value >>> 40 & 0xFFL));
    }

    public static void putLittleLong48(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.setByte(offset + 0, (byte)(value >>> 0 & 0xFFL));
        dest.setByte(offset + 1, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(offset + 2, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(offset + 3, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(offset + 4, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(offset + 5, (byte)(value >>> 40 & 0xFFL));
    }

    public static void addLittleLong48(PrimitiveCollections.ByteList dest, long value) {
        dest.addByte((byte)(value >>> 0 & 0xFFL));
        dest.addByte((byte)(value >>> 8 & 0xFFL));
        dest.addByte((byte)(value >>> 16 & 0xFFL));
        dest.addByte((byte)(value >>> 24 & 0xFFL));
        dest.addByte((byte)(value >>> 32 & 0xFFL));
        dest.addByte((byte)(value >>> 40 & 0xFFL));
    }

    public static void addLittleLong48(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.insertByte(offset + 0, (byte)(value >>> 0 & 0xFFL));
        dest.insertByte(offset + 1, (byte)(value >>> 8 & 0xFFL));
        dest.insertByte(offset + 2, (byte)(value >>> 16 & 0xFFL));
        dest.insertByte(offset + 3, (byte)(value >>> 24 & 0xFFL));
        dest.insertByte(offset + 4, (byte)(value >>> 32 & 0xFFL));
        dest.insertByte(offset + 5, (byte)(value >>> 40 & 0xFFL));
    }

    public static void putLittleLong48(OutputStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
    }

    public static void putLittleLong48(OutputByteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
    }

    public static void putLittleLong48(StreamAPIs.ByteBlockWriteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
    }

    public static void putLittleLong56(byte[] dest, long value) {
        dest[0] = (byte)(value >>> 0 & 0xFFL);
        dest[1] = (byte)(value >>> 8 & 0xFFL);
        dest[2] = (byte)(value >>> 16 & 0xFFL);
        dest[3] = (byte)(value >>> 24 & 0xFFL);
        dest[4] = (byte)(value >>> 32 & 0xFFL);
        dest[5] = (byte)(value >>> 40 & 0xFFL);
        dest[6] = (byte)(value >>> 48 & 0xFFL);
    }

    public static void putLittleLong56(byte[] dest, int offset, long value) {
        dest[offset + 0] = (byte)(value >>> 0 & 0xFFL);
        dest[offset + 1] = (byte)(value >>> 8 & 0xFFL);
        dest[offset + 2] = (byte)(value >>> 16 & 0xFFL);
        dest[offset + 3] = (byte)(value >>> 24 & 0xFFL);
        dest[offset + 4] = (byte)(value >>> 32 & 0xFFL);
        dest[offset + 5] = (byte)(value >>> 40 & 0xFFL);
        dest[offset + 6] = (byte)(value >>> 48 & 0xFFL);
    }

    public static void putLittleLong56(Slice<byte[]> dest, long value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 0 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 2] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 3] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 4] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 5] = (byte)(value >>> 40 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 6] = (byte)(value >>> 48 & 0xFFL);
    }

    public static void putLittleLong56(Slice<byte[]> dest, int offset, long value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 0 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 2] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 3] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 4] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 5] = (byte)(value >>> 40 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 6] = (byte)(value >>> 48 & 0xFFL);
    }

    public static void setLittleLong56(PrimitiveCollections.ByteList dest, long value) {
        dest.setByte(0, (byte)(value >>> 0 & 0xFFL));
        dest.setByte(1, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(2, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(3, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(4, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(5, (byte)(value >>> 40 & 0xFFL));
        dest.setByte(6, (byte)(value >>> 48 & 0xFFL));
    }

    public static void putLittleLong56(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.setByte(offset + 0, (byte)(value >>> 0 & 0xFFL));
        dest.setByte(offset + 1, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(offset + 2, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(offset + 3, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(offset + 4, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(offset + 5, (byte)(value >>> 40 & 0xFFL));
        dest.setByte(offset + 6, (byte)(value >>> 48 & 0xFFL));
    }

    public static void addLittleLong56(PrimitiveCollections.ByteList dest, long value) {
        dest.addByte((byte)(value >>> 0 & 0xFFL));
        dest.addByte((byte)(value >>> 8 & 0xFFL));
        dest.addByte((byte)(value >>> 16 & 0xFFL));
        dest.addByte((byte)(value >>> 24 & 0xFFL));
        dest.addByte((byte)(value >>> 32 & 0xFFL));
        dest.addByte((byte)(value >>> 40 & 0xFFL));
        dest.addByte((byte)(value >>> 48 & 0xFFL));
    }

    public static void addLittleLong56(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.insertByte(offset + 0, (byte)(value >>> 0 & 0xFFL));
        dest.insertByte(offset + 1, (byte)(value >>> 8 & 0xFFL));
        dest.insertByte(offset + 2, (byte)(value >>> 16 & 0xFFL));
        dest.insertByte(offset + 3, (byte)(value >>> 24 & 0xFFL));
        dest.insertByte(offset + 4, (byte)(value >>> 32 & 0xFFL));
        dest.insertByte(offset + 5, (byte)(value >>> 40 & 0xFFL));
        dest.insertByte(offset + 6, (byte)(value >>> 48 & 0xFFL));
    }

    public static void putLittleLong56(OutputStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 48 & 0xFFL));
    }

    public static void putLittleLong56(OutputByteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 48 & 0xFFL));
    }

    public static void putLittleLong56(StreamAPIs.ByteBlockWriteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 48 & 0xFFL));
    }

    public static void putLittleLong(byte[] dest, long value) {
        dest[0] = (byte)(value >>> 0 & 0xFFL);
        dest[1] = (byte)(value >>> 8 & 0xFFL);
        dest[2] = (byte)(value >>> 16 & 0xFFL);
        dest[3] = (byte)(value >>> 24 & 0xFFL);
        dest[4] = (byte)(value >>> 32 & 0xFFL);
        dest[5] = (byte)(value >>> 40 & 0xFFL);
        dest[6] = (byte)(value >>> 48 & 0xFFL);
        dest[7] = (byte)(value >>> 56 & 0xFFL);
    }

    public static void putLittleLong(byte[] dest, int offset, long value) {
        dest[offset + 0] = (byte)(value >>> 0 & 0xFFL);
        dest[offset + 1] = (byte)(value >>> 8 & 0xFFL);
        dest[offset + 2] = (byte)(value >>> 16 & 0xFFL);
        dest[offset + 3] = (byte)(value >>> 24 & 0xFFL);
        dest[offset + 4] = (byte)(value >>> 32 & 0xFFL);
        dest[offset + 5] = (byte)(value >>> 40 & 0xFFL);
        dest[offset + 6] = (byte)(value >>> 48 & 0xFFL);
        dest[offset + 7] = (byte)(value >>> 56 & 0xFFL);
    }

    public static void putLittleLong(Slice<byte[]> dest, long value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 0 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 2] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 3] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 4] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 5] = (byte)(value >>> 40 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 6] = (byte)(value >>> 48 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 7] = (byte)(value >>> 56 & 0xFFL);
    }

    public static void putLittleLong(Slice<byte[]> dest, int offset, long value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 0 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 2] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 3] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 4] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 5] = (byte)(value >>> 40 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 6] = (byte)(value >>> 48 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 7] = (byte)(value >>> 56 & 0xFFL);
    }

    public static void setLittleLong(PrimitiveCollections.ByteList dest, long value) {
        dest.setByte(0, (byte)(value >>> 0 & 0xFFL));
        dest.setByte(1, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(2, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(3, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(4, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(5, (byte)(value >>> 40 & 0xFFL));
        dest.setByte(6, (byte)(value >>> 48 & 0xFFL));
        dest.setByte(7, (byte)(value >>> 56 & 0xFFL));
    }

    public static void putLittleLong(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.setByte(offset + 0, (byte)(value >>> 0 & 0xFFL));
        dest.setByte(offset + 1, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(offset + 2, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(offset + 3, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(offset + 4, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(offset + 5, (byte)(value >>> 40 & 0xFFL));
        dest.setByte(offset + 6, (byte)(value >>> 48 & 0xFFL));
        dest.setByte(offset + 7, (byte)(value >>> 56 & 0xFFL));
    }

    public static void addLittleLong(PrimitiveCollections.ByteList dest, long value) {
        dest.addByte((byte)(value >>> 0 & 0xFFL));
        dest.addByte((byte)(value >>> 8 & 0xFFL));
        dest.addByte((byte)(value >>> 16 & 0xFFL));
        dest.addByte((byte)(value >>> 24 & 0xFFL));
        dest.addByte((byte)(value >>> 32 & 0xFFL));
        dest.addByte((byte)(value >>> 40 & 0xFFL));
        dest.addByte((byte)(value >>> 48 & 0xFFL));
        dest.addByte((byte)(value >>> 56 & 0xFFL));
    }

    public static void addLittleLong(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.insertByte(offset + 0, (byte)(value >>> 0 & 0xFFL));
        dest.insertByte(offset + 1, (byte)(value >>> 8 & 0xFFL));
        dest.insertByte(offset + 2, (byte)(value >>> 16 & 0xFFL));
        dest.insertByte(offset + 3, (byte)(value >>> 24 & 0xFFL));
        dest.insertByte(offset + 4, (byte)(value >>> 32 & 0xFFL));
        dest.insertByte(offset + 5, (byte)(value >>> 40 & 0xFFL));
        dest.insertByte(offset + 6, (byte)(value >>> 48 & 0xFFL));
        dest.insertByte(offset + 7, (byte)(value >>> 56 & 0xFFL));
    }

    public static void putLittleLong(OutputStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 48 & 0xFFL));
        dest.write((byte)(value >>> 56 & 0xFFL));
    }

    public static void putLittleLong(OutputByteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 48 & 0xFFL));
        dest.write((byte)(value >>> 56 & 0xFFL));
    }

    public static void putLittleLong(StreamAPIs.ByteBlockWriteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 0 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 48 & 0xFFL));
        dest.write((byte)(value >>> 56 & 0xFFL));
    }

    public static char getBigChar(byte[] source) {
        char rv = '\u0000';
        rv = (char)(rv | (source[0] & 0xFF) << 8);
        rv = (char)(rv | (source[1] & 0xFF) << 0);
        return rv;
    }

    public static char getBigChar(byte[] source, int offset) {
        char rv = '\u0000';
        rv = (char)(rv | (source[offset + 0] & 0xFF) << 8);
        rv = (char)(rv | (source[offset + 1] & 0xFF) << 0);
        return rv;
    }

    public static char getBigChar(Slice<byte[]> source) {
        char rv = '\u0000';
        rv = (char)(rv | (source.getUnderlying()[source.getOffset() + 0] & 0xFF) << 8);
        rv = (char)(rv | (source.getUnderlying()[source.getOffset() + 1] & 0xFF) << 0);
        return rv;
    }

    public static char getBigChar(Slice<byte[]> source, int offset) {
        char rv = '\u0000';
        rv = (char)(rv | (source.getUnderlying()[source.getOffset() + offset + 0] & 0xFF) << 8);
        rv = (char)(rv | (source.getUnderlying()[source.getOffset() + offset + 1] & 0xFF) << 0);
        return rv;
    }

    public static char getBigChar(PrimitiveCollections.ByteList source) {
        char rv = '\u0000';
        rv = (char)(rv | (source.getByte(0) & 0xFF) << 8);
        rv = (char)(rv | (source.getByte(1) & 0xFF) << 0);
        return rv;
    }

    public static char getBigChar(PrimitiveCollections.ByteList source, int offset) {
        char rv = '\u0000';
        rv = (char)(rv | (source.getByte(offset + 0) & 0xFF) << 8);
        rv = (char)(rv | (source.getByte(offset + 1) & 0xFF) << 0);
        return rv;
    }

    public static char getBigChar(InputStream source) throws IOException, EOFException {
        char rv = '\u0000';
        rv = (char)(rv | (Bytes.getByte(source) & 0xFF) << 8);
        rv = (char)(rv | (Bytes.getByte(source) & 0xFF) << 0);
        return rv;
    }

    public static char getBigChar(InputByteStream source) throws IOException, EOFException {
        char rv = '\u0000';
        rv = (char)(rv | (Bytes.getByte(source) & 0xFF) << 8);
        rv = (char)(rv | (Bytes.getByte(source) & 0xFF) << 0);
        return rv;
    }

    public static char getBigChar(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        char rv = '\u0000';
        rv = (char)(rv | (Bytes.getByte(source) & 0xFF) << 8);
        rv = (char)(rv | (Bytes.getByte(source) & 0xFF) << 0);
        return rv;
    }

    public static short getBigShort(byte[] source) {
        short rv = 0;
        rv = (short)(rv | (source[0] & 0xFF) << 8);
        rv = (short)(rv | (source[1] & 0xFF) << 0);
        return rv;
    }

    public static short getBigShort(byte[] source, int offset) {
        short rv = 0;
        rv = (short)(rv | (source[offset + 0] & 0xFF) << 8);
        rv = (short)(rv | (source[offset + 1] & 0xFF) << 0);
        return rv;
    }

    public static short getBigShort(Slice<byte[]> source) {
        short rv = 0;
        rv = (short)(rv | (source.getUnderlying()[source.getOffset() + 0] & 0xFF) << 8);
        rv = (short)(rv | (source.getUnderlying()[source.getOffset() + 1] & 0xFF) << 0);
        return rv;
    }

    public static short getBigShort(Slice<byte[]> source, int offset) {
        short rv = 0;
        rv = (short)(rv | (source.getUnderlying()[source.getOffset() + offset + 0] & 0xFF) << 8);
        rv = (short)(rv | (source.getUnderlying()[source.getOffset() + offset + 1] & 0xFF) << 0);
        return rv;
    }

    public static short getBigShort(PrimitiveCollections.ByteList source) {
        short rv = 0;
        rv = (short)(rv | (source.getByte(0) & 0xFF) << 8);
        rv = (short)(rv | (source.getByte(1) & 0xFF) << 0);
        return rv;
    }

    public static short getBigShort(PrimitiveCollections.ByteList source, int offset) {
        short rv = 0;
        rv = (short)(rv | (source.getByte(offset + 0) & 0xFF) << 8);
        rv = (short)(rv | (source.getByte(offset + 1) & 0xFF) << 0);
        return rv;
    }

    public static short getBigShort(InputStream source) throws IOException, EOFException {
        short rv = 0;
        rv = (short)(rv | (Bytes.getByte(source) & 0xFF) << 8);
        rv = (short)(rv | (Bytes.getByte(source) & 0xFF) << 0);
        return rv;
    }

    public static short getBigShort(InputByteStream source) throws IOException, EOFException {
        short rv = 0;
        rv = (short)(rv | (Bytes.getByte(source) & 0xFF) << 8);
        rv = (short)(rv | (Bytes.getByte(source) & 0xFF) << 0);
        return rv;
    }

    public static short getBigShort(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        short rv = 0;
        rv = (short)(rv | (Bytes.getByte(source) & 0xFF) << 8);
        rv = (short)(rv | (Bytes.getByte(source) & 0xFF) << 0);
        return rv;
    }

    public static int getBigUInt24(byte[] source) {
        int rv = 0;
        rv |= (source[0] & 0xFF) << 16;
        rv |= (source[1] & 0xFF) << 8;
        return rv |= (source[2] & 0xFF) << 0;
    }

    public static int getBigUInt24(byte[] source, int offset) {
        int rv = 0;
        rv |= (source[offset + 0] & 0xFF) << 16;
        rv |= (source[offset + 1] & 0xFF) << 8;
        return rv |= (source[offset + 2] & 0xFF) << 0;
    }

    public static int getBigUInt24(Slice<byte[]> source) {
        int rv = 0;
        rv |= (source.getUnderlying()[source.getOffset() + 0] & 0xFF) << 16;
        rv |= (source.getUnderlying()[source.getOffset() + 1] & 0xFF) << 8;
        return rv |= (source.getUnderlying()[source.getOffset() + 2] & 0xFF) << 0;
    }

    public static int getBigUInt24(Slice<byte[]> source, int offset) {
        int rv = 0;
        rv |= (source.getUnderlying()[source.getOffset() + offset + 0] & 0xFF) << 16;
        rv |= (source.getUnderlying()[source.getOffset() + offset + 1] & 0xFF) << 8;
        return rv |= (source.getUnderlying()[source.getOffset() + offset + 2] & 0xFF) << 0;
    }

    public static int getBigUInt24(PrimitiveCollections.ByteList source) {
        int rv = 0;
        rv |= (source.getByte(0) & 0xFF) << 16;
        rv |= (source.getByte(1) & 0xFF) << 8;
        return rv |= (source.getByte(2) & 0xFF) << 0;
    }

    public static int getBigUInt24(PrimitiveCollections.ByteList source, int offset) {
        int rv = 0;
        rv |= (source.getByte(offset + 0) & 0xFF) << 16;
        rv |= (source.getByte(offset + 1) & 0xFF) << 8;
        return rv |= (source.getByte(offset + 2) & 0xFF) << 0;
    }

    public static int getBigUInt24(InputStream source) throws IOException, EOFException {
        int rv = 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 16;
        rv |= (Bytes.getByte(source) & 0xFF) << 8;
        return rv |= (Bytes.getByte(source) & 0xFF) << 0;
    }

    public static int getBigUInt24(InputByteStream source) throws IOException, EOFException {
        int rv = 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 16;
        rv |= (Bytes.getByte(source) & 0xFF) << 8;
        return rv |= (Bytes.getByte(source) & 0xFF) << 0;
    }

    public static int getBigUInt24(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        int rv = 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 16;
        rv |= (Bytes.getByte(source) & 0xFF) << 8;
        return rv |= (Bytes.getByte(source) & 0xFF) << 0;
    }

    public static int getBigInt(byte[] source) {
        int rv = 0;
        rv |= (source[0] & 0xFF) << 24;
        rv |= (source[1] & 0xFF) << 16;
        rv |= (source[2] & 0xFF) << 8;
        return rv |= (source[3] & 0xFF) << 0;
    }

    public static int getBigInt(byte[] source, int offset) {
        int rv = 0;
        rv |= (source[offset + 0] & 0xFF) << 24;
        rv |= (source[offset + 1] & 0xFF) << 16;
        rv |= (source[offset + 2] & 0xFF) << 8;
        return rv |= (source[offset + 3] & 0xFF) << 0;
    }

    public static int getBigInt(Slice<byte[]> source) {
        int rv = 0;
        rv |= (source.getUnderlying()[source.getOffset() + 0] & 0xFF) << 24;
        rv |= (source.getUnderlying()[source.getOffset() + 1] & 0xFF) << 16;
        rv |= (source.getUnderlying()[source.getOffset() + 2] & 0xFF) << 8;
        return rv |= (source.getUnderlying()[source.getOffset() + 3] & 0xFF) << 0;
    }

    public static int getBigInt(Slice<byte[]> source, int offset) {
        int rv = 0;
        rv |= (source.getUnderlying()[source.getOffset() + offset + 0] & 0xFF) << 24;
        rv |= (source.getUnderlying()[source.getOffset() + offset + 1] & 0xFF) << 16;
        rv |= (source.getUnderlying()[source.getOffset() + offset + 2] & 0xFF) << 8;
        return rv |= (source.getUnderlying()[source.getOffset() + offset + 3] & 0xFF) << 0;
    }

    public static int getBigInt(PrimitiveCollections.ByteList source) {
        int rv = 0;
        rv |= (source.getByte(0) & 0xFF) << 24;
        rv |= (source.getByte(1) & 0xFF) << 16;
        rv |= (source.getByte(2) & 0xFF) << 8;
        return rv |= (source.getByte(3) & 0xFF) << 0;
    }

    public static int getBigInt(PrimitiveCollections.ByteList source, int offset) {
        int rv = 0;
        rv |= (source.getByte(offset + 0) & 0xFF) << 24;
        rv |= (source.getByte(offset + 1) & 0xFF) << 16;
        rv |= (source.getByte(offset + 2) & 0xFF) << 8;
        return rv |= (source.getByte(offset + 3) & 0xFF) << 0;
    }

    public static int getBigInt(InputStream source) throws IOException, EOFException {
        int rv = 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 24;
        rv |= (Bytes.getByte(source) & 0xFF) << 16;
        rv |= (Bytes.getByte(source) & 0xFF) << 8;
        return rv |= (Bytes.getByte(source) & 0xFF) << 0;
    }

    public static int getBigInt(InputByteStream source) throws IOException, EOFException {
        int rv = 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 24;
        rv |= (Bytes.getByte(source) & 0xFF) << 16;
        rv |= (Bytes.getByte(source) & 0xFF) << 8;
        return rv |= (Bytes.getByte(source) & 0xFF) << 0;
    }

    public static int getBigInt(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        int rv = 0;
        rv |= (Bytes.getByte(source) & 0xFF) << 24;
        rv |= (Bytes.getByte(source) & 0xFF) << 16;
        rv |= (Bytes.getByte(source) & 0xFF) << 8;
        return rv |= (Bytes.getByte(source) & 0xFF) << 0;
    }

    public static long getBigULong40(byte[] source) {
        long rv = 0L;
        rv |= ((long)source[0] & 0xFFL) << 32;
        rv |= ((long)source[1] & 0xFFL) << 24;
        rv |= ((long)source[2] & 0xFFL) << 16;
        rv |= ((long)source[3] & 0xFFL) << 8;
        return rv |= ((long)source[4] & 0xFFL) << 0;
    }

    public static long getBigULong40(byte[] source, int offset) {
        long rv = 0L;
        rv |= ((long)source[offset + 0] & 0xFFL) << 32;
        rv |= ((long)source[offset + 1] & 0xFFL) << 24;
        rv |= ((long)source[offset + 2] & 0xFFL) << 16;
        rv |= ((long)source[offset + 3] & 0xFFL) << 8;
        return rv |= ((long)source[offset + 4] & 0xFFL) << 0;
    }

    public static long getBigULong40(Slice<byte[]> source) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 0] & 0xFFL) << 32;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 1] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 2] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 3] & 0xFFL) << 8;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + 4] & 0xFFL) << 0;
    }

    public static long getBigULong40(Slice<byte[]> source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 0] & 0xFFL) << 32;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 1] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 2] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 3] & 0xFFL) << 8;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 4] & 0xFFL) << 0;
    }

    public static long getBigULong40(PrimitiveCollections.ByteList source) {
        long rv = 0L;
        rv |= ((long)source.getByte(0) & 0xFFL) << 32;
        rv |= ((long)source.getByte(1) & 0xFFL) << 24;
        rv |= ((long)source.getByte(2) & 0xFFL) << 16;
        rv |= ((long)source.getByte(3) & 0xFFL) << 8;
        return rv |= ((long)source.getByte(4) & 0xFFL) << 0;
    }

    public static long getBigULong40(PrimitiveCollections.ByteList source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getByte(offset + 0) & 0xFFL) << 32;
        rv |= ((long)source.getByte(offset + 1) & 0xFFL) << 24;
        rv |= ((long)source.getByte(offset + 2) & 0xFFL) << 16;
        rv |= ((long)source.getByte(offset + 3) & 0xFFL) << 8;
        return rv |= ((long)source.getByte(offset + 4) & 0xFFL) << 0;
    }

    public static long getBigULong40(InputStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
    }

    public static long getBigULong40(InputByteStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
    }

    public static long getBigULong40(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
    }

    public static long getBigULong48(byte[] source) {
        long rv = 0L;
        rv |= ((long)source[0] & 0xFFL) << 40;
        rv |= ((long)source[1] & 0xFFL) << 32;
        rv |= ((long)source[2] & 0xFFL) << 24;
        rv |= ((long)source[3] & 0xFFL) << 16;
        rv |= ((long)source[4] & 0xFFL) << 8;
        return rv |= ((long)source[5] & 0xFFL) << 0;
    }

    public static long getBigULong48(byte[] source, int offset) {
        long rv = 0L;
        rv |= ((long)source[offset + 0] & 0xFFL) << 40;
        rv |= ((long)source[offset + 1] & 0xFFL) << 32;
        rv |= ((long)source[offset + 2] & 0xFFL) << 24;
        rv |= ((long)source[offset + 3] & 0xFFL) << 16;
        rv |= ((long)source[offset + 4] & 0xFFL) << 8;
        return rv |= ((long)source[offset + 5] & 0xFFL) << 0;
    }

    public static long getBigULong48(Slice<byte[]> source) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 0] & 0xFFL) << 40;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 1] & 0xFFL) << 32;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 2] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 3] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 4] & 0xFFL) << 8;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + 5] & 0xFFL) << 0;
    }

    public static long getBigULong48(Slice<byte[]> source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 0] & 0xFFL) << 40;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 1] & 0xFFL) << 32;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 2] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 3] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 4] & 0xFFL) << 8;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 5] & 0xFFL) << 0;
    }

    public static long getBigULong48(PrimitiveCollections.ByteList source) {
        long rv = 0L;
        rv |= ((long)source.getByte(0) & 0xFFL) << 40;
        rv |= ((long)source.getByte(1) & 0xFFL) << 32;
        rv |= ((long)source.getByte(2) & 0xFFL) << 24;
        rv |= ((long)source.getByte(3) & 0xFFL) << 16;
        rv |= ((long)source.getByte(4) & 0xFFL) << 8;
        return rv |= ((long)source.getByte(5) & 0xFFL) << 0;
    }

    public static long getBigULong48(PrimitiveCollections.ByteList source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getByte(offset + 0) & 0xFFL) << 40;
        rv |= ((long)source.getByte(offset + 1) & 0xFFL) << 32;
        rv |= ((long)source.getByte(offset + 2) & 0xFFL) << 24;
        rv |= ((long)source.getByte(offset + 3) & 0xFFL) << 16;
        rv |= ((long)source.getByte(offset + 4) & 0xFFL) << 8;
        return rv |= ((long)source.getByte(offset + 5) & 0xFFL) << 0;
    }

    public static long getBigULong48(InputStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
    }

    public static long getBigULong48(InputByteStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
    }

    public static long getBigULong48(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
    }

    public static long getBigULong56(byte[] source) {
        long rv = 0L;
        rv |= ((long)source[0] & 0xFFL) << 48;
        rv |= ((long)source[1] & 0xFFL) << 40;
        rv |= ((long)source[2] & 0xFFL) << 32;
        rv |= ((long)source[3] & 0xFFL) << 24;
        rv |= ((long)source[4] & 0xFFL) << 16;
        rv |= ((long)source[5] & 0xFFL) << 8;
        return rv |= ((long)source[6] & 0xFFL) << 0;
    }

    public static long getBigULong56(byte[] source, int offset) {
        long rv = 0L;
        rv |= ((long)source[offset + 0] & 0xFFL) << 48;
        rv |= ((long)source[offset + 1] & 0xFFL) << 40;
        rv |= ((long)source[offset + 2] & 0xFFL) << 32;
        rv |= ((long)source[offset + 3] & 0xFFL) << 24;
        rv |= ((long)source[offset + 4] & 0xFFL) << 16;
        rv |= ((long)source[offset + 5] & 0xFFL) << 8;
        return rv |= ((long)source[offset + 6] & 0xFFL) << 0;
    }

    public static long getBigULong56(Slice<byte[]> source) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 0] & 0xFFL) << 48;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 1] & 0xFFL) << 40;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 2] & 0xFFL) << 32;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 3] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 4] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 5] & 0xFFL) << 8;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + 6] & 0xFFL) << 0;
    }

    public static long getBigULong56(Slice<byte[]> source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 0] & 0xFFL) << 48;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 1] & 0xFFL) << 40;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 2] & 0xFFL) << 32;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 3] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 4] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 5] & 0xFFL) << 8;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 6] & 0xFFL) << 0;
    }

    public static long getBigULong56(PrimitiveCollections.ByteList source) {
        long rv = 0L;
        rv |= ((long)source.getByte(0) & 0xFFL) << 48;
        rv |= ((long)source.getByte(1) & 0xFFL) << 40;
        rv |= ((long)source.getByte(2) & 0xFFL) << 32;
        rv |= ((long)source.getByte(3) & 0xFFL) << 24;
        rv |= ((long)source.getByte(4) & 0xFFL) << 16;
        rv |= ((long)source.getByte(5) & 0xFFL) << 8;
        return rv |= ((long)source.getByte(6) & 0xFFL) << 0;
    }

    public static long getBigULong56(PrimitiveCollections.ByteList source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getByte(offset + 0) & 0xFFL) << 48;
        rv |= ((long)source.getByte(offset + 1) & 0xFFL) << 40;
        rv |= ((long)source.getByte(offset + 2) & 0xFFL) << 32;
        rv |= ((long)source.getByte(offset + 3) & 0xFFL) << 24;
        rv |= ((long)source.getByte(offset + 4) & 0xFFL) << 16;
        rv |= ((long)source.getByte(offset + 5) & 0xFFL) << 8;
        return rv |= ((long)source.getByte(offset + 6) & 0xFFL) << 0;
    }

    public static long getBigULong56(InputStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 48;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
    }

    public static long getBigULong56(InputByteStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 48;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
    }

    public static long getBigULong56(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 48;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
    }

    public static long getBigLong(byte[] source) {
        long rv = 0L;
        rv |= ((long)source[0] & 0xFFL) << 56;
        rv |= ((long)source[1] & 0xFFL) << 48;
        rv |= ((long)source[2] & 0xFFL) << 40;
        rv |= ((long)source[3] & 0xFFL) << 32;
        rv |= ((long)source[4] & 0xFFL) << 24;
        rv |= ((long)source[5] & 0xFFL) << 16;
        rv |= ((long)source[6] & 0xFFL) << 8;
        return rv |= ((long)source[7] & 0xFFL) << 0;
    }

    public static long getBigLong(byte[] source, int offset) {
        long rv = 0L;
        rv |= ((long)source[offset + 0] & 0xFFL) << 56;
        rv |= ((long)source[offset + 1] & 0xFFL) << 48;
        rv |= ((long)source[offset + 2] & 0xFFL) << 40;
        rv |= ((long)source[offset + 3] & 0xFFL) << 32;
        rv |= ((long)source[offset + 4] & 0xFFL) << 24;
        rv |= ((long)source[offset + 5] & 0xFFL) << 16;
        rv |= ((long)source[offset + 6] & 0xFFL) << 8;
        return rv |= ((long)source[offset + 7] & 0xFFL) << 0;
    }

    public static long getBigLong(Slice<byte[]> source) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 0] & 0xFFL) << 56;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 1] & 0xFFL) << 48;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 2] & 0xFFL) << 40;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 3] & 0xFFL) << 32;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 4] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 5] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + 6] & 0xFFL) << 8;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + 7] & 0xFFL) << 0;
    }

    public static long getBigLong(Slice<byte[]> source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 0] & 0xFFL) << 56;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 1] & 0xFFL) << 48;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 2] & 0xFFL) << 40;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 3] & 0xFFL) << 32;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 4] & 0xFFL) << 24;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 5] & 0xFFL) << 16;
        rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 6] & 0xFFL) << 8;
        return rv |= ((long)source.getUnderlying()[source.getOffset() + offset + 7] & 0xFFL) << 0;
    }

    public static long getBigLong(PrimitiveCollections.ByteList source) {
        long rv = 0L;
        rv |= ((long)source.getByte(0) & 0xFFL) << 56;
        rv |= ((long)source.getByte(1) & 0xFFL) << 48;
        rv |= ((long)source.getByte(2) & 0xFFL) << 40;
        rv |= ((long)source.getByte(3) & 0xFFL) << 32;
        rv |= ((long)source.getByte(4) & 0xFFL) << 24;
        rv |= ((long)source.getByte(5) & 0xFFL) << 16;
        rv |= ((long)source.getByte(6) & 0xFFL) << 8;
        return rv |= ((long)source.getByte(7) & 0xFFL) << 0;
    }

    public static long getBigLong(PrimitiveCollections.ByteList source, int offset) {
        long rv = 0L;
        rv |= ((long)source.getByte(offset + 0) & 0xFFL) << 56;
        rv |= ((long)source.getByte(offset + 1) & 0xFFL) << 48;
        rv |= ((long)source.getByte(offset + 2) & 0xFFL) << 40;
        rv |= ((long)source.getByte(offset + 3) & 0xFFL) << 32;
        rv |= ((long)source.getByte(offset + 4) & 0xFFL) << 24;
        rv |= ((long)source.getByte(offset + 5) & 0xFFL) << 16;
        rv |= ((long)source.getByte(offset + 6) & 0xFFL) << 8;
        return rv |= ((long)source.getByte(offset + 7) & 0xFFL) << 0;
    }

    public static long getBigLong(InputStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 56;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 48;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
    }

    public static long getBigLong(InputByteStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 56;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 48;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
    }

    public static long getBigLong(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        long rv = 0L;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 56;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 48;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 40;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 32;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 24;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 16;
        rv |= ((long)Bytes.getByte(source) & 0xFFL) << 8;
        return rv |= ((long)Bytes.getByte(source) & 0xFFL) << 0;
    }

    public static void putBigChar(byte[] dest, char value) {
        dest[0] = (byte)(value >>> 8 & 0xFF);
        dest[1] = (byte)(value >>> 0 & 0xFF);
    }

    public static void putBigChar(byte[] dest, int offset, char value) {
        dest[offset + 0] = (byte)(value >>> 8 & 0xFF);
        dest[offset + 1] = (byte)(value >>> 0 & 0xFF);
    }

    public static void putBigChar(Slice<byte[]> dest, char value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 8 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 0 & 0xFF);
    }

    public static void putBigChar(Slice<byte[]> dest, int offset, char value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 8 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 0 & 0xFF);
    }

    public static void setBigChar(PrimitiveCollections.ByteList dest, char value) {
        dest.setByte(0, (byte)(value >>> 8 & 0xFF));
        dest.setByte(1, (byte)(value >>> 0 & 0xFF));
    }

    public static void putBigChar(PrimitiveCollections.ByteList dest, int offset, char value) {
        dest.setByte(offset + 0, (byte)(value >>> 8 & 0xFF));
        dest.setByte(offset + 1, (byte)(value >>> 0 & 0xFF));
    }

    public static void addBigChar(PrimitiveCollections.ByteList dest, char value) {
        dest.addByte((byte)(value >>> 8 & 0xFF));
        dest.addByte((byte)(value >>> 0 & 0xFF));
    }

    public static void addBigChar(PrimitiveCollections.ByteList dest, int offset, char value) {
        dest.insertByte(offset + 0, (byte)(value >>> 8 & 0xFF));
        dest.insertByte(offset + 1, (byte)(value >>> 0 & 0xFF));
    }

    public static void putBigChar(OutputStream dest, char value) throws IOException, EOFException {
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 0 & 0xFF));
    }

    public static void putBigChar(OutputByteStream dest, char value) throws IOException, EOFException {
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 0 & 0xFF));
    }

    public static void putBigChar(StreamAPIs.ByteBlockWriteStream dest, char value) throws IOException, EOFException {
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 0 & 0xFF));
    }

    public static void putBigShort(byte[] dest, short value) {
        dest[0] = (byte)(value >>> 8 & 0xFF);
        dest[1] = (byte)(value >>> 0 & 0xFF);
    }

    public static void putBigShort(byte[] dest, int offset, short value) {
        dest[offset + 0] = (byte)(value >>> 8 & 0xFF);
        dest[offset + 1] = (byte)(value >>> 0 & 0xFF);
    }

    public static void putBigShort(Slice<byte[]> dest, short value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 8 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 0 & 0xFF);
    }

    public static void putBigShort(Slice<byte[]> dest, int offset, short value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 8 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 0 & 0xFF);
    }

    public static void setBigShort(PrimitiveCollections.ByteList dest, short value) {
        dest.setByte(0, (byte)(value >>> 8 & 0xFF));
        dest.setByte(1, (byte)(value >>> 0 & 0xFF));
    }

    public static void putBigShort(PrimitiveCollections.ByteList dest, int offset, short value) {
        dest.setByte(offset + 0, (byte)(value >>> 8 & 0xFF));
        dest.setByte(offset + 1, (byte)(value >>> 0 & 0xFF));
    }

    public static void addBigShort(PrimitiveCollections.ByteList dest, short value) {
        dest.addByte((byte)(value >>> 8 & 0xFF));
        dest.addByte((byte)(value >>> 0 & 0xFF));
    }

    public static void addBigShort(PrimitiveCollections.ByteList dest, int offset, short value) {
        dest.insertByte(offset + 0, (byte)(value >>> 8 & 0xFF));
        dest.insertByte(offset + 1, (byte)(value >>> 0 & 0xFF));
    }

    public static void putBigShort(OutputStream dest, short value) throws IOException, EOFException {
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 0 & 0xFF));
    }

    public static void putBigShort(OutputByteStream dest, short value) throws IOException, EOFException {
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 0 & 0xFF));
    }

    public static void putBigShort(StreamAPIs.ByteBlockWriteStream dest, short value) throws IOException, EOFException {
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 0 & 0xFF));
    }

    public static void putBigInt24(byte[] dest, int value) {
        dest[0] = (byte)(value >>> 16 & 0xFF);
        dest[1] = (byte)(value >>> 8 & 0xFF);
        dest[2] = (byte)(value >>> 0 & 0xFF);
    }

    public static void putBigInt24(byte[] dest, int offset, int value) {
        dest[offset + 0] = (byte)(value >>> 16 & 0xFF);
        dest[offset + 1] = (byte)(value >>> 8 & 0xFF);
        dest[offset + 2] = (byte)(value >>> 0 & 0xFF);
    }

    public static void putBigInt24(Slice<byte[]> dest, int value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 16 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 8 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 2] = (byte)(value >>> 0 & 0xFF);
    }

    public static void putBigInt24(Slice<byte[]> dest, int offset, int value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 16 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 8 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 2] = (byte)(value >>> 0 & 0xFF);
    }

    public static void setBigInt24(PrimitiveCollections.ByteList dest, int value) {
        dest.setByte(0, (byte)(value >>> 16 & 0xFF));
        dest.setByte(1, (byte)(value >>> 8 & 0xFF));
        dest.setByte(2, (byte)(value >>> 0 & 0xFF));
    }

    public static void putBigInt24(PrimitiveCollections.ByteList dest, int offset, int value) {
        dest.setByte(offset + 0, (byte)(value >>> 16 & 0xFF));
        dest.setByte(offset + 1, (byte)(value >>> 8 & 0xFF));
        dest.setByte(offset + 2, (byte)(value >>> 0 & 0xFF));
    }

    public static void addBigInt24(PrimitiveCollections.ByteList dest, int value) {
        dest.addByte((byte)(value >>> 16 & 0xFF));
        dest.addByte((byte)(value >>> 8 & 0xFF));
        dest.addByte((byte)(value >>> 0 & 0xFF));
    }

    public static void addBigInt24(PrimitiveCollections.ByteList dest, int offset, int value) {
        dest.insertByte(offset + 0, (byte)(value >>> 16 & 0xFF));
        dest.insertByte(offset + 1, (byte)(value >>> 8 & 0xFF));
        dest.insertByte(offset + 2, (byte)(value >>> 0 & 0xFF));
    }

    public static void putBigInt24(OutputStream dest, int value) throws IOException, EOFException {
        dest.write((byte)(value >>> 16 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 0 & 0xFF));
    }

    public static void putBigInt24(OutputByteStream dest, int value) throws IOException, EOFException {
        dest.write((byte)(value >>> 16 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 0 & 0xFF));
    }

    public static void putBigInt24(StreamAPIs.ByteBlockWriteStream dest, int value) throws IOException, EOFException {
        dest.write((byte)(value >>> 16 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 0 & 0xFF));
    }

    public static void putBigInt(byte[] dest, int value) {
        dest[0] = (byte)(value >>> 24 & 0xFF);
        dest[1] = (byte)(value >>> 16 & 0xFF);
        dest[2] = (byte)(value >>> 8 & 0xFF);
        dest[3] = (byte)(value >>> 0 & 0xFF);
    }

    public static void putBigInt(byte[] dest, int offset, int value) {
        dest[offset + 0] = (byte)(value >>> 24 & 0xFF);
        dest[offset + 1] = (byte)(value >>> 16 & 0xFF);
        dest[offset + 2] = (byte)(value >>> 8 & 0xFF);
        dest[offset + 3] = (byte)(value >>> 0 & 0xFF);
    }

    public static void putBigInt(Slice<byte[]> dest, int value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 24 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 16 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 2] = (byte)(value >>> 8 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + 3] = (byte)(value >>> 0 & 0xFF);
    }

    public static void putBigInt(Slice<byte[]> dest, int offset, int value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 24 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 16 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 2] = (byte)(value >>> 8 & 0xFF);
        dest.getUnderlying()[dest.getOffset() + offset + 3] = (byte)(value >>> 0 & 0xFF);
    }

    public static void setBigInt(PrimitiveCollections.ByteList dest, int value) {
        dest.setByte(0, (byte)(value >>> 24 & 0xFF));
        dest.setByte(1, (byte)(value >>> 16 & 0xFF));
        dest.setByte(2, (byte)(value >>> 8 & 0xFF));
        dest.setByte(3, (byte)(value >>> 0 & 0xFF));
    }

    public static void putBigInt(PrimitiveCollections.ByteList dest, int offset, int value) {
        dest.setByte(offset + 0, (byte)(value >>> 24 & 0xFF));
        dest.setByte(offset + 1, (byte)(value >>> 16 & 0xFF));
        dest.setByte(offset + 2, (byte)(value >>> 8 & 0xFF));
        dest.setByte(offset + 3, (byte)(value >>> 0 & 0xFF));
    }

    public static void addBigInt(PrimitiveCollections.ByteList dest, int value) {
        dest.addByte((byte)(value >>> 24 & 0xFF));
        dest.addByte((byte)(value >>> 16 & 0xFF));
        dest.addByte((byte)(value >>> 8 & 0xFF));
        dest.addByte((byte)(value >>> 0 & 0xFF));
    }

    public static void addBigInt(PrimitiveCollections.ByteList dest, int offset, int value) {
        dest.insertByte(offset + 0, (byte)(value >>> 24 & 0xFF));
        dest.insertByte(offset + 1, (byte)(value >>> 16 & 0xFF));
        dest.insertByte(offset + 2, (byte)(value >>> 8 & 0xFF));
        dest.insertByte(offset + 3, (byte)(value >>> 0 & 0xFF));
    }

    public static void putBigInt(OutputStream dest, int value) throws IOException, EOFException {
        dest.write((byte)(value >>> 24 & 0xFF));
        dest.write((byte)(value >>> 16 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 0 & 0xFF));
    }

    public static void putBigInt(OutputByteStream dest, int value) throws IOException, EOFException {
        dest.write((byte)(value >>> 24 & 0xFF));
        dest.write((byte)(value >>> 16 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 0 & 0xFF));
    }

    public static void putBigInt(StreamAPIs.ByteBlockWriteStream dest, int value) throws IOException, EOFException {
        dest.write((byte)(value >>> 24 & 0xFF));
        dest.write((byte)(value >>> 16 & 0xFF));
        dest.write((byte)(value >>> 8 & 0xFF));
        dest.write((byte)(value >>> 0 & 0xFF));
    }

    public static void putBigLong40(byte[] dest, long value) {
        dest[0] = (byte)(value >>> 32 & 0xFFL);
        dest[1] = (byte)(value >>> 24 & 0xFFL);
        dest[2] = (byte)(value >>> 16 & 0xFFL);
        dest[3] = (byte)(value >>> 8 & 0xFFL);
        dest[4] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void putBigLong40(byte[] dest, int offset, long value) {
        dest[offset + 0] = (byte)(value >>> 32 & 0xFFL);
        dest[offset + 1] = (byte)(value >>> 24 & 0xFFL);
        dest[offset + 2] = (byte)(value >>> 16 & 0xFFL);
        dest[offset + 3] = (byte)(value >>> 8 & 0xFFL);
        dest[offset + 4] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void putBigLong40(Slice<byte[]> dest, long value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 2] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 3] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 4] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void putBigLong40(Slice<byte[]> dest, int offset, long value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 2] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 3] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 4] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void setBigLong40(PrimitiveCollections.ByteList dest, long value) {
        dest.setByte(0, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(1, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(2, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(3, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(4, (byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong40(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.setByte(offset + 0, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(offset + 1, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(offset + 2, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(offset + 3, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(offset + 4, (byte)(value >>> 0 & 0xFFL));
    }

    public static void addBigLong40(PrimitiveCollections.ByteList dest, long value) {
        dest.addByte((byte)(value >>> 32 & 0xFFL));
        dest.addByte((byte)(value >>> 24 & 0xFFL));
        dest.addByte((byte)(value >>> 16 & 0xFFL));
        dest.addByte((byte)(value >>> 8 & 0xFFL));
        dest.addByte((byte)(value >>> 0 & 0xFFL));
    }

    public static void addBigLong40(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.insertByte(offset + 0, (byte)(value >>> 32 & 0xFFL));
        dest.insertByte(offset + 1, (byte)(value >>> 24 & 0xFFL));
        dest.insertByte(offset + 2, (byte)(value >>> 16 & 0xFFL));
        dest.insertByte(offset + 3, (byte)(value >>> 8 & 0xFFL));
        dest.insertByte(offset + 4, (byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong40(OutputStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong40(OutputByteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong40(StreamAPIs.ByteBlockWriteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong48(byte[] dest, long value) {
        dest[0] = (byte)(value >>> 40 & 0xFFL);
        dest[1] = (byte)(value >>> 32 & 0xFFL);
        dest[2] = (byte)(value >>> 24 & 0xFFL);
        dest[3] = (byte)(value >>> 16 & 0xFFL);
        dest[4] = (byte)(value >>> 8 & 0xFFL);
        dest[5] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void putBigLong48(byte[] dest, int offset, long value) {
        dest[offset + 0] = (byte)(value >>> 40 & 0xFFL);
        dest[offset + 1] = (byte)(value >>> 32 & 0xFFL);
        dest[offset + 2] = (byte)(value >>> 24 & 0xFFL);
        dest[offset + 3] = (byte)(value >>> 16 & 0xFFL);
        dest[offset + 4] = (byte)(value >>> 8 & 0xFFL);
        dest[offset + 5] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void putBigLong48(Slice<byte[]> dest, long value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 40 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 2] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 3] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 4] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 5] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void putBigLong48(Slice<byte[]> dest, int offset, long value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 40 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 2] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 3] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 4] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 5] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void setBigLong48(PrimitiveCollections.ByteList dest, long value) {
        dest.setByte(0, (byte)(value >>> 40 & 0xFFL));
        dest.setByte(1, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(2, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(3, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(4, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(5, (byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong48(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.setByte(offset + 0, (byte)(value >>> 40 & 0xFFL));
        dest.setByte(offset + 1, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(offset + 2, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(offset + 3, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(offset + 4, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(offset + 5, (byte)(value >>> 0 & 0xFFL));
    }

    public static void addBigLong48(PrimitiveCollections.ByteList dest, long value) {
        dest.addByte((byte)(value >>> 40 & 0xFFL));
        dest.addByte((byte)(value >>> 32 & 0xFFL));
        dest.addByte((byte)(value >>> 24 & 0xFFL));
        dest.addByte((byte)(value >>> 16 & 0xFFL));
        dest.addByte((byte)(value >>> 8 & 0xFFL));
        dest.addByte((byte)(value >>> 0 & 0xFFL));
    }

    public static void addBigLong48(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.insertByte(offset + 0, (byte)(value >>> 40 & 0xFFL));
        dest.insertByte(offset + 1, (byte)(value >>> 32 & 0xFFL));
        dest.insertByte(offset + 2, (byte)(value >>> 24 & 0xFFL));
        dest.insertByte(offset + 3, (byte)(value >>> 16 & 0xFFL));
        dest.insertByte(offset + 4, (byte)(value >>> 8 & 0xFFL));
        dest.insertByte(offset + 5, (byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong48(OutputStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong48(OutputByteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong48(StreamAPIs.ByteBlockWriteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong56(byte[] dest, long value) {
        dest[0] = (byte)(value >>> 48 & 0xFFL);
        dest[1] = (byte)(value >>> 40 & 0xFFL);
        dest[2] = (byte)(value >>> 32 & 0xFFL);
        dest[3] = (byte)(value >>> 24 & 0xFFL);
        dest[4] = (byte)(value >>> 16 & 0xFFL);
        dest[5] = (byte)(value >>> 8 & 0xFFL);
        dest[6] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void putBigLong56(byte[] dest, int offset, long value) {
        dest[offset + 0] = (byte)(value >>> 48 & 0xFFL);
        dest[offset + 1] = (byte)(value >>> 40 & 0xFFL);
        dest[offset + 2] = (byte)(value >>> 32 & 0xFFL);
        dest[offset + 3] = (byte)(value >>> 24 & 0xFFL);
        dest[offset + 4] = (byte)(value >>> 16 & 0xFFL);
        dest[offset + 5] = (byte)(value >>> 8 & 0xFFL);
        dest[offset + 6] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void putBigLong56(Slice<byte[]> dest, long value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 48 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 40 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 2] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 3] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 4] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 5] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 6] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void putBigLong56(Slice<byte[]> dest, int offset, long value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 48 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 40 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 2] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 3] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 4] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 5] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 6] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void setBigLong56(PrimitiveCollections.ByteList dest, long value) {
        dest.setByte(0, (byte)(value >>> 48 & 0xFFL));
        dest.setByte(1, (byte)(value >>> 40 & 0xFFL));
        dest.setByte(2, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(3, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(4, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(5, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(6, (byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong56(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.setByte(offset + 0, (byte)(value >>> 48 & 0xFFL));
        dest.setByte(offset + 1, (byte)(value >>> 40 & 0xFFL));
        dest.setByte(offset + 2, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(offset + 3, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(offset + 4, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(offset + 5, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(offset + 6, (byte)(value >>> 0 & 0xFFL));
    }

    public static void addBigLong56(PrimitiveCollections.ByteList dest, long value) {
        dest.addByte((byte)(value >>> 48 & 0xFFL));
        dest.addByte((byte)(value >>> 40 & 0xFFL));
        dest.addByte((byte)(value >>> 32 & 0xFFL));
        dest.addByte((byte)(value >>> 24 & 0xFFL));
        dest.addByte((byte)(value >>> 16 & 0xFFL));
        dest.addByte((byte)(value >>> 8 & 0xFFL));
        dest.addByte((byte)(value >>> 0 & 0xFFL));
    }

    public static void addBigLong56(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.insertByte(offset + 0, (byte)(value >>> 48 & 0xFFL));
        dest.insertByte(offset + 1, (byte)(value >>> 40 & 0xFFL));
        dest.insertByte(offset + 2, (byte)(value >>> 32 & 0xFFL));
        dest.insertByte(offset + 3, (byte)(value >>> 24 & 0xFFL));
        dest.insertByte(offset + 4, (byte)(value >>> 16 & 0xFFL));
        dest.insertByte(offset + 5, (byte)(value >>> 8 & 0xFFL));
        dest.insertByte(offset + 6, (byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong56(OutputStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 48 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong56(OutputByteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 48 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong56(StreamAPIs.ByteBlockWriteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 48 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong(byte[] dest, long value) {
        dest[0] = (byte)(value >>> 56 & 0xFFL);
        dest[1] = (byte)(value >>> 48 & 0xFFL);
        dest[2] = (byte)(value >>> 40 & 0xFFL);
        dest[3] = (byte)(value >>> 32 & 0xFFL);
        dest[4] = (byte)(value >>> 24 & 0xFFL);
        dest[5] = (byte)(value >>> 16 & 0xFFL);
        dest[6] = (byte)(value >>> 8 & 0xFFL);
        dest[7] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void putBigLong(byte[] dest, int offset, long value) {
        dest[offset + 0] = (byte)(value >>> 56 & 0xFFL);
        dest[offset + 1] = (byte)(value >>> 48 & 0xFFL);
        dest[offset + 2] = (byte)(value >>> 40 & 0xFFL);
        dest[offset + 3] = (byte)(value >>> 32 & 0xFFL);
        dest[offset + 4] = (byte)(value >>> 24 & 0xFFL);
        dest[offset + 5] = (byte)(value >>> 16 & 0xFFL);
        dest[offset + 6] = (byte)(value >>> 8 & 0xFFL);
        dest[offset + 7] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void putBigLong(Slice<byte[]> dest, long value) {
        dest.getUnderlying()[dest.getOffset() + 0] = (byte)(value >>> 56 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 1] = (byte)(value >>> 48 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 2] = (byte)(value >>> 40 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 3] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 4] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 5] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 6] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + 7] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void putBigLong(Slice<byte[]> dest, int offset, long value) {
        dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)(value >>> 56 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 1] = (byte)(value >>> 48 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 2] = (byte)(value >>> 40 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 3] = (byte)(value >>> 32 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 4] = (byte)(value >>> 24 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 5] = (byte)(value >>> 16 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 6] = (byte)(value >>> 8 & 0xFFL);
        dest.getUnderlying()[dest.getOffset() + offset + 7] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void setBigLong(PrimitiveCollections.ByteList dest, long value) {
        dest.setByte(0, (byte)(value >>> 56 & 0xFFL));
        dest.setByte(1, (byte)(value >>> 48 & 0xFFL));
        dest.setByte(2, (byte)(value >>> 40 & 0xFFL));
        dest.setByte(3, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(4, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(5, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(6, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(7, (byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.setByte(offset + 0, (byte)(value >>> 56 & 0xFFL));
        dest.setByte(offset + 1, (byte)(value >>> 48 & 0xFFL));
        dest.setByte(offset + 2, (byte)(value >>> 40 & 0xFFL));
        dest.setByte(offset + 3, (byte)(value >>> 32 & 0xFFL));
        dest.setByte(offset + 4, (byte)(value >>> 24 & 0xFFL));
        dest.setByte(offset + 5, (byte)(value >>> 16 & 0xFFL));
        dest.setByte(offset + 6, (byte)(value >>> 8 & 0xFFL));
        dest.setByte(offset + 7, (byte)(value >>> 0 & 0xFFL));
    }

    public static void addBigLong(PrimitiveCollections.ByteList dest, long value) {
        dest.addByte((byte)(value >>> 56 & 0xFFL));
        dest.addByte((byte)(value >>> 48 & 0xFFL));
        dest.addByte((byte)(value >>> 40 & 0xFFL));
        dest.addByte((byte)(value >>> 32 & 0xFFL));
        dest.addByte((byte)(value >>> 24 & 0xFFL));
        dest.addByte((byte)(value >>> 16 & 0xFFL));
        dest.addByte((byte)(value >>> 8 & 0xFFL));
        dest.addByte((byte)(value >>> 0 & 0xFFL));
    }

    public static void addBigLong(PrimitiveCollections.ByteList dest, int offset, long value) {
        dest.insertByte(offset + 0, (byte)(value >>> 56 & 0xFFL));
        dest.insertByte(offset + 1, (byte)(value >>> 48 & 0xFFL));
        dest.insertByte(offset + 2, (byte)(value >>> 40 & 0xFFL));
        dest.insertByte(offset + 3, (byte)(value >>> 32 & 0xFFL));
        dest.insertByte(offset + 4, (byte)(value >>> 24 & 0xFFL));
        dest.insertByte(offset + 5, (byte)(value >>> 16 & 0xFFL));
        dest.insertByte(offset + 6, (byte)(value >>> 8 & 0xFFL));
        dest.insertByte(offset + 7, (byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong(OutputStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 56 & 0xFFL));
        dest.write((byte)(value >>> 48 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong(OutputByteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 56 & 0xFFL));
        dest.write((byte)(value >>> 48 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 0 & 0xFFL));
    }

    public static void putBigLong(StreamAPIs.ByteBlockWriteStream dest, long value) throws IOException, EOFException {
        dest.write((byte)(value >>> 56 & 0xFFL));
        dest.write((byte)(value >>> 48 & 0xFFL));
        dest.write((byte)(value >>> 40 & 0xFFL));
        dest.write((byte)(value >>> 32 & 0xFFL));
        dest.write((byte)(value >>> 24 & 0xFFL));
        dest.write((byte)(value >>> 16 & 0xFFL));
        dest.write((byte)(value >>> 8 & 0xFFL));
        dest.write((byte)(value >>> 0 & 0xFFL));
    }

    public static int getLittleSInt24(byte[] source) {
        return BitUtilities.signedUpcast24(Bytes.getLittleUInt24(source));
    }

    public static int getLittleSInt24(byte[] source, int offset) {
        return BitUtilities.signedUpcast24(Bytes.getLittleUInt24(source, offset));
    }

    public static int getLittleSInt24(Slice<byte[]> source) {
        return BitUtilities.signedUpcast24(Bytes.getLittleUInt24(source));
    }

    public static int getLittleSInt24(Slice<byte[]> source, int offset) {
        return BitUtilities.signedUpcast24(Bytes.getLittleUInt24(source, offset));
    }

    public static int getLittleSInt24(PrimitiveCollections.ByteList source) {
        return BitUtilities.signedUpcast24(Bytes.getLittleUInt24(source));
    }

    public static int getLittleSInt24(PrimitiveCollections.ByteList source, int offset) {
        return BitUtilities.signedUpcast24(Bytes.getLittleUInt24(source, offset));
    }

    public static int getLittleSInt24(InputStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast24(Bytes.getLittleUInt24(source));
    }

    public static int getLittleSInt24(InputByteStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast24(Bytes.getLittleUInt24(source));
    }

    public static int getLittleSInt24(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast24(Bytes.getLittleUInt24(source));
    }

    public static long getLittleSLong40(byte[] source) {
        return BitUtilities.signedUpcast40(Bytes.getLittleULong40(source));
    }

    public static long getLittleSLong40(byte[] source, int offset) {
        return BitUtilities.signedUpcast40(Bytes.getLittleULong40(source, offset));
    }

    public static long getLittleSLong40(Slice<byte[]> source) {
        return BitUtilities.signedUpcast40(Bytes.getLittleULong40(source));
    }

    public static long getLittleSLong40(Slice<byte[]> source, int offset) {
        return BitUtilities.signedUpcast40(Bytes.getLittleULong40(source, offset));
    }

    public static long getLittleSLong40(PrimitiveCollections.ByteList source) {
        return BitUtilities.signedUpcast40(Bytes.getLittleULong40(source));
    }

    public static long getLittleSLong40(PrimitiveCollections.ByteList source, int offset) {
        return BitUtilities.signedUpcast40(Bytes.getLittleULong40(source, offset));
    }

    public static long getLittleSLong40(InputStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast40(Bytes.getLittleULong40(source));
    }

    public static long getLittleSLong40(InputByteStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast40(Bytes.getLittleULong40(source));
    }

    public static long getLittleSLong40(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast40(Bytes.getLittleULong40(source));
    }

    public static long getLittleSLong48(byte[] source) {
        return BitUtilities.signedUpcast48(Bytes.getLittleULong48(source));
    }

    public static long getLittleSLong48(byte[] source, int offset) {
        return BitUtilities.signedUpcast48(Bytes.getLittleULong48(source, offset));
    }

    public static long getLittleSLong48(Slice<byte[]> source) {
        return BitUtilities.signedUpcast48(Bytes.getLittleULong48(source));
    }

    public static long getLittleSLong48(Slice<byte[]> source, int offset) {
        return BitUtilities.signedUpcast48(Bytes.getLittleULong48(source, offset));
    }

    public static long getLittleSLong48(PrimitiveCollections.ByteList source) {
        return BitUtilities.signedUpcast48(Bytes.getLittleULong48(source));
    }

    public static long getLittleSLong48(PrimitiveCollections.ByteList source, int offset) {
        return BitUtilities.signedUpcast48(Bytes.getLittleULong48(source, offset));
    }

    public static long getLittleSLong48(InputStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast48(Bytes.getLittleULong48(source));
    }

    public static long getLittleSLong48(InputByteStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast48(Bytes.getLittleULong48(source));
    }

    public static long getLittleSLong48(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast48(Bytes.getLittleULong48(source));
    }

    public static long getLittleSLong56(byte[] source) {
        return BitUtilities.signedUpcast56(Bytes.getLittleULong56(source));
    }

    public static long getLittleSLong56(byte[] source, int offset) {
        return BitUtilities.signedUpcast56(Bytes.getLittleULong56(source, offset));
    }

    public static long getLittleSLong56(Slice<byte[]> source) {
        return BitUtilities.signedUpcast56(Bytes.getLittleULong56(source));
    }

    public static long getLittleSLong56(Slice<byte[]> source, int offset) {
        return BitUtilities.signedUpcast56(Bytes.getLittleULong56(source, offset));
    }

    public static long getLittleSLong56(PrimitiveCollections.ByteList source) {
        return BitUtilities.signedUpcast56(Bytes.getLittleULong56(source));
    }

    public static long getLittleSLong56(PrimitiveCollections.ByteList source, int offset) {
        return BitUtilities.signedUpcast56(Bytes.getLittleULong56(source, offset));
    }

    public static long getLittleSLong56(InputStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast56(Bytes.getLittleULong56(source));
    }

    public static long getLittleSLong56(InputByteStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast56(Bytes.getLittleULong56(source));
    }

    public static long getLittleSLong56(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast56(Bytes.getLittleULong56(source));
    }

    public static int getBigSInt24(byte[] source) {
        return BitUtilities.signedUpcast24(Bytes.getBigUInt24(source));
    }

    public static int getBigSInt24(byte[] source, int offset) {
        return BitUtilities.signedUpcast24(Bytes.getBigUInt24(source, offset));
    }

    public static int getBigSInt24(Slice<byte[]> source) {
        return BitUtilities.signedUpcast24(Bytes.getBigUInt24(source));
    }

    public static int getBigSInt24(Slice<byte[]> source, int offset) {
        return BitUtilities.signedUpcast24(Bytes.getBigUInt24(source, offset));
    }

    public static int getBigSInt24(PrimitiveCollections.ByteList source) {
        return BitUtilities.signedUpcast24(Bytes.getBigUInt24(source));
    }

    public static int getBigSInt24(PrimitiveCollections.ByteList source, int offset) {
        return BitUtilities.signedUpcast24(Bytes.getBigUInt24(source, offset));
    }

    public static int getBigSInt24(InputStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast24(Bytes.getBigUInt24(source));
    }

    public static int getBigSInt24(InputByteStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast24(Bytes.getBigUInt24(source));
    }

    public static int getBigSInt24(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast24(Bytes.getBigUInt24(source));
    }

    public static long getBigSLong40(byte[] source) {
        return BitUtilities.signedUpcast40(Bytes.getBigULong40(source));
    }

    public static long getBigSLong40(byte[] source, int offset) {
        return BitUtilities.signedUpcast40(Bytes.getBigULong40(source, offset));
    }

    public static long getBigSLong40(Slice<byte[]> source) {
        return BitUtilities.signedUpcast40(Bytes.getBigULong40(source));
    }

    public static long getBigSLong40(Slice<byte[]> source, int offset) {
        return BitUtilities.signedUpcast40(Bytes.getBigULong40(source, offset));
    }

    public static long getBigSLong40(PrimitiveCollections.ByteList source) {
        return BitUtilities.signedUpcast40(Bytes.getBigULong40(source));
    }

    public static long getBigSLong40(PrimitiveCollections.ByteList source, int offset) {
        return BitUtilities.signedUpcast40(Bytes.getBigULong40(source, offset));
    }

    public static long getBigSLong40(InputStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast40(Bytes.getBigULong40(source));
    }

    public static long getBigSLong40(InputByteStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast40(Bytes.getBigULong40(source));
    }

    public static long getBigSLong40(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast40(Bytes.getBigULong40(source));
    }

    public static long getBigSLong48(byte[] source) {
        return BitUtilities.signedUpcast48(Bytes.getBigULong48(source));
    }

    public static long getBigSLong48(byte[] source, int offset) {
        return BitUtilities.signedUpcast48(Bytes.getBigULong48(source, offset));
    }

    public static long getBigSLong48(Slice<byte[]> source) {
        return BitUtilities.signedUpcast48(Bytes.getBigULong48(source));
    }

    public static long getBigSLong48(Slice<byte[]> source, int offset) {
        return BitUtilities.signedUpcast48(Bytes.getBigULong48(source, offset));
    }

    public static long getBigSLong48(PrimitiveCollections.ByteList source) {
        return BitUtilities.signedUpcast48(Bytes.getBigULong48(source));
    }

    public static long getBigSLong48(PrimitiveCollections.ByteList source, int offset) {
        return BitUtilities.signedUpcast48(Bytes.getBigULong48(source, offset));
    }

    public static long getBigSLong48(InputStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast48(Bytes.getBigULong48(source));
    }

    public static long getBigSLong48(InputByteStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast48(Bytes.getBigULong48(source));
    }

    public static long getBigSLong48(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast48(Bytes.getBigULong48(source));
    }

    public static long getBigSLong56(byte[] source) {
        return BitUtilities.signedUpcast56(Bytes.getBigULong56(source));
    }

    public static long getBigSLong56(byte[] source, int offset) {
        return BitUtilities.signedUpcast56(Bytes.getBigULong56(source, offset));
    }

    public static long getBigSLong56(Slice<byte[]> source) {
        return BitUtilities.signedUpcast56(Bytes.getBigULong56(source));
    }

    public static long getBigSLong56(Slice<byte[]> source, int offset) {
        return BitUtilities.signedUpcast56(Bytes.getBigULong56(source, offset));
    }

    public static long getBigSLong56(PrimitiveCollections.ByteList source) {
        return BitUtilities.signedUpcast56(Bytes.getBigULong56(source));
    }

    public static long getBigSLong56(PrimitiveCollections.ByteList source, int offset) {
        return BitUtilities.signedUpcast56(Bytes.getBigULong56(source, offset));
    }

    public static long getBigSLong56(InputStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast56(Bytes.getBigULong56(source));
    }

    public static long getBigSLong56(InputByteStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast56(Bytes.getBigULong56(source));
    }

    public static long getBigSLong56(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        return BitUtilities.signedUpcast56(Bytes.getBigULong56(source));
    }

    public static float getLittleFloat(byte[] source) {
        return Float.intBitsToFloat(Bytes.getLittleInt(source));
    }

    public static float getLittleFloat(byte[] source, int offset) {
        return Float.intBitsToFloat(Bytes.getLittleInt(source, offset));
    }

    public static float getLittleFloat(Slice<byte[]> source) {
        return Float.intBitsToFloat(Bytes.getLittleInt(source));
    }

    public static float getLittleFloat(Slice<byte[]> source, int offset) {
        return Float.intBitsToFloat(Bytes.getLittleInt(source, offset));
    }

    public static float getLittleFloat(PrimitiveCollections.ByteList source) {
        return Float.intBitsToFloat(Bytes.getLittleInt(source));
    }

    public static float getLittleFloat(PrimitiveCollections.ByteList source, int offset) {
        return Float.intBitsToFloat(Bytes.getLittleInt(source, offset));
    }

    public static float getLittleFloat(InputStream source) throws IOException, EOFException {
        return Float.intBitsToFloat(Bytes.getLittleInt(source));
    }

    public static float getLittleFloat(InputByteStream source) throws IOException, EOFException {
        return Float.intBitsToFloat(Bytes.getLittleInt(source));
    }

    public static float getLittleFloat(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        return Float.intBitsToFloat(Bytes.getLittleInt(source));
    }

    public static void putLittleFloat(byte[] dest, float value) {
        Bytes.putLittleInt(dest, Float.floatToRawIntBits(value));
    }

    public static void putLittleFloat(byte[] dest, int offset, float value) {
        Bytes.putLittleInt(dest, offset, Float.floatToRawIntBits(value));
    }

    public static void putLittleFloat(Slice<byte[]> dest, float value) {
        Bytes.putLittleInt(dest, Float.floatToRawIntBits(value));
    }

    public static void putLittleFloat(Slice<byte[]> dest, int offset, float value) {
        Bytes.putLittleInt(dest, offset, Float.floatToRawIntBits(value));
    }

    public static void setLittleFloat(PrimitiveCollections.ByteList dest, float value) {
        Bytes.setLittleInt(dest, Float.floatToRawIntBits(value));
    }

    public static void putLittleFloat(PrimitiveCollections.ByteList dest, int offset, float value) {
        Bytes.putLittleInt(dest, offset, Float.floatToRawIntBits(value));
    }

    public static void addLittleFloat(PrimitiveCollections.ByteList dest, float value) {
        Bytes.addLittleInt(dest, Float.floatToRawIntBits(value));
    }

    public static void addLittleFloat(PrimitiveCollections.ByteList dest, int offset, float value) {
        Bytes.addLittleInt(dest, offset, Float.floatToRawIntBits(value));
    }

    public static void putLittleFloat(OutputStream dest, float value) throws IOException, EOFException {
        Bytes.putLittleInt(dest, Float.floatToRawIntBits(value));
    }

    public static void putLittleFloat(OutputByteStream dest, float value) throws IOException, EOFException {
        Bytes.putLittleInt(dest, Float.floatToRawIntBits(value));
    }

    public static void putLittleFloat(StreamAPIs.ByteBlockWriteStream dest, float value) throws IOException, EOFException {
        Bytes.putLittleInt(dest, Float.floatToRawIntBits(value));
    }

    public static double getLittleDouble(byte[] source) {
        return Double.longBitsToDouble(Bytes.getLittleLong(source));
    }

    public static double getLittleDouble(byte[] source, int offset) {
        return Double.longBitsToDouble(Bytes.getLittleLong(source, offset));
    }

    public static double getLittleDouble(Slice<byte[]> source) {
        return Double.longBitsToDouble(Bytes.getLittleLong(source));
    }

    public static double getLittleDouble(Slice<byte[]> source, int offset) {
        return Double.longBitsToDouble(Bytes.getLittleLong(source, offset));
    }

    public static double getLittleDouble(PrimitiveCollections.ByteList source) {
        return Double.longBitsToDouble(Bytes.getLittleLong(source));
    }

    public static double getLittleDouble(PrimitiveCollections.ByteList source, int offset) {
        return Double.longBitsToDouble(Bytes.getLittleLong(source, offset));
    }

    public static double getLittleDouble(InputStream source) throws IOException, EOFException {
        return Double.longBitsToDouble(Bytes.getLittleLong(source));
    }

    public static double getLittleDouble(InputByteStream source) throws IOException, EOFException {
        return Double.longBitsToDouble(Bytes.getLittleLong(source));
    }

    public static double getLittleDouble(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        return Double.longBitsToDouble(Bytes.getLittleLong(source));
    }

    public static void putLittleDouble(byte[] dest, double value) {
        Bytes.putLittleLong(dest, Double.doubleToRawLongBits(value));
    }

    public static void putLittleDouble(byte[] dest, int offset, double value) {
        Bytes.putLittleLong(dest, offset, Double.doubleToRawLongBits(value));
    }

    public static void putLittleDouble(Slice<byte[]> dest, double value) {
        Bytes.putLittleLong(dest, Double.doubleToRawLongBits(value));
    }

    public static void putLittleDouble(Slice<byte[]> dest, int offset, double value) {
        Bytes.putLittleLong(dest, offset, Double.doubleToRawLongBits(value));
    }

    public static void setLittleDouble(PrimitiveCollections.ByteList dest, double value) {
        Bytes.setLittleLong(dest, Double.doubleToRawLongBits(value));
    }

    public static void putLittleDouble(PrimitiveCollections.ByteList dest, int offset, double value) {
        Bytes.putLittleLong(dest, offset, Double.doubleToRawLongBits(value));
    }

    public static void addLittleDouble(PrimitiveCollections.ByteList dest, double value) {
        Bytes.addLittleLong(dest, Double.doubleToRawLongBits(value));
    }

    public static void addLittleDouble(PrimitiveCollections.ByteList dest, int offset, double value) {
        Bytes.addLittleLong(dest, offset, Double.doubleToRawLongBits(value));
    }

    public static void putLittleDouble(OutputStream dest, double value) throws IOException, EOFException {
        Bytes.putLittleLong(dest, Double.doubleToRawLongBits(value));
    }

    public static void putLittleDouble(OutputByteStream dest, double value) throws IOException, EOFException {
        Bytes.putLittleLong(dest, Double.doubleToRawLongBits(value));
    }

    public static void putLittleDouble(StreamAPIs.ByteBlockWriteStream dest, double value) throws IOException, EOFException {
        Bytes.putLittleLong(dest, Double.doubleToRawLongBits(value));
    }

    public static float getBigFloat(byte[] source) {
        return Float.intBitsToFloat(Bytes.getBigInt(source));
    }

    public static float getBigFloat(byte[] source, int offset) {
        return Float.intBitsToFloat(Bytes.getBigInt(source, offset));
    }

    public static float getBigFloat(Slice<byte[]> source) {
        return Float.intBitsToFloat(Bytes.getBigInt(source));
    }

    public static float getBigFloat(Slice<byte[]> source, int offset) {
        return Float.intBitsToFloat(Bytes.getBigInt(source, offset));
    }

    public static float getBigFloat(PrimitiveCollections.ByteList source) {
        return Float.intBitsToFloat(Bytes.getBigInt(source));
    }

    public static float getBigFloat(PrimitiveCollections.ByteList source, int offset) {
        return Float.intBitsToFloat(Bytes.getBigInt(source, offset));
    }

    public static float getBigFloat(InputStream source) throws IOException, EOFException {
        return Float.intBitsToFloat(Bytes.getBigInt(source));
    }

    public static float getBigFloat(InputByteStream source) throws IOException, EOFException {
        return Float.intBitsToFloat(Bytes.getBigInt(source));
    }

    public static float getBigFloat(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        return Float.intBitsToFloat(Bytes.getBigInt(source));
    }

    public static void putBigFloat(byte[] dest, float value) {
        Bytes.putBigInt(dest, Float.floatToRawIntBits(value));
    }

    public static void putBigFloat(byte[] dest, int offset, float value) {
        Bytes.putBigInt(dest, offset, Float.floatToRawIntBits(value));
    }

    public static void putBigFloat(Slice<byte[]> dest, float value) {
        Bytes.putBigInt(dest, Float.floatToRawIntBits(value));
    }

    public static void putBigFloat(Slice<byte[]> dest, int offset, float value) {
        Bytes.putBigInt(dest, offset, Float.floatToRawIntBits(value));
    }

    public static void setBigFloat(PrimitiveCollections.ByteList dest, float value) {
        Bytes.setBigInt(dest, Float.floatToRawIntBits(value));
    }

    public static void putBigFloat(PrimitiveCollections.ByteList dest, int offset, float value) {
        Bytes.putBigInt(dest, offset, Float.floatToRawIntBits(value));
    }

    public static void addBigFloat(PrimitiveCollections.ByteList dest, float value) {
        Bytes.addBigInt(dest, Float.floatToRawIntBits(value));
    }

    public static void addBigFloat(PrimitiveCollections.ByteList dest, int offset, float value) {
        Bytes.addBigInt(dest, offset, Float.floatToRawIntBits(value));
    }

    public static void putBigFloat(OutputStream dest, float value) throws IOException, EOFException {
        Bytes.putBigInt(dest, Float.floatToRawIntBits(value));
    }

    public static void putBigFloat(OutputByteStream dest, float value) throws IOException, EOFException {
        Bytes.putBigInt(dest, Float.floatToRawIntBits(value));
    }

    public static void putBigFloat(StreamAPIs.ByteBlockWriteStream dest, float value) throws IOException, EOFException {
        Bytes.putBigInt(dest, Float.floatToRawIntBits(value));
    }

    public static double getBigDouble(byte[] source) {
        return Double.longBitsToDouble(Bytes.getBigLong(source));
    }

    public static double getBigDouble(byte[] source, int offset) {
        return Double.longBitsToDouble(Bytes.getBigLong(source, offset));
    }

    public static double getBigDouble(Slice<byte[]> source) {
        return Double.longBitsToDouble(Bytes.getBigLong(source));
    }

    public static double getBigDouble(Slice<byte[]> source, int offset) {
        return Double.longBitsToDouble(Bytes.getBigLong(source, offset));
    }

    public static double getBigDouble(PrimitiveCollections.ByteList source) {
        return Double.longBitsToDouble(Bytes.getBigLong(source));
    }

    public static double getBigDouble(PrimitiveCollections.ByteList source, int offset) {
        return Double.longBitsToDouble(Bytes.getBigLong(source, offset));
    }

    public static double getBigDouble(InputStream source) throws IOException, EOFException {
        return Double.longBitsToDouble(Bytes.getBigLong(source));
    }

    public static double getBigDouble(InputByteStream source) throws IOException, EOFException {
        return Double.longBitsToDouble(Bytes.getBigLong(source));
    }

    public static double getBigDouble(StreamAPIs.ByteBlockReadStream source) throws IOException, EOFException {
        return Double.longBitsToDouble(Bytes.getBigLong(source));
    }

    public static void putBigDouble(byte[] dest, double value) {
        Bytes.putBigLong(dest, Double.doubleToRawLongBits(value));
    }

    public static void putBigDouble(byte[] dest, int offset, double value) {
        Bytes.putBigLong(dest, offset, Double.doubleToRawLongBits(value));
    }

    public static void putBigDouble(Slice<byte[]> dest, double value) {
        Bytes.putBigLong(dest, Double.doubleToRawLongBits(value));
    }

    public static void putBigDouble(Slice<byte[]> dest, int offset, double value) {
        Bytes.putBigLong(dest, offset, Double.doubleToRawLongBits(value));
    }

    public static void setBigDouble(PrimitiveCollections.ByteList dest, double value) {
        Bytes.setBigLong(dest, Double.doubleToRawLongBits(value));
    }

    public static void putBigDouble(PrimitiveCollections.ByteList dest, int offset, double value) {
        Bytes.putBigLong(dest, offset, Double.doubleToRawLongBits(value));
    }

    public static void addBigDouble(PrimitiveCollections.ByteList dest, double value) {
        Bytes.addBigLong(dest, Double.doubleToRawLongBits(value));
    }

    public static void addBigDouble(PrimitiveCollections.ByteList dest, int offset, double value) {
        Bytes.addBigLong(dest, offset, Double.doubleToRawLongBits(value));
    }

    public static void putBigDouble(OutputStream dest, double value) throws IOException, EOFException {
        Bytes.putBigLong(dest, Double.doubleToRawLongBits(value));
    }

    public static void putBigDouble(OutputByteStream dest, double value) throws IOException, EOFException {
        Bytes.putBigLong(dest, Double.doubleToRawLongBits(value));
    }

    public static void putBigDouble(StreamAPIs.ByteBlockWriteStream dest, double value) throws IOException, EOFException {
        Bytes.putBigLong(dest, Double.doubleToRawLongBits(value));
    }

    public static char getChar(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleChar(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigChar(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static char getChar(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleChar(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigChar(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static char getChar(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleChar(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigChar(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static char getChar(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleChar(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigChar(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static char getChar(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleChar(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigChar(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static char getChar(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleChar(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigChar(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static char getChar(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleChar(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigChar(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static char getChar(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleChar(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigChar(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static char getChar(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleChar(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigChar(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static char getChar(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleChar(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigChar(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static char getChar(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleChar(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigChar(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static short getShort(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleShort(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigShort(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static short getShort(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleShort(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigShort(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static short getShort(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleShort(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigShort(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static short getShort(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleShort(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigShort(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static short getShort(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleShort(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigShort(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static short getShort(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleShort(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigShort(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static short getShort(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleShort(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigShort(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static short getShort(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleShort(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigShort(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static short getShort(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleShort(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigShort(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static short getShort(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleShort(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigShort(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static short getShort(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleShort(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigShort(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getUInt24(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getUInt24(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUInt24(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUInt24(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getUInt24(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getUInt24(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUInt24(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUInt24(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getUInt24(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getUInt24(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUInt24(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUInt24(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getUInt24(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getUInt24(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getUInt24(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getUInt24(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getUInt24(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUInt24(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUInt24(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getInt(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleInt(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigInt(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getInt(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleInt(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigInt(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getInt(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleInt(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigInt(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getInt(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleInt(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigInt(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getInt(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleInt(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigInt(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getInt(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleInt(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigInt(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getInt(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleInt(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigInt(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getInt(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleInt(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigInt(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getInt(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleInt(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigInt(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getInt(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleInt(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigInt(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getInt(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleInt(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigInt(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong40(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong40(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong40(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong40(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong40(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong40(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong40(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong40(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong40(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong40(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong40(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong40(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong40(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong40(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong40(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong40(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong40(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong40(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong40(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong48(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong48(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong48(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong48(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong48(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong48(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong48(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong48(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong48(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong48(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong48(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong48(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong48(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong48(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong48(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong48(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong48(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong48(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong48(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong56(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong56(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong56(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong56(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong56(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong56(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong56(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong56(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong56(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong56(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong56(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong56(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong56(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong56(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong56(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong56(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getULong56(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleULong56(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigULong56(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLong(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleLong(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigLong(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLong(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleLong(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigLong(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLong(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleLong(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigLong(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLong(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleLong(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigLong(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLong(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleLong(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigLong(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLong(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleLong(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigLong(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLong(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleLong(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigLong(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLong(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleLong(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigLong(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLong(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleLong(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigLong(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLong(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleLong(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigLong(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLong(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleLong(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigLong(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static float getFloat(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleFloat(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigFloat(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static float getFloat(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleFloat(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigFloat(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static float getFloat(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleFloat(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigFloat(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static float getFloat(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleFloat(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigFloat(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static float getFloat(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleFloat(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigFloat(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static float getFloat(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleFloat(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigFloat(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static float getFloat(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleFloat(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigFloat(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static float getFloat(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleFloat(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigFloat(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static float getFloat(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleFloat(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigFloat(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static float getFloat(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleFloat(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigFloat(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static float getFloat(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleFloat(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigFloat(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static double getDouble(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleDouble(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigDouble(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static double getDouble(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleDouble(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigDouble(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static double getDouble(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleDouble(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigDouble(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static double getDouble(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleDouble(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigDouble(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static double getDouble(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleDouble(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigDouble(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static double getDouble(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleDouble(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigDouble(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static double getDouble(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleDouble(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigDouble(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static double getDouble(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleDouble(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigDouble(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static double getDouble(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleDouble(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigDouble(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static double getDouble(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleDouble(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigDouble(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static double getDouble(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleDouble(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigDouble(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getSInt24(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getSInt24(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSInt24(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSInt24(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getSInt24(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getSInt24(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSInt24(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSInt24(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getSInt24(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getSInt24(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSInt24(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSInt24(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getSInt24(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getSInt24(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getSInt24(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getSInt24(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSInt24(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSInt24(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getSInt24(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSInt24(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSInt24(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong40(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong40(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong40(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong40(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong40(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong40(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong40(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong40(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong40(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong40(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong40(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong40(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong40(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong40(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong40(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong40(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong40(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong40(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong40(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong40(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong40(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong48(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong48(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong48(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong48(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong48(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong48(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong48(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong48(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong48(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong48(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong48(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong48(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong48(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong48(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong48(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong48(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong48(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong48(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong48(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong48(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong48(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong56(byte[] source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong56(byte[] source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong56(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong56(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong56(Slice<byte[]> source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong56(Slice<byte[]> source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong56(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong56(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong56(PrimitiveCollections.ByteList source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong56(PrimitiveCollections.ByteList source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong56(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong56(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong56(InputStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong56(InputByteStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong56(StreamAPIs.ByteBlockReadStream source, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong56(ByteBuffer source, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong56(source);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong56(source);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getSLong56(ByteBuffer source, int offset, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleSLong56(source, offset);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigSLong56(source, offset);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static void putChar(byte[] dest, char value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleChar(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigChar(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putChar(byte[] dest, int offset, char value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleChar(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigChar(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putChar(Slice<byte[]> dest, char value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleChar(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigChar(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putChar(Slice<byte[]> dest, int offset, char value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleChar(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigChar(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void setChar(PrimitiveCollections.ByteList dest, char value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.setLittleChar(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.setBigChar(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putChar(PrimitiveCollections.ByteList dest, int offset, char value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleChar(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigChar(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addChar(PrimitiveCollections.ByteList dest, char value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleChar(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigChar(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addChar(PrimitiveCollections.ByteList dest, int offset, char value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleChar(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigChar(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putChar(OutputStream dest, char value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleChar(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigChar(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putChar(OutputByteStream dest, char value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleChar(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigChar(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putChar(StreamAPIs.ByteBlockWriteStream dest, char value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleChar(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigChar(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putChar(ByteBuffer dest, char value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleChar(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigChar(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putChar(ByteBuffer dest, int offset, char value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleChar(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigChar(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static byte[] packChar(char value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.packLittleChar(value);
        }
        if (endianness == Endianness.Big) {
            return Bytes.packBigChar(value);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static void putShort(byte[] dest, short value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleShort(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigShort(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putShort(byte[] dest, int offset, short value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleShort(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigShort(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putShort(Slice<byte[]> dest, short value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleShort(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigShort(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putShort(Slice<byte[]> dest, int offset, short value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleShort(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigShort(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void setShort(PrimitiveCollections.ByteList dest, short value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.setLittleShort(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.setBigShort(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putShort(PrimitiveCollections.ByteList dest, int offset, short value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleShort(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigShort(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addShort(PrimitiveCollections.ByteList dest, short value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleShort(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigShort(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addShort(PrimitiveCollections.ByteList dest, int offset, short value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleShort(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigShort(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putShort(OutputStream dest, short value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleShort(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigShort(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putShort(OutputByteStream dest, short value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleShort(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigShort(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putShort(StreamAPIs.ByteBlockWriteStream dest, short value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleShort(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigShort(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putShort(ByteBuffer dest, short value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleShort(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigShort(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putShort(ByteBuffer dest, int offset, short value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleShort(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigShort(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static byte[] packShort(short value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.packLittleShort(value);
        }
        if (endianness == Endianness.Big) {
            return Bytes.packBigShort(value);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static void putInt24(byte[] dest, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt24(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt24(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt24(byte[] dest, int offset, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt24(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt24(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt24(Slice<byte[]> dest, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt24(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt24(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt24(Slice<byte[]> dest, int offset, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt24(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt24(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void setInt24(PrimitiveCollections.ByteList dest, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.setLittleInt24(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.setBigInt24(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt24(PrimitiveCollections.ByteList dest, int offset, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt24(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt24(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addInt24(PrimitiveCollections.ByteList dest, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleInt24(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigInt24(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addInt24(PrimitiveCollections.ByteList dest, int offset, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleInt24(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigInt24(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt24(OutputStream dest, int value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt24(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt24(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt24(OutputByteStream dest, int value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt24(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt24(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt24(StreamAPIs.ByteBlockWriteStream dest, int value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt24(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt24(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt24(ByteBuffer dest, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt24(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt24(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt24(ByteBuffer dest, int offset, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt24(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt24(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static byte[] packInt24(int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.packLittleInt24(value);
        }
        if (endianness == Endianness.Big) {
            return Bytes.packBigInt24(value);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static void putInt(byte[] dest, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt(byte[] dest, int offset, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt(Slice<byte[]> dest, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt(Slice<byte[]> dest, int offset, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void setInt(PrimitiveCollections.ByteList dest, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.setLittleInt(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.setBigInt(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt(PrimitiveCollections.ByteList dest, int offset, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addInt(PrimitiveCollections.ByteList dest, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleInt(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigInt(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addInt(PrimitiveCollections.ByteList dest, int offset, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleInt(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigInt(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt(OutputStream dest, int value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt(OutputByteStream dest, int value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt(StreamAPIs.ByteBlockWriteStream dest, int value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt(ByteBuffer dest, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putInt(ByteBuffer dest, int offset, int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleInt(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigInt(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static byte[] packInt(int value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.packLittleInt(value);
        }
        if (endianness == Endianness.Big) {
            return Bytes.packBigInt(value);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static void putLong40(byte[] dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong40(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong40(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong40(byte[] dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong40(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong40(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong40(Slice<byte[]> dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong40(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong40(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong40(Slice<byte[]> dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong40(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong40(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void setLong40(PrimitiveCollections.ByteList dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.setLittleLong40(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.setBigLong40(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong40(PrimitiveCollections.ByteList dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong40(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong40(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addLong40(PrimitiveCollections.ByteList dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleLong40(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigLong40(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addLong40(PrimitiveCollections.ByteList dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleLong40(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigLong40(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong40(OutputStream dest, long value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong40(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong40(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong40(OutputByteStream dest, long value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong40(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong40(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong40(StreamAPIs.ByteBlockWriteStream dest, long value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong40(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong40(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong40(ByteBuffer dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong40(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong40(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong40(ByteBuffer dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong40(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong40(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static byte[] packLong40(long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.packLittleLong40(value);
        }
        if (endianness == Endianness.Big) {
            return Bytes.packBigLong40(value);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static void putLong48(byte[] dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong48(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong48(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong48(byte[] dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong48(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong48(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong48(Slice<byte[]> dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong48(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong48(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong48(Slice<byte[]> dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong48(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong48(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void setLong48(PrimitiveCollections.ByteList dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.setLittleLong48(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.setBigLong48(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong48(PrimitiveCollections.ByteList dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong48(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong48(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addLong48(PrimitiveCollections.ByteList dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleLong48(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigLong48(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addLong48(PrimitiveCollections.ByteList dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleLong48(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigLong48(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong48(OutputStream dest, long value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong48(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong48(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong48(OutputByteStream dest, long value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong48(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong48(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong48(StreamAPIs.ByteBlockWriteStream dest, long value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong48(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong48(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong48(ByteBuffer dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong48(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong48(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong48(ByteBuffer dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong48(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong48(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static byte[] packLong48(long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.packLittleLong48(value);
        }
        if (endianness == Endianness.Big) {
            return Bytes.packBigLong48(value);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static void putLong56(byte[] dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong56(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong56(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong56(byte[] dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong56(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong56(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong56(Slice<byte[]> dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong56(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong56(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong56(Slice<byte[]> dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong56(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong56(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void setLong56(PrimitiveCollections.ByteList dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.setLittleLong56(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.setBigLong56(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong56(PrimitiveCollections.ByteList dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong56(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong56(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addLong56(PrimitiveCollections.ByteList dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleLong56(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigLong56(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addLong56(PrimitiveCollections.ByteList dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleLong56(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigLong56(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong56(OutputStream dest, long value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong56(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong56(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong56(OutputByteStream dest, long value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong56(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong56(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong56(StreamAPIs.ByteBlockWriteStream dest, long value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong56(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong56(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong56(ByteBuffer dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong56(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong56(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong56(ByteBuffer dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong56(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong56(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static byte[] packLong56(long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.packLittleLong56(value);
        }
        if (endianness == Endianness.Big) {
            return Bytes.packBigLong56(value);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static void putLong(byte[] dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong(byte[] dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong(Slice<byte[]> dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong(Slice<byte[]> dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void setLong(PrimitiveCollections.ByteList dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.setLittleLong(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.setBigLong(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong(PrimitiveCollections.ByteList dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addLong(PrimitiveCollections.ByteList dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleLong(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigLong(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addLong(PrimitiveCollections.ByteList dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleLong(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigLong(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong(OutputStream dest, long value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong(OutputByteStream dest, long value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong(StreamAPIs.ByteBlockWriteStream dest, long value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong(ByteBuffer dest, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLong(ByteBuffer dest, int offset, long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleLong(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigLong(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static byte[] packLong(long value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.packLittleLong(value);
        }
        if (endianness == Endianness.Big) {
            return Bytes.packBigLong(value);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static void putFloat(byte[] dest, float value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleFloat(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigFloat(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putFloat(byte[] dest, int offset, float value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleFloat(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigFloat(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putFloat(Slice<byte[]> dest, float value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleFloat(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigFloat(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putFloat(Slice<byte[]> dest, int offset, float value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleFloat(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigFloat(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void setFloat(PrimitiveCollections.ByteList dest, float value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.setLittleFloat(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.setBigFloat(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putFloat(PrimitiveCollections.ByteList dest, int offset, float value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleFloat(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigFloat(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addFloat(PrimitiveCollections.ByteList dest, float value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleFloat(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigFloat(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addFloat(PrimitiveCollections.ByteList dest, int offset, float value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleFloat(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigFloat(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putFloat(OutputStream dest, float value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleFloat(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigFloat(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putFloat(OutputByteStream dest, float value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleFloat(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigFloat(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putFloat(StreamAPIs.ByteBlockWriteStream dest, float value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleFloat(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigFloat(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putFloat(ByteBuffer dest, float value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleFloat(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigFloat(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putFloat(ByteBuffer dest, int offset, float value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleFloat(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigFloat(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static byte[] packFloat(float value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.packLittleFloat(value);
        }
        if (endianness == Endianness.Big) {
            return Bytes.packBigFloat(value);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static void putDouble(byte[] dest, double value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleDouble(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigDouble(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putDouble(byte[] dest, int offset, double value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleDouble(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigDouble(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putDouble(Slice<byte[]> dest, double value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleDouble(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigDouble(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putDouble(Slice<byte[]> dest, int offset, double value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleDouble(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigDouble(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void setDouble(PrimitiveCollections.ByteList dest, double value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.setLittleDouble(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.setBigDouble(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putDouble(PrimitiveCollections.ByteList dest, int offset, double value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleDouble(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigDouble(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addDouble(PrimitiveCollections.ByteList dest, double value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleDouble(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigDouble(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addDouble(PrimitiveCollections.ByteList dest, int offset, double value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittleDouble(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.addBigDouble(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putDouble(OutputStream dest, double value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleDouble(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigDouble(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putDouble(OutputByteStream dest, double value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleDouble(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigDouble(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putDouble(StreamAPIs.ByteBlockWriteStream dest, double value, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittleDouble(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigDouble(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putDouble(ByteBuffer dest, double value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleDouble(dest, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigDouble(dest, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putDouble(ByteBuffer dest, int offset, double value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittleDouble(dest, offset, value);
        } else if (endianness == Endianness.Big) {
            Bytes.putBigDouble(dest, offset, value);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static byte[] packDouble(double value, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.packLittleDouble(value);
        }
        if (endianness == Endianness.Big) {
            return Bytes.packBigDouble(value);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static byte[] packLittleChar(char value) {
        byte[] dest = new byte[2];
        Bytes.putLittleChar(dest, value);
        return dest;
    }

    public static byte[] packLittleShort(short value) {
        byte[] dest = new byte[2];
        Bytes.putLittleShort(dest, value);
        return dest;
    }

    public static byte[] packLittleInt24(int value) {
        byte[] dest = new byte[3];
        Bytes.putLittleInt24(dest, value);
        return dest;
    }

    public static byte[] packLittleInt(int value) {
        byte[] dest = new byte[4];
        Bytes.putLittleInt(dest, value);
        return dest;
    }

    public static byte[] packLittleLong40(long value) {
        byte[] dest = new byte[5];
        Bytes.putLittleLong40(dest, value);
        return dest;
    }

    public static byte[] packLittleLong48(long value) {
        byte[] dest = new byte[6];
        Bytes.putLittleLong48(dest, value);
        return dest;
    }

    public static byte[] packLittleLong56(long value) {
        byte[] dest = new byte[7];
        Bytes.putLittleLong56(dest, value);
        return dest;
    }

    public static byte[] packLittleLong(long value) {
        byte[] dest = new byte[8];
        Bytes.putLittleLong(dest, value);
        return dest;
    }

    public static byte[] packLittleFloat(float value) {
        byte[] dest = new byte[4];
        Bytes.putLittleFloat(dest, value);
        return dest;
    }

    public static byte[] packLittleDouble(double value) {
        byte[] dest = new byte[8];
        Bytes.putLittleDouble(dest, value);
        return dest;
    }

    public static byte[] packBigChar(char value) {
        byte[] dest = new byte[2];
        Bytes.putBigChar(dest, value);
        return dest;
    }

    public static byte[] packBigShort(short value) {
        byte[] dest = new byte[2];
        Bytes.putBigShort(dest, value);
        return dest;
    }

    public static byte[] packBigInt24(int value) {
        byte[] dest = new byte[3];
        Bytes.putBigInt24(dest, value);
        return dest;
    }

    public static byte[] packBigInt(int value) {
        byte[] dest = new byte[4];
        Bytes.putBigInt(dest, value);
        return dest;
    }

    public static byte[] packBigLong40(long value) {
        byte[] dest = new byte[5];
        Bytes.putBigLong40(dest, value);
        return dest;
    }

    public static byte[] packBigLong48(long value) {
        byte[] dest = new byte[6];
        Bytes.putBigLong48(dest, value);
        return dest;
    }

    public static byte[] packBigLong56(long value) {
        byte[] dest = new byte[7];
        Bytes.putBigLong56(dest, value);
        return dest;
    }

    public static byte[] packBigLong(long value) {
        byte[] dest = new byte[8];
        Bytes.putBigLong(dest, value);
        return dest;
    }

    public static byte[] packBigFloat(float value) {
        byte[] dest = new byte[4];
        Bytes.putBigFloat(dest, value);
        return dest;
    }

    public static byte[] packBigDouble(double value) {
        byte[] dest = new byte[8];
        Bytes.putBigDouble(dest, value);
        return dest;
    }

    public static long getLittleUnsigned(byte[] source, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source[0] & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getLittleShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getLittleUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getLittleInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getLittleULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getLittleULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getLittleULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getLittleLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getBigUnsigned(byte[] source, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source[0] & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getBigShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getBigUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getBigInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getBigULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getBigULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getBigULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getBigLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getUnsigned(byte[] source, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUnsigned(source, numberOfBytes);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUnsigned(source, numberOfBytes);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLittleUnsigned(byte[] source, int offset, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source[offset + 0] & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getLittleShort(source, offset) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getLittleUInt24(source, offset) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getLittleInt(source, offset) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getLittleULong40(source, offset) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getLittleULong48(source, offset) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getLittleULong56(source, offset) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getLittleLong(source, offset);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getBigUnsigned(byte[] source, int offset, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source[offset + 0] & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getBigShort(source, offset) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getBigUInt24(source, offset) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getBigInt(source, offset) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getBigULong40(source, offset) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getBigULong48(source, offset) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getBigULong56(source, offset) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getBigLong(source, offset);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getUnsigned(byte[] source, int offset, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUnsigned(source, offset, numberOfBytes);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUnsigned(source, offset, numberOfBytes);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLittleUnsigned(Slice<byte[]> source, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source.getUnderlying()[source.getOffset() + 0] & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getLittleShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getLittleUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getLittleInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getLittleULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getLittleULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getLittleULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getLittleLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getBigUnsigned(Slice<byte[]> source, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source.getUnderlying()[source.getOffset() + 0] & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getBigShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getBigUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getBigInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getBigULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getBigULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getBigULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getBigLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getUnsigned(Slice<byte[]> source, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUnsigned(source, numberOfBytes);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUnsigned(source, numberOfBytes);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLittleUnsigned(Slice<byte[]> source, int offset, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source.getUnderlying()[source.getOffset() + offset + 0] & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getLittleShort(source, offset) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getLittleUInt24(source, offset) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getLittleInt(source, offset) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getLittleULong40(source, offset) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getLittleULong48(source, offset) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getLittleULong56(source, offset) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getLittleLong(source, offset);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getBigUnsigned(Slice<byte[]> source, int offset, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source.getUnderlying()[source.getOffset() + offset + 0] & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getBigShort(source, offset) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getBigUInt24(source, offset) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getBigInt(source, offset) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getBigULong40(source, offset) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getBigULong48(source, offset) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getBigULong56(source, offset) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getBigLong(source, offset);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getUnsigned(Slice<byte[]> source, int offset, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUnsigned(source, offset, numberOfBytes);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUnsigned(source, offset, numberOfBytes);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLittleUnsigned(PrimitiveCollections.ByteList source, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source.getByte(0) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getLittleShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getLittleUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getLittleInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getLittleULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getLittleULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getLittleULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getLittleLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getBigUnsigned(PrimitiveCollections.ByteList source, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source.getByte(0) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getBigShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getBigUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getBigInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getBigULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getBigULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getBigULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getBigLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getUnsigned(PrimitiveCollections.ByteList source, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUnsigned(source, numberOfBytes);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUnsigned(source, numberOfBytes);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLittleUnsigned(PrimitiveCollections.ByteList source, int offset, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source.getByte(offset + 0) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getLittleShort(source, offset) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getLittleUInt24(source, offset) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getLittleInt(source, offset) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getLittleULong40(source, offset) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getLittleULong48(source, offset) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getLittleULong56(source, offset) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getLittleLong(source, offset);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getBigUnsigned(PrimitiveCollections.ByteList source, int offset, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source.getByte(offset + 0) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getBigShort(source, offset) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getBigUInt24(source, offset) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getBigInt(source, offset) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getBigULong40(source, offset) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getBigULong48(source, offset) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getBigULong56(source, offset) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getBigLong(source, offset);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getUnsigned(PrimitiveCollections.ByteList source, int offset, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUnsigned(source, offset, numberOfBytes);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUnsigned(source, offset, numberOfBytes);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLittleUnsigned(InputStream source, int numberOfBytes) throws IOException, EOFException {
        switch (numberOfBytes) {
            case 1: {
                return (long)Bytes.getByte(source) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getLittleShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getLittleUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getLittleInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getLittleULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getLittleULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getLittleULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getLittleLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getBigUnsigned(InputStream source, int numberOfBytes) throws IOException, EOFException {
        switch (numberOfBytes) {
            case 1: {
                return (long)Bytes.getByte(source) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getBigShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getBigUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getBigInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getBigULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getBigULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getBigULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getBigLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getUnsigned(InputStream source, int numberOfBytes, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUnsigned(source, numberOfBytes);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUnsigned(source, numberOfBytes);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLittleUnsigned(InputByteStream source, int numberOfBytes) throws IOException, EOFException {
        switch (numberOfBytes) {
            case 1: {
                return (long)Bytes.getByte(source) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getLittleShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getLittleUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getLittleInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getLittleULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getLittleULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getLittleULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getLittleLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getBigUnsigned(InputByteStream source, int numberOfBytes) throws IOException, EOFException {
        switch (numberOfBytes) {
            case 1: {
                return (long)Bytes.getByte(source) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getBigShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getBigUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getBigInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getBigULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getBigULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getBigULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getBigLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getUnsigned(InputByteStream source, int numberOfBytes, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUnsigned(source, numberOfBytes);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUnsigned(source, numberOfBytes);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLittleUnsigned(StreamAPIs.ByteBlockReadStream source, int numberOfBytes) throws IOException, EOFException {
        switch (numberOfBytes) {
            case 1: {
                return (long)Bytes.getByte(source) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getLittleShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getLittleUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getLittleInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getLittleULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getLittleULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getLittleULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getLittleLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getBigUnsigned(StreamAPIs.ByteBlockReadStream source, int numberOfBytes) throws IOException, EOFException {
        switch (numberOfBytes) {
            case 1: {
                return (long)Bytes.getByte(source) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getBigShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getBigUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getBigInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getBigULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getBigULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getBigULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getBigLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getUnsigned(StreamAPIs.ByteBlockReadStream source, int numberOfBytes, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUnsigned(source, numberOfBytes);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUnsigned(source, numberOfBytes);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLittleUnsigned(ByteBuffer source, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source.get(0) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getLittleShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getLittleUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getLittleInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getLittleULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getLittleULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getLittleULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getLittleLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getBigUnsigned(ByteBuffer source, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source.get(0) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getBigShort(source) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getBigUInt24(source) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getBigInt(source) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getBigULong40(source) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getBigULong48(source) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getBigULong56(source) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getBigLong(source);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getUnsigned(ByteBuffer source, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUnsigned(source, numberOfBytes);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUnsigned(source, numberOfBytes);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static long getLittleUnsigned(ByteBuffer source, int offset, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source.get(offset + 0) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getLittleShort(source, offset) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getLittleUInt24(source, offset) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getLittleInt(source, offset) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getLittleULong40(source, offset) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getLittleULong48(source, offset) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getLittleULong56(source, offset) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getLittleLong(source, offset);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getBigUnsigned(ByteBuffer source, int offset, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                return (long)source.get(offset + 0) & 0xFFL;
            }
            case 2: {
                return (long)Bytes.getBigShort(source, offset) & 0xFFFFL;
            }
            case 3: {
                return (long)Bytes.getBigUInt24(source, offset) & 0xFFFFFFL;
            }
            case 4: {
                return (long)Bytes.getBigInt(source, offset) & 0xFFFFFFFFL;
            }
            case 5: {
                return Bytes.getBigULong40(source, offset) & 0xFFFFFFFFFFL;
            }
            case 6: {
                return Bytes.getBigULong48(source, offset) & 0xFFFFFFFFFFFFL;
            }
            case 7: {
                return Bytes.getBigULong56(source, offset) & 0xFFFFFFFFFFFFFFL;
            }
            case 8: {
                return Bytes.getBigLong(source, offset);
            }
        }
        throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
    }

    public static long getUnsigned(ByteBuffer source, int offset, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.getLittleUnsigned(source, offset, numberOfBytes);
        }
        if (endianness == Endianness.Big) {
            return Bytes.getBigUnsigned(source, offset, numberOfBytes);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static void putLittle(byte[] dest, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest[0] = (byte)value;
                break;
            }
            case 2: {
                Bytes.putLittleShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.putLittleInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.putLittleInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.putLittleLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.putLittleLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.putLittleLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.putLittleLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void putBig(byte[] dest, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest[0] = (byte)value;
                break;
            }
            case 2: {
                Bytes.putBigShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.putBigInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.putBigInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.putBigLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.putBigLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.putBigLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.putBigLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void put(byte[] dest, long value, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittle(dest, value, numberOfBytes);
        } else if (endianness == Endianness.Big) {
            Bytes.putBig(dest, value, numberOfBytes);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLittle(byte[] dest, int offset, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest[offset + 0] = (byte)value;
                break;
            }
            case 2: {
                Bytes.putLittleShort(dest, offset, (short)value);
                break;
            }
            case 3: {
                Bytes.putLittleInt24(dest, offset, (int)value);
                break;
            }
            case 4: {
                Bytes.putLittleInt(dest, offset, (int)value);
                break;
            }
            case 5: {
                Bytes.putLittleLong40(dest, offset, value);
                break;
            }
            case 6: {
                Bytes.putLittleLong48(dest, offset, value);
                break;
            }
            case 7: {
                Bytes.putLittleLong56(dest, offset, value);
                break;
            }
            case 8: {
                Bytes.putLittleLong(dest, offset, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void putBig(byte[] dest, int offset, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest[offset + 0] = (byte)value;
                break;
            }
            case 2: {
                Bytes.putBigShort(dest, offset, (short)value);
                break;
            }
            case 3: {
                Bytes.putBigInt24(dest, offset, (int)value);
                break;
            }
            case 4: {
                Bytes.putBigInt(dest, offset, (int)value);
                break;
            }
            case 5: {
                Bytes.putBigLong40(dest, offset, value);
                break;
            }
            case 6: {
                Bytes.putBigLong48(dest, offset, value);
                break;
            }
            case 7: {
                Bytes.putBigLong56(dest, offset, value);
                break;
            }
            case 8: {
                Bytes.putBigLong(dest, offset, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void put(byte[] dest, int offset, long value, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittle(dest, offset, value, numberOfBytes);
        } else if (endianness == Endianness.Big) {
            Bytes.putBig(dest, offset, value, numberOfBytes);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLittle(Slice<byte[]> dest, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.getUnderlying()[dest.getOffset() + 0] = (byte)value;
                break;
            }
            case 2: {
                Bytes.putLittleShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.putLittleInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.putLittleInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.putLittleLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.putLittleLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.putLittleLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.putLittleLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void putBig(Slice<byte[]> dest, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.getUnderlying()[dest.getOffset() + 0] = (byte)value;
                break;
            }
            case 2: {
                Bytes.putBigShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.putBigInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.putBigInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.putBigLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.putBigLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.putBigLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.putBigLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void put(Slice<byte[]> dest, long value, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittle(dest, value, numberOfBytes);
        } else if (endianness == Endianness.Big) {
            Bytes.putBig(dest, value, numberOfBytes);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLittle(Slice<byte[]> dest, int offset, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)value;
                break;
            }
            case 2: {
                Bytes.putLittleShort(dest, offset, (short)value);
                break;
            }
            case 3: {
                Bytes.putLittleInt24(dest, offset, (int)value);
                break;
            }
            case 4: {
                Bytes.putLittleInt(dest, offset, (int)value);
                break;
            }
            case 5: {
                Bytes.putLittleLong40(dest, offset, value);
                break;
            }
            case 6: {
                Bytes.putLittleLong48(dest, offset, value);
                break;
            }
            case 7: {
                Bytes.putLittleLong56(dest, offset, value);
                break;
            }
            case 8: {
                Bytes.putLittleLong(dest, offset, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void putBig(Slice<byte[]> dest, int offset, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.getUnderlying()[dest.getOffset() + offset + 0] = (byte)value;
                break;
            }
            case 2: {
                Bytes.putBigShort(dest, offset, (short)value);
                break;
            }
            case 3: {
                Bytes.putBigInt24(dest, offset, (int)value);
                break;
            }
            case 4: {
                Bytes.putBigInt(dest, offset, (int)value);
                break;
            }
            case 5: {
                Bytes.putBigLong40(dest, offset, value);
                break;
            }
            case 6: {
                Bytes.putBigLong48(dest, offset, value);
                break;
            }
            case 7: {
                Bytes.putBigLong56(dest, offset, value);
                break;
            }
            case 8: {
                Bytes.putBigLong(dest, offset, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void put(Slice<byte[]> dest, int offset, long value, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittle(dest, offset, value, numberOfBytes);
        } else if (endianness == Endianness.Big) {
            Bytes.putBig(dest, offset, value, numberOfBytes);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void setLittle(PrimitiveCollections.ByteList dest, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.setByte(0, (byte)value);
                break;
            }
            case 2: {
                Bytes.setLittleShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.setLittleInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.setLittleInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.setLittleLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.setLittleLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.setLittleLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.setLittleLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void setBig(PrimitiveCollections.ByteList dest, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.setByte(0, (byte)value);
                break;
            }
            case 2: {
                Bytes.setBigShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.setBigInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.setBigInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.setBigLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.setBigLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.setBigLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.setBigLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void set(PrimitiveCollections.ByteList dest, long value, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.setLittle(dest, value, numberOfBytes);
        } else if (endianness == Endianness.Big) {
            Bytes.setBig(dest, value, numberOfBytes);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLittle(PrimitiveCollections.ByteList dest, int offset, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.setByte(offset + 0, (byte)value);
                break;
            }
            case 2: {
                Bytes.putLittleShort(dest, offset, (short)value);
                break;
            }
            case 3: {
                Bytes.putLittleInt24(dest, offset, (int)value);
                break;
            }
            case 4: {
                Bytes.putLittleInt(dest, offset, (int)value);
                break;
            }
            case 5: {
                Bytes.putLittleLong40(dest, offset, value);
                break;
            }
            case 6: {
                Bytes.putLittleLong48(dest, offset, value);
                break;
            }
            case 7: {
                Bytes.putLittleLong56(dest, offset, value);
                break;
            }
            case 8: {
                Bytes.putLittleLong(dest, offset, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void putBig(PrimitiveCollections.ByteList dest, int offset, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.setByte(offset + 0, (byte)value);
                break;
            }
            case 2: {
                Bytes.putBigShort(dest, offset, (short)value);
                break;
            }
            case 3: {
                Bytes.putBigInt24(dest, offset, (int)value);
                break;
            }
            case 4: {
                Bytes.putBigInt(dest, offset, (int)value);
                break;
            }
            case 5: {
                Bytes.putBigLong40(dest, offset, value);
                break;
            }
            case 6: {
                Bytes.putBigLong48(dest, offset, value);
                break;
            }
            case 7: {
                Bytes.putBigLong56(dest, offset, value);
                break;
            }
            case 8: {
                Bytes.putBigLong(dest, offset, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void put(PrimitiveCollections.ByteList dest, int offset, long value, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittle(dest, offset, value, numberOfBytes);
        } else if (endianness == Endianness.Big) {
            Bytes.putBig(dest, offset, value, numberOfBytes);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addLittle(PrimitiveCollections.ByteList dest, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.addByte((byte)value);
                break;
            }
            case 2: {
                Bytes.addLittleShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.addLittleInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.addLittleInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.addLittleLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.addLittleLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.addLittleLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.addLittleLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void addBig(PrimitiveCollections.ByteList dest, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.addByte((byte)value);
                break;
            }
            case 2: {
                Bytes.addBigShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.addBigInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.addBigInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.addBigLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.addBigLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.addBigLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.addBigLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void add(PrimitiveCollections.ByteList dest, long value, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittle(dest, value, numberOfBytes);
        } else if (endianness == Endianness.Big) {
            Bytes.addBig(dest, value, numberOfBytes);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void addLittle(PrimitiveCollections.ByteList dest, int offset, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.insertByte(offset + 0, (byte)value);
                break;
            }
            case 2: {
                Bytes.addLittleShort(dest, offset, (short)value);
                break;
            }
            case 3: {
                Bytes.addLittleInt24(dest, offset, (int)value);
                break;
            }
            case 4: {
                Bytes.addLittleInt(dest, offset, (int)value);
                break;
            }
            case 5: {
                Bytes.addLittleLong40(dest, offset, value);
                break;
            }
            case 6: {
                Bytes.addLittleLong48(dest, offset, value);
                break;
            }
            case 7: {
                Bytes.addLittleLong56(dest, offset, value);
                break;
            }
            case 8: {
                Bytes.addLittleLong(dest, offset, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void addBig(PrimitiveCollections.ByteList dest, int offset, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.insertByte(offset + 0, (byte)value);
                break;
            }
            case 2: {
                Bytes.addBigShort(dest, offset, (short)value);
                break;
            }
            case 3: {
                Bytes.addBigInt24(dest, offset, (int)value);
                break;
            }
            case 4: {
                Bytes.addBigInt(dest, offset, (int)value);
                break;
            }
            case 5: {
                Bytes.addBigLong40(dest, offset, value);
                break;
            }
            case 6: {
                Bytes.addBigLong48(dest, offset, value);
                break;
            }
            case 7: {
                Bytes.addBigLong56(dest, offset, value);
                break;
            }
            case 8: {
                Bytes.addBigLong(dest, offset, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void add(PrimitiveCollections.ByteList dest, int offset, long value, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.addLittle(dest, offset, value, numberOfBytes);
        } else if (endianness == Endianness.Big) {
            Bytes.addBig(dest, offset, value, numberOfBytes);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLittle(OutputStream dest, long value, int numberOfBytes) throws IOException, EOFException {
        switch (numberOfBytes) {
            case 1: {
                dest.write((byte)value);
                break;
            }
            case 2: {
                Bytes.putLittleShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.putLittleInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.putLittleInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.putLittleLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.putLittleLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.putLittleLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.putLittleLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void putBig(OutputStream dest, long value, int numberOfBytes) throws IOException, EOFException {
        switch (numberOfBytes) {
            case 1: {
                dest.write((byte)value);
                break;
            }
            case 2: {
                Bytes.putBigShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.putBigInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.putBigInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.putBigLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.putBigLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.putBigLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.putBigLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void put(OutputStream dest, long value, int numberOfBytes, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittle(dest, value, numberOfBytes);
        } else if (endianness == Endianness.Big) {
            Bytes.putBig(dest, value, numberOfBytes);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLittle(OutputByteStream dest, long value, int numberOfBytes) throws IOException, EOFException {
        switch (numberOfBytes) {
            case 1: {
                dest.write((byte)value);
                break;
            }
            case 2: {
                Bytes.putLittleShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.putLittleInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.putLittleInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.putLittleLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.putLittleLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.putLittleLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.putLittleLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void putBig(OutputByteStream dest, long value, int numberOfBytes) throws IOException, EOFException {
        switch (numberOfBytes) {
            case 1: {
                dest.write((byte)value);
                break;
            }
            case 2: {
                Bytes.putBigShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.putBigInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.putBigInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.putBigLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.putBigLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.putBigLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.putBigLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void put(OutputByteStream dest, long value, int numberOfBytes, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittle(dest, value, numberOfBytes);
        } else if (endianness == Endianness.Big) {
            Bytes.putBig(dest, value, numberOfBytes);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLittle(StreamAPIs.ByteBlockWriteStream dest, long value, int numberOfBytes) throws IOException, EOFException {
        switch (numberOfBytes) {
            case 1: {
                dest.write((byte)value);
                break;
            }
            case 2: {
                Bytes.putLittleShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.putLittleInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.putLittleInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.putLittleLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.putLittleLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.putLittleLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.putLittleLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void putBig(StreamAPIs.ByteBlockWriteStream dest, long value, int numberOfBytes) throws IOException, EOFException {
        switch (numberOfBytes) {
            case 1: {
                dest.write((byte)value);
                break;
            }
            case 2: {
                Bytes.putBigShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.putBigInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.putBigInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.putBigLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.putBigLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.putBigLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.putBigLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void put(StreamAPIs.ByteBlockWriteStream dest, long value, int numberOfBytes, Endianness endianness) throws IOException, EOFException {
        if (endianness == Endianness.Little) {
            Bytes.putLittle(dest, value, numberOfBytes);
        } else if (endianness == Endianness.Big) {
            Bytes.putBig(dest, value, numberOfBytes);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLittle(ByteBuffer dest, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.put(0, (byte)value);
                break;
            }
            case 2: {
                Bytes.putLittleShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.putLittleInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.putLittleInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.putLittleLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.putLittleLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.putLittleLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.putLittleLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void putBig(ByteBuffer dest, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.put(0, (byte)value);
                break;
            }
            case 2: {
                Bytes.putBigShort(dest, (short)value);
                break;
            }
            case 3: {
                Bytes.putBigInt24(dest, (int)value);
                break;
            }
            case 4: {
                Bytes.putBigInt(dest, (int)value);
                break;
            }
            case 5: {
                Bytes.putBigLong40(dest, value);
                break;
            }
            case 6: {
                Bytes.putBigLong48(dest, value);
                break;
            }
            case 7: {
                Bytes.putBigLong56(dest, value);
                break;
            }
            case 8: {
                Bytes.putBigLong(dest, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void put(ByteBuffer dest, long value, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittle(dest, value, numberOfBytes);
        } else if (endianness == Endianness.Big) {
            Bytes.putBig(dest, value, numberOfBytes);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static void putLittle(ByteBuffer dest, int offset, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.put(offset + 0, (byte)value);
                break;
            }
            case 2: {
                Bytes.putLittleShort(dest, offset, (short)value);
                break;
            }
            case 3: {
                Bytes.putLittleInt24(dest, offset, (int)value);
                break;
            }
            case 4: {
                Bytes.putLittleInt(dest, offset, (int)value);
                break;
            }
            case 5: {
                Bytes.putLittleLong40(dest, offset, value);
                break;
            }
            case 6: {
                Bytes.putLittleLong48(dest, offset, value);
                break;
            }
            case 7: {
                Bytes.putLittleLong56(dest, offset, value);
                break;
            }
            case 8: {
                Bytes.putLittleLong(dest, offset, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void putBig(ByteBuffer dest, int offset, long value, int numberOfBytes) {
        switch (numberOfBytes) {
            case 1: {
                dest.put(offset + 0, (byte)value);
                break;
            }
            case 2: {
                Bytes.putBigShort(dest, offset, (short)value);
                break;
            }
            case 3: {
                Bytes.putBigInt24(dest, offset, (int)value);
                break;
            }
            case 4: {
                Bytes.putBigInt(dest, offset, (int)value);
                break;
            }
            case 5: {
                Bytes.putBigLong40(dest, offset, value);
                break;
            }
            case 6: {
                Bytes.putBigLong48(dest, offset, value);
                break;
            }
            case 7: {
                Bytes.putBigLong56(dest, offset, value);
                break;
            }
            case 8: {
                Bytes.putBigLong(dest, offset, value);
                break;
            }
            default: {
                throw numberOfBytes <= 0 ? new IllegalArgumentException("Invalid number of bytes!: " + numberOfBytes) : new UnsupportedOperationException("Unsupported number of bytes: " + numberOfBytes);
            }
        }
    }

    public static void put(ByteBuffer dest, int offset, long value, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            Bytes.putLittle(dest, offset, value, numberOfBytes);
        } else if (endianness == Endianness.Big) {
            Bytes.putBig(dest, offset, value, numberOfBytes);
        } else {
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
        }
    }

    public static byte[] packLittle(long value, int numberOfBytes) {
        byte[] dest = new byte[numberOfBytes];
        Bytes.putLittle(dest, value, numberOfBytes);
        return dest;
    }

    public static byte[] packBig(long value, int numberOfBytes) {
        byte[] dest = new byte[numberOfBytes];
        Bytes.putBig(dest, value, numberOfBytes);
        return dest;
    }

    public static byte[] pack(long value, int numberOfBytes, Endianness endianness) {
        if (endianness == Endianness.Little) {
            return Bytes.packLittle(value, numberOfBytes);
        }
        if (endianness == Endianness.Big) {
            return Bytes.packBig(value, numberOfBytes);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)endianness);
    }

    public static int getLittleUInt24Buffermodifying(ByteBuffer source) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        int rv = source.getShort() & 0xFFFF;
        return rv |= (source.get() & 0xFF) << 16;
    }

    public static int getBigUInt24Buffermodifying(ByteBuffer source) {
        source.order(ByteOrder.BIG_ENDIAN);
        int rv = (source.getShort() & 0xFFFF) << 8;
        return rv |= source.get() & 0xFF;
    }

    public static int getLittleUInt24Buffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        int rv = source.getShort(offset) & 0xFFFF;
        return rv |= (source.get(offset + 2) & 0xFF) << 16;
    }

    public static int getBigUInt24Buffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.BIG_ENDIAN);
        int rv = (source.getShort(offset) & 0xFFFF) << 8;
        return rv |= source.get(offset + 2) & 0xFF;
    }

    public static void putLittleInt24Buffermodifying(ByteBuffer source, int value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putShort((short)value);
        source.put((byte)(value >>> 16));
    }

    public static void putBigInt24Buffermodifying(ByteBuffer source, int value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putShort((short)(value >>> 8));
        source.put((byte)value);
    }

    public static void putLittleInt24Buffermodifying(ByteBuffer source, int offset, int value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putShort(offset, (short)value);
        source.put(offset + 2, (byte)(value >>> 16));
    }

    public static void putBigInt24Buffermodifying(ByteBuffer source, int offset, int value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putShort(offset, (short)(value >>> 8));
        source.put(offset + 2, (byte)value);
    }

    public static long getLittleULong40Buffermodifying(ByteBuffer source) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        long rv = (long)source.getInt() & 0xFFFFFFFFL;
        return rv |= ((long)source.get() & 0xFFL) << 32;
    }

    public static long getBigULong40Buffermodifying(ByteBuffer source) {
        source.order(ByteOrder.BIG_ENDIAN);
        long rv = ((long)source.getInt() & 0xFFFFFFFFL) << 8;
        return rv |= (long)source.get() & 0xFFL;
    }

    public static long getLittleULong40Buffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        long rv = (long)source.getInt(offset) & 0xFFFFFFFFL;
        return rv |= ((long)source.get(offset + 4) & 0xFFL) << 32;
    }

    public static long getBigULong40Buffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.BIG_ENDIAN);
        long rv = ((long)source.getInt(offset) & 0xFFFFFFFFL) << 8;
        return rv |= (long)source.get(offset + 4) & 0xFFL;
    }

    public static void putLittleLong40Buffermodifying(ByteBuffer source, long value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putInt((int)value);
        source.put((byte)(value >>> 32));
    }

    public static void putBigLong40Buffermodifying(ByteBuffer source, long value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putInt((int)(value >>> 8));
        source.put((byte)value);
    }

    public static void putLittleLong40Buffermodifying(ByteBuffer source, int offset, long value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putInt(offset, (int)value);
        source.put(offset + 4, (byte)(value >>> 32));
    }

    public static void putBigLong40Buffermodifying(ByteBuffer source, int offset, long value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putInt(offset, (int)(value >>> 8));
        source.put(offset + 4, (byte)value);
    }

    public static long getLittleULong48Buffermodifying(ByteBuffer source) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        long rv = (long)source.getInt() & 0xFFFFFFFFL;
        return rv |= ((long)source.getShort() & 0xFFFFL) << 32;
    }

    public static long getBigULong48Buffermodifying(ByteBuffer source) {
        source.order(ByteOrder.BIG_ENDIAN);
        long rv = ((long)source.getInt() & 0xFFFFFFFFL) << 16;
        return rv |= (long)source.getShort() & 0xFFFFL;
    }

    public static long getLittleULong48Buffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        long rv = (long)source.getInt(offset) & 0xFFFFFFFFL;
        return rv |= ((long)source.getShort(offset + 4) & 0xFFFFL) << 32;
    }

    public static long getBigULong48Buffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.BIG_ENDIAN);
        long rv = ((long)source.getInt(offset) & 0xFFFFFFFFL) << 16;
        return rv |= (long)source.getShort(offset + 4) & 0xFFFFL;
    }

    public static void putLittleLong48Buffermodifying(ByteBuffer source, long value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putInt((int)value);
        source.putShort((short)(value >>> 32));
    }

    public static void putBigLong48Buffermodifying(ByteBuffer source, long value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putInt((int)(value >>> 16));
        source.putShort((short)value);
    }

    public static void putLittleLong48Buffermodifying(ByteBuffer source, int offset, long value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putInt(offset, (int)value);
        source.putShort(offset + 4, (short)(value >>> 32));
    }

    public static void putBigLong48Buffermodifying(ByteBuffer source, int offset, long value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putInt(offset, (int)(value >>> 16));
        source.putShort(offset + 4, (short)value);
    }

    public static long getLittleULong56Buffermodifying(ByteBuffer source) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        long rv = (long)source.getInt() & 0xFFFFFFFFL;
        rv |= ((long)source.getShort() & 0xFFFFL) << 32;
        return rv |= ((long)source.get() & 0xFFL) << 48;
    }

    public static long getBigULong56Buffermodifying(ByteBuffer source) {
        source.order(ByteOrder.BIG_ENDIAN);
        long rv = ((long)source.getInt() & 0xFFFFFFFFL) << 24;
        rv |= ((long)source.getShort() & 0xFFFFL) << 8;
        return rv |= (long)source.get() & 0xFFL;
    }

    public static long getLittleULong56Buffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        long rv = (long)source.getInt(offset) & 0xFFFFFFFFL;
        rv |= ((long)source.getShort(offset + 4) & 0xFFFFL) << 32;
        return rv |= ((long)source.get(offset + 6) & 0xFFL) << 48;
    }

    public static long getBigULong56Buffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.BIG_ENDIAN);
        long rv = ((long)source.getInt(offset) & 0xFFFFFFFFL) << 24;
        rv |= ((long)source.getShort(offset + 4) & 0xFFFFL) << 8;
        return rv |= (long)source.get(offset + 6) & 0xFFL;
    }

    public static void putLittleLong56Buffermodifying(ByteBuffer source, long value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putInt((int)value);
        source.putShort((short)(value >>> 32));
        source.put((byte)(value >>> 48));
    }

    public static void putBigLong56Buffermodifying(ByteBuffer source, long value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putInt((int)(value >>> 24));
        source.putShort((short)(value >> 8));
        source.put((byte)value);
    }

    public static void putLittleLong56Buffermodifying(ByteBuffer source, int offset, long value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putInt(offset, (int)value);
        source.putShort(offset + 4, (short)(value >>> 32));
        source.put(offset + 6, (byte)(value >>> 48));
    }

    public static void putBigLong56Buffermodifying(ByteBuffer source, int offset, long value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putInt(offset, (int)(value >>> 24));
        source.putShort(offset + 4, (short)(value >>> 8));
        source.put(offset + 6, (byte)value);
    }

    public static int getUInt24Buffermodifying(ByteBuffer source, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            return Bytes.getLittleUInt24Buffermodifying(source);
        }
        if (endianness == ByteOrder.BIG_ENDIAN) {
            return Bytes.getBigUInt24Buffermodifying(source);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
    }

    public static int getUInt24Buffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            return Bytes.getLittleUInt24Buffermodifying(source, offset);
        }
        if (endianness == ByteOrder.BIG_ENDIAN) {
            return Bytes.getBigUInt24Buffermodifying(source, offset);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
    }

    public static void putInt24Buffermodifying(ByteBuffer source, int value, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            Bytes.putLittleInt24Buffermodifying(source, value);
        } else if (endianness == ByteOrder.BIG_ENDIAN) {
            Bytes.putBigInt24Buffermodifying(source, value);
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
        }
    }

    public static void putInt24Buffermodifying(ByteBuffer source, int offset, int value, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            Bytes.putLittleInt24Buffermodifying(source, offset, value);
        } else if (endianness == ByteOrder.BIG_ENDIAN) {
            Bytes.putBigInt24Buffermodifying(source, offset, value);
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
        }
    }

    public static long getULong40Buffermodifying(ByteBuffer source, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            return Bytes.getLittleULong40Buffermodifying(source);
        }
        if (endianness == ByteOrder.BIG_ENDIAN) {
            return Bytes.getBigULong40Buffermodifying(source);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
    }

    public static long getULong40Buffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            return Bytes.getLittleULong40Buffermodifying(source, offset);
        }
        if (endianness == ByteOrder.BIG_ENDIAN) {
            return Bytes.getBigULong40Buffermodifying(source, offset);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
    }

    public static void putLong40Buffermodifying(ByteBuffer source, long value, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            Bytes.putLittleLong40Buffermodifying(source, value);
        } else if (endianness == ByteOrder.BIG_ENDIAN) {
            Bytes.putBigLong40Buffermodifying(source, value);
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
        }
    }

    public static void putLong40Buffermodifying(ByteBuffer source, int offset, long value, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            Bytes.putLittleLong40Buffermodifying(source, offset, value);
        } else if (endianness == ByteOrder.BIG_ENDIAN) {
            Bytes.putBigLong40Buffermodifying(source, offset, value);
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
        }
    }

    public static long getULong48Buffermodifying(ByteBuffer source, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            return Bytes.getLittleULong48Buffermodifying(source);
        }
        if (endianness == ByteOrder.BIG_ENDIAN) {
            return Bytes.getBigULong48Buffermodifying(source);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
    }

    public static long getULong48Buffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            return Bytes.getLittleULong48Buffermodifying(source, offset);
        }
        if (endianness == ByteOrder.BIG_ENDIAN) {
            return Bytes.getBigULong48Buffermodifying(source, offset);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
    }

    public static void putLong48Buffermodifying(ByteBuffer source, long value, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            Bytes.putLittleLong48Buffermodifying(source, value);
        } else if (endianness == ByteOrder.BIG_ENDIAN) {
            Bytes.putBigLong48Buffermodifying(source, value);
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
        }
    }

    public static void putLong48Buffermodifying(ByteBuffer source, int offset, long value, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            Bytes.putLittleLong48Buffermodifying(source, offset, value);
        } else if (endianness == ByteOrder.BIG_ENDIAN) {
            Bytes.putBigLong48Buffermodifying(source, offset, value);
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
        }
    }

    public static long getULong56Buffermodifying(ByteBuffer source, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            return Bytes.getLittleULong56Buffermodifying(source);
        }
        if (endianness == ByteOrder.BIG_ENDIAN) {
            return Bytes.getBigULong56Buffermodifying(source);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
    }

    public static long getULong56Buffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            return Bytes.getLittleULong56Buffermodifying(source, offset);
        }
        if (endianness == ByteOrder.BIG_ENDIAN) {
            return Bytes.getBigULong56Buffermodifying(source, offset);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
    }

    public static void putLong56Buffermodifying(ByteBuffer source, long value, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            Bytes.putLittleLong56Buffermodifying(source, value);
        } else if (endianness == ByteOrder.BIG_ENDIAN) {
            Bytes.putBigLong56Buffermodifying(source, value);
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
        }
    }

    public static void putLong56Buffermodifying(ByteBuffer source, int offset, long value, ByteOrder endianness) {
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            Bytes.putLittleLong56Buffermodifying(source, offset, value);
        } else if (endianness == ByteOrder.BIG_ENDIAN) {
            Bytes.putBigLong56Buffermodifying(source, offset, value);
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(endianness);
        }
    }

    public static int getLittleSInt24Buffermodifying(ByteBuffer source) {
        return BitUtilities.signedUpcast24(Bytes.getLittleUInt24Buffermodifying(source));
    }

    public static int getBigSInt24Buffermodifying(ByteBuffer source) {
        return BitUtilities.signedUpcast24(Bytes.getBigUInt24Buffermodifying(source));
    }

    public static int getSInt24Buffermodifying(ByteBuffer source, ByteOrder endianness) {
        return BitUtilities.signedUpcast24(Bytes.getUInt24Buffermodifying(source, endianness));
    }

    public static int getLittleSInt24Buffermodifying(ByteBuffer source, int offset) {
        return BitUtilities.signedUpcast24(Bytes.getLittleUInt24Buffermodifying(source, offset));
    }

    public static int getBigSInt24Buffermodifying(ByteBuffer source, int offset) {
        return BitUtilities.signedUpcast24(Bytes.getBigUInt24Buffermodifying(source, offset));
    }

    public static int getSInt24Buffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        return BitUtilities.signedUpcast24(Bytes.getUInt24Buffermodifying(source, offset, endianness));
    }

    public static long getLittleSLong40Buffermodifying(ByteBuffer source) {
        return BitUtilities.signedUpcast40(Bytes.getLittleULong40Buffermodifying(source));
    }

    public static long getBigSLong40Buffermodifying(ByteBuffer source) {
        return BitUtilities.signedUpcast40(Bytes.getBigULong40Buffermodifying(source));
    }

    public static long getSLong40Buffermodifying(ByteBuffer source, ByteOrder endianness) {
        return BitUtilities.signedUpcast40(Bytes.getULong40Buffermodifying(source, endianness));
    }

    public static long getLittleSLong40Buffermodifying(ByteBuffer source, int offset) {
        return BitUtilities.signedUpcast40(Bytes.getLittleULong40Buffermodifying(source, offset));
    }

    public static long getBigSLong40Buffermodifying(ByteBuffer source, int offset) {
        return BitUtilities.signedUpcast40(Bytes.getBigULong40Buffermodifying(source, offset));
    }

    public static long getSLong40Buffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        return BitUtilities.signedUpcast40(Bytes.getULong40Buffermodifying(source, offset, endianness));
    }

    public static long getLittleSLong48Buffermodifying(ByteBuffer source) {
        return BitUtilities.signedUpcast48(Bytes.getLittleULong48Buffermodifying(source));
    }

    public static long getBigSLong48Buffermodifying(ByteBuffer source) {
        return BitUtilities.signedUpcast48(Bytes.getBigULong48Buffermodifying(source));
    }

    public static long getSLong48Buffermodifying(ByteBuffer source, ByteOrder endianness) {
        return BitUtilities.signedUpcast48(Bytes.getULong48Buffermodifying(source, endianness));
    }

    public static long getLittleSLong48Buffermodifying(ByteBuffer source, int offset) {
        return BitUtilities.signedUpcast48(Bytes.getLittleULong48Buffermodifying(source, offset));
    }

    public static long getBigSLong48Buffermodifying(ByteBuffer source, int offset) {
        return BitUtilities.signedUpcast48(Bytes.getBigULong48Buffermodifying(source, offset));
    }

    public static long getSLong48Buffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        return BitUtilities.signedUpcast48(Bytes.getULong48Buffermodifying(source, offset, endianness));
    }

    public static long getLittleSLong56Buffermodifying(ByteBuffer source) {
        return BitUtilities.signedUpcast56(Bytes.getLittleULong56Buffermodifying(source));
    }

    public static long getBigSLong56Buffermodifying(ByteBuffer source) {
        return BitUtilities.signedUpcast56(Bytes.getBigULong56Buffermodifying(source));
    }

    public static long getSLong56Buffermodifying(ByteBuffer source, ByteOrder endianness) {
        return BitUtilities.signedUpcast56(Bytes.getULong56Buffermodifying(source, endianness));
    }

    public static long getLittleSLong56Buffermodifying(ByteBuffer source, int offset) {
        return BitUtilities.signedUpcast56(Bytes.getLittleULong56Buffermodifying(source, offset));
    }

    public static long getBigSLong56Buffermodifying(ByteBuffer source, int offset) {
        return BitUtilities.signedUpcast56(Bytes.getBigULong56Buffermodifying(source, offset));
    }

    public static long getSLong56Buffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        return BitUtilities.signedUpcast56(Bytes.getULong56Buffermodifying(source, offset, endianness));
    }

    public static char getLittleCharBuffermodifying(ByteBuffer source) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        return source.getChar();
    }

    public static char getBigCharBuffermodifying(ByteBuffer source) {
        source.order(ByteOrder.BIG_ENDIAN);
        return source.getChar();
    }

    public static char getCharBuffermodifying(ByteBuffer source, ByteOrder endianness) {
        source.order(endianness);
        return source.getChar();
    }

    public static char getLittleCharBuffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        return source.getChar(offset);
    }

    public static char getBigCharBuffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.BIG_ENDIAN);
        return source.getChar(offset);
    }

    public static char getCharBuffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        source.order(endianness);
        return source.getChar(offset);
    }

    public static void putLittleCharBuffermodifying(ByteBuffer source, char value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putChar(value);
    }

    public static void putBigCharBuffermodifying(ByteBuffer source, char value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putChar(value);
    }

    public static void putCharBuffermodifying(ByteBuffer source, char value, ByteOrder endianness) {
        source.order(endianness);
        source.putChar(value);
    }

    public static void putLittleCharBuffermodifying(ByteBuffer source, int offset, char value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putChar(offset, value);
    }

    public static void putBigCharBuffermodifying(ByteBuffer source, int offset, char value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putChar(offset, value);
    }

    public static void putCharBuffermodifying(ByteBuffer source, int offset, char value, ByteOrder endianness) {
        source.order(endianness);
        source.putChar(offset, value);
    }

    public static short getLittleShortBuffermodifying(ByteBuffer source) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        return source.getShort();
    }

    public static short getBigShortBuffermodifying(ByteBuffer source) {
        source.order(ByteOrder.BIG_ENDIAN);
        return source.getShort();
    }

    public static short getShortBuffermodifying(ByteBuffer source, ByteOrder endianness) {
        source.order(endianness);
        return source.getShort();
    }

    public static short getLittleShortBuffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        return source.getShort(offset);
    }

    public static short getBigShortBuffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.BIG_ENDIAN);
        return source.getShort(offset);
    }

    public static short getShortBuffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        source.order(endianness);
        return source.getShort(offset);
    }

    public static void putLittleShortBuffermodifying(ByteBuffer source, short value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putShort(value);
    }

    public static void putBigShortBuffermodifying(ByteBuffer source, short value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putShort(value);
    }

    public static void putShortBuffermodifying(ByteBuffer source, short value, ByteOrder endianness) {
        source.order(endianness);
        source.putShort(value);
    }

    public static void putLittleShortBuffermodifying(ByteBuffer source, int offset, short value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putShort(offset, value);
    }

    public static void putBigShortBuffermodifying(ByteBuffer source, int offset, short value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putShort(offset, value);
    }

    public static void putShortBuffermodifying(ByteBuffer source, int offset, short value, ByteOrder endianness) {
        source.order(endianness);
        source.putShort(offset, value);
    }

    public static float getLittleFloatBuffermodifying(ByteBuffer source) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        return source.getFloat();
    }

    public static float getBigFloatBuffermodifying(ByteBuffer source) {
        source.order(ByteOrder.BIG_ENDIAN);
        return source.getFloat();
    }

    public static float getFloatBuffermodifying(ByteBuffer source, ByteOrder endianness) {
        source.order(endianness);
        return source.getFloat();
    }

    public static float getLittleFloatBuffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        return source.getFloat(offset);
    }

    public static float getBigFloatBuffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.BIG_ENDIAN);
        return source.getFloat(offset);
    }

    public static float getFloatBuffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        source.order(endianness);
        return source.getFloat(offset);
    }

    public static void putLittleFloatBuffermodifying(ByteBuffer source, float value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putFloat(value);
    }

    public static void putBigFloatBuffermodifying(ByteBuffer source, float value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putFloat(value);
    }

    public static void putFloatBuffermodifying(ByteBuffer source, float value, ByteOrder endianness) {
        source.order(endianness);
        source.putFloat(value);
    }

    public static void putLittleFloatBuffermodifying(ByteBuffer source, int offset, float value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putFloat(offset, value);
    }

    public static void putBigFloatBuffermodifying(ByteBuffer source, int offset, float value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putFloat(offset, value);
    }

    public static void putFloatBuffermodifying(ByteBuffer source, int offset, float value, ByteOrder endianness) {
        source.order(endianness);
        source.putFloat(offset, value);
    }

    public static int getLittleIntBuffermodifying(ByteBuffer source) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        return source.getInt();
    }

    public static int getBigIntBuffermodifying(ByteBuffer source) {
        source.order(ByteOrder.BIG_ENDIAN);
        return source.getInt();
    }

    public static int getIntBuffermodifying(ByteBuffer source, ByteOrder endianness) {
        source.order(endianness);
        return source.getInt();
    }

    public static int getLittleIntBuffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        return source.getInt(offset);
    }

    public static int getBigIntBuffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.BIG_ENDIAN);
        return source.getInt(offset);
    }

    public static int getIntBuffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        source.order(endianness);
        return source.getInt(offset);
    }

    public static void putLittleIntBuffermodifying(ByteBuffer source, int value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putInt(value);
    }

    public static void putBigIntBuffermodifying(ByteBuffer source, int value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putInt(value);
    }

    public static void putIntBuffermodifying(ByteBuffer source, int value, ByteOrder endianness) {
        source.order(endianness);
        source.putInt(value);
    }

    public static void putLittleIntBuffermodifying(ByteBuffer source, int offset, int value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putInt(offset, value);
    }

    public static void putBigIntBuffermodifying(ByteBuffer source, int offset, int value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putInt(offset, value);
    }

    public static void putIntBuffermodifying(ByteBuffer source, int offset, int value, ByteOrder endianness) {
        source.order(endianness);
        source.putInt(offset, value);
    }

    public static double getLittleDoubleBuffermodifying(ByteBuffer source) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        return source.getDouble();
    }

    public static double getBigDoubleBuffermodifying(ByteBuffer source) {
        source.order(ByteOrder.BIG_ENDIAN);
        return source.getDouble();
    }

    public static double getDoubleBuffermodifying(ByteBuffer source, ByteOrder endianness) {
        source.order(endianness);
        return source.getDouble();
    }

    public static double getLittleDoubleBuffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        return source.getDouble(offset);
    }

    public static double getBigDoubleBuffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.BIG_ENDIAN);
        return source.getDouble(offset);
    }

    public static double getDoubleBuffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        source.order(endianness);
        return source.getDouble(offset);
    }

    public static void putLittleDoubleBuffermodifying(ByteBuffer source, double value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putDouble(value);
    }

    public static void putBigDoubleBuffermodifying(ByteBuffer source, double value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putDouble(value);
    }

    public static void putDoubleBuffermodifying(ByteBuffer source, double value, ByteOrder endianness) {
        source.order(endianness);
        source.putDouble(value);
    }

    public static void putLittleDoubleBuffermodifying(ByteBuffer source, int offset, double value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putDouble(offset, value);
    }

    public static void putBigDoubleBuffermodifying(ByteBuffer source, int offset, double value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putDouble(offset, value);
    }

    public static void putDoubleBuffermodifying(ByteBuffer source, int offset, double value, ByteOrder endianness) {
        source.order(endianness);
        source.putDouble(offset, value);
    }

    public static long getLittleLongBuffermodifying(ByteBuffer source) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        return source.getLong();
    }

    public static long getBigLongBuffermodifying(ByteBuffer source) {
        source.order(ByteOrder.BIG_ENDIAN);
        return source.getLong();
    }

    public static long getLongBuffermodifying(ByteBuffer source, ByteOrder endianness) {
        source.order(endianness);
        return source.getLong();
    }

    public static long getLittleLongBuffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        return source.getLong(offset);
    }

    public static long getBigLongBuffermodifying(ByteBuffer source, int offset) {
        source.order(ByteOrder.BIG_ENDIAN);
        return source.getLong(offset);
    }

    public static long getLongBuffermodifying(ByteBuffer source, int offset, ByteOrder endianness) {
        source.order(endianness);
        return source.getLong(offset);
    }

    public static void putLittleLongBuffermodifying(ByteBuffer source, long value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putLong(value);
    }

    public static void putBigLongBuffermodifying(ByteBuffer source, long value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putLong(value);
    }

    public static void putLongBuffermodifying(ByteBuffer source, long value, ByteOrder endianness) {
        source.order(endianness);
        source.putLong(value);
    }

    public static void putLittleLongBuffermodifying(ByteBuffer source, int offset, long value) {
        source.order(ByteOrder.LITTLE_ENDIAN);
        source.putLong(offset, value);
    }

    public static void putBigLongBuffermodifying(ByteBuffer source, int offset, long value) {
        source.order(ByteOrder.BIG_ENDIAN);
        source.putLong(offset, value);
    }

    public static void putLongBuffermodifying(ByteBuffer source, int offset, long value, ByteOrder endianness) {
        source.order(endianness);
        source.putLong(offset, value);
    }

    public static char getLittleChar(ByteBuffer source) {
        char rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleCharBuffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static char getBigChar(ByteBuffer source) {
        char rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigCharBuffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static char getChar(ByteBuffer source, ByteOrder endianness) {
        char rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getCharBuffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static char getLittleChar(ByteBuffer source, int offset) {
        char rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleCharBuffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static char getBigChar(ByteBuffer source, int offset) {
        char rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigCharBuffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static char getChar(ByteBuffer source, int offset, ByteOrder endianness) {
        char rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getCharBuffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static short getLittleShort(ByteBuffer source) {
        short rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleShortBuffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static short getBigShort(ByteBuffer source) {
        short rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigShortBuffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static short getShort(ByteBuffer source, ByteOrder endianness) {
        short rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getShortBuffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static short getLittleShort(ByteBuffer source, int offset) {
        short rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleShortBuffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static short getBigShort(ByteBuffer source, int offset) {
        short rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigShortBuffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static short getShort(ByteBuffer source, int offset, ByteOrder endianness) {
        short rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getShortBuffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static float getLittleFloat(ByteBuffer source) {
        float rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleFloatBuffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static float getBigFloat(ByteBuffer source) {
        float rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigFloatBuffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static float getFloat(ByteBuffer source, ByteOrder endianness) {
        float rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getFloatBuffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static float getLittleFloat(ByteBuffer source, int offset) {
        float rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleFloatBuffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static float getBigFloat(ByteBuffer source, int offset) {
        float rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigFloatBuffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static float getFloat(ByteBuffer source, int offset, ByteOrder endianness) {
        float rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getFloatBuffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static int getLittleInt(ByteBuffer source) {
        int rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleIntBuffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static int getBigInt(ByteBuffer source) {
        int rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigIntBuffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static int getInt(ByteBuffer source, ByteOrder endianness) {
        int rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getIntBuffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static int getLittleInt(ByteBuffer source, int offset) {
        int rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleIntBuffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static int getBigInt(ByteBuffer source, int offset) {
        int rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigIntBuffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static int getInt(ByteBuffer source, int offset, ByteOrder endianness) {
        int rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getIntBuffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static double getLittleDouble(ByteBuffer source) {
        double rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleDoubleBuffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static double getBigDouble(ByteBuffer source) {
        double rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigDoubleBuffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static double getDouble(ByteBuffer source, ByteOrder endianness) {
        double rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getDoubleBuffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static double getLittleDouble(ByteBuffer source, int offset) {
        double rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleDoubleBuffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static double getBigDouble(ByteBuffer source, int offset) {
        double rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigDoubleBuffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static double getDouble(ByteBuffer source, int offset, ByteOrder endianness) {
        double rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getDoubleBuffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getLittleLong(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleLongBuffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getBigLong(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigLongBuffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getLong(ByteBuffer source, ByteOrder endianness) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLongBuffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getLittleLong(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleLongBuffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getBigLong(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigLongBuffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getLong(ByteBuffer source, int offset, ByteOrder endianness) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLongBuffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static int getLittleSInt24(ByteBuffer source) {
        int rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleSInt24Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static int getBigSInt24(ByteBuffer source) {
        int rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigSInt24Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static int getSInt24(ByteBuffer source, ByteOrder endianness) {
        int rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getSInt24Buffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static int getLittleSInt24(ByteBuffer source, int offset) {
        int rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleSInt24Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static int getBigSInt24(ByteBuffer source, int offset) {
        int rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigSInt24Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static int getSInt24(ByteBuffer source, int offset, ByteOrder endianness) {
        int rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getSInt24Buffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getLittleSLong40(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleSLong40Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getBigSLong40(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigSLong40Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getSLong40(ByteBuffer source, ByteOrder endianness) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getSLong40Buffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getLittleSLong40(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleSLong40Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getBigSLong40(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigSLong40Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getSLong40(ByteBuffer source, int offset, ByteOrder endianness) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getSLong40Buffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getLittleSLong48(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleSLong48Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getBigSLong48(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigSLong48Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getSLong48(ByteBuffer source, ByteOrder endianness) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getSLong48Buffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getLittleSLong48(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleSLong48Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getBigSLong48(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigSLong48Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getSLong48(ByteBuffer source, int offset, ByteOrder endianness) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getSLong48Buffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getLittleSLong56(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleSLong56Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getBigSLong56(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigSLong56Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getSLong56(ByteBuffer source, ByteOrder endianness) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getSLong56Buffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getLittleSLong56(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleSLong56Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getBigSLong56(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigSLong56Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getSLong56(ByteBuffer source, int offset, ByteOrder endianness) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getSLong56Buffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static int getLittleUInt24(ByteBuffer source) {
        int rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleUInt24Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static int getBigUInt24(ByteBuffer source) {
        int rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigUInt24Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static int getUInt24(ByteBuffer source, ByteOrder endianness) {
        int rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getUInt24Buffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static int getLittleUInt24(ByteBuffer source, int offset) {
        int rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleUInt24Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static int getBigUInt24(ByteBuffer source, int offset) {
        int rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigUInt24Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static int getUInt24(ByteBuffer source, int offset, ByteOrder endianness) {
        int rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getUInt24Buffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getLittleULong40(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleULong40Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getBigULong40(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigULong40Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getULong40(ByteBuffer source, ByteOrder endianness) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getULong40Buffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getLittleULong40(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleULong40Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getBigULong40(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigULong40Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getULong40(ByteBuffer source, int offset, ByteOrder endianness) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getULong40Buffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getLittleULong48(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleULong48Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getBigULong48(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigULong48Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getULong48(ByteBuffer source, ByteOrder endianness) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getULong48Buffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getLittleULong48(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleULong48Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getBigULong48(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigULong48Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getULong48(ByteBuffer source, int offset, ByteOrder endianness) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getULong48Buffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getLittleULong56(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleULong56Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getBigULong56(ByteBuffer source) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigULong56Buffermodifying(source);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getULong56(ByteBuffer source, ByteOrder endianness) {
        long rv;
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getULong56Buffermodifying(source, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
        return rv;
    }

    public static long getLittleULong56(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getLittleULong56Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getBigULong56(ByteBuffer source, int offset) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getBigULong56Buffermodifying(source, offset);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static long getULong56(ByteBuffer source, int offset, ByteOrder endianness) {
        long rv;
        ByteOrder originalByteOrder = source.order();
        try {
            rv = Bytes.getULong56Buffermodifying(source, offset, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
        return rv;
    }

    public static void putLittleChar(ByteBuffer source, char value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleCharBuffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putBigChar(ByteBuffer source, char value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigCharBuffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putChar(ByteBuffer source, char value, ByteOrder endianness) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putCharBuffermodifying(source, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLittleChar(ByteBuffer source, int offset, char value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleCharBuffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigChar(ByteBuffer source, int offset, char value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigCharBuffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigChar(ByteBuffer source, int offset, char value, ByteOrder endianness) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putCharBuffermodifying(source, offset, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putLittleShort(ByteBuffer source, short value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleShortBuffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putBigShort(ByteBuffer source, short value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigShortBuffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putShort(ByteBuffer source, short value, ByteOrder endianness) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putShortBuffermodifying(source, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLittleShort(ByteBuffer source, int offset, short value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleShortBuffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigShort(ByteBuffer source, int offset, short value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigShortBuffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigShort(ByteBuffer source, int offset, short value, ByteOrder endianness) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putShortBuffermodifying(source, offset, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putLittleFloat(ByteBuffer source, float value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleFloatBuffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putBigFloat(ByteBuffer source, float value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigFloatBuffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putFloat(ByteBuffer source, float value, ByteOrder endianness) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putFloatBuffermodifying(source, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLittleFloat(ByteBuffer source, int offset, float value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleFloatBuffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigFloat(ByteBuffer source, int offset, float value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigFloatBuffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigFloat(ByteBuffer source, int offset, float value, ByteOrder endianness) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putFloatBuffermodifying(source, offset, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putLittleInt(ByteBuffer source, int value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleIntBuffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putBigInt(ByteBuffer source, int value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigIntBuffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putInt(ByteBuffer source, int value, ByteOrder endianness) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putIntBuffermodifying(source, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLittleInt(ByteBuffer source, int offset, int value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleIntBuffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigInt(ByteBuffer source, int offset, int value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigIntBuffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigInt(ByteBuffer source, int offset, int value, ByteOrder endianness) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putIntBuffermodifying(source, offset, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putLittleDouble(ByteBuffer source, double value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleDoubleBuffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putBigDouble(ByteBuffer source, double value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigDoubleBuffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putDouble(ByteBuffer source, double value, ByteOrder endianness) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putDoubleBuffermodifying(source, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLittleDouble(ByteBuffer source, int offset, double value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleDoubleBuffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigDouble(ByteBuffer source, int offset, double value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigDoubleBuffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigDouble(ByteBuffer source, int offset, double value, ByteOrder endianness) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putDoubleBuffermodifying(source, offset, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putLittleLong(ByteBuffer source, long value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleLongBuffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putBigLong(ByteBuffer source, long value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigLongBuffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLong(ByteBuffer source, long value, ByteOrder endianness) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLongBuffermodifying(source, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLittleLong(ByteBuffer source, int offset, long value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleLongBuffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigLong(ByteBuffer source, int offset, long value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigLongBuffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigLong(ByteBuffer source, int offset, long value, ByteOrder endianness) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLongBuffermodifying(source, offset, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putLittleInt24(ByteBuffer source, int value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleInt24Buffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putBigInt24(ByteBuffer source, int value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigInt24Buffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putInt24(ByteBuffer source, int value, ByteOrder endianness) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putInt24Buffermodifying(source, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLittleInt24(ByteBuffer source, int offset, int value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleInt24Buffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigInt24(ByteBuffer source, int offset, int value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigInt24Buffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigInt24(ByteBuffer source, int offset, int value, ByteOrder endianness) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putInt24Buffermodifying(source, offset, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putLittleLong40(ByteBuffer source, long value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleLong40Buffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putBigLong40(ByteBuffer source, long value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigLong40Buffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLong40(ByteBuffer source, long value, ByteOrder endianness) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLong40Buffermodifying(source, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLittleLong40(ByteBuffer source, int offset, long value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleLong40Buffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigLong40(ByteBuffer source, int offset, long value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigLong40Buffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigLong40(ByteBuffer source, int offset, long value, ByteOrder endianness) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLong40Buffermodifying(source, offset, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putLittleLong48(ByteBuffer source, long value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleLong48Buffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putBigLong48(ByteBuffer source, long value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigLong48Buffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLong48(ByteBuffer source, long value, ByteOrder endianness) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLong48Buffermodifying(source, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLittleLong48(ByteBuffer source, int offset, long value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleLong48Buffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigLong48(ByteBuffer source, int offset, long value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigLong48Buffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigLong48(ByteBuffer source, int offset, long value, ByteOrder endianness) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLong48Buffermodifying(source, offset, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putLittleLong56(ByteBuffer source, long value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleLong56Buffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putBigLong56(ByteBuffer source, long value) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigLong56Buffermodifying(source, value);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLong56(ByteBuffer source, long value, ByteOrder endianness) {
        int originalPosition = source.position();
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLong56Buffermodifying(source, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
            source.position(originalPosition);
        }
    }

    public static void putLittleLong56(ByteBuffer source, int offset, long value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLittleLong56Buffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigLong56(ByteBuffer source, int offset, long value) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putBigLong56Buffermodifying(source, offset, value);
        }
        finally {
            source.order(originalByteOrder);
        }
    }

    public static void putBigLong56(ByteBuffer source, int offset, long value, ByteOrder endianness) {
        ByteOrder originalByteOrder = source.order();
        try {
            Bytes.putLong56Buffermodifying(source, offset, value, endianness);
        }
        finally {
            source.order(originalByteOrder);
        }
    }
}

