/*
 * Decompiled with CFR 0.152.
 */
package rebound.text.encodings.detection.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.testing.WidespreadTestingUtilities;
import rebound.text.encodings.detection.TextEncodingDetector;
import rebound.util.collections.CollectionUtilities;
import rebound.util.functional.throwing.FunctionalInterfacesThrowingCheckedExceptionsStandard;

public class ExhhaustiveTextEncodingDetector
implements TextEncodingDetector {
    protected final Iterable<Charset> underlyings;

    public ExhhaustiveTextEncodingDetector(Iterable<Charset> underlyings) {
        this.underlyings = underlyings;
    }

    public ExhhaustiveTextEncodingDetector(Charset ... underlyings) {
        this(CollectionUtilities.asList(underlyings));
    }

    @ImplementationTransparency
    public Iterable<Charset> getUnderlyings() {
        return this.underlyings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Charset detectEncoding(FunctionalInterfacesThrowingCheckedExceptionsStandard.NullaryFunctionThrowingIOException<InputStream> opener) throws IOException, UnsupportedCharsetException {
        for (Charset encoding : this.underlyings) {
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                Charset charset;
                InputStream in = opener.f();
                try {
                    CharsetDecoder decoder = encoding.newDecoder();
                    decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                    decoder.onMalformedInput(CodingErrorAction.REPORT);
                    try {
                        InputStreamReader r = new InputStreamReader(in, decoder);
                        char[] b = new char[4096];
                        boolean bad = false;
                        while (!bad) {
                            int amt = r.read(b);
                            if (amt == -1) {
                                charset = encoding;
                                return charset;
                            }
                            int i = 0;
                            while (i < amt && !bad) {
                                if (b[i] == '\u0000') {
                                    bad = true;
                                }
                                ++i;
                            }
                        }
                        WidespreadTestingUtilities.asrt(bad);
                    }
                    catch (CharacterCodingException characterCodingException) {
                        // empty catch block
                    }
                }
                finally {
                    if (in == null) return charset;
                    in.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        return null;
    }

    @Override
    public Charset detectEncoding(byte[] in, int offset, int length) throws UnsupportedCharsetException {
        for (Charset encoding : this.underlyings) {
            CharsetDecoder decoder = encoding.newDecoder();
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            try {
                decoder.decode(ByteBuffer.wrap(in, offset, length));
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
        }
        return null;
    }
}

