/*
 * Decompiled with CFR 0.152.
 */
package rebound.bits;

import rebound.annotations.semantic.simpledata.ActuallySigned;
import rebound.annotations.semantic.simpledata.ActuallyUnsigned;
import rebound.bits.Unsigned;
import rebound.exceptions.OverflowException;

public class BitfieldSafeCasts {
    public static byte safeCastU8toS8(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static short safeCastU8toS16(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static int safeCastU8toS32(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static long safeCastU8toS64(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastU8toS24(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=40)
    public static long safeCastU8toS40(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastU8toS48(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastU8toS56(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastU8toU24(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastU8toU40(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastU8toU48(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastU8toU56(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastU8toU8(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static short safeCastU8toU16(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static int safeCastU8toU32(@ActuallyUnsigned byte input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static byte safeCastS8toS8(byte input) throws OverflowException {
        long u = input;
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static short safeCastS8toS16(byte input) throws OverflowException {
        long u = input;
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static int safeCastS8toS32(byte input) throws OverflowException {
        long u = input;
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static long safeCastS8toS64(byte input) throws OverflowException {
        long u = input;
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastS8toS24(byte input) throws OverflowException {
        long u = input;
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=40)
    public static long safeCastS8toS40(byte input) throws OverflowException {
        long u = input;
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastS8toS48(byte input) throws OverflowException {
        long u = input;
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastS8toS56(byte input) throws OverflowException {
        long u = input;
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastS8toU24(byte input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastS8toU40(byte input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastS8toU48(byte input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastS8toU56(byte input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastS8toU8(byte input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static short safeCastS8toU16(byte input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static int safeCastS8toU32(byte input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static byte safeCastU16toS8(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastU16toS16(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static int safeCastU16toS32(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static long safeCastU16toS64(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastU16toS24(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=40)
    public static long safeCastU16toS40(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastU16toS48(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastU16toS56(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastU16toU24(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastU16toU40(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastU16toU48(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastU16toU56(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastU16toU8(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastU16toU16(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static int safeCastU16toU32(@ActuallyUnsigned short input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static byte safeCastS16toS8(short input) throws OverflowException {
        long u = input;
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastS16toS16(short input) throws OverflowException {
        long u = input;
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static int safeCastS16toS32(short input) throws OverflowException {
        long u = input;
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static long safeCastS16toS64(short input) throws OverflowException {
        long u = input;
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastS16toS24(short input) throws OverflowException {
        long u = input;
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=40)
    public static long safeCastS16toS40(short input) throws OverflowException {
        long u = input;
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastS16toS48(short input) throws OverflowException {
        long u = input;
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastS16toS56(short input) throws OverflowException {
        long u = input;
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastS16toU24(short input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastS16toU40(short input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastS16toU48(short input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastS16toU56(short input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastS16toU8(short input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastS16toU16(short input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static int safeCastS16toU32(short input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static byte safeCastU24toS8(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastU24toS16(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    public static int safeCastU24toS32(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static long safeCastU24toS64(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastU24toS24(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=40)
    public static long safeCastU24toS40(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastU24toS48(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastU24toS56(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastU24toU24(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastU24toU40(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastU24toU48(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastU24toU56(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastU24toU8(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastU24toU16(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    @ActuallyUnsigned
    public static int safeCastU24toU32(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static byte safeCastS24toS8(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastS24toS16(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    public static int safeCastS24toS32(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static long safeCastS24toS64(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastS24toS24(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=40)
    public static long safeCastS24toS40(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastS24toS48(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastS24toS56(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastS24toU24(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastS24toU40(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastS24toU48(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastS24toU56(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastS24toU8(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastS24toU16(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    @ActuallyUnsigned
    public static int safeCastS24toU32(@ActuallySigned(value=24) int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static byte safeCastU32toS8(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastU32toS16(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    public static int safeCastU32toS32(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static long safeCastU32toS64(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastU32toS24(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=40)
    public static long safeCastU32toS40(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastU32toS48(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastU32toS56(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastU32toU24(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastU32toU40(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastU32toU48(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastU32toU56(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastU32toU8(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastU32toU16(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    @ActuallyUnsigned
    public static int safeCastU32toU32(@ActuallyUnsigned int input) throws OverflowException {
        long u = Unsigned.upcastTo64(input);
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static byte safeCastS32toS8(int input) throws OverflowException {
        long u = input;
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastS32toS16(int input) throws OverflowException {
        long u = input;
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    public static int safeCastS32toS32(int input) throws OverflowException {
        long u = input;
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static long safeCastS32toS64(int input) throws OverflowException {
        long u = input;
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastS32toS24(int input) throws OverflowException {
        long u = input;
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=40)
    public static long safeCastS32toS40(int input) throws OverflowException {
        long u = input;
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastS32toS48(int input) throws OverflowException {
        long u = input;
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastS32toS56(int input) throws OverflowException {
        long u = input;
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastS32toU24(int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastS32toU40(int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastS32toU48(int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastS32toU56(int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastS32toU8(int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastS32toU16(int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    @ActuallyUnsigned
    public static int safeCastS32toU32(int input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    public static byte safeCastU40toS8(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastU40toS16(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    public static int safeCastU40toS32(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static long safeCastU40toS64(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastU40toS24(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallySigned(value=40)
    public static long safeCastU40toS40(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastU40toS48(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastU40toS56(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastU40toU24(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastU40toU40(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastU40toU48(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastU40toU56(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastU40toU8(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastU40toU16(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    @ActuallyUnsigned
    public static int safeCastU40toU32(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static byte safeCastS40toS8(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastS40toS16(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    public static int safeCastS40toS32(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static long safeCastS40toS64(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastS40toS24(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallySigned(value=40)
    public static long safeCastS40toS40(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastS40toS48(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastS40toS56(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastS40toU24(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastS40toU40(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastS40toU48(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastS40toU56(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastS40toU8(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastS40toU16(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    @ActuallyUnsigned
    public static int safeCastS40toU32(@ActuallySigned(value=40) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static byte safeCastU48toS8(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastU48toS16(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    public static int safeCastU48toS32(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static long safeCastU48toS64(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastU48toS24(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallySigned(value=40)
    public static long safeCastU48toS40(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastU48toS48(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastU48toS56(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastU48toU24(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastU48toU40(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastU48toU48(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastU48toU56(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastU48toU8(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastU48toU16(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    @ActuallyUnsigned
    public static int safeCastU48toU32(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static byte safeCastS48toS8(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastS48toS16(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    public static int safeCastS48toS32(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static long safeCastS48toS64(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastS48toS24(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallySigned(value=40)
    public static long safeCastS48toS40(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastS48toS48(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastS48toS56(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastS48toU24(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastS48toU40(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastS48toU48(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastS48toU56(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastS48toU8(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastS48toU16(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    @ActuallyUnsigned
    public static int safeCastS48toU32(@ActuallySigned(value=48) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static byte safeCastU56toS8(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastU56toS16(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    public static int safeCastU56toS32(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static long safeCastU56toS64(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastU56toS24(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallySigned(value=40)
    public static long safeCastU56toS40(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastU56toS48(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastU56toS56(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastU56toU24(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastU56toU40(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastU56toU48(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastU56toU56(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastU56toU8(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastU56toU16(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    @ActuallyUnsigned
    public static int safeCastU56toU32(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static byte safeCastS56toS8(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastS56toS16(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    public static int safeCastS56toS32(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static long safeCastS56toS64(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastS56toS24(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallySigned(value=40)
    public static long safeCastS56toS40(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastS56toS48(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastS56toS56(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastS56toU24(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastS56toU40(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastS56toU48(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastS56toU56(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastS56toU8(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastS56toU16(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    @ActuallyUnsigned
    public static int safeCastS56toU32(@ActuallySigned(value=56) long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static byte safeCastS64toS8(long input) throws OverflowException {
        long u = input;
        if (u < -128L || u > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastS64toS16(long input) throws OverflowException {
        long u = input;
        if (u < -32768L || u > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    public static int safeCastS64toS32(long input) throws OverflowException {
        long u = input;
        if (u < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static long safeCastS64toS64(long input) throws OverflowException {
        long u = input;
        if (u < Long.MIN_VALUE || u > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastS64toS24(long input) throws OverflowException {
        long u = input;
        if (u < -8388608L || u > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallySigned(value=40)
    public static long safeCastS64toS40(long input) throws OverflowException {
        long u = input;
        if (u < -549755813888L || u > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastS64toS48(long input) throws OverflowException {
        long u = input;
        if (u < -140737488355328L || u > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastS64toS56(long input) throws OverflowException {
        long u = input;
        if (u < -36028797018963968L || u > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastS64toU24(long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastS64toU40(long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastS64toU48(long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastS64toU56(long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastS64toU8(long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastS64toU16(long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    @ActuallyUnsigned
    public static int safeCastS64toU32(long input) throws OverflowException {
        long u = input;
        if (u < 0L || u > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static byte safeCastU64toS8(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > 127L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    public static short safeCastU64toS16(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > 32767L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    public static int safeCastU64toS32(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > Integer.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    public static long safeCastU64toS64(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > Long.MAX_VALUE) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=24)
    public static int safeCastU64toS24(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > 0x7FFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallySigned(value=40)
    public static long safeCastU64toS40(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > 0x7FFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=48)
    public static long safeCastU64toS48(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > 0x7FFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallySigned(value=56)
    public static long safeCastU64toS56(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > 0x7FFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=24)
    public static int safeCastU64toU24(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > 0xFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallyUnsigned(value=40)
    public static long safeCastU64toU40(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > 0xFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=48)
    public static long safeCastU64toU48(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > 0xFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned(value=56)
    public static long safeCastU64toU56(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > 0xFFFFFFFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static byte safeCastU64toU8(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > 255L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (byte)input;
    }

    @ActuallyUnsigned
    public static short safeCastU64toU16(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > 65535L) {
            throw new OverflowException(String.valueOf(input));
        }
        return (short)input;
    }

    @ActuallyUnsigned
    public static int safeCastU64toU32(@ActuallyUnsigned long input) throws OverflowException {
        if (input < 0L || input > 0xFFFFFFFFL) {
            throw new OverflowException(String.valueOf(input));
        }
        return (int)input;
    }

    @ActuallyUnsigned
    public static long safeCastS8toU64(byte input) throws OverflowException {
        if (input < 0) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static long safeCastS16toU64(short input) throws OverflowException {
        if (input < 0) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static long safeCastS32toU64(int input) throws OverflowException {
        if (input < 0) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static long safeCastS64toU64(long input) throws OverflowException {
        if (input < 0L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static long safeCastS24toU64(@ActuallySigned(value=24) int input) throws OverflowException {
        if (input < 0) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static long safeCastS40toU64(@ActuallySigned(value=40) long input) throws OverflowException {
        if (input < 0L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static long safeCastS48toU64(@ActuallySigned(value=48) long input) throws OverflowException {
        if (input < 0L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static long safeCastS56toU64(@ActuallySigned(value=56) long input) throws OverflowException {
        if (input < 0L) {
            throw new OverflowException(String.valueOf(input));
        }
        return input;
    }

    @ActuallyUnsigned
    public static long safeCastU24toU64(@ActuallyUnsigned(value=24) int input) throws OverflowException {
        return input;
    }

    @ActuallyUnsigned
    public static long safeCastU40toU64(@ActuallyUnsigned(value=40) long input) throws OverflowException {
        return input;
    }

    @ActuallyUnsigned
    public static long safeCastU48toU64(@ActuallyUnsigned(value=48) long input) throws OverflowException {
        return input;
    }

    @ActuallyUnsigned
    public static long safeCastU56toU64(@ActuallyUnsigned(value=56) long input) throws OverflowException {
        return input;
    }

    @ActuallyUnsigned
    public static long safeCastU64toU64(@ActuallyUnsigned long input) throws OverflowException {
        return input;
    }

    @ActuallyUnsigned
    public static long safeCastU8toU64(@ActuallyUnsigned byte input) throws OverflowException {
        return Unsigned.upcastTo64(input);
    }

    @ActuallyUnsigned
    public static long safeCastU16toU64(@ActuallyUnsigned short input) throws OverflowException {
        return Unsigned.upcastTo64(input);
    }

    @ActuallyUnsigned
    public static long safeCastU32toU64(@ActuallyUnsigned int input) throws OverflowException {
        return Unsigned.upcastTo64(input);
    }
}

