/*
 * Decompiled with CFR 0.152.
 */
package rebound.hci.graphics2d.gui.awt.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import rebound.hci.graphics2d.gui.awt.components.JFileChooserWrapper;
import rebound.hci.graphics2d.gui.componentinterfaces.AbstractFileChooser;

public class LatentFileBox
extends JComponent {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_TEXT = "Choose a file.";
    protected static final int CHANGE_BUTTON_WIDTH = 80;
    protected File selectedFile = null;
    protected JTextField pathDisplay = new JTextField();
    protected JButton changeButton;
    protected String defaultText = "Choose a file.";
    protected AbstractFileChooser filechooser;

    public LatentFileBox() {
        this.pathDisplay.setEditable(false);
        this.pathDisplay.setText(this.defaultText);
        this.changeButton = new JButton();
        this.changeButton.setText("Change");
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LatentFileBox.this.changeButtonClicked();
            }
        });
        this.add(this.pathDisplay);
        this.add(this.changeButton);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        int width = this.getWidth();
        int height = this.getHeight();
        this.pathDisplay.setLocation(0, 0);
        this.pathDisplay.setSize(width - 80, height);
        this.changeButton.setLocation(width - 80, 0);
        this.changeButton.setSize(80, height);
    }

    protected void changeButtonClicked() {
        if (this.filechooser == null) {
            JFileChooser jfc = new JFileChooser();
            JFileChooserWrapper wrapper = new JFileChooserWrapper(jfc);
            this.filechooser = wrapper;
        }
        this.setSelectedFile(this.filechooser.promptOne());
    }

    public void setSelectedFile(File selectedFile) {
        this.selectedFile = selectedFile;
        if (selectedFile == null) {
            this.pathDisplay.setText(this.defaultText);
        } else {
            this.pathDisplay.setText(selectedFile.getName());
        }
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
        if (this.selectedFile == null) {
            this.pathDisplay.setText(defaultText);
        }
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public AbstractFileChooser getFileChooser() {
        return this.filechooser;
    }

    public void setFileChooser(AbstractFileChooser filechooser) {
        this.filechooser = filechooser;
    }
}

