/*
 * Decompiled with CFR 0.152.
 */
package rebound.math;

import com.google.common.primitives.UnsignedLong;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rebound.annotations.semantic.simpledata.ActuallyUnsigned;
import rebound.annotations.semantic.simpledata.MayNormalizePrimitives;
import rebound.bits.BitfieldSafeCasts;
import rebound.bits.Bytes;
import rebound.bits.Unsigned;
import rebound.exceptions.DivisionByZeroException;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.InfinityException;
import rebound.exceptions.NonfiniteException;
import rebound.exceptions.NotANumberException;
import rebound.exceptions.NotYetImplementedException;
import rebound.exceptions.OutOfDomainArithmeticException;
import rebound.exceptions.OverflowException;
import rebound.exceptions.StructuredClassCastException;
import rebound.exceptions.TruncationException;
import rebound.math.ArithmeticIntegerInterval;
import rebound.math.Direction1D;
import rebound.math.ImmutableRational;
import rebound.math.PolyInteger;
import rebound.math.Rational;
import rebound.math.RationalOrInteger;
import rebound.math.RealNumeric;
import rebound.math.SmallFloatMathUtilities;
import rebound.math.SmallIntegerMathUtilities;
import rebound.testing.WidespreadTestingUtilities;
import rebound.text.StringUtilities;
import rebound.util.BasicExceptionUtilities;
import rebound.util.Primitives;
import rebound.util.collections.ArrayUtilities;
import rebound.util.collections.FilterAwayReturnPath;
import rebound.util.collections.Mapper;
import rebound.util.collections.PairOrdered;
import rebound.util.collections.PairOrderedImmutable;
import rebound.util.collections.PolymorphicCollectionUtilities;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.functional.ContinueSignal;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.functional.functions.DefaultComparisonNumericallyAbstract;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.JavaNamespace;

public class MathUtilities
implements JavaNamespace {
    public static final Object Zero = MathUtilities.normalizeNumberToRationalOrInteger(0);
    public static final Object One = MathUtilities.normalizeNumberToRationalOrInteger(1);
    public static final BigInteger BIGINT_NEGATIVE_ONE = MathUtilities.toBigInteger(-1);
    public static final BigInteger BIGINT_BYTE_MIN_VAL = MathUtilities.toBigInteger((byte)-128);
    public static final BigInteger BIGINT_BYTE_MAX_VAL = MathUtilities.toBigInteger((byte)127);
    public static final BigInteger BIGINT_BYTE_ABOVE_MAX_VAL = MathUtilities.toBigInteger(128);
    public static final BigInteger BIGINT_SHORT_MIN_VAL = MathUtilities.toBigInteger((short)Short.MIN_VALUE);
    public static final BigInteger BIGINT_SHORT_MAX_VAL = MathUtilities.toBigInteger((short)Short.MAX_VALUE);
    public static final BigInteger BIGINT_SHORT_ABOVE_MAX_VAL = MathUtilities.toBigInteger(32768);
    public static final BigInteger BIGINT_CHAR_MIN_VAL = MathUtilities.toBigInteger('\u0000');
    public static final BigInteger BIGINT_CHAR_MAX_VAL = MathUtilities.toBigInteger('\uffff');
    public static final BigInteger BIGINT_CHAR_ABOVE_MAX_VAL = MathUtilities.toBigInteger(65536);
    public static final BigInteger BIGINT_INT_MIN_VAL = MathUtilities.toBigInteger(Integer.MIN_VALUE);
    public static final BigInteger BIGINT_INT_MAX_VAL = MathUtilities.toBigInteger(Integer.MAX_VALUE);
    public static final BigInteger BIGINT_INT_ABOVE_MAX_VAL = MathUtilities.toBigInteger(0x80000000L);
    public static final BigInteger BIGINT_LONG_MIN_VAL = MathUtilities.toBigInteger(Long.MIN_VALUE);
    public static final BigInteger BIGINT_LONG_MAX_VAL = MathUtilities.toBigInteger(Long.MAX_VALUE);
    public static final BigInteger BIGINT_LONG_ABOVE_MAX_VAL = BIGINT_LONG_MAX_VAL.add(BigInteger.ONE);
    public static final BigInteger BIGINT_ULONG_MIN_VAL = BigInteger.ZERO;
    public static final BigInteger BIGINT_ULONG_MAX_VAL = MathUtilities.toBigInteger(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L));
    public static final BigInteger BIGINT_ULONG_ABOVE_MAX_VAL = MathUtilities.toBigInteger(Long.MAX_VALUE).add(BigInteger.ONE);
    public static final BigInteger DoubleMaxBoundAsBigInteger = (BigInteger)MathUtilities.safeCastFloatToInteger(Double.MAX_VALUE);
    public static final BigInteger DoubleMinBoundAsBigInteger = (BigInteger)MathUtilities.safeCastFloatToInteger(-1.7976931348623157E308);
    public static final BigInteger FloatMaxBoundAsBigInteger = (BigInteger)MathUtilities.safeCastFloatToInteger(Float.MAX_VALUE);
    public static final BigInteger FloatMinBoundAsBigInteger = (BigInteger)MathUtilities.safeCastFloatToInteger(-3.4028235E38f);
    protected static final Object IEEE754SingleConversionSubnormalDenominator = MathUtilities.pow(2, 149);
    protected static final Object IEEE754DoubleConversionSubnormalDenominator = MathUtilities.pow(2, 1074);
    public static final Comparator<Object> MathComparator = MathUtilities::mathcmp;
    public static final Comparator<Object> MathComparatorReverse = (a, b) -> MathUtilities.mathcmp(b, a);
    public static final ArithmeticIntegerInterval EmptyInterval = new ArithmeticIntegerInterval(0L, 0L);

    public static boolean isNegativeInfinity(Object o) {
        return BasicObjectUtilities.eq(o, (Object)Float.valueOf(Float.NEGATIVE_INFINITY)) || BasicObjectUtilities.eq(o, (Object)Double.NEGATIVE_INFINITY) || o == Infinity.Negative;
    }

    public static boolean isPositiveInfinity(Object o) {
        return BasicObjectUtilities.eq(o, (Object)Float.valueOf(Float.POSITIVE_INFINITY)) || BasicObjectUtilities.eq(o, (Object)Double.POSITIVE_INFINITY) || o == Infinity.Positive;
    }

    public static boolean isInfinity(Object o) {
        return MathUtilities.isNegativeInfinity(o) || MathUtilities.isPositiveInfinity(o);
    }

    public static int factor(long number, long[] primes, long[] primeExponents) {
        if (number == 0L || number == 1L) {
            return 0;
        }
        if (number < 0L) {
            throw new NotYetImplementedException("unsigned integers not yet supported");
        }
        int numberOfDistinctPrimes = 0;
        long i = 2L;
        while (i <= number) {
            if (number == 1L) {
                return numberOfDistinctPrimes;
            }
            if (number % i == 0L) {
                primes[numberOfDistinctPrimes] = i;
                primeExponents[numberOfDistinctPrimes] = 0L;
                while (number % i == 0L) {
                    int n = numberOfDistinctPrimes;
                    primeExponents[n] = primeExponents[n] + 1L;
                    number /= i;
                }
                ++numberOfDistinctPrimes;
            }
            ++i;
        }
        if (number == 1L) {
            return numberOfDistinctPrimes;
        }
        throw new ImpossibleException();
    }

    public static long getNumberOfFactors(long[] primeExponents, int primeCount) {
        long facs = 1L;
        int i = 0;
        while (i < primeCount) {
            facs *= primeExponents[i] + 1L;
            ++i;
        }
        return facs;
    }

    public static long getNumberOfPrimeFactors(long[] primeExponents, int primeCount) {
        long pfacs = 0L;
        int i = 0;
        while (i < primeCount) {
            pfacs += primeExponents[i];
            ++i;
        }
        return pfacs;
    }

    /*
     * Unable to fully structure code
     */
    public static int expandPrimeExponentList(long[] primes, long[] primeExponents, int count, long[] morePrimes, long[] morePrimeExponentList) {
        e = 0;
        i = 0;
        ** GOTO lbl13
        {
            morePrimeExponentList[e] = 0L;
            ++e;
            do {
                if (primes[i] != morePrimes[e] && e < morePrimes.length) continue block0;
                if (primes[i] != morePrimes[e]) {
                    throw new IllegalArgumentException("The second prime list is not a superset of the first prime list.");
                }
                morePrimeExponentList[e] = primeExponents[i];
                ++e;
                ++i;
lbl13:
                // 2 sources

            } while (i < count);
        }
        return e;
    }

    public static long[] getPrimesByCount(long max) {
        PrimitiveCollections.LongArrayList list = new PrimitiveCollections.LongArrayList();
        long n = 2L;
        while (n <= max) {
            if (MathUtilities.isPrime(n)) {
                list.addLong(n);
            }
            ++n;
        }
        return list.toLongArray();
    }

    public static long[] getPrimesByBound(int count) {
        PrimitiveCollections.LongArrayList list = new PrimitiveCollections.LongArrayList();
        long n = 2L;
        while (list.size() < count) {
            if (MathUtilities.isPrime(n)) {
                list.addLong(n);
            }
            ++n;
        }
        return list.toLongArray();
    }

    public static long getFirstPrimeAboveBound(long startingPoint) {
        long n = startingPoint;
        do {
            if (++n >= startingPoint) continue;
            return 0L;
        } while (!MathUtilities.isPrime(n));
        return n;
    }

    public static LongInfiniteIterator getPrimeGenerator(long startingPoint) {
        return new LongInfiniteIterator(startingPoint){
            long n;
            {
                this.n = l;
            }

            @Override
            public long next() {
                while (!MathUtilities.isPrime(this.n)) {
                    ++this.n;
                }
                long p = this.n++;
                return p;
            }
        };
    }

    public static boolean isPrime(long number) {
        long n = 2L;
        while (n < number) {
            if (number % n == 0L) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static int reduceUnsigned(int[] numbers) {
        return MathUtilities.reduceUnsigned(numbers, 0, numbers.length);
    }

    public static int reduceSigned(int[] numbers) {
        return MathUtilities.reduceSigned(numbers, 0, numbers.length);
    }

    public static int reduceUnsigned(int[] numbers, int start, int end) {
        int gcd = SmallIntegerMathUtilities.gcd((int[])numbers.clone(), start, end);
        if (gcd == 0 || gcd == 1) {
            return gcd;
        }
        int i = start;
        while (i < end) {
            numbers[i] = Unsigned.divideU32(numbers[i], gcd);
            ++i;
        }
        return gcd;
    }

    public static int reduceSigned(int[] numbers, int start, int end) {
        int gcd = SmallIntegerMathUtilities.gcd((int[])numbers.clone(), start, end);
        if (gcd == 0 || gcd == 1) {
            return gcd;
        }
        int i = start;
        while (i < end) {
            int n = i++;
            numbers[n] = numbers[n] / gcd;
        }
        return gcd;
    }

    public static boolean isFractionsEqual(int n1, int d1, int n2, int d2) {
        int gcd2;
        int gcd1;
        return (n1 /= (gcd1 = SmallIntegerMathUtilities.gcd(n1, n1))) == (n2 /= (gcd2 = SmallIntegerMathUtilities.gcd(n2, d2))) && (d1 /= gcd1) == (d2 /= gcd2);
    }

    public static int factorial32(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return 0;
        }
        if (n > 12) {
            throw new OverflowException();
        }
        int f = 1;
        int i = 1;
        while (i <= n) {
            f *= i;
            ++i;
        }
        return f;
    }

    public static long factorial64(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return 0L;
        }
        if (n > 20) {
            throw new OverflowException();
        }
        long f = 1L;
        int i = 1;
        while (i <= n) {
            f *= (long)i;
            ++i;
        }
        return f;
    }

    public static int factorialPartial32(int inclusiveStart, int inclusiveEnd) {
        if (inclusiveStart < 0) {
            throw new IllegalArgumentException();
        }
        if (inclusiveEnd < 0) {
            throw new IllegalArgumentException();
        }
        if (inclusiveEnd < inclusiveStart) {
            throw new IllegalArgumentException();
        }
        int f = 1;
        int i = inclusiveStart;
        while (i <= inclusiveEnd) {
            f = SmallIntegerMathUtilities.safe_mul_s32(f, i);
            ++i;
        }
        return f;
    }

    public static long factorialPartial64(int inclusiveStart, int inclusiveEnd) {
        if (inclusiveStart < 0) {
            throw new IllegalArgumentException();
        }
        if (inclusiveEnd < 0) {
            throw new IllegalArgumentException();
        }
        if (inclusiveEnd < inclusiveStart) {
            throw new IllegalArgumentException();
        }
        long f = 1L;
        int i = inclusiveStart;
        while (i <= inclusiveEnd) {
            f = SmallIntegerMathUtilities.safe_mul_s64(f, i);
            ++i;
        }
        return f;
    }

    public static BigInteger toBigInteger(byte value) {
        return MathUtilities.toBigInteger((long)value);
    }

    public static BigInteger toBigInteger(short value) {
        return MathUtilities.toBigInteger((long)value);
    }

    public static BigInteger toBigInteger(char value) {
        return MathUtilities.toBigInteger((long)value);
    }

    public static BigInteger toBigInteger(int value) {
        return MathUtilities.toBigInteger((long)value);
    }

    public static BigInteger toBigInteger(long value) {
        return BigInteger.valueOf(value);
    }

    @MayNormalizePrimitives
    public static BigInteger toBigInteger(@PolyInteger Object value) {
        Objects.requireNonNull(value);
        if (value instanceof Byte) {
            return MathUtilities.toBigInteger((Byte)value);
        }
        if (value instanceof Short) {
            return MathUtilities.toBigInteger((Short)value);
        }
        if (value instanceof Character) {
            return MathUtilities.toBigInteger(((Character)value).charValue());
        }
        if (value instanceof Integer) {
            return MathUtilities.toBigInteger((Integer)value);
        }
        if (value instanceof Long) {
            return MathUtilities.toBigInteger((Long)value);
        }
        if (value instanceof UnsignedLong) {
            return ((UnsignedLong)value).bigIntegerValue();
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        throw new StructuredClassCastException("Not a supported integer type!!: " + value.getClass().getName(), value.getClass());
    }

    public static BigInteger toBigIntegerFromUnsignedLong(@ActuallyUnsigned long value) {
        if (value >= 0L) {
            return MathUtilities.toBigInteger(value);
        }
        byte[] b = new byte[9];
        Bytes.putBigLong(b, 1, value);
        return new BigInteger(b);
    }

    public static ContinueSignal observeAllSequences(int sequenceMaxCardinality, int sequenceLength, FunctionInterfaces.UnaryFunction<PrimitiveCollections.ImmutableIntegerArrayList, ContinueSignal> observe) {
        return MathUtilities.observeAllSequencesSharedArray(sequenceMaxCardinality, sequenceLength, s -> (ContinueSignal)((Object)((Object)observe.f(PrimitiveCollections.ImmutableIntegerArrayList.newCopying(s)))));
    }

    public static ContinueSignal observeAllSequencesSharedArray(int sequenceMaxCardinality, int sequenceLength, FunctionInterfaces.UnaryFunction<int[], ContinueSignal> observe) {
        int[] sequence = new int[sequenceLength];
        do {
            if (observe.f(sequence) != ContinueSignal.Stop) continue;
            return ContinueSignal.Stop;
        } while (MathUtilities.increment(sequence, 0, sequenceMaxCardinality));
        return ContinueSignal.Continue;
    }

    public static boolean increment(boolean[] integer) {
        return MathUtilities.increment(integer, 0, integer.length);
    }

    public static boolean increment(boolean[] integer, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (integer[offset + i]) {
                integer[offset + i] = false;
                continue;
            }
            integer[offset + i] = true;
            return true;
        }
        return false;
    }

    public static boolean increment(int[] values, int inclusiveLowBound, int exclusiveHighBound) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] >= exclusiveHighBound - 1) {
                values[i] = inclusiveLowBound;
                continue;
            }
            int n = i;
            values[n] = values[n] + 1;
            return true;
        }
        return false;
    }

    public static boolean increment(long[] values, long inclusiveLowBound, long exclusiveHighBound) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] >= exclusiveHighBound - 1L) {
                values[i] = inclusiveLowBound;
                continue;
            }
            int n = i;
            values[n] = values[n] + 1L;
            return true;
        }
        return false;
    }

    public static boolean increment(int[] values, int inclusiveLowBound, int[] exclusiveHighBounds) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] >= exclusiveHighBounds[i] - 1) {
                values[i] = inclusiveLowBound;
                continue;
            }
            int n = i;
            values[n] = values[n] + 1;
            return true;
        }
        return false;
    }

    public static int cmpPolyIntegers(Object a, Object b) {
        a = MathUtilities.normalizeNumberToRationalOrInteger(a);
        b = MathUtilities.normalizeNumberToRationalOrInteger(b);
        if (a instanceof Long) {
            long ap = (Long)a;
            if (b instanceof Long) {
                long bp = (Long)b;
                return SmallIntegerMathUtilities.cmp(ap, bp);
            }
            if (b instanceof BigInteger) {
                return MathUtilities.toBigInteger(ap).compareTo((BigInteger)b);
            }
            if (!MathUtilities.isInteger(b)) {
                throw new IllegalArgumentException();
            }
            return -((Comparable)b).compareTo(a);
        }
        if (a instanceof BigInteger) {
            return ((BigInteger)a).compareTo(MathUtilities.toBigInteger(b));
        }
        if (!MathUtilities.isInteger(a)) {
            throw new IllegalArgumentException();
        }
        if (!MathUtilities.isInteger(b)) {
            throw new IllegalArgumentException();
        }
        return ((Comparable)a).compareTo(b);
    }

    public static Long imizeOnerootIntegerIndependent(IntegerToBooleanFunction function, RootingParity rootingParity) {
        return MathUtilities.imizeOnerootIntegerIndependent(function, Long.MIN_VALUE, Long.MAX_VALUE, rootingParity);
    }

    public static Long imizeOnerootIntegerIndependent(IntegerToBooleanFunction function, long lowBound, long highBound, RootingParity rootingParity) {
        if (rootingParity == RootingParity.MINIMIZE) {
            if (function.evaluate(lowBound)) {
                return lowBound;
            }
            if (!function.evaluate(highBound)) {
                return null;
            }
        } else {
            if (!function.evaluate(lowBound)) {
                return null;
            }
            if (function.evaluate(highBound)) {
                return highBound;
            }
        }
        while (true) {
            if (rootingParity == RootingParity.MINIMIZE) {
                if (highBound == lowBound + 1L) {
                    return highBound;
                }
            } else if (highBound == lowBound + 1L) {
                return lowBound;
            }
            if (highBound <= lowBound) {
                throw new ImpossibleException("crazy rooting glitch?!");
            }
            long midpoint = lowBound + (highBound - lowBound) / 2L;
            if (midpoint == lowBound || midpoint == highBound) {
                throw new ImpossibleException("rooting glitch?!");
            }
            if (function.evaluate(midpoint) == (rootingParity == RootingParity.MINIMIZE)) {
                highBound = midpoint;
                continue;
            }
            lowBound = midpoint;
        }
    }

    @Nullable
    public static <I, O extends Comparable> O leastMap(Mapper<I, O> function, Iterable<I> inputs) {
        PairOrdered<I, O> p = MathUtilities.leastMapPair(function, inputs);
        return (O)(p == null ? null : (Comparable)p.getB());
    }

    @Nullable
    public static <E extends Comparable> E least(Iterable<E> inputs) {
        return (E)MathUtilities.leastMap(x -> x, inputs);
    }

    @Nullable
    public static <E> E least(Iterable<E> inputs, Comparator<E> comparison) {
        PairOrdered<Object, Object> p = MathUtilities.leastMapPair(x -> x, inputs, comparison);
        return (E)(p == null ? null : p.getB());
    }

    public static <E extends Comparable> E least(E a, E b) {
        return DefaultComparisonNumericallyAbstract.I.compare(a, b) < 0 ? a : b;
    }

    @Nullable
    public static <I, O extends Comparable> O greatestMap(Mapper<I, O> function, Iterable<I> inputs) {
        PairOrdered<I, O> p = MathUtilities.greatestMapPair(function, inputs);
        return (O)(p == null ? null : (Comparable)p.getB());
    }

    @Nullable
    public static <E extends Comparable> E greatest(Iterable<E> inputs) {
        return (E)MathUtilities.greatestMap(x -> x, inputs);
    }

    @Nullable
    public static <E> E greatest(Iterable<E> inputs, Comparator<E> comparison) {
        PairOrdered<Object, Object> p = MathUtilities.greatestMapPair(x -> x, inputs, comparison);
        return (E)(p == null ? null : p.getB());
    }

    public static <E extends Comparable> E greatest(E a, E b) {
        return DefaultComparisonNumericallyAbstract.I.compare(a, b) > 0 ? a : b;
    }

    @Nullable
    public static <I, O extends Comparable> PairOrdered<I, O> leastMapPair(Mapper<I, O> function, Iterable<I> inputs) {
        return MathUtilities.leastMapPair(function, inputs, DefaultComparisonNumericallyAbstract.I);
    }

    @Nullable
    public static <I, O> PairOrdered<I, O> leastMapPair(Mapper<I, O> function, Iterable<I> inputs, Comparator<O> comparison) {
        boolean has = false;
        Object extremestInput = null;
        Object extremestOutput = null;
        for (I input : inputs) {
            O output;
            try {
                output = function.f(input);
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            if (!has) {
                extremestOutput = output;
                extremestInput = input;
                has = true;
                continue;
            }
            if (comparison.compare(output, extremestOutput) >= 0) continue;
            extremestOutput = output;
            extremestInput = input;
        }
        return has ? new PairOrderedImmutable<Object, Object>(extremestInput, extremestOutput) : null;
    }

    @Nullable
    public static <I, O extends Comparable> PairOrdered<I, O> greatestMapPair(Mapper<I, O> function, Iterable<I> inputs) {
        return MathUtilities.greatestMapPair(function, inputs, DefaultComparisonNumericallyAbstract.I);
    }

    @Nullable
    public static <I, O> PairOrdered<I, O> greatestMapPair(Mapper<I, O> function, Iterable<I> inputs, Comparator<O> comparison) {
        boolean has = false;
        Object extremestInput = null;
        Object extremestOutput = null;
        for (I input : inputs) {
            O output;
            try {
                output = function.f(input);
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            if (!has) {
                extremestOutput = output;
                extremestInput = input;
                has = true;
                continue;
            }
            if (comparison.compare(output, extremestOutput) <= 0) continue;
            extremestOutput = output;
            extremestInput = input;
        }
        return has ? new PairOrderedImmutable<Object, Object>(extremestInput, extremestOutput) : null;
    }

    public static int safeCastBigIntegerToS32(BigInteger input) {
        if (input.compareTo(BIGINT_INT_MIN_VAL) < 0 || input.compareTo(BIGINT_INT_MAX_VAL) > 0) {
            throw new OverflowException(input + " -> S32");
        }
        return input.intValue();
    }

    public static boolean isOverflowsCastBigIntegerToS32(BigInteger input) {
        return input.compareTo(BIGINT_INT_MIN_VAL) < 0 || input.compareTo(BIGINT_INT_MAX_VAL) > 0;
    }

    public static long safeCastBigIntegerToS64(BigInteger input) throws OverflowException {
        if (MathUtilities.isOverflowsCastBigIntegerToS64(input)) {
            throw new OverflowException(input + " -> S64");
        }
        return input.longValue();
    }

    public static boolean isOverflowsCastBigIntegerToS64(BigInteger input) {
        return input.compareTo(BIGINT_LONG_MIN_VAL) < 0 || input.compareTo(BIGINT_LONG_MAX_VAL) > 0;
    }

    @ActuallyUnsigned
    public static long safeCastBigIntegerToU64(BigInteger input) throws OverflowException {
        if (MathUtilities.isOverflowsCastBigIntegerToU64(input)) {
            throw new OverflowException(input + " -> U64");
        }
        return input.longValue();
    }

    public static boolean isOverflowsCastBigIntegerToU64(BigInteger input) {
        return input.compareTo(BIGINT_ULONG_MIN_VAL) < 0 || input.compareTo(BIGINT_ULONG_MAX_VAL) > 0;
    }

    public static BigInteger ulongToBigInteger(@ActuallyUnsigned long v) {
        return new BigInteger(1, Bytes.packBigLong(v));
    }

    public static byte safeCastIntegerToS8(Object input) {
        return BitfieldSafeCasts.safeCastS64toS8(MathUtilities.safeCastIntegerToS64(input));
    }

    public static short safeCastIntegerToS16(Object input) {
        return BitfieldSafeCasts.safeCastS64toS16(MathUtilities.safeCastIntegerToS64(input));
    }

    public static int safeCastIntegerToS32(Object input) throws OverflowException {
        return BitfieldSafeCasts.safeCastS64toS32(MathUtilities.safeCastIntegerToS64(input));
    }

    public static byte safeCastAnythingToS8(Object input) throws OverflowException, TruncationException {
        return BitfieldSafeCasts.safeCastS64toS8(MathUtilities.safeCastAnythingToS64(input));
    }

    public static short safeCastAnythingToS16(Object input) throws OverflowException, TruncationException {
        return BitfieldSafeCasts.safeCastS64toS16(MathUtilities.safeCastAnythingToS64(input));
    }

    public static int safeCastAnythingToS32(Object input) throws OverflowException, TruncationException {
        return BitfieldSafeCasts.safeCastS64toS32(MathUtilities.safeCastAnythingToS64(input));
    }

    public static long safeCastIntegerToS64(Object input) throws OverflowException {
        if (input instanceof CastableToIntegerTrait.CastableToSmallIntegerTrait) {
            return ((CastableToIntegerTrait.CastableToSmallIntegerTrait)input).toSmallInteger();
        }
        if (input instanceof CastableToIntegerTrait) {
            input = ((CastableToIntegerTrait)input).toInteger();
        }
        if (input instanceof Byte) {
            return ((Byte)input).byteValue();
        }
        if (input instanceof Short) {
            return ((Short)input).shortValue();
        }
        if (input instanceof Character) {
            return ((Character)input).charValue();
        }
        if (input instanceof Integer) {
            return ((Integer)input).intValue();
        }
        if (input instanceof Long) {
            return (Long)input;
        }
        if (input instanceof UnsignedLong) {
            return BitfieldSafeCasts.safeCastU64toS64(((UnsignedLong)input).longValue());
        }
        if (input instanceof BigInteger) {
            return MathUtilities.safeCastBigIntegerToS64((BigInteger)input);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(input);
    }

    public static long safeCastAnythingToS64(Object input) throws OverflowException, TruncationException {
        if (input instanceof Rational) {
            input = MathUtilities.reduce(input);
        }
        if (MathUtilities.isInteger(input)) {
            return MathUtilities.safeCastIntegerToS64(input);
        }
        if (input instanceof Float) {
            return MathUtilities.safeCastIntegerToS64(MathUtilities.safeCastFloatToInteger(((Float)input).floatValue()));
        }
        if (input instanceof Double) {
            return MathUtilities.safeCastIntegerToS64(MathUtilities.safeCastFloatToInteger((Double)input));
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(input);
    }

    @ActuallyUnsigned
    public static long safeCastIntegerToU64(Object input) throws OverflowException {
        if (input instanceof CastableToIntegerTrait.CastableToSmallIntegerTrait) {
            input = ((CastableToIntegerTrait.CastableToSmallIntegerTrait)input).toSmallInteger();
        } else if (input instanceof CastableToIntegerTrait) {
            input = ((CastableToIntegerTrait)input).toInteger();
        }
        if (input instanceof Byte) {
            return BitfieldSafeCasts.safeCastS8toU64((Byte)input);
        }
        if (input instanceof Short) {
            return BitfieldSafeCasts.safeCastS16toU64((Short)input);
        }
        if (input instanceof Character) {
            return ((Character)input).charValue();
        }
        if (input instanceof Integer) {
            return BitfieldSafeCasts.safeCastS32toU64((Integer)input);
        }
        if (input instanceof Long) {
            return BitfieldSafeCasts.safeCastS64toU64((Long)input);
        }
        if (input instanceof BigInteger) {
            return MathUtilities.safeCastBigIntegerToU64((BigInteger)input);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(input);
    }

    @ActuallyUnsigned
    public static long safeCastAnythingToU64(Object input) throws OverflowException, TruncationException {
        if (input instanceof Rational) {
            input = MathUtilities.reduce(input);
        }
        if (MathUtilities.isInteger(input)) {
            return MathUtilities.safeCastIntegerToU64(input);
        }
        if (input instanceof Float) {
            return MathUtilities.safeCastIntegerToU64(MathUtilities.safeCastFloatToInteger(((Float)input).floatValue()));
        }
        if (input instanceof Double) {
            return MathUtilities.safeCastIntegerToU64(MathUtilities.safeCastFloatToInteger((Double)input));
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(input);
    }

    public static boolean isOverflowsCastIntegerToS64(Object input) {
        if (input instanceof Byte) {
            return false;
        }
        if (input instanceof Short) {
            return false;
        }
        if (input instanceof Character) {
            return false;
        }
        if (input instanceof Integer) {
            return false;
        }
        if (input instanceof Long) {
            return false;
        }
        if (input instanceof UnsignedLong) {
            return ((UnsignedLong)input).longValue() < 0L;
        }
        if (input instanceof BigInteger) {
            return MathUtilities.isOverflowsCastBigIntegerToS64((BigInteger)input);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(input);
    }

    public static boolean isOverflowsCastToS32(Object input) {
        if (input instanceof Byte) {
            return false;
        }
        if (input instanceof Short) {
            return false;
        }
        if (input instanceof Character) {
            return false;
        }
        if (input instanceof Integer) {
            return false;
        }
        if (input instanceof Long) {
            return (Long)input < Integer.MIN_VALUE || (Long)input > Integer.MAX_VALUE;
        }
        if (input instanceof UnsignedLong) {
            long v = ((UnsignedLong)input).longValue();
            return v < 0L || v > Integer.MAX_VALUE;
        }
        if (input instanceof BigInteger) {
            return MathUtilities.isOverflowsCastBigIntegerToS32((BigInteger)input);
        }
        try {
            MathUtilities.safeCastIntegerToS32(input);
        }
        catch (OverflowException exc) {
            return false;
        }
        return true;
    }

    public static Object safeCastFloatToInteger(float f) throws TruncationException {
        if (!SmallFloatMathUtilities.isFloatingPointAnInteger(f)) {
            throw new TruncationException();
        }
        if (SmallFloatMathUtilities.isFloatingOutOfS64Bounds(f)) {
            Object r = MathUtilities.convertFloatToRationalOrInteger(f);
            assert (r instanceof Long || r instanceof BigInteger);
            return r;
        }
        return (long)f;
    }

    public static Object safeCastFloatToInteger(double f) throws TruncationException {
        if (!SmallFloatMathUtilities.isFloatingPointAnInteger(f)) {
            throw new TruncationException();
        }
        if (SmallFloatMathUtilities.isFloatingOutOfS64Bounds(f)) {
            Object r = MathUtilities.convertFloatToRationalOrInteger(f);
            assert (r instanceof Long || r instanceof BigInteger);
            return r;
        }
        return (long)f;
    }

    public static double safeCastAnythingToDouble(Object x) throws OverflowException {
        if (x instanceof BigInteger) {
            BigInteger bix = (BigInteger)x;
            if (DoubleMaxBoundAsBigInteger.compareTo(bix) < 0) {
                throw new OverflowException();
            }
            if (DoubleMinBoundAsBigInteger.compareTo(bix) < 0) {
                throw new OverflowException();
            }
            return bix.doubleValue();
        }
        return ((Number)x).doubleValue();
    }

    public static float safeCastAnythingToFloat(Object x) throws OverflowException {
        if (x instanceof BigInteger) {
            BigInteger bix = (BigInteger)x;
            if (FloatMaxBoundAsBigInteger.compareTo(bix) < 0) {
                throw new OverflowException();
            }
            if (FloatMinBoundAsBigInteger.compareTo(bix) < 0) {
                throw new OverflowException();
            }
            return bix.floatValue();
        }
        return ((Number)x).floatValue();
    }

    public static BigInteger safeCastAnythingToBigInteger(Object input) throws TruncationException {
        if (input instanceof Rational) {
            if ((input = MathUtilities.reduce(input)) instanceof Rational) {
                throw new TruncationException();
            }
            return MathUtilities.toBigInteger(input);
        }
        if (input instanceof Float) {
            float f = ((Float)input).floatValue();
            Object r = MathUtilities.convertFloatToRationalOrInteger(f);
            if (r instanceof Rational) {
                throw new TruncationException();
            }
            return MathUtilities.toBigInteger(r);
        }
        if (input instanceof Double) {
            double f = (Double)input;
            Object r = MathUtilities.convertFloatToRationalOrInteger(f);
            if (r instanceof Rational) {
                throw new TruncationException();
            }
            return MathUtilities.toBigInteger(r);
        }
        return MathUtilities.toBigInteger(input);
    }

    @RationalOrInteger
    public static Object safeCastAnythingToRationalOrInteger(Object x) {
        if (MathUtilities.isRationalOrInteger(x)) {
            return x;
        }
        if (x instanceof Float) {
            return MathUtilities.convertFloatToRationalOrInteger(((Float)x).floatValue());
        }
        if (x instanceof Double) {
            return MathUtilities.convertFloatToRationalOrInteger((Double)x);
        }
        if (x instanceof BigDecimal) {
            throw new NotYetImplementedException();
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(x);
    }

    @RationalOrInteger
    public static Object convertFloatToRationalOrInteger(float f) {
        int[] p = SmallFloatMathUtilities.rawparseIEEE754SinglePrecision(f);
        int sign = p[0];
        int presignificand = p[1];
        int postcharacteristic = p[2];
        if (postcharacteristic == 128) {
            throw SmallFloatMathUtilities.isNaN(f) ? new NotANumberException() : new InfinityException();
        }
        Object v = postcharacteristic == -127 ? MathUtilities.divide(presignificand, IEEE754SingleConversionSubnormalDenominator) : MathUtilities.add(MathUtilities.pow(2, postcharacteristic), MathUtilities.divide(presignificand, MathUtilities.pow(2, 23 - postcharacteristic)));
        return sign == -1 ? MathUtilities.negate(v) : v;
    }

    @RationalOrInteger
    public static Object convertFloatToRationalOrInteger(double f) {
        long[] p = SmallFloatMathUtilities.rawparseIEEE754DoublePrecision(f);
        long sign = p[0];
        long presignificand = p[1];
        long postcharacteristic = p[2];
        if (postcharacteristic == 1024L) {
            throw SmallFloatMathUtilities.isNaN(f) ? new NotANumberException() : new InfinityException();
        }
        Object v = postcharacteristic == -1023L ? MathUtilities.divide(presignificand, IEEE754DoubleConversionSubnormalDenominator) : MathUtilities.add(MathUtilities.pow(2, postcharacteristic), MathUtilities.divide(presignificand, MathUtilities.pow(2, 52L - postcharacteristic)));
        return sign == -1L ? MathUtilities.negate(v) : v;
    }

    @RationalOrInteger
    public static Object convertFloatToClosestSmallRationalOrInteger(float f) {
        return MathUtilities.castTruncatingPrecisionToClosestSmallRational(MathUtilities.convertFloatToRationalOrInteger(f));
    }

    @RationalOrInteger
    public static Object convertFloatToClosestSmallRationalOrInteger(double f) {
        return MathUtilities.castTruncatingPrecisionToClosestSmallRational(MathUtilities.convertFloatToRationalOrInteger(f));
    }

    @RationalOrInteger
    public static Object castTruncatingPrecisionToClosestSmallRational(@RationalOrInteger Object possiblyBigRational) throws OverflowException {
        return MathUtilities.castTruncatingPrecisionToClosestSmallRational(possiblyBigRational, RoundingMode.DOWN);
    }

    @RationalOrInteger
    public static Object castTruncatingPrecisionToClosestSmallRational(@RationalOrInteger Object possiblyBigRational, RoundingMode roundingMode) throws OverflowException {
        if (possiblyBigRational instanceof BigInteger) {
            possiblyBigRational = MathUtilities.normalizeNumberToRationalOrInteger(possiblyBigRational);
        }
        if (possiblyBigRational instanceof BigInteger) {
            throw new OverflowException();
        }
        if (possiblyBigRational instanceof Rational) {
            Rational ir = (Rational)possiblyBigRational;
            if (ir.getNumerator() instanceof BigInteger || ir.getDenominator() instanceof BigInteger) {
                Object rv = MathUtilities.castTruncatingPrecisionToClosestRationalOfGivenDenominator(possiblyBigRational, Long.MAX_VALUE, roundingMode);
                if (rv instanceof BigInteger) {
                    throw new OverflowException();
                }
                if (rv instanceof Rational) {
                    Rational r = (Rational)rv;
                    if (r.getDenominator() instanceof BigInteger) {
                        throw new AssertionError();
                    }
                    if (r.getNumerator() instanceof BigInteger) {
                        throw new OverflowException();
                    }
                }
                return rv;
            }
            return ir;
        }
        return possiblyBigRational;
    }

    @PolyInteger
    public static Object getClosestIntegerNumberOfDenominationsToArbitraryRational(@RationalOrInteger Object possiblyBigRational, @RationalOrInteger Object denomination, RoundingMode roundingMode) {
        return MathUtilities.round(MathUtilities.divide(possiblyBigRational, denomination), roundingMode);
    }

    @RationalOrInteger
    public static Object castTruncatingPrecisionToClosestRational(@RationalOrInteger Object possiblyBigRational, @RationalOrInteger Object denomination, RoundingMode roundingMode) {
        return MathUtilities.multiply(denomination, MathUtilities.getClosestIntegerNumberOfDenominationsToArbitraryRational(possiblyBigRational, denomination, roundingMode));
    }

    @RationalOrInteger
    public static Object castTruncatingPrecisionToClosestRationalOfGivenDenominator(@RationalOrInteger Object possiblyBigRational, Object largestDenominator) {
        return MathUtilities.castTruncatingPrecisionToClosestRationalOfGivenDenominator(possiblyBigRational, largestDenominator, RoundingMode.DOWN);
    }

    @RationalOrInteger
    public static Object castTruncatingPrecisionToClosestRationalOfGivenDenominator(@RationalOrInteger Object possiblyBigRational, @PolyInteger Object largestDenominator, RoundingMode roundingMode) {
        Object[] r = MathUtilities.getRationalNumeratorAndDenominator(possiblyBigRational);
        Object possiblyBigRationalN = r[0];
        Object possiblyBigRationalD = r[1];
        return MathUtilities.rational(MathUtilities.roundingIntegerDivision(MathUtilities.multiply(possiblyBigRationalN, largestDenominator), possiblyBigRationalD, roundingMode), largestDenominator);
    }

    public static long roundingDivision(long numerator, long divisor, RoundingMode roundingMode) {
        if (roundingMode == RoundingMode.CEILING) {
            return SmallIntegerMathUtilities.ceilingDivision(numerator, divisor);
        }
        if (roundingMode == RoundingMode.FLOOR) {
            return SmallIntegerMathUtilities.floorDivision(numerator, divisor);
        }
        if (roundingMode == RoundingMode.UNNECESSARY) {
            return SmallIntegerMathUtilities.losslessDivision(numerator, divisor);
        }
        if (roundingMode == RoundingMode.UP) {
            return SmallIntegerMathUtilities.awayfromzeroDivision(numerator, divisor);
        }
        if (roundingMode == RoundingMode.DOWN) {
            return SmallIntegerMathUtilities.towardzeroDivision(numerator, divisor);
        }
        if (roundingMode == RoundingMode.HALF_UP) {
            return SmallIntegerMathUtilities.halfawayfromzeroDivision(numerator, divisor);
        }
        if (roundingMode == RoundingMode.HALF_DOWN) {
            return SmallIntegerMathUtilities.halftowardzeroDivision(numerator, divisor);
        }
        if (roundingMode == RoundingMode.HALF_EVEN) {
            return SmallIntegerMathUtilities.halfevenDivision(numerator, divisor);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)roundingMode);
    }

    @PolyInteger
    public static Object round(@RealNumeric Object x, RoundingMode roundingMode) {
        if ((x = MathUtilities.safeCastAnythingToRationalOrInteger(x)) instanceof Rational) {
            Object[] r = MathUtilities.getRationalNumeratorAndDenominator(x);
            Object n = r[0];
            Object d = r[1];
            return MathUtilities.roundingIntegerDivision(n, d, roundingMode);
        }
        return x;
    }

    @PolyInteger
    public static Object roundingIntegerDivision(@PolyInteger Object n, @PolyInteger Object d, RoundingMode roundingMode) throws DivisionByZeroException {
        if (MathUtilities.matheq(d, One)) {
            return n;
        }
        if (MathUtilities.matheq(n, Zero)) {
            return n;
        }
        if (MathUtilities.matheq(d, Zero)) {
            throw new DivisionByZeroException();
        }
        if (n instanceof Long && d instanceof Long) {
            return MathUtilities.roundingDivision((Long)n, (Long)d, roundingMode);
        }
        BigInteger nb = MathUtilities.toBigInteger(n);
        BigInteger db = MathUtilities.toBigInteger(d);
        return MathUtilities.normalizeNumberToRationalOrInteger(MathUtilities.roundingBigIntegerDivision(nb, db, roundingMode));
    }

    public static BigInteger roundingBigIntegerDivision(BigInteger n, BigInteger d, RoundingMode roundingMode) throws DivisionByZeroException {
        if (MathUtilities.matheq(d, Zero)) {
            throw new DivisionByZeroException();
        }
        if (roundingMode == RoundingMode.DOWN) {
            return n.divide(d);
        }
        if (roundingMode == RoundingMode.UP) {
            BigInteger[] qr = n.divideAndRemainder(d);
            BigInteger q = qr[0];
            BigInteger r = qr[1];
            if (r.equals(BigInteger.ZERO)) {
                return q;
            }
            int s = n.signum() * d.signum();
            if (s == 1) {
                return q.add(BigInteger.ONE);
            }
            if (s == -1) {
                return q.subtract(BigInteger.ONE);
            }
            throw new AssertionError();
        }
        throw new NotYetImplementedException("Rounding mode: " + (Object)((Object)roundingMode));
    }

    @MayNormalizePrimitives
    public static Object normalizeNumberToRationalOrInteger(Object a) {
        Objects.requireNonNull(a);
        if (a instanceof Long || a instanceof UnsignedLong) {
            return a;
        }
        if (a instanceof Integer || a instanceof Short || a instanceof Character || a instanceof Byte) {
            return ((Number)a).longValue();
        }
        if (a instanceof Rational) {
            if (MathUtilities.matheq(((Rational)a).getDenominator(), 1)) {
                return MathUtilities.normalizeNumberToRationalOrInteger(((Rational)a).getNumerator());
            }
            return a;
        }
        if (a instanceof BigInteger) {
            if (!MathUtilities.isOverflowsCastBigIntegerToS64((BigInteger)a)) {
                return ((BigInteger)a).longValue();
            }
            if (!MathUtilities.isOverflowsCastBigIntegerToU64((BigInteger)a)) {
                return UnsignedLong.valueOf((BigInteger)a);
            }
            return a;
        }
        if (a instanceof Float) {
            return MathUtilities.convertFloatToRationalOrInteger(((Float)a).floatValue());
        }
        if (a instanceof Double) {
            return MathUtilities.convertFloatToRationalOrInteger((Double)a);
        }
        throw new StructuredClassCastException(a.getClass());
    }

    @MayNormalizePrimitives
    public static Rational normalizeNumberToRational(Object a) {
        Object roi = MathUtilities.normalizeNumberToRationalOrInteger(a);
        return MathUtilities.isInteger(roi) ? new ImmutableRational(roi, 1L) : (Rational)roi;
    }

    public static double floatingApproximationDouble(Object a) {
        if (a instanceof Number) {
            return ((Number)a).doubleValue();
        }
        if (a instanceof Rational) {
            return ((Rational)a).toDoubleEstimate();
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(a);
    }

    public static float floatingApproximationSingle(Object a) {
        if (a instanceof Number) {
            return ((Number)a).floatValue();
        }
        if (a instanceof Rational) {
            return (float)((Rational)a).toDoubleEstimate();
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(a);
    }

    public static int signum(Object a) {
        Objects.requireNonNull(a);
        if (a instanceof Double) {
            double aa = SmallFloatMathUtilities.requireFinite((Double)a);
            if (aa < 0.0) {
                return -1;
            }
            if (aa > 0.0) {
                return 1;
            }
            if (aa == 0.0) {
                return 0;
            }
            throw new AssertionError();
        }
        if (a instanceof Float) {
            float aa = SmallFloatMathUtilities.requireFinite(((Float)a).floatValue());
            if (aa < 0.0f) {
                return -1;
            }
            if (aa > 0.0f) {
                return 1;
            }
            if (aa == 0.0f) {
                return 0;
            }
            throw new AssertionError();
        }
        if ((a = Primitives.normalizePrimitive(a)) instanceof Long) {
            return SmallIntegerMathUtilities.signum((Long)a);
        }
        if (a instanceof BigInteger) {
            return ((BigInteger)a).signum();
        }
        if (a instanceof BigDecimal) {
            return ((BigDecimal)a).signum();
        }
        if (a instanceof Rational) {
            assert (MathUtilities.signum(((Rational)a).getDenominator()) == 1);
            return MathUtilities.signum(((Rational)a).getNumerator());
        }
        throw new StructuredClassCastException(a.getClass());
    }

    public static boolean isNegative(Object x) {
        return MathUtilities.signum(x) < 0;
    }

    public static boolean isZero(Object x) {
        return MathUtilities.signum(x) == 0;
    }

    public static boolean isPositive(Object x) {
        return MathUtilities.signum(x) > 0;
    }

    public static int multiplicativeSignum(@RationalOrInteger Object x) {
        if (MathUtilities.mathcmp(x, Zero) <= 0) {
            throw new ArithmeticException();
        }
        return MathUtilities.signum(MathUtilities.subtract(x, One));
    }

    public static int mathhash(@Nonnull Object a) {
        Objects.requireNonNull(a);
        if (Primitives.isIntegerPrimitiveWrapperInstance(a)) {
            return MathUtilities.mathhashS64(((Number)a).longValue());
        }
        if (a instanceof UnsignedLong) {
            return MathUtilities.mathhashU64(((UnsignedLong)a).longValue());
        }
        if (MathUtilities.isInteger(a)) {
            try {
                long i = MathUtilities.safeCastAnythingToS64(a);
                return MathUtilities.mathhashS64(i);
            }
            catch (OverflowException i) {
            }
            catch (TruncationException i) {
                // empty catch block
            }
            if (a instanceof BigInteger) {
                BigInteger bi = (BigInteger)a;
                BigInteger i = bi.mod(BIGINT_ULONG_ABOVE_MAX_VAL);
                return MathUtilities.mathhashU64(i.longValueExact());
            }
            if (a instanceof Rational) {
                Object n = ((Rational)a).getNumerator();
                Object d = ((Rational)a).getNumerator();
                assert (MathUtilities.matheq(d, 1));
                return MathUtilities.mathhash(n);
            }
            throw new NotYetImplementedException("Numeric type: " + a.getClass());
        }
        if (a instanceof Rational) {
            Object n = ((Rational)a).getNumerator();
            Object d = ((Rational)a).getNumerator();
            if (MathUtilities.matheq(d, 1)) {
                return MathUtilities.mathhash(n);
            }
            int nHash = MathUtilities.mathhash(n);
            int dHash = MathUtilities.mathhash(d);
            return nHash ^ dHash;
        }
        throw new NotYetImplementedException("Numeric type: " + a.getClass());
    }

    public static int mathhashS64(long i) {
        if (i > Integer.MIN_VALUE && i < Integer.MAX_VALUE) {
            return (int)i;
        }
        return (int)i ^ (int)(i >> 32);
    }

    public static int mathhashU64(@ActuallyUnsigned long i) {
        if (i < Integer.MAX_VALUE) {
            return (int)i;
        }
        return (int)i ^ (int)(i >> 32);
    }

    public static boolean matheq(@Nonnull Object a, @Nonnull Object b) {
        return MathUtilities.mathcmp(a, b) == 0;
    }

    public static int mathcmp(@Nonnull Object a, @Nonnull Object b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        if (BasicObjectUtilities.eq(a, b)) {
            return 0;
        }
        boolean ani = MathUtilities.isNegativeInfinity(a);
        boolean bni = MathUtilities.isNegativeInfinity(b);
        boolean api = MathUtilities.isPositiveInfinity(a);
        boolean bpi = MathUtilities.isPositiveInfinity(b);
        if (ani) {
            return bni ? 0 : -1;
        }
        if (bni) {
            return 1;
        }
        if (api) {
            return bpi ? 0 : 1;
        }
        if (bpi) {
            return -1;
        }
        if (a instanceof Long && b instanceof Long) {
            return SmallIntegerMathUtilities.cmp((Long)a, (Long)b);
        }
        if (a instanceof UnsignedLong && b instanceof UnsignedLong) {
            return ((UnsignedLong)a).compareTo((UnsignedLong)b);
        }
        if (a instanceof Long && b instanceof UnsignedLong) {
            long av = (Long)a;
            long bv = ((UnsignedLong)b).longValue();
            return av < 0L ? -1 : (bv < 0L ? -1 : SmallIntegerMathUtilities.cmp(av, bv));
        }
        if (a instanceof UnsignedLong && b instanceof Long) {
            return -MathUtilities.mathcmp(b, a);
        }
        if (a instanceof BigInteger && b instanceof BigInteger) {
            return ((BigInteger)a).compareTo((BigInteger)b);
        }
        if (a instanceof BigInteger && b instanceof Long) {
            return ((BigInteger)a).compareTo(BigInteger.valueOf((Long)b));
        }
        if (a instanceof BigInteger && b instanceof UnsignedLong) {
            return ((BigInteger)a).compareTo(((UnsignedLong)b).bigIntegerValue());
        }
        if (a instanceof Long && b instanceof BigInteger) {
            return BigInteger.valueOf((Long)a).compareTo((BigInteger)b);
        }
        if (a instanceof UnsignedLong && b instanceof BigInteger) {
            return ((UnsignedLong)a).bigIntegerValue().compareTo((BigInteger)b);
        }
        if (a instanceof Comparable && a.getClass() == b.getClass()) {
            return ((Comparable)a).compareTo(b);
        }
        return MathUtilities.signum(MathUtilities.subtract(a, b));
    }

    public static boolean isInteger(Object x) {
        return x instanceof Long || x instanceof Integer || x instanceof Short || x instanceof Character || x instanceof Byte || x instanceof UnsignedLong || x instanceof BigInteger;
    }

    public static boolean isRationalOrInteger(Object x) {
        return MathUtilities.isInteger(x) || x instanceof Rational;
    }

    public static boolean isNonintegerRational(Object x) {
        return x instanceof Rational && !MathUtilities.matheq(((Rational)x).getDenominator(), 1);
    }

    public static boolean isRealNumber(Object x) {
        return x instanceof Number || x instanceof Rational;
    }

    public static boolean isPossiblyComplexNumber(Object x) {
        throw new NotYetImplementedException();
    }

    public static boolean isPurelyImaginaryNumber(Object x) {
        throw new NotYetImplementedException();
    }

    public static boolean isNonRealComplexNumber(Object x) {
        return MathUtilities.isPossiblyComplexNumber(x) || !MathUtilities.isRealNumber(x);
    }

    @Nonnull
    @PolyInteger
    public static Object requireInteger(@Nonnull Object x) {
        Objects.requireNonNull(x);
        if (!MathUtilities.isInteger(x)) {
            throw new IllegalArgumentException("Not an integer type: " + StringUtilities.repr(x));
        }
        return x;
    }

    @Nonnull
    @RationalOrInteger
    public static Object requireRationalOrInteger(@Nonnull Object x) {
        Objects.requireNonNull(x);
        if (!MathUtilities.isRationalOrInteger(x)) {
            throw new IllegalArgumentException("Not an integer or rational type: " + StringUtilities.repr(x));
        }
        return x;
    }

    @Nonnull
    @RealNumeric
    public static Object requireRealNumber(@Nonnull Object x) {
        Objects.requireNonNull(x);
        if (!MathUtilities.isRealNumber(x)) {
            throw new IllegalArgumentException("Not an integer or rational or float\u2014not a real-number type: " + StringUtilities.repr(x));
        }
        return x;
    }

    @MayNormalizePrimitives
    protected static Object internalRational(Object numerator, Object denominator) {
        numerator = MathUtilities.normalizeNumberToRationalOrInteger(numerator);
        denominator = MathUtilities.normalizeNumberToRationalOrInteger(denominator);
        if (!MathUtilities.isInteger(numerator)) {
            throw new IllegalArgumentException("Numerator not an integer!!: " + numerator);
        }
        if (!MathUtilities.isInteger(denominator)) {
            throw new IllegalArgumentException("Numerator not an integer!!: " + numerator);
        }
        if (MathUtilities.matheq(denominator, 1)) {
            return numerator;
        }
        return new ImmutableRational(numerator, denominator);
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object rational(@PolyInteger Object numerator, @PolyInteger Object denominator) {
        return MathUtilities.reduce(numerator, denominator);
    }

    public static Object[] getRationalNumeratorAndDenominator(@RationalOrInteger Object rationalOrInteger) {
        Object d;
        Object n;
        if (rationalOrInteger instanceof Rational) {
            Rational r = (Rational)rationalOrInteger;
            n = r.getNumerator();
            d = r.getDenominator();
        } else {
            n = rationalOrInteger;
            d = One;
        }
        return new Object[]{n, d};
    }

    public static long[] getRationalNumeratorAndDenominatorSmall(@RationalOrInteger Object rationalOrInteger) {
        long d;
        long n;
        if (rationalOrInteger instanceof Rational) {
            Rational r = (Rational)rationalOrInteger;
            Object nn = r.getNumerator();
            Object dd = r.getDenominator();
            if (dd instanceof BigInteger) {
                throw new TruncationException();
            }
            if (nn instanceof BigInteger) {
                throw new OverflowException();
            }
            n = (Long)nn;
            d = (Long)dd;
        } else {
            if (rationalOrInteger instanceof BigInteger) {
                throw new OverflowException();
            }
            n = (Long)rationalOrInteger;
            d = (Long)One;
        }
        return new long[]{n, d};
    }

    @MayNormalizePrimitives
    @RealNumeric
    public static Object negate(@RealNumeric Object a) {
        if ((a = MathUtilities.normalizeNumberToRationalOrInteger(a)) instanceof Long) {
            long l = (Long)a;
            if (l == Long.MIN_VALUE) {
                return BIGINT_LONG_ABOVE_MAX_VAL;
            }
            return -l;
        }
        if (a instanceof Rational) {
            Rational r = (Rational)a;
            return MathUtilities.rational(MathUtilities.negate(r.getNumerator()), r.getDenominator());
        }
        if (a instanceof BigInteger) {
            return ((BigInteger)a).negate();
        }
        if (a instanceof Double) {
            return -((Double)a).doubleValue();
        }
        if (a instanceof BigDecimal) {
            return ((BigDecimal)a).negate();
        }
        throw new StructuredClassCastException(a.getClass());
    }

    @MayNormalizePrimitives
    @RealNumeric
    public static Object absPoly(@RealNumeric Object x) {
        return MathUtilities.mathcmp(x, 0) < 0 ? MathUtilities.negate(x) : x;
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object reciprocate(@RationalOrInteger Object a) {
        if ((a = MathUtilities.normalizeNumberToRationalOrInteger(a)) instanceof Rational) {
            return MathUtilities.rational(((Rational)a).getDenominator(), ((Rational)a).getNumerator());
        }
        return MathUtilities.rational(1, a);
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object add(@RationalOrInteger Object a, @RationalOrInteger Object b) {
        BigInteger c;
        a = MathUtilities.normalizeNumberToRationalOrInteger(a);
        b = MathUtilities.normalizeNumberToRationalOrInteger(b);
        boolean aRat = a instanceof Rational;
        boolean bRat = b instanceof Rational;
        if (aRat || bRat) {
            Object aNum = aRat ? ((Rational)a).getNumerator() : a;
            Integer aDen = aRat ? ((Rational)a).getDenominator() : Integer.valueOf(1);
            Object bNum = bRat ? ((Rational)b).getNumerator() : b;
            Integer bDen = bRat ? ((Rational)b).getDenominator() : Integer.valueOf(1);
            return MathUtilities.reduce(MathUtilities.rational(MathUtilities.add(MathUtilities.multiply(aNum, bDen), MathUtilities.multiply(bNum, aDen)), MathUtilities.multiply(aDen, bDen)));
        }
        if (a instanceof Long && b instanceof Long && !SmallIntegerMathUtilities.isOverflow_add_s64((Long)a, (Long)b)) {
            long sa = (Long)a;
            long sb = (Long)b;
            long c2 = sa + sb;
            if (sa > 0L && sb > 0L && (c2 <= 0L || c2 <= sa || c2 <= sb)) {
                throw new AssertionError();
            }
            if (sa < 0L && sb < 0L && (c2 >= 0L || c2 >= sa || c2 >= sb)) {
                throw new AssertionError();
            }
            if (c2 - sa != sb) {
                throw new AssertionError();
            }
            if (c2 - sb != sa) {
                throw new AssertionError();
            }
            return c2;
        }
        if (a instanceof Long) {
            a = BigInteger.valueOf((Long)a);
        }
        if (b instanceof Long) {
            b = BigInteger.valueOf((Long)b);
        }
        return MathUtilities.isOverflowsCastBigIntegerToS64(c = ((BigInteger)a).add((BigInteger)b)) ? c : Long.valueOf(c.longValue());
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object add(@RationalOrInteger Object a, @RationalOrInteger Object b, @RationalOrInteger Object c) {
        return MathUtilities.add(MathUtilities.add(a, b), c);
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object add(@RationalOrInteger Object a, @RationalOrInteger Object b, @RationalOrInteger Object c, @RationalOrInteger Object d) {
        return MathUtilities.add(MathUtilities.add(MathUtilities.add(a, b), c), d);
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object multiply(@RationalOrInteger Object a, @RationalOrInteger Object b) {
        BigInteger c;
        a = MathUtilities.normalizeNumberToRationalOrInteger(a);
        b = MathUtilities.normalizeNumberToRationalOrInteger(b);
        boolean aRat = a instanceof Rational;
        boolean bRat = b instanceof Rational;
        if (aRat || bRat) {
            Object aNum = aRat ? ((Rational)a).getNumerator() : a;
            Integer aDen = aRat ? ((Rational)a).getDenominator() : Integer.valueOf(1);
            Object bNum = bRat ? ((Rational)b).getNumerator() : b;
            Integer bDen = bRat ? ((Rational)b).getDenominator() : Integer.valueOf(1);
            return MathUtilities.reduce(MathUtilities.rational(MathUtilities.multiply(aNum, bNum), MathUtilities.multiply(aDen, bDen)));
        }
        if (a instanceof Long && b instanceof Long && !SmallIntegerMathUtilities.isOverflow_mul_s64((Long)a, (Long)b)) {
            long sa = (Long)a;
            long sb = (Long)b;
            long c2 = (Long)a * (Long)b;
            if ((sa > 0L && sb > 0L || sa < 0L && sb < 0L) && c2 <= 0L) {
                throw new AssertionError();
            }
            if ((sa > 0L && sb < 0L || sa < 0L && sb > 0L) && c2 >= 0L) {
                throw new AssertionError();
            }
            if (c2 != 0L && c2 % sa != 0L) {
                throw new AssertionError();
            }
            if (c2 != 0L && c2 % sb != 0L) {
                throw new AssertionError();
            }
            if (c2 != 0L && c2 / sa != sb) {
                throw new AssertionError();
            }
            if (c2 != 0L && c2 / sb != sa) {
                throw new AssertionError();
            }
            return c2;
        }
        if (a instanceof Long) {
            a = BigInteger.valueOf((Long)a);
        }
        if (b instanceof Long) {
            b = BigInteger.valueOf((Long)b);
        }
        return MathUtilities.isOverflowsCastBigIntegerToS64(c = ((BigInteger)a).multiply((BigInteger)b)) ? c : Long.valueOf(c.longValue());
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object multiply(@RationalOrInteger Object a, @RationalOrInteger Object b, @RationalOrInteger Object c) {
        return MathUtilities.multiply(MathUtilities.multiply(a, b), c);
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object multiply(@RationalOrInteger Object a, @RationalOrInteger Object b, @RationalOrInteger Object c, @RationalOrInteger Object d) {
        return MathUtilities.multiply(MathUtilities.multiply(MathUtilities.multiply(a, b), c), d);
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object mul(@RationalOrInteger Object a, @RationalOrInteger Object b) {
        return MathUtilities.multiply(a, b);
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object mul(@RationalOrInteger Object a, @RationalOrInteger Object b, @RationalOrInteger Object c) {
        return MathUtilities.multiply(a, b, c);
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object mul(@RationalOrInteger Object a, @RationalOrInteger Object b, @RationalOrInteger Object c, @RationalOrInteger Object d) {
        return MathUtilities.multiply(a, b, c, d);
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object pow(@RationalOrInteger Object base, @RationalOrInteger Object exponent) {
        Object aDen;
        base = MathUtilities.normalizeNumberToRationalOrInteger(base);
        if (MathUtilities.isZero(exponent = MathUtilities.normalizeNumberToRationalOrInteger(exponent))) {
            if (MathUtilities.isZero(base)) {
                throw new ArithmeticException("0 to the power of 0!!  :O");
            }
            return 1L;
        }
        if (!MathUtilities.isInteger(exponent)) {
            throw new NotYetImplementedException("Fractional exponents!! (Ie, Roots!) \\o/");
        }
        boolean aRat = base instanceof Rational;
        Object aNum = aRat ? ((Rational)base).getNumerator() : base;
        Object object = aDen = aRat ? ((Rational)base).getDenominator() : One;
        if (MathUtilities.isNegative(exponent)) {
            exponent = MathUtilities.negate(exponent);
            Object s = aNum;
            aNum = aDen;
            aDen = s;
        }
        if (MathUtilities.matheq(aDen, 1)) {
            BigInteger baseBI;
            base = aNum;
            if (base instanceof Long) {
                baseBI = BigInteger.valueOf((Long)base);
            } else if (base instanceof BigInteger) {
                baseBI = (BigInteger)base;
            } else {
                throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(base);
            }
            int exponentS32 = MathUtilities.safeCastIntegerToS32(exponent);
            BigInteger power = baseBI.pow(exponentS32);
            return MathUtilities.isOverflowsCastBigIntegerToS64(power) ? power : Long.valueOf(power.longValueExact());
        }
        return MathUtilities.rational(MathUtilities.pow(aNum, exponent), MathUtilities.pow(aDen, exponent));
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object subtract(@RationalOrInteger Object minuend, @RationalOrInteger Object subtrahend) {
        return MathUtilities.add(minuend, MathUtilities.negate(subtrahend));
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object divide(@RationalOrInteger Object dividend, @RationalOrInteger Object divisor) {
        return MathUtilities.multiply(dividend, MathUtilities.reciprocate(divisor));
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object sub(@RationalOrInteger Object minuend, @RationalOrInteger Object subtrahend) {
        return MathUtilities.subtract(minuend, subtrahend);
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object div(@RationalOrInteger Object dividend, @RationalOrInteger Object divisor) {
        return MathUtilities.divide(dividend, divisor);
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object reduce(@RationalOrInteger Object a) {
        if ((a = MathUtilities.normalizeNumberToRationalOrInteger(a)) instanceof Rational) {
            Object n = ((Rational)a).getNumerator();
            Object d = ((Rational)a).getDenominator();
            return MathUtilities.reduce(n, d);
        }
        if (MathUtilities.isInteger(a)) {
            return a;
        }
        throw new StructuredClassCastException("Either it's an unsupported type of rational or integer, or it's neither a rational nor an integer!!", a.getClass());
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object reduce(@PolyInteger Object numerator, @PolyInteger Object denominator) {
        BigInteger dd;
        BigInteger nn;
        if (!MathUtilities.isInteger(numerator)) {
            throw new IllegalArgumentException();
        }
        if (!MathUtilities.isInteger(denominator)) {
            throw new IllegalArgumentException();
        }
        Object n = MathUtilities.normalizeNumberToRationalOrInteger(numerator);
        Object d = MathUtilities.normalizeNumberToRationalOrInteger(denominator);
        if (MathUtilities.matheq(d, Zero)) {
            throw new DivisionByZeroException();
        }
        if (n instanceof Long && d instanceof Long && !SmallIntegerMathUtilities.isOverflow_neg_s64((Long)n) && !SmallIntegerMathUtilities.isOverflow_neg_s64((Long)d)) {
            long gcd;
            long nn2 = (Long)n;
            long dd2 = (Long)d;
            boolean negative = nn2 < 0L ^ dd2 < 0L;
            if ((nn2 = Math.abs(nn2)) % (gcd = SmallIntegerMathUtilities.gcd_binary(nn2, dd2 = Math.abs(dd2))) != 0L) {
                throw new AssertionError();
            }
            if (dd2 % gcd != 0L) {
                throw new AssertionError();
            }
            nn2 /= gcd;
            dd2 /= gcd;
            if (negative) {
                nn2 = -nn2;
            }
            return MathUtilities.internalRational(nn2, dd2);
        }
        if (n instanceof Long) {
            nn = BigInteger.valueOf((Long)n);
        } else if (n instanceof BigInteger) {
            nn = (BigInteger)n;
        } else {
            throw new IllegalArgumentException("Numerator not an integer!!: (" + BasicObjectUtilities.getClassNT(n) + ")" + n);
        }
        if (d instanceof Long) {
            dd = BigInteger.valueOf((Long)d);
        } else if (d instanceof BigInteger) {
            dd = (BigInteger)d;
        } else {
            throw new IllegalArgumentException("Denominator not an integer!!: (" + BasicObjectUtilities.getClassNT(n) + ")" + d);
        }
        boolean negative = nn.compareTo(BigInteger.ZERO) < 1 ^ dd.compareTo(BigInteger.ZERO) < 1;
        nn = nn.abs();
        dd = dd.abs();
        BigInteger gcd = nn.gcd(dd);
        nn = nn.divide(gcd);
        dd = dd.divide(gcd);
        if (negative) {
            nn = nn.negate();
        }
        return MathUtilities.internalRational(nn, dd);
    }

    @MayNormalizePrimitives
    public static <I> Object sumMapping(Mapper<I, Object> mapper, Iterable<I> inputs) {
        Object result = Zero;
        for (I input : inputs) {
            Object output;
            try {
                output = mapper.f(input);
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            result = MathUtilities.add(result, output);
        }
        return result;
    }

    @MayNormalizePrimitives
    public static <I> Object productMapping(Mapper<I, Object> mapper, Iterable<I> inputs) {
        Object result = One;
        for (I input : inputs) {
            Object output;
            try {
                output = mapper.f(input);
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            result = MathUtilities.multiply(result, output);
        }
        return result;
    }

    @MayNormalizePrimitives
    public static <I> long sumMapping64(Mapper<I, Long> mapper, Iterable<I> inputs) {
        long result = 0L;
        for (I input : inputs) {
            long output;
            try {
                output = mapper.f(input);
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            result = Math.addExact(result, output);
        }
        return result;
    }

    @MayNormalizePrimitives
    public static <I> long productMapping64(Mapper<I, Long> mapper, Iterable<I> inputs) {
        long result = 1L;
        for (I input : inputs) {
            long output;
            try {
                output = mapper.f(input);
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            result = Math.multiplyExact(result, output);
        }
        return result;
    }

    @MayNormalizePrimitives
    public static <I> int sumMapping32(Mapper<I, Integer> mapper, Iterable<I> inputs) {
        return BitfieldSafeCasts.safeCastS64toS32(MathUtilities.sumMapping64(i -> MathUtilities.upcastNT((Integer)mapper.f(i)), inputs));
    }

    @MayNormalizePrimitives
    public static <I> int productMapping32(Mapper<I, Integer> mapper, Iterable<I> inputs) {
        return BitfieldSafeCasts.safeCastS64toS32(MathUtilities.productMapping64(i -> MathUtilities.upcastNT((Integer)mapper.f(i)), inputs));
    }

    public static Integer upcastNT(Byte b) {
        return b == null ? null : Integer.valueOf(b.byteValue());
    }

    public static Integer upcastNT(Short b) {
        return b == null ? null : Integer.valueOf(b.shortValue());
    }

    public static Long upcastNT(Integer b) {
        return b == null ? null : Long.valueOf(b.intValue());
    }

    public static double[] linearRegression_BundledSamplesLongs(Object input) {
        throw new NotYetImplementedException();
    }

    public static Object sumIntegers(Object a, Object b) {
        throw new NotYetImplementedException();
    }

    public static Object sumIntegersVariadic(Object collectionOfIntegers) {
        Object rv = 0;
        for (Object x : PolymorphicCollectionUtilities.anyToSingleUseIterable(collectionOfIntegers)) {
            rv = MathUtilities.sumIntegers(rv, x);
        }
        return rv;
    }

    public static Object rectDataSumIntegersCrossDimension(Object collectionOfCollectionsOfIntegers, int crossIndex) {
        Object rv = 0;
        for (Object row : PolymorphicCollectionUtilities.anyToSingleUseIterable(collectionOfCollectionsOfIntegers)) {
            Object v = PolymorphicCollectionUtilities.getuni(row, crossIndex);
            if (v == null) {
                throw new IndexOutOfBoundsException(String.valueOf(crossIndex));
            }
            rv = MathUtilities.sumIntegers(rv, v);
        }
        return rv;
    }

    public static Object rectDataSumIntegersFirstDimension(Object collectionOfCollectionsOfIntegers, int index) {
        return MathUtilities.sumIntegersVariadic(PolymorphicCollectionUtilities.getuni(collectionOfCollectionsOfIntegers, index));
    }

    public static long rectDataSumLongIntegersCrossDimension(Object collectionOfCollectionsOfIntegers, int crossIndex) {
        long rv = 0L;
        for (Object row : PolymorphicCollectionUtilities.anyToSingleUseIterable(collectionOfCollectionsOfIntegers)) {
            Object v = PolymorphicCollectionUtilities.getuni(row, crossIndex);
            if (v == null) {
                throw new IndexOutOfBoundsException(String.valueOf(crossIndex));
            }
            long smallv = MathUtilities.safeCastIntegerToS64(v);
            rv = SmallIntegerMathUtilities.safe_add_s64(rv, smallv);
        }
        return rv;
    }

    public static BigInteger getBigIntegerFromTwosComplementBinaryOctets(byte[] octets) {
        return new BigInteger(octets);
    }

    public static BigInteger getBigIntegerFromUnsignedBinaryOctets(byte[] octets) {
        return new BigInteger(ArrayUtilities.concat1WithArray((byte)0, octets));
    }

    public static boolean isInModularInterval(double x, double modularLow, double modularHigh, double modularBase) {
        x = SmallFloatMathUtilities.progmod(x, modularBase);
        if ((modularLow = SmallFloatMathUtilities.progmod(modularLow, modularBase)) > (modularHigh = SmallFloatMathUtilities.progmod(modularHigh, modularBase))) {
            return x >= modularLow || x < modularHigh;
        }
        return x >= modularLow && x < modularHigh;
    }

    public static Object parsePolyInteger(String text) throws NumberFormatException {
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException exc) {
            return new BigInteger(text);
        }
    }

    @Nonnull
    public static Number parseRationalOrInteger(@Nonnull String text) throws NumberFormatException {
        Object rational;
        Objects.requireNonNull(text);
        Long base = 10L;
        text = text.trim();
        text = StringUtilities.trim(text, '+');
        boolean negative = false;
        while (text.startsWith("-")) {
            negative = !negative;
            text = text.substring(1);
            text = text.trim();
            text = StringUtilities.trim(text, '+');
        }
        int slash = text.indexOf(47);
        if (slash != -1) {
            String num = text.substring(0, slash).trim();
            String den = text.substring(slash + 1).trim();
            rational = MathUtilities.reduce(MathUtilities.parsePolyInteger(num), MathUtilities.parsePolyInteger(den));
        } else {
            Object intpart;
            int e = text.indexOf(101);
            if (e == -1) {
                e = text.indexOf(69);
            }
            short exponent = 0;
            if (e != -1) {
                exponent = MathUtilities.safeCastIntegerToS16(MathUtilities.parsePolyInteger(text.substring(e + 1).trim()));
                text = text.substring(0, e).trim();
            }
            int d = text.indexOf(46);
            Object fractionalPart = null;
            if (d != -1) {
                String decpart = text.substring(d + 1).trim();
                int len = decpart.length();
                Object fracnum = MathUtilities.parsePolyInteger(decpart);
                Object fracden = MathUtilities.pow(base, len);
                fractionalPart = MathUtilities.rational(fracnum, fracden);
                text = text.substring(0, d).trim();
            }
            rational = intpart = text.isEmpty() ? Zero : MathUtilities.parsePolyInteger(text);
            if (fractionalPart != null) {
                rational = MathUtilities.add(rational, fractionalPart);
            }
            if (exponent != 0) {
                rational = MathUtilities.multiply(rational, MathUtilities.pow(base, exponent));
            }
        }
        if (negative) {
            rational = MathUtilities.negate(rational);
        }
        return (Number)MathUtilities.reduce(rational);
    }

    public static String formatRationalOrIntegerBase10NoExponentNotation(@RationalOrInteger Object number, int maximumDecimalPlaces) {
        if (MathUtilities.isInteger(number)) {
            return number.toString();
        }
        if (number instanceof Rational) {
            double f = MathUtilities.floatingApproximationDouble(number);
            if (!Double.isFinite(f)) {
                throw new NonfiniteException();
            }
            return new DecimalFormat("#." + StringUtilities.mulnn('#', maximumDecimalPlaces)).format(f);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(number);
    }

    public static Object parseRationalOrIntegerPassingNulls(String x) {
        return x == null ? (Number)null : (Number)MathUtilities.parseRationalOrInteger(x);
    }

    public static String formatRationalOrIntegerBase10NoExponentNotationPassingNulls(@RationalOrInteger Object number, int maximumDecimalPlaces) {
        return number == null ? null : MathUtilities.formatRationalOrIntegerBase10NoExponentNotation(number, maximumDecimalPlaces);
    }

    @Nonnegative
    public static int modularSubtraction(int minuend, int subtrahend, int modularBase) {
        int diff = minuend - subtrahend;
        if (diff >= 0) {
            return diff;
        }
        return modularBase + diff;
    }

    @Nonnegative
    public static int modularSubtractionLesser(int minuend, int subtrahend, int modularBase) {
        int diff = minuend - subtrahend;
        if (diff >= 0) {
            return MathUtilities.least(diff, modularBase - diff);
        }
        return MathUtilities.least(-diff, modularBase + diff);
    }

    public static ArithmeticIntegerInterval emptyInterval() {
        return EmptyInterval;
    }

    public static ArithmeticIntegerInterval singletonInterval(long v) {
        return MathUtilities.intervalByPointAndSize(v, 1L);
    }

    public static ArithmeticIntegerInterval intervalByPoints(long lowInclusive, long highExclusive) {
        return new ArithmeticIntegerInterval(lowInclusive, highExclusive - lowInclusive);
    }

    public static ArithmeticIntegerInterval intervalByPointAndSize(long lowInclusive, long size) {
        return new ArithmeticIntegerInterval(lowInclusive, size);
    }

    public static ArithmeticIntegerInterval intervalByPointsOrEmptyIfReversed(long lowInclusive, long highExclusive) {
        return MathUtilities.intervalByPointAndSizeOrEmptyIfReversed(lowInclusive, highExclusive - lowInclusive);
    }

    public static ArithmeticIntegerInterval intervalByPointAndSizeOrEmptyIfReversed(long lowInclusive, long size) {
        if (size < 0L) {
            return MathUtilities.emptyInterval();
        }
        return MathUtilities.intervalByPointAndSize(lowInclusive, size);
    }

    public static ArithmeticIntegerInterval intervalByIntervalExplicitBounds(ArithmeticIntegerInterval low, boolean lowInclusive, ArithmeticIntegerInterval high, boolean highInclusive) {
        long l = lowInclusive ? low.getStart() : low.getPastEnd();
        long h = highInclusive ? high.getPastEnd() : high.getStart();
        return MathUtilities.intervalByPointsOrEmptyIfReversed(l, h);
    }

    public static ArithmeticIntegerInterval intervalByExplicitBounds(long low, boolean lowInclusive, long high, boolean highInclusive) {
        long l = lowInclusive ? low : low + 1L;
        long h = highInclusive ? high + 1L : high;
        return MathUtilities.intervalByPointsOrEmptyIfReversed(l, h);
    }

    public static ArithmeticIntegerInterval intervalAdd(ArithmeticIntegerInterval a, ArithmeticIntegerInterval b) {
        long al = a.getStart();
        long ah = a.getPastEnd();
        long bl = b.getStart();
        long bh = b.getPastEnd();
        return MathUtilities.intervalByPoints(al + bl, ah + bh);
    }

    public static ArithmeticIntegerInterval intervalSubtract(ArithmeticIntegerInterval a, ArithmeticIntegerInterval b) {
        long al = a.getStart();
        long ah = a.getPastEnd();
        long bl = b.getStart();
        long bh = b.getPastEnd();
        return MathUtilities.intervalByPoints(al - bh, ah - bl);
    }

    public static ArithmeticIntegerInterval intervalNegate(ArithmeticIntegerInterval a) {
        long al = a.getStart();
        long ah = a.getPastEnd();
        return MathUtilities.intervalByPoints(-ah, -al);
    }

    public static ArithmeticIntegerInterval intervalMultiply(ArithmeticIntegerInterval a, ArithmeticIntegerInterval b) {
        long al = a.getStart();
        long ah = a.getPastEnd();
        long bl = b.getStart();
        long bh = b.getPastEnd();
        long c0 = al * bl;
        long c1 = ah * bl;
        long c2 = al * bh;
        long c3 = ah * bh;
        return MathUtilities.intervalByPoints(SmallIntegerMathUtilities.least(c0, c1, c2, c3), SmallIntegerMathUtilities.greatest(c0, c1, c2, c3));
    }

    public static ArithmeticIntegerInterval intervalDivide(ArithmeticIntegerInterval a, ArithmeticIntegerInterval b) {
        if (b.containsPoint(0L)) {
            throw new DivisionByZeroException();
        }
        long al = a.getStart();
        long ah = a.getPastEnd();
        long bl = b.getStart();
        long bh = b.getPastEnd();
        long c0 = al / bl;
        long c1 = ah / bl;
        long c2 = al / bh;
        long c3 = ah / bh;
        return MathUtilities.intervalByPoints(SmallIntegerMathUtilities.least(c0, c1, c2, c3), SmallIntegerMathUtilities.greatest(c0, c1, c2, c3));
    }

    public static ArithmeticIntegerInterval intervalUnion(ArithmeticIntegerInterval a, ArithmeticIntegerInterval b) {
        long h;
        long al = a.getStart();
        long ah = a.getPastEnd();
        long bl = b.getStart();
        long bh = b.getPastEnd();
        long l = MathUtilities.greatest(al, bl);
        if (l > (h = MathUtilities.least(ah, bh).longValue())) {
            throw new IllegalArgumentException("Tried to union disjoint intervals: " + a + " \u222a " + b);
        }
        l = MathUtilities.least(al, bl);
        h = MathUtilities.greatest(ah, bh);
        return MathUtilities.intervalByPoints(l, h);
    }

    public static ArithmeticIntegerInterval intervalBoundsUnion(ArithmeticIntegerInterval a, ArithmeticIntegerInterval b) {
        long al = a.getStart();
        long ah = a.getPastEnd();
        long bl = b.getStart();
        long bh = b.getPastEnd();
        long l = MathUtilities.least(al, bl);
        long h = MathUtilities.greatest(ah, bh);
        return MathUtilities.intervalByPoints(l, h);
    }

    public static ArithmeticIntegerInterval intervalIntersection(ArithmeticIntegerInterval a, ArithmeticIntegerInterval b) {
        long al = a.getStart();
        long ah = a.getPastEnd();
        long bl = b.getStart();
        long bh = b.getPastEnd();
        long l = MathUtilities.greatest(al, bl);
        long h = MathUtilities.least(ah, bh);
        return MathUtilities.intervalByPointsOrEmptyIfReversed(l, h);
    }

    public static long intervalMidpointFloor(ArithmeticIntegerInterval a) {
        long al = a.getStart();
        long ah = a.getPastEnd();
        return SmallIntegerMathUtilities.floorDivision(ah - al, 2L);
    }

    public static long intervalMidpointCeiling(ArithmeticIntegerInterval a) {
        long al = a.getStart();
        long ah = a.getPastEnd();
        return SmallIntegerMathUtilities.ceilingDivision(ah - al, 2L);
    }

    public static long intervalMidpointNearzero(ArithmeticIntegerInterval a) {
        long al = a.getStart();
        long ah = a.getPastEnd();
        return (ah - al) / 2L;
    }

    public static long intervalMidpointAwayzero(ArithmeticIntegerInterval a) {
        long al = a.getStart();
        long ah = a.getPastEnd();
        return SmallIntegerMathUtilities.awayfromzeroDivision(ah - al, 2L);
    }

    public static long intervalMidpointRounding(ArithmeticIntegerInterval a) {
        long al = a.getStart();
        long ah = a.getPastEnd();
        return SmallIntegerMathUtilities.roundingIntegerDivision(ah - al, 2L);
    }

    public static ArithmeticIntegerInterval intervalIntersectionOfSubset(ArithmeticIntegerInterval superCandidate, ArithmeticIntegerInterval subCandidate) {
        return MathUtilities.intervalIsSubsetOrEqual(superCandidate, subCandidate) ? subCandidate : null;
    }

    public static boolean intervalIsSubsetOrEqual(ArithmeticIntegerInterval superCandidate, ArithmeticIntegerInterval subCandidate) {
        ArithmeticIntegerInterval a = superCandidate;
        ArithmeticIntegerInterval b = subCandidate;
        long al = a.getStart();
        long ah = a.getPastEnd();
        long bl = b.getStart();
        long bh = b.getPastEnd();
        return al <= bl && ah >= bh;
    }

    public static boolean intervalIsSubsetNotEqual(ArithmeticIntegerInterval superCandidate, ArithmeticIntegerInterval subCandidate) {
        return MathUtilities.intervalIsSubsetOrEqual(superCandidate, subCandidate) && !BasicObjectUtilities.eq((Object)superCandidate, (Object)subCandidate);
    }

    public static ArithmeticIntegerInterval intervalIntersectionOfSubsetSymmetric(ArithmeticIntegerInterval a, ArithmeticIntegerInterval b) {
        ArithmeticIntegerInterval r = MathUtilities.intervalIntersectionOfSubset(a, b);
        return r != null ? r : MathUtilities.intervalIntersectionOfSubset(b, a);
    }

    @Nullable
    public static Integer binarySearchS32(FunctionInterfaces.UnaryFunctionIntToObject<Direction1D> predicate, int inclusiveLowBound, int exclusiveHighBound) {
        Long r = MathUtilities.binarySearchS64(i -> (Direction1D)((Object)((Object)predicate.f(BitfieldSafeCasts.safeCastS64toS32(i)))), inclusiveLowBound, exclusiveHighBound);
        return r == null ? null : Integer.valueOf(BitfieldSafeCasts.safeCastS64toS32(r));
    }

    @Nullable
    public static Long binarySearchS64(FunctionInterfaces.UnaryFunctionLongToObject<Direction1D> predicate, long inclusiveLowBound, long exclusiveHighBound) {
        Direction1D r;
        long m;
        if (exclusiveHighBound < inclusiveLowBound) {
            throw new IllegalArgumentException();
        }
        if (exclusiveHighBound == inclusiveLowBound) {
            return null;
        }
        long l = inclusiveLowBound;
        long h = exclusiveHighBound;
        while (true) {
            WidespreadTestingUtilities.asrt(l != h);
            m = (l + h) / 2L;
            WidespreadTestingUtilities.asrt(m != h);
            WidespreadTestingUtilities.asrt(h == l + 1L == (m == l));
            r = predicate.f(m);
            if (r == Direction1D.HigherUp) {
                if (h == l + 1L) {
                    WidespreadTestingUtilities.asrt(m == l);
                    return null;
                }
                l = m;
                continue;
            }
            if (r != Direction1D.LowerDown) break;
            if (h == l + 1L) {
                WidespreadTestingUtilities.asrt(m == l);
                return null;
            }
            h = m;
        }
        if (r == null) {
            throw new IllegalArgumentException();
        }
        WidespreadTestingUtilities.asrt(r == Direction1D.Zero);
        return m;
    }

    /*
     * Unable to fully structure code
     */
    public static void placeValueStandard(@ActuallyUnsigned long value, @ActuallyUnsigned long radix, FunctionInterfaces.UnaryProcedureLong digitOutputted) {
        if (radix >= 2L) ** GOTO lbl6
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            digit = Unsigned.modulusU64(value, radix);
            value = Unsigned.divideU64(value, radix);
            digitOutputted.f(digit);
lbl6:
            // 2 sources

            ** while (Unsigned.greaterThanU64((long)value, (long)0L))
        }
lbl7:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public static void placeValueBijective(@ActuallyUnsigned long value, @ActuallyUnsigned long radix, FunctionInterfaces.UnaryProcedureLong digitOutputted) {
        if (radix >= 2L) ** GOTO lbl6
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            digit = Unsigned.modulusU64(value - 1L, radix);
            value = Unsigned.divideU64(value - 1L, radix);
            digitOutputted.f(digit);
lbl6:
            // 2 sources

            ** while (Unsigned.greaterThanU64((long)value, (long)0L))
        }
lbl7:
        // 1 sources

    }

    public static <T> T requirePositivePoly(T number) {
        if (MathUtilities.mathcmp(number, 0L) <= 0) {
            throw new IllegalArgumentException("Was: " + number);
        }
        return number;
    }

    public static <T> T requireNegativePoly(T number) {
        if (MathUtilities.mathcmp(number, 0L) >= 0) {
            throw new IllegalArgumentException("Was: " + number);
        }
        return number;
    }

    public static <T> T requireZeroPoly(T number) {
        if (!MathUtilities.matheq(number, 0L)) {
            throw new IllegalArgumentException("Was: " + number);
        }
        return number;
    }

    public static <T> T requireNonNegativePoly(T number) {
        if (MathUtilities.mathcmp(number, 0L) < 0) {
            throw new IllegalArgumentException("Was: " + number);
        }
        return number;
    }

    public static <T> T requireNonPositivePoly(T number) {
        if (MathUtilities.mathcmp(number, 0L) > 0) {
            throw new IllegalArgumentException("Was: " + number);
        }
        return number;
    }

    public static <T> T requireNonZeroPoly(T number) {
        if (MathUtilities.matheq(number, 0L)) {
            throw new IllegalArgumentException("Was: " + number);
        }
        return number;
    }

    @MayNormalizePrimitives
    @RationalOrInteger
    public static Object sqrtROI(@RationalOrInteger Object value) throws OutOfDomainArithmeticException {
        if ((value = Primitives.normalizeIfIntegerPrimitive(value)) instanceof Rational) {
            Rational r = (Rational)value;
            return MathUtilities.rational(MathUtilities.sqrtROI(r.getNumerator()), MathUtilities.sqrtROI(r.getDenominator()));
        }
        if (value instanceof Long) {
            long v = (Long)value;
            if (v < 0L) {
                throw new OutOfDomainArithmeticException();
            }
            long r = SmallIntegerMathUtilities.floorSqrtS64(v);
            if (r * r == v) {
                return r;
            }
            return MathUtilities.convertFloatToRationalOrInteger(Math.sqrt(MathUtilities.floatingApproximationDouble(value)));
        }
        if (value instanceof BigInteger) {
            BigInteger v = (BigInteger)value;
            if (v.signum() < 0) {
                throw new OutOfDomainArithmeticException();
            }
            BigInteger r = MathUtilities.floorSqrtBigInt(v);
            if (r.multiply(r).equals(v)) {
                return r;
            }
            return MathUtilities.convertFloatToRationalOrInteger(Math.sqrt(MathUtilities.floatingApproximationDouble(value)));
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(value);
    }

    public static BigInteger floorSqrtBigInt(@ActuallyUnsigned BigInteger v) {
        throw new NotYetImplementedException();
    }

    public static BigInteger ceilSqrtBigInt(@ActuallyUnsigned BigInteger v) {
        throw new NotYetImplementedException();
    }

    public static interface CastableToIntegerTrait {
        public Object toInteger();

        public static interface CastableToSmallIntegerTrait
        extends CastableToIntegerTrait {
            public long toSmallInteger() throws OverflowException;
        }
    }

    public static enum DivisionType {
        LOSSLESS,
        LOSSY;

    }

    public static enum Infinity {
        Negative,
        Positive;

    }

    public static interface IntegerToBooleanFunction {
        public boolean evaluate(long var1);
    }

    public static interface LongInfiniteIterator {
        public long next();
    }

    public static enum RootingParity {
        MINIMIZE,
        MAXIMIZE;

    }
}

