/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui.edos;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rebound.hci.graphics2d.gui.awt.components.ImageFormatDropDown;
import rebound.hci.graphics2d.gui.awt.components.JFileChooserWrapper;
import rebound.hci.graphics2d.gui.awt.components.LatentFileBox;
import rebound.jagent.ui.gui.edos.EdosWindow;

public class ExportSetDialog
extends JFrame {
    protected EdosWindow callback;
    protected JPanel pane;
    protected ImageFormatDropDown formatBox;
    protected LatentFileBox directoryField;
    protected JTextField baseNameField;
    protected JLabel statusLabel;
    protected JButton submitButton;
    protected JButton cancelButton;
    protected Color infoStatusColor;
    protected Color errorStatusColor;

    public ExportSetDialog() {
        super("Export Set");
        this.setSize(300, 139);
        this.setContentPane(this.getPane());
        this.setDefaultCloseOperation(1);
        this.setResizable(true);
    }

    public JPanel getPane() {
        if (this.pane == null) {
            this.pane = new JPanel(){

                @Override
                public void doLayout() {
                    super.doLayout();
                    int width = this.getWidth();
                    int height = this.getHeight();
                    int emptySpace = height - 116;
                    int cancelWidth = width / 2;
                    int submitWidth = width - cancelWidth;
                    ExportSetDialog.this.getFormatBox().setLocation(0, 0);
                    ExportSetDialog.this.getFormatBox().setSize(width, 20);
                    ExportSetDialog.this.getDirectoryField().setLocation(0, 20);
                    ExportSetDialog.this.getDirectoryField().setSize(width, 28);
                    ExportSetDialog.this.getBaseNameField().setLocation(0, 48);
                    ExportSetDialog.this.getBaseNameField().setSize(width, 20);
                    ExportSetDialog.this.getSubmitButton().setLocation(0, 68);
                    ExportSetDialog.this.getSubmitButton().setSize(submitWidth, 28);
                    ExportSetDialog.this.getCancelButton().setLocation(submitWidth, 68);
                    ExportSetDialog.this.getCancelButton().setSize(cancelWidth, 28);
                    ExportSetDialog.this.getStatusLabel().setLocation(0, 96 + emptySpace);
                    ExportSetDialog.this.getStatusLabel().setSize(width, 20);
                }
            };
            this.pane.add(this.getFormatBox());
            this.pane.add(this.getDirectoryField());
            this.pane.add(this.getBaseNameField());
            this.pane.add(this.getSubmitButton());
            this.pane.add(this.getCancelButton());
            this.pane.add(this.getStatusLabel());
        }
        return this.pane;
    }

    public ImageFormatDropDown getFormatBox() {
        if (this.formatBox == null) {
            this.formatBox = new ImageFormatDropDown();
            this.formatBox.populateProviders(ImageFormatDropDown.Parity.WRITER);
        }
        return this.formatBox;
    }

    public LatentFileBox getDirectoryField() {
        if (this.directoryField == null) {
            JFileChooser jfc = new JFileChooser();
            jfc.setFileSelectionMode(1);
            JFileChooserWrapper wrapper = new JFileChooserWrapper(jfc);
            wrapper.setDisplayType(JFileChooserWrapper.JFileChooserDisplayType.CUSTOM);
            wrapper.setCustomApproveButtonText("Choose folder");
            this.directoryField = new LatentFileBox();
            this.directoryField.setDefaultText("Choose a containing folder.");
            this.directoryField.setFileChooser(wrapper);
        }
        return this.directoryField;
    }

    public JTextField getBaseNameField() {
        if (this.baseNameField == null) {
            this.baseNameField = new JTextField();
        }
        return this.baseNameField;
    }

    public JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setText("Pick a format, folder, and filename.");
            this.infoStatusColor = this.statusLabel.getForeground();
            this.errorStatusColor = Color.red.darker();
        }
        return this.statusLabel;
    }

    public JButton getSubmitButton() {
        if (this.submitButton == null) {
            this.submitButton = new JButton();
            this.submitButton.setText("Save Set");
            this.submitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportSetDialog.this.submitClicked();
                }
            });
        }
        return this.submitButton;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportSetDialog.this.cancelClicked();
                }
            });
        }
        return this.cancelButton;
    }

    public void setStatusText(String text) {
        this.getStatusLabel().setForeground(this.infoStatusColor);
        this.getStatusLabel().setText(text);
        this.getCallback().setStatusText(text);
    }

    public void setErrorText(String text) {
        this.getStatusLabel().setForeground(this.errorStatusColor);
        this.getStatusLabel().setText(text);
    }

    public void display() {
        this.getDirectoryField().setSelectedFile(null);
        this.getBaseNameField().setText("File name template");
        this.setVisible(true);
        this.getBaseNameField().requestFocusInWindow();
        this.getBaseNameField().selectAll();
    }

    public void cancelClicked() {
        this.setVisible(false);
    }

    public void submitClicked() {
        if (this.validateFields()) {
            this.doExport();
        }
    }

    public boolean validateFields() {
        ImageWriterSpi spi = this.getFormatBox().getSelectedWriterSpi();
        if (spi == null) {
            if (this.getFormatBox().getSelectedObjects().length == 0) {
                this.getFormatBox().populateProviders(ImageFormatDropDown.Parity.WRITER);
                if (this.getFormatBox().getSelectedObjects().length == 0) {
                    this.setErrorText("(ErrCode: XIW) Uh oh. There are no ImageWriters installed on your system.");
                    return false;
                }
                return false;
            }
            this.setErrorText("You need to choose an image format.");
            return false;
        }
        String basename = this.getBaseNameField().getText();
        if (basename.length() == 0) {
            this.setStatusText("The number will be the entire filename.");
        } else {
            boolean badExt = false;
            String[] exts = spi.getFileSuffixes();
            if (exts.length > 0) {
                badExt = true;
                String[] stringArray = exts;
                int n = exts.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    if (basename.toLowerCase().endsWith(ext.toLowerCase())) {
                        badExt = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (badExt) {
                this.setStatusText(String.valueOf(spi.getFileSuffixes()[0]) + " is a conventional filename suffix.");
            }
        }
        if (this.getDirectoryField().getSelectedFile() == null || !this.getDirectoryField().getSelectedFile().isDirectory()) {
            this.setErrorText("You must choose a folder to save files in.");
            return false;
        }
        return true;
    }

    public void doExport() {
        this.setVisible(false);
        this.getCallback().exportSetCallback(this.getDirectoryField().getSelectedFile(), this.getBaseNameField().getText(), 1, this.getFormatBox().getSelectedWriterSpi());
    }

    public EdosWindow getCallback() {
        return this.callback;
    }

    public void setCallback(EdosWindow callback) {
        this.callback = callback;
    }
}

