/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.c16;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import rebound.bits.Bytes;
import rebound.hci.graphics2d.ImageUtilities;
import rebound.io.iio.RandomAccessBytes;
import rebound.io.iio.sio.RandomAccessFileWrapper;
import rebound.jagent.lib.FormatMismatchException;
import rebound.jagent.lib.c16.DataMap;
import rebound.jagent.lib.c16.ToC16Notifee;
import rebound.util.collections.ArrayUtilities;

public class ToC16Converter {
    protected boolean transparencyEmulation = false;
    protected boolean bits565 = true;
    protected ToC16Notifee notifee;
    protected BufferedImage[] frames;
    protected byte[][] frameAlphaMaps;

    public void write(File path) throws IOException, FormatMismatchException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RandomAccessFileWrapper file = new RandomAccessFileWrapper(new RandomAccessFile(path, "rw"));){
            this.write(file);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void write(RandomAccessBytes file) throws IOException, FormatMismatchException {
        this.normalizeImages();
        if (this.notifee != null) {
            this.notifee.startC16Writing();
        }
        DataMap map = new DataMap();
        file.setLength(0L);
        this.calculateHeaderLen(map);
        file.seek(map.headersLength);
        this.writeImageDatii(file, map);
        file.seek(0L);
        this.writeHeaders(file, map);
    }

    protected void writeHeaders(RandomAccessBytes file, DataMap map) throws IOException, FormatMismatchException {
        if (this.frames.length >= 65536) {
            throw new FormatMismatchException("Too many frames (" + this.frames.length + ") to store in an S16 (max: 65535 or 32767)");
        }
        int flags = 2;
        if (this.bits565) {
            flags |= 1;
        }
        Bytes.putLittleInt(file, flags);
        Bytes.putLittleShort(file, (short)this.frames.length);
        int i = 0;
        while (i < this.frames.length) {
            this.writeFrameHeader(file, i, map);
            ++i;
        }
    }

    protected void writeFrameHeader(RandomAccessBytes file, int frameIndex, DataMap map) throws IOException, FormatMismatchException {
        int width = this.frames[frameIndex].getWidth();
        int height = this.frames[frameIndex].getHeight();
        if (width >= 65536) {
            throw new FormatMismatchException("Image is too wide (" + width + ") to store in a C16 (max: 65535 or 32767)");
        }
        if (height >= 65536) {
            throw new FormatMismatchException("Image is too tall (" + height + ") to store in a C16 (max: 65535 or 32767)");
        }
        Bytes.putLittleInt(file, map.offsets[frameIndex][0]);
        Bytes.putLittleShort(file, (short)width);
        Bytes.putLittleShort(file, (short)height);
        int row = 1;
        while (row < height) {
            Bytes.putLittleInt(file, map.offsets[frameIndex][row]);
            ++row;
        }
    }

    protected void calculateHeaderLen(DataMap map) {
        map.headersLength = 4;
        map.headersLength += 2;
        int i = 0;
        while (i < this.frames.length) {
            map.headersLength += 4;
            map.headersLength += 2;
            map.headersLength += 2;
            map.headersLength += 4 * (this.frames[i].getHeight() - 1);
            ++i;
        }
    }

    protected void writeImageDatii(RandomAccessBytes file, DataMap map) throws IOException, FormatMismatchException {
        map.offsets = new int[this.frames.length][];
        int i = 0;
        while (i < this.frames.length) {
            this.writeImageData(file, i, map);
            if (this.notifee != null) {
                this.notifee.finC16WritingFrame(i, this.frames.length);
            }
            ++i;
        }
        if (this.notifee != null) {
            this.notifee.finC16Writing();
        }
    }

    protected void writeImageData(RandomAccessBytes file, int frameIndex, DataMap map) throws IOException, FormatMismatchException {
        map.offsets[frameIndex] = new int[this.frames[frameIndex].getHeight()];
        int y = 0;
        while (y < this.frames[frameIndex].getHeight()) {
            this.writeRow(file, map, frameIndex, y);
            ++y;
        }
        Bytes.putLittleShort(file, (short)0);
    }

    protected void writeRow(RandomAccessBytes file, DataMap map, int frameIndex, int y) throws IOException, FormatMismatchException {
        map.offsets[frameIndex][y] = (int)file.getFilePointer();
        BufferedImage normalizedImage = this.frames[frameIndex];
        int width = normalizedImage.getWidth();
        int rowOffset = y * width;
        boolean transparent = false;
        int length = 0;
        short[] rawImageData = ((DataBufferUShort)normalizedImage.getRaster().getDataBuffer()).getData();
        byte[] alphaMap = this.frameAlphaMaps[frameIndex];
        if (width >= 32768) {
            throw new FormatMismatchException("Image is too wide (" + normalizedImage.getWidth() + "x" + normalizedImage.getHeight() + ") to store in a C16 (max: 32767x65535)");
        }
        int x = 0;
        while (x < width) {
            if (alphaMap == null) {
                if (this.isTransparencyEmulation()) {
                    transparent = rawImageData[rowOffset + x] == 0;
                    length = 1;
                    while (x + length < width && rawImageData[rowOffset + x + length] == 0 == transparent) {
                        ++length;
                    }
                } else {
                    transparent = false;
                    length = width;
                }
            } else {
                transparent = alphaMap[rowOffset + x] >= 0;
                length = 1;
                while (x + length < width && alphaMap[rowOffset + x + length] >= 0 == transparent) {
                    ++length;
                }
            }
            short runHeader = (short)(length << 1);
            if (!transparent) {
                runHeader = (short)(runHeader | 1);
            }
            Bytes.putLittleShort(file, runHeader);
            if (!transparent) {
                byte[] split = ArrayUtilities.splitElements16to8LE(rawImageData, rowOffset + x, length);
                file.write(split);
            }
            x += length;
        }
        Bytes.putLittleShort(file, (short)0);
    }

    protected boolean isImageOnRightMode(BufferedImage img) {
        return this.bits565 && img.getType() == 8 || !this.bits565 && img.getType() == 9;
    }

    protected void normalizeImages() {
        if (this.notifee != null) {
            this.notifee.startC16PreConverting();
        }
        BufferedImage[] converted = new BufferedImage[this.frames.length];
        this.frameAlphaMaps = new byte[this.frames.length][];
        ColorConvertOp converter = new ColorConvertOp(ColorSpace.getInstance(1000), null);
        BufferedImage dest = null;
        BufferedImage src = null;
        int i = 0;
        while (i < this.frames.length) {
            src = this.frames[i];
            this.frameAlphaMaps[i] = ImageUtilities.getAlpha(src);
            if (this.isImageOnRightMode(src) && src.getRaster().getDataBuffer().getOffset() == 0) {
                dest = src;
            } else {
                dest = new BufferedImage(src.getWidth(), src.getHeight(), this.isBits565() ? 8 : 9);
                converter.filter(src, dest);
            }
            converted[i] = dest;
            if (this.notifee != null) {
                this.notifee.finC16PreConvertingFrame(i, this.frames.length);
            }
            ++i;
        }
        this.frames = converted;
        if (this.notifee != null) {
            this.notifee.finC16PreConverting();
        }
    }

    public boolean isBits565() {
        return this.bits565;
    }

    public void setBits565(boolean bits565) {
        this.bits565 = bits565;
    }

    public void setFrames(BufferedImage[] frames) {
        this.frames = frames;
    }

    public boolean isTransparencyEmulation() {
        return this.transparencyEmulation;
    }

    public void setTransparencyEmulation(boolean transparencyEmulation) {
        this.transparencyEmulation = transparencyEmulation;
    }

    public ToC16Notifee getNotifee() {
        return this.notifee;
    }

    public void setNotifee(ToC16Notifee notifee) {
        this.notifee = notifee;
    }
}

