/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import rebound.annotations.semantic.reachability.LiveValue;
import rebound.annotations.semantic.reachability.SnapshotValue;
import rebound.exceptions.AlreadyExistsException;
import rebound.util.collections.CollectionUtilities;
import rebound.util.collections.CollectionWithGetArbitraryElement;
import rebound.util.collections.CollectionWithPopArbitraryElement;
import rebound.util.objectutil.Copyable;
import rebound.util.objectutil.ObjectUtilities;
import rebound.util.objectutil.PubliclyCloneable;
import rebound.util.objectutil.Trimmable;

public class SetifyingDecorator<E>
implements Set<E>,
PubliclyCloneable<SetifyingDecorator<E>>,
Copyable,
Trimmable,
CollectionWithGetArbitraryElement<E>,
CollectionWithPopArbitraryElement<E> {
    protected Collection<E> backing;

    public SetifyingDecorator() {
        this.backing = new ArrayList();
    }

    public SetifyingDecorator(@LiveValue Collection<E> backing) {
        this.backing = backing;
    }

    public static <E> SetifyingDecorator<E> newSafe(@LiveValue Collection<E> backing) {
        if (new HashSet<E>(backing).size() != backing.size()) {
            throw new AlreadyExistsException();
        }
        return new SetifyingDecorator<E>(backing);
    }

    public static <E> SetifyingDecorator<E> newUniqueifyingOP(@SnapshotValue Collection<E> backing) {
        ArrayList<E> newBacking = new ArrayList<E>(backing.size());
        for (E e : backing) {
            if (newBacking.contains(e)) continue;
            newBacking.add(e);
        }
        return new SetifyingDecorator(newBacking);
    }

    public Collection<E> getBacking() {
        return this.backing;
    }

    public void setBacking(Collection<E> backing) {
        this.backing = backing;
    }

    @Override
    public void setFrom(Object s) {
        SetifyingDecorator source = (SetifyingDecorator)s;
        this.setBacking(ObjectUtilities.attemptCloneWithReflection(source.getBacking()));
    }

    @Override
    public Trimmable.TrimmableTrimRV couldYouMaybeUseALittleLessMemoryIfYouDontMind() {
        return ObjectUtilities.trimThing(this.backing, false);
    }

    @Override
    public boolean add(E e) {
        boolean contains = this.contains(e);
        if (!contains) {
            this.backing.add(e);
        }
        return !contains;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean atLeastOne = false;
        for (E e : c) {
            atLeastOne |= this.add(e);
        }
        return atLeastOne;
    }

    @Override
    public boolean remove(Object o) {
        return this.backing.remove(o);
    }

    @Override
    public void clear() {
        this.backing.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.backing.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.backing.retainAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.backing.iterator();
    }

    @Override
    public E popArbitraryElement() {
        return CollectionUtilities.popArbitraryElementDefaulting(this.backing);
    }

    @Override
    public E getArbitraryElement() {
        return CollectionUtilities.getArbitraryElementDefaulting(this.backing);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.backing.containsAll(c);
    }

    @Override
    public boolean contains(Object o) {
        return this.backing.contains(o);
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.backing.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.backing.toArray(a);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SetifyingDecorator) {
            return this.backing.equals(((SetifyingDecorator)obj).backing);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.backing.hashCode();
    }

    public String toString() {
        return this.backing.toString();
    }

    @Override
    public SetifyingDecorator<E> clone() {
        return new SetifyingDecorator<E>(ObjectUtilities.attemptCloneWithReflection(this.backing));
    }
}

