/*
 * Decompiled with CFR 0.152.
 */
package rebound.util;

import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import rebound.annotations.purelyforhumans.DeprecatedInFavorOfMember;
import rebound.annotations.semantic.AccessedDynamicallyOrExternallyToJavaOrKnownToBeInImportantSerializedUse;
import rebound.annotations.semantic.temporal.NeverReturns;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.util.BasicExceptionUtilities;
import rebound.util.objectutil.JavaNamespace;

@AccessedDynamicallyOrExternallyToJavaOrKnownToBeInImportantSerializedUse
public class ExceptionUtilities
implements JavaNamespace {
    @NeverReturns
    @AccessedDynamicallyOrExternallyToJavaOrKnownToBeInImportantSerializedUse
    public static RuntimeException throwGeneralThrowableAttemptingUnverifiedThrow(Throwable target) {
        if (target instanceof RuntimeException) {
            throw (RuntimeException)target;
        }
        if (target instanceof Error) {
            throw (Error)target;
        }
        throw new WrappedThrowableRuntimeException(target);
    }

    public static void throwIfFatalError(Throwable t) {
        if (BasicExceptionUtilities.isFatalError(t)) {
            ExceptionUtilities.throwGeneralThrowableAttemptingUnverifiedThrow(t);
        }
    }

    public static void defaultThrowableHandling(Throwable t) {
        ExceptionUtilities.throwIfFatalError(t);
        t.printStackTrace();
    }

    public static WrappedThrowableRuntimeException rewrapToUnchecked(InvocationTargetException exc) {
        return new WrappedThrowableRuntimeException(exc.getCause());
    }

    @Deprecated
    @DeprecatedInFavorOfMember(cls=BasicExceptionUtilities.class, member="rethrowSafe")
    @NeverReturns
    @AccessedDynamicallyOrExternallyToJavaOrKnownToBeInImportantSerializedUse
    public static RuntimeException throwGeneralThrowableIfPossible(Throwable target) throws RuntimeException, Error {
        return BasicExceptionUtilities.rethrowSafe(target);
    }

    public static void tryCatchElseFinally(@Nullable Runnable tryBlock, @Nullable Runnable catchBlock, @Nullable Runnable elseBlock, @Nullable Runnable finallyBlock) {
        boolean success = false;
        try {
            if (tryBlock != null) {
                tryBlock.run();
            }
            success = true;
        }
        finally {
            if (!success) {
                if (catchBlock != null) {
                    catchBlock.run();
                }
            } else if (elseBlock != null) {
                elseBlock.run();
            }
            if (finallyBlock != null) {
                finallyBlock.run();
            }
        }
    }
}

