/*
 * Decompiled with CFR 0.152.
 */
package rebound.text.encodings.detection;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import javax.annotation.Nullable;
import rebound.exceptions.ImpossibleException;
import rebound.io.util.TextIOUtilities;
import rebound.util.functional.throwing.FunctionalInterfacesThrowingCheckedExceptionsStandard;

public interface TextEncodingDetector {
    @Nullable
    default public Charset detectEncoding(byte[] in) throws UnsupportedCharsetException {
        return this.detectEncoding(in, 0, in.length);
    }

    @Nullable
    default public Charset detectEncoding(byte[] in, int offset, int length) throws UnsupportedCharsetException {
        try {
            return this.detectEncoding(() -> new ByteArrayInputStream(in));
        }
        catch (IOException exc) {
            throw new ImpossibleException(exc);
        }
    }

    @Nullable
    public Charset detectEncoding(FunctionalInterfacesThrowingCheckedExceptionsStandard.NullaryFunctionThrowingIOException<InputStream> var1) throws IOException, UnsupportedCharsetException;

    default public int headSize() {
        return 1024;
    }

    default public String decodeToMemory(byte[] in, Charset defaultIfUndetectable) throws CharacterCodingException, UnsupportedCharsetException {
        try {
            return TextIOUtilities.readAllToString(this.decodeToStream(in, defaultIfUndetectable));
        }
        catch (IOException exc) {
            throw new ImpossibleException(exc);
        }
    }

    default public String decodeToMemory(FunctionalInterfacesThrowingCheckedExceptionsStandard.NullaryFunctionThrowingIOException<InputStream> opener, Charset defaultIfUndetectable) throws IOException, CharacterCodingException, UnsupportedCharsetException {
        return TextIOUtilities.readAllToString(this.decodeToStream(opener, defaultIfUndetectable));
    }

    default public Reader decodeToStream(byte[] in, Charset defaultIfUndetectable) throws CharacterCodingException, UnsupportedCharsetException {
        try {
            return this.decodeToStream(() -> new ByteArrayInputStream(in), defaultIfUndetectable);
        }
        catch (IOException exc) {
            throw new ImpossibleException(exc);
        }
    }

    default public Reader decodeToStream(FunctionalInterfacesThrowingCheckedExceptionsStandard.NullaryFunctionThrowingIOException<InputStream> opener, Charset defaultIfUndetectable) throws IOException, CharacterCodingException, UnsupportedCharsetException {
        Charset detected = this.detectEncoding(opener);
        InputStream in = opener.f();
        return new InputStreamReader(in, detected == null ? defaultIfUndetectable : detected);
    }

    default public String decodeToMemory(byte[] in) throws CharacterCodingException, UnsupportedCharsetException {
        return this.decodeToMemory(in, StandardCharsets.UTF_8);
    }

    default public String decodeToMemory(FunctionalInterfacesThrowingCheckedExceptionsStandard.NullaryFunctionThrowingIOException<InputStream> opener) throws IOException, CharacterCodingException, UnsupportedCharsetException {
        return this.decodeToMemory(opener, StandardCharsets.UTF_8);
    }

    default public Reader decodeToStream(byte[] in) throws CharacterCodingException, UnsupportedCharsetException {
        return this.decodeToStream(in, StandardCharsets.UTF_8);
    }

    default public Reader decodeToStream(FunctionalInterfacesThrowingCheckedExceptionsStandard.NullaryFunctionThrowingIOException<InputStream> opener) throws IOException, CharacterCodingException, UnsupportedCharsetException {
        return this.decodeToStream(opener, StandardCharsets.UTF_8);
    }
}

