/*
 * Decompiled with CFR 0.152.
 */
package rebound.text;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rebound.text.StringUtilities;
import rebound.util.collections.ArrayUtilities;
import rebound.util.functional.FunctionInterfaces;

public class CharacterPredicates {
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean DEFINED16_PATTERN = c -> Character.isDefined(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean SURROGATE_PATTERN = c -> Character.isSurrogate(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean NOT_SURROGATE_PATTERN = c -> !Character.isSurrogate(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean GENERALLY_PRINTABLE_CHARS = c -> c < ' ' ? c == '\t' || c == '\r' || c == '\n' : Character.isWhitespace(c) || Character.isDefined(c) && !Character.isSurrogate(c) && !Character.isISOControl(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean GENERALLY_PRINTABLE_NONNEWLINE_CHARS = c -> c != '\n' && c != '\r' && GENERALLY_PRINTABLE_CHARS.f(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean WHITESPACE_PATTERN = c -> Character.isWhitespace(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean NONNEWLINE_WHITESPACE_PATTERN = c -> Character.getType(c) != 13 && Character.isWhitespace(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean SPACE_PATTERN = c -> Character.isSpaceChar(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean DIGIT_PATTERN = c -> Character.isDigit(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean ASCII_DECIMAL_DIGIT_PATTERN = c -> c >= '0' && c <= '9';
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean ASCII_DECIMAL_DIGIT_AND_NUMERIC_PUNCTUATION_PATTERN = c -> c >= '0' && c <= '9' || c == '.' || c == '-' || c == '+';
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean ASCII_DECIMAL_DIGIT_AND_NUMERIC_PUNCTUATION_PATTERN_AND_BASIC_FLOATING_POINT_SCIENTIFIC_NOTATION_SYNTAX = c -> c >= '0' && c <= '9' || c == '.' || c == '-' || c == '+' || c == 'e' || c == 'E';
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean ASCII_HEXADECIMAL_DIGIT_PATTERN = c -> c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean ALPHABETIC_PATTERN = c -> Character.isAlphabetic(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean ISOCONTROL_PATTERN = c -> Character.isISOControl(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean IDEOGRAPHIC_PATTERN = c -> Character.isIdeographic(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean LETTER_PATTERN = c -> Character.isLetter(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean LOWERCASE_PATTERN = c -> Character.isLowerCase(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean UPPERCASE_PATTERN = c -> Character.isUpperCase(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean TITLECASE_PATTERN = c -> Character.isTitleCase(c);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean DEFINED16_PATTERN_INVERSE = new InverseCharacterPattern(DEFINED16_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean SURROGATE_PATTERN_INVERSE = new InverseCharacterPattern(SURROGATE_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean NOT_SURROGATE_PATTERN_INVERSE = new InverseCharacterPattern(NOT_SURROGATE_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean GENERALLY_PRINTABLE_CHARS_INVERSE = new InverseCharacterPattern(GENERALLY_PRINTABLE_CHARS);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean GENERALLY_PRINTABLE_NONNEWLINE_CHARS_INVERSE = new InverseCharacterPattern(GENERALLY_PRINTABLE_NONNEWLINE_CHARS);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean WHITESPACE_PATTERN_INVERSE = new InverseCharacterPattern(WHITESPACE_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean NONNEWLINE_WHITESPACE_PATTERN_INVERSE = new InverseCharacterPattern(NONNEWLINE_WHITESPACE_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean SPACE_PATTERN_INVERSE = new InverseCharacterPattern(SPACE_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean DIGIT_PATTERN_INVERSE = new InverseCharacterPattern(DIGIT_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean ASCII_DECIMAL_DIGIT_PATTERN_INVERSE = new InverseCharacterPattern(ASCII_DECIMAL_DIGIT_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean ASCII_DECIMAL_DIGIT_AND_NUMERIC_PUNCTUATION_PATTERN_INVERSE = new InverseCharacterPattern(ASCII_DECIMAL_DIGIT_AND_NUMERIC_PUNCTUATION_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean ASCII_DECIMAL_DIGIT_AND_NUMERIC_PUNCTUATION_PATTERN_AND_BASIC_FLOATING_POINT_SCIENTIFIC_NOTATION_SYNTAX_INVERSE = new InverseCharacterPattern(ASCII_DECIMAL_DIGIT_AND_NUMERIC_PUNCTUATION_PATTERN_AND_BASIC_FLOATING_POINT_SCIENTIFIC_NOTATION_SYNTAX);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean ASCII_HEXADECIMAL_DIGIT_PATTERN_INVERSE = new InverseCharacterPattern(ASCII_HEXADECIMAL_DIGIT_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean ALPHABETIC_PATTERN_INVERSE = new InverseCharacterPattern(ALPHABETIC_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean ISOCONTROL_PATTERN_INVERSE = new InverseCharacterPattern(ISOCONTROL_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean IDEOGRAPHIC_PATTERN_INVERSE = new InverseCharacterPattern(IDEOGRAPHIC_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean LETTER_PATTERN_INVERSE = new InverseCharacterPattern(LETTER_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean LOWERCASE_PATTERN_INVERSE = new InverseCharacterPattern(LOWERCASE_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean UPPERCASE_PATTERN_INVERSE = new InverseCharacterPattern(UPPERCASE_PATTERN);
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean TITLECASE_PATTERN_INVERSE = new InverseCharacterPattern(TITLECASE_PATTERN);
    public static final Predicate StringPattern_IsEmpty = input -> StringUtilities.getLength(input) == 0;
    public static final Predicate StringPattern_IsNotEmpty = input -> StringUtilities.getLength(input) != 0;
    public static final Predicate StringPattern_IsAllWhitespace = input -> StringUtilities.isUniform(input, WHITESPACE_PATTERN);
    public static final Predicate StringPattern_IsNotAllWhitespace = input -> !StringUtilities.isUniform(input, WHITESPACE_PATTERN);
    public static final Predicate StringPattern_IsAllNotwhitespace = input -> StringUtilities.isUniform(input, WHITESPACE_PATTERN_INVERSE);
    public static final Predicate StringPattern_IsNotAllNotwhitespace = input -> !StringUtilities.isUniform(input, WHITESPACE_PATTERN_INVERSE);

    public static NaiveCharacterSequencePattern newStaticNaiveCharacterSequencePattern(Object textthing) {
        char[] target = StringUtilities.textthingToPossiblyUnclonedCharArray(textthing);
        return (src, offset, length) -> {
            if (offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (length == -1) {
                length = src.length - offset;
            }
            if (length != target.length) {
                return -1;
            }
            if (ArrayUtilities.arrayMatches(src, offset, target, 0, target.length)) {
                return target.length;
            }
            return -1;
        };
    }

    public static NaiveCharacterSequencePattern newCaseInsensitiveStaticNaiveCharacterSequencePattern(Object textthing) {
        char[] target = StringUtilities.textthingToPossiblyUnclonedCharArray(textthing);
        return (src, offset, length) -> {
            if (offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (length == -1) {
                length = src.length - offset;
            }
            if (length != target.length) {
                return -1;
            }
            if (StringUtilities.arrayMatchesCaseInsensitive(src, offset, target, 0, target.length)) {
                return target.length;
            }
            return -1;
        };
    }

    public static NaiveCharacterSequencePattern newRegexNaiveCharacterSequencePattern(Object patternthing, int regexFlags) {
        Pattern pattern = patternthing instanceof Pattern ? (Pattern)patternthing : Pattern.compile(StringUtilities.textthingToString(patternthing));
        return (src, offset, length) -> {
            Matcher matcher;
            if (offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (length == -1) {
                length = src.length - offset;
            }
            if (!(matcher = pattern.matcher(new StringUtilities.TransparentArraySharingCharSequence(src, offset, length))).lookingAt()) {
                return -1;
            }
            return matcher.end();
        };
    }

    public static NaiveCharacterSequencePattern newRegexNaiveCharacterSequencePattern(Object compiledPatternOrPatternStringToCompile) {
        return CharacterPredicates.newRegexNaiveCharacterSequencePattern(compiledPatternOrPatternStringToCompile, 0);
    }

    public static NaiveCharacterSequencePattern newLengthClobberingNaiveCharacterSequencePattern(NaiveCharacterSequencePattern underlying, int valueToReturnOnSuccess) {
        return (src, offset, length) -> underlying.matches(src, offset, length) != -1 ? valueToReturnOnSuccess : -1;
    }

    public static NaiveCharacterSequencePattern newLengthClobberingNaiveCharacterSequencePattern(NaiveCharacterSequencePattern underlying) {
        return CharacterPredicates.newLengthClobberingNaiveCharacterSequencePattern(underlying, 0);
    }

    public static boolean regexMatchesAtStartButNotNecessarilyEnd(Object patternthing, CharSequence text) {
        Pattern p = patternthing instanceof Pattern ? (Pattern)patternthing : Pattern.compile(StringUtilities.textthingToString(patternthing));
        return p.matcher(text).lookingAt();
    }

    public static boolean isDigit(char c, int radix) {
        return Character.digit(c, radix) != -1;
    }

    public static boolean isAsciiLowercase(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isAsciiUppercase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isAsciiDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isAsciiAlpha(char c) {
        return CharacterPredicates.isAsciiLowercase(c) || CharacterPredicates.isAsciiUppercase(c);
    }

    public static boolean isAsciiAlphanum(char c) {
        return CharacterPredicates.isAsciiAlpha(c) || CharacterPredicates.isAsciiDigit(c);
    }

    public static class CaseInsensitiveCharacterPattern
    implements FunctionInterfaces.UnaryFunctionCharToBoolean {
        protected FunctionInterfaces.UnaryFunctionCharToBoolean pattern;

        public CaseInsensitiveCharacterPattern() {
        }

        public CaseInsensitiveCharacterPattern(FunctionInterfaces.UnaryFunctionCharToBoolean pattern) {
            this.pattern = pattern;
        }

        public FunctionInterfaces.UnaryFunctionCharToBoolean getCharacterPattern() {
            return this.pattern;
        }

        public void setCharacterPattern(FunctionInterfaces.UnaryFunctionCharToBoolean pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean f(char c) {
            return this.pattern.f(Character.toLowerCase(c)) || this.pattern.f(Character.toUpperCase(c));
        }
    }

    public static class InverseCharacterPattern
    implements FunctionInterfaces.UnaryFunctionCharToBoolean {
        protected FunctionInterfaces.UnaryFunctionCharToBoolean pattern;

        public InverseCharacterPattern() {
        }

        public InverseCharacterPattern(FunctionInterfaces.UnaryFunctionCharToBoolean pattern) {
            this.setPattern(pattern);
        }

        @Override
        public boolean f(char c) {
            return !this.pattern.f(c);
        }

        public FunctionInterfaces.UnaryFunctionCharToBoolean getPattern() {
            return this.pattern;
        }

        public void setPattern(FunctionInterfaces.UnaryFunctionCharToBoolean pattern) {
            this.pattern = pattern;
        }
    }

    @FunctionalInterface
    public static interface NaiveCharacterSequencePattern {
        public int matches(char[] var1, int var2, int var3);
    }
}

