/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.cli;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import rebound.apps.reboundcommonsbuilding.packaging.jar.annotations.PackageAsSimpleJar;
import rebound.bits.Endianness;
import rebound.file.FSUtilities;
import rebound.hci.graphics2d.ImageUtilities;
import rebound.jagent.lib.FormatMismatchException;
import rebound.jagent.lib.blk.FromBLKConverter;
import rebound.jagent.lib.c16.FromC16Converter;
import rebound.jagent.lib.s16.FromS16Converter;
import rebound.text.StringUtilities;
import rebound.util.cli.StandardArguments;

@PackageAsSimpleJar(value="edostool.jar")
public class EdosTool {
    public static final String HELP = "";
    public static final String INTERNAL_FORMAT_RAW_ARGB32_BE = "raw32-be";
    public static final String INTERNAL_FORMAT_RAW_ARGB32_LE = "raw32-le";
    public static final String INTERNAL_FORMAT_RAW_RGB16_565_BE = "raw16-565-be";
    public static final String INTERNAL_FORMAT_RAW_RGB16_565_LE = "raw16-565-le";
    public static final String INTERNAL_FORMAT_RAW_RGB16_555_BE = "raw16-555-be";
    public static final String INTERNAL_FORMAT_RAW_RGB16_555_LE = "raw16-555-le";
    protected String formatName = "raw32-be";
    protected String suffix = ".png";
    protected boolean verbose = false;

    public static void main(String[] args) throws IOException, FormatMismatchException {
        StandardArguments sargs = new StandardArguments();
        sargs.bake(args);
        EdosTool tool = new EdosTool();
        if (!sargs.getLongSuffices("type=").isEmpty()) {
            tool.formatName = sargs.getLongSuffices("type=").get(0);
        }
        if (!sargs.getLongSuffices("suffix=").isEmpty()) {
            tool.suffix = sargs.getLongSuffices("suffix=").get(0);
        }
        tool.verbose = sargs.isSwitchPresent('v');
        for (String t : sargs.getTargets()) {
            tool.processExtract(new File(t));
        }
    }

    public void processExtract(File f) throws IOException, FormatMismatchException {
        if ((f = f.getAbsoluteFile()).isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                this.processExtract(c);
                ++n2;
            }
        } else if (f.isFile()) {
            if (this.verbose) {
                System.out.println("Processing " + f.getParent());
            }
            try {
                String bnl = f.getName().toLowerCase();
                if (bnl.toLowerCase().endsWith(".c16")) {
                    this.processC16(f);
                } else if (bnl.toLowerCase().endsWith(".s16")) {
                    this.processS16(f);
                } else if (bnl.toLowerCase().endsWith(".blk")) {
                    this.processBLK(f);
                }
            }
            catch (Exception exc) {
                if (!this.verbose) {
                    System.err.println("Error on " + f.getPath());
                }
                exc.printStackTrace();
            }
        } else {
            System.out.println("Not a file or directory: " + f);
        }
    }

    public void processC16(File file) throws IOException, FormatMismatchException {
        FromC16Converter conv = new FromC16Converter();
        conv.read(file);
        String stem = StringUtilities.rsplit(file.getName(), '.', 1)[0];
        new File(file.getParentFile(), stem).mkdir();
        int i = 0;
        while (i < conv.getFrames().length) {
            File dest = new File(stem, String.valueOf(i) + this.suffix);
            this.writeImage(conv.getFrames()[i], dest);
            ++i;
        }
    }

    public void processS16(File file) throws IOException, FormatMismatchException {
        FromS16Converter conv = new FromS16Converter();
        conv.read(file);
        String stem = StringUtilities.rsplit(file.getName(), '.', 1)[0];
        new File(file.getParentFile(), stem).mkdir();
        int i = 0;
        while (i < conv.getFrames().length) {
            File dest = new File(stem, String.valueOf(i) + this.suffix);
            this.writeImage(conv.getFrames()[i], dest);
            ++i;
        }
    }

    public void processBLK(File file) throws IOException, FormatMismatchException {
        FromBLKConverter conv = new FromBLKConverter();
        conv.read(file);
        String stem = StringUtilities.rsplit(file.getName(), '.', 1)[0];
        File dest = new File(file.getParentFile(), String.valueOf(stem) + this.suffix);
        this.writeImage(conv.getBackground(), dest);
    }

    public void writeImage(BufferedImage image, File dest) throws IOException {
        if (this.verbose) {
            System.out.println("\t" + dest);
        }
        if (FSUtilities.lexists(dest)) {
            System.err.println("Destination file extsts: " + dest);
            return;
        }
        if (INTERNAL_FORMAT_RAW_ARGB32_BE.equals(this.formatName)) {
            this.writeFile(dest, ImageUtilities.extractRawImageData_ARGB32_bytes(image, Endianness.Big));
        } else if (INTERNAL_FORMAT_RAW_ARGB32_LE.equals(this.formatName)) {
            this.writeFile(dest, ImageUtilities.extractRawImageData_ARGB32_bytes(image, Endianness.Little));
        } else if (INTERNAL_FORMAT_RAW_RGB16_565_BE.equals(this.formatName)) {
            this.writeFile(dest, ImageUtilities.extractRawImageData_5X5_bytes(image, true, Endianness.Big));
        } else if (INTERNAL_FORMAT_RAW_RGB16_565_LE.equals(this.formatName)) {
            this.writeFile(dest, ImageUtilities.extractRawImageData_5X5_bytes(image, true, Endianness.Little));
        } else if (INTERNAL_FORMAT_RAW_RGB16_555_BE.equals(this.formatName)) {
            this.writeFile(dest, ImageUtilities.extractRawImageData_5X5_bytes(image, false, Endianness.Big));
        } else if (INTERNAL_FORMAT_RAW_RGB16_555_LE.equals(this.formatName)) {
            this.writeFile(dest, ImageUtilities.extractRawImageData_5X5_bytes(image, false, Endianness.Little));
        } else {
            boolean success = ImageIO.write((RenderedImage)image, this.formatName, dest);
            if (!success) {
                System.err.println("Unable to write format '" + this.formatName + "' : " + dest);
            }
        }
    }

    protected void writeFile(File file, byte[] data) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(data);
        }
    }
}

