/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.blk;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import rebound.bits.Bytes;
import rebound.bits.Unsigned;
import rebound.io.iio.RandomAccessBytes;
import rebound.io.iio.sio.RandomAccessFileWrapper;
import rebound.io.util.BasicIOUtilities;
import rebound.jagent.lib.FormatMismatchException;
import rebound.jagent.lib.blk.DataMap;
import rebound.jagent.lib.blk.FromBLKNotifee;
import rebound.util.collections.ArrayUtilities;

public class FromBLKConverter {
    protected static final int[] BITMASKS_565 = new int[]{63488, 2016, 31};
    protected static final int[] BITMASKS_555 = new int[]{31744, 992, 31};
    protected boolean bits565;
    protected BufferedImage background;
    protected FromBLKNotifee notifee;

    public void read(File path) throws IOException, FormatMismatchException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RandomAccessFileWrapper file = new RandomAccessFileWrapper(new RandomAccessFile(path, "r"));){
            this.read(file);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void read(RandomAccessBytes file) throws IOException, FormatMismatchException {
        DataMap map = new DataMap();
        if (this.notifee != null) {
            this.notifee.startBLKReading();
        }
        this.readHeaders(file, map);
        this.readImageData(file, map);
        if (this.notifee != null) {
            this.notifee.finBLKReading();
        }
    }

    protected void readHeaders(RandomAccessBytes file, DataMap map) throws IOException, FormatMismatchException {
        int flags = Bytes.getLittleInt(file);
        boolean bl = this.bits565 = (flags & 1) != 0;
        if ((flags & 2) != 0) {
            throw new FormatMismatchException("Attempting to read (what looks like) a C16 file, when expecting a BLK");
        }
        int width = Unsigned.upcast(Bytes.getLittleShort(file));
        int height = Unsigned.upcast(Bytes.getLittleShort(file));
        int count = Unsigned.upcast(Bytes.getLittleShort(file));
        if (count != width * height) {
            throw new FormatMismatchException("Invalid BLK header (count != width * height)");
        }
        map.offsets = new int[count];
        int i = 0;
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                this.readHeader(file, map, i);
                ++i;
                ++y;
            }
            ++x;
        }
        this.background = new BufferedImage(width * 128, height * 128, this.bits565 ? 8 : 9);
    }

    protected void readHeader(RandomAccessBytes file, DataMap map, int index) throws IOException, FormatMismatchException {
        int offset = Bytes.getLittleInt(file);
        int width = Unsigned.upcast(Bytes.getLittleShort(file));
        int height = Unsigned.upcast(Bytes.getLittleShort(file));
        if (width != 128) {
            throw new FormatMismatchException("Width of block " + index + " is not 128");
        }
        if (height != 128) {
            throw new FormatMismatchException("Height of block " + index + " is not 128");
        }
        map.offsets[index] = offset + 4;
    }

    protected void readImageData(RandomAccessBytes file, DataMap map) throws IOException {
        int i = 0;
        int x = 0;
        while (x < this.getWidthInBlocks()) {
            int y = 0;
            while (y < this.getHeightInBlocks()) {
                this.readBlock(file, map, i, x, y);
                if (this.notifee != null) {
                    this.notifee.finBLKReadingBlock(i);
                }
                ++i;
                ++y;
            }
            ++x;
        }
    }

    protected void readBlock(RandomAccessBytes file, DataMap map, int index, int blockx, int blocky) throws IOException {
        file.seek(map.offsets[index]);
        byte[] rawdata = new byte[32768];
        BasicIOUtilities.readFully(file, rawdata);
        short[] shortedData = ArrayUtilities.mergeElements8to16LE(rawdata, 0, rawdata.length);
        SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(1, 128, 128, this.bits565 ? BITMASKS_565 : BITMASKS_555);
        DataBufferUShort db = new DataBufferUShort(shortedData, shortedData.length);
        WritableRaster raster = Raster.createWritableRaster(sm, db, new Point(blockx * 128, blocky * 128));
        this.background.getRaster().setRect(raster);
    }

    public int getWidthInBlocks() {
        int w = this.background.getWidth();
        int bw = w / 128;
        if (w % 128 != 0) {
            ++bw;
        }
        return bw;
    }

    public int getHeightInBlocks() {
        int h = this.background.getHeight();
        int bh = h / 128;
        if (h % 128 != 0) {
            ++bh;
        }
        return bh;
    }

    public int getBlockCount() {
        return this.getWidthInBlocks() * this.getHeightInBlocks();
    }

    protected int getRealX(int xblock, int xInBlock) {
        return xblock * 128 + xInBlock;
    }

    protected int getRealY(int yblock, int yInBlock) {
        return yblock * 128 + yInBlock;
    }

    public FromBLKNotifee getNotifee() {
        return this.notifee;
    }

    public void setNotifee(FromBLKNotifee notifee) {
        this.notifee = notifee;
    }

    public boolean isBits565() {
        return this.bits565;
    }

    public BufferedImage getBackground() {
        return this.background;
    }
}

