/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import javax.annotation.concurrent.Immutable;
import rebound.annotations.hints.IntendedToBeSubclassedImplementedOrOverriddenByApiUser;

@Immutable
public class Interval<RuntimeType extends Interval<RuntimeType>> {
    protected final int offset;
    protected final int length;

    public Interval(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getPastEnd() {
        return this.offset + this.length;
    }

    public boolean isEmpty() {
        return this.getLength() == 0;
    }

    public boolean isIndexInUnderlyingInRange(int indexInUnderlying) {
        return (indexInUnderlying -= this.offset) >= 0 && indexInUnderlying < this.length;
    }

    public RuntimeType subslice(int offset, int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (offset + length > this.length) {
            throw new IndexOutOfBoundsException();
        }
        if (offset == 0 && length == this.getLength()) {
            return (RuntimeType)this;
        }
        return this.subslice0(offset, length);
    }

    @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
    protected RuntimeType subslice0(int offset, int length) {
        return (RuntimeType)new Interval<RuntimeType>(this.offset + offset, length);
    }

    public RuntimeType subsliceByExclusiveBound(int start, int end) {
        return this.subslice(start, end - start);
    }

    public RuntimeType subsliceToEnd(int offset) {
        return this.subslice(offset, this.length - offset);
    }

    public RuntimeType subsliceFromBeginning(int lengthOrExclusiveEndingBound) {
        return this.subslice(0, lengthOrExclusiveEndingBound);
    }
}

