/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.IdentityHashMap;
import rebound.io.StandardExternalizationFormats;
import rebound.util.collections.MapSet;
import rebound.util.collections.RuntimeReadabilityCollection;
import rebound.util.collections.RuntimeWriteabilityCollection;

public class IdentityHashSet<E>
extends MapSet<E, E>
implements RuntimeWriteabilityCollection,
RuntimeReadabilityCollection,
Externalizable {
    private static final long serialVersionUID = 1L;

    public IdentityHashSet() {
        super(new IdentityHashMap());
    }

    public IdentityHashSet(Iterable<E> initialContents) {
        super(new IdentityHashMap());
        this.addAll(initialContents);
    }

    public IdentityHashSet(int expectedMaxSize) {
        super(new IdentityHashMap(expectedMaxSize));
    }

    @Override
    public boolean isReadableCollection() {
        return true;
    }

    @Override
    public Boolean isWritableCollection() {
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 0) {
            throw new UnsupportedOperationException();
        }
        StandardExternalizationFormats.readExternalSet(this, in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(0);
        StandardExternalizationFormats.writeExternalSet(this, out);
    }
}

