/*
 * Decompiled with CFR 0.152.
 */
package rebound.text.parsing.apis.tokenstream;

import rebound.annotations.hints.IntendedToBeSubclassedImplementedOrOverriddenByApiUser;
import rebound.annotations.semantic.FunctionalityType;
import rebound.annotations.semantic.StaticTraitPredicate;
import rebound.annotations.semantic.TraitPredicate;
import rebound.text.StringUtilities;
import rebound.text.parsing.apis.tokenstream.SimpleTokenWithMemoryOfOriginalSource;
import rebound.text.parsing.apis.tokenstream.WherefulToken;

@FunctionalityType
public interface SimpleTokenWithLineAndColumnNumbers
extends WherefulToken {
    public static int getStartingLineNumberInSource1Based(Object token) {
        int n = -1;
        if (token instanceof SimpleTokenWithLineAndColumnNumbers) {
            n = ((SimpleTokenWithLineAndColumnNumbers)token).getStartingLineNumberInSource1Based();
        }
        if (n != -1) {
            return n;
        }
        if (token instanceof SimpleTokenWithMemoryOfOriginalSource) {
            int start = ((WherefulToken)token).getStartingCharacterIndexInSource();
            return StringUtilities.getLineNumber(start, ((SimpleTokenWithMemoryOfOriginalSource)token).getOriginalSource());
        }
        return -1;
    }

    public static int getStartingColumnNumberInSource1Based(Object token) {
        int n = -1;
        if (token instanceof SimpleTokenWithLineAndColumnNumbers) {
            n = ((SimpleTokenWithLineAndColumnNumbers)token).getStartingColumnNumberInSource1Based();
        }
        if (n != -1) {
            return n;
        }
        if (token instanceof SimpleTokenWithMemoryOfOriginalSource) {
            int start = ((WherefulToken)token).getStartingCharacterIndexInSource();
            return StringUtilities.getColumnNumber(start, ((SimpleTokenWithMemoryOfOriginalSource)token).getOriginalSource());
        }
        return -1;
    }

    @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
    default public int getStartingLineNumberInSource1Based() {
        return -1;
    }

    @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
    default public int getStartingColumnNumberInSource1Based() {
        return -1;
    }

    @TraitPredicate
    default public boolean isSimpleTokenWithLineAndColumnNumbers() {
        return true;
    }

    @StaticTraitPredicate
    public static boolean is(Object x) {
        return x instanceof SimpleTokenWithLineAndColumnNumbers && ((SimpleTokenWithLineAndColumnNumbers)x).isSimpleTokenWithLineAndColumnNumbers();
    }
}

