/*
 * Decompiled with CFR 0.152.
 */
package rebound.testing;

import rebound.GlobalCodeMetastuffContext;
import rebound.annotations.semantic.temporal.NeverReturns;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.objectutil.ObjectUtilities;

public class WidespreadTestingUtilities {
    public static void asrt(boolean condition) throws AssertionError {
        if (!condition) {
            throw new AssertionError();
        }
    }

    public static void asrt(boolean condition, String message) throws AssertionError {
        if (!condition) {
            throw new AssertionError((Object)message);
        }
    }

    public static void asrt(boolean condition, FunctionInterfaces.NullaryFunction<?> detailMessageClosure) throws AssertionError {
        if (!condition) {
            Object msg = detailMessageClosure.f();
            throw new AssertionError(msg);
        }
    }

    public static void softasrt(boolean condition) throws AssertionError {
        if (!condition) {
            GlobalCodeMetastuffContext.logBug();
        }
    }

    public static void softasrt(boolean condition, String message) throws AssertionError {
        if (!condition) {
            GlobalCodeMetastuffContext.logBug(message);
        }
    }

    public static void softasrt(boolean condition, FunctionInterfaces.NullaryFunction<?> detailMessageClosure) throws AssertionError {
        if (!condition) {
            Object msg = detailMessageClosure.f();
            GlobalCodeMetastuffContext.logBug(ObjectUtilities.toStringNT(msg));
        }
    }

    public static void casrt(boolean hard, boolean condition) throws AssertionError {
        if (hard) {
            WidespreadTestingUtilities.asrt(condition);
        } else {
            WidespreadTestingUtilities.softasrt(condition);
        }
    }

    public static void casrt(boolean hard, boolean condition, String message) throws AssertionError {
        if (hard) {
            WidespreadTestingUtilities.asrt(condition, message);
        } else {
            WidespreadTestingUtilities.softasrt(condition, message);
        }
    }

    public static void casrt(boolean hard, boolean condition, FunctionInterfaces.NullaryFunction<?> detailMessageClosure) throws AssertionError {
        if (hard) {
            WidespreadTestingUtilities.asrt(condition, detailMessageClosure);
        } else {
            WidespreadTestingUtilities.softasrt(condition, detailMessageClosure);
        }
    }

    @NeverReturns
    public static RuntimeException fail() throws AssertionError {
        throw new AssertionError();
    }

    @NeverReturns
    public static RuntimeException fail(String message) throws AssertionError {
        throw new AssertionError((Object)message);
    }
}

