/*
 * Decompiled with CFR 0.152.
 */
package rebound.math;

import rebound.annotations.semantic.SignalType;
import rebound.annotations.semantic.simpledata.Positive;
import rebound.exceptions.OverflowException;
import rebound.math.MathUtilities;
import rebound.math.PolyInteger;

@SignalType
public interface Rational<IntegerType>
extends Comparable {
    @PolyInteger
    public IntegerType getNumerator();

    @Positive
    @PolyInteger
    public IntegerType getDenominator();

    default public long getNumeratorS64() throws OverflowException {
        return MathUtilities.safeCastIntegerToS64(this.getNumerator());
    }

    default public long getDenominatorS64() throws OverflowException {
        return MathUtilities.safeCastIntegerToS64(this.getDenominator());
    }

    public double toDoubleEstimate();

    public String toFractionString();

    public String toPossiblyRepeatingDecimalString();

    default public int compareTo(Object o) {
        return MathUtilities.mathcmp(this, o);
    }
}

