/*
 * Decompiled with CFR 0.152.
 */
package rebound.io.ucs4;

import java.io.Closeable;
import java.io.IOException;
import java.nio.IntBuffer;

public interface UCS4Reader
extends Closeable {
    public long read() throws IOException;

    default public int read(int[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public int read(int[] var1, int var2, int var3) throws IOException;

    default public int read(IntBuffer target) throws IOException {
        if (target.hasArray()) {
            return this.read(target.array(), target.arrayOffset() + target.position(), target.remaining());
        }
        int len = target.remaining();
        int[] cbuf = new int[len];
        int n = this.read(cbuf, 0, len);
        if (n > 0) {
            target.put(cbuf, 0, n);
        }
        return n;
    }

    public long skip(long var1) throws IOException;

    default public boolean ready() throws IOException {
        return false;
    }

    default public boolean markSupported() {
        return false;
    }

    default public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported");
    }

    default public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public void close() throws IOException;
}

