/*
 * Decompiled with CFR 0.152.
 */
package rebound.io.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import rebound.io.HeadReopenableInputStream;
import rebound.io.ucs4.UCS4ArrayWriter;
import rebound.io.ucs4.UCS4Reader;
import rebound.io.ucs4.UCS4Writer;
import rebound.io.util.PureTextWritingBody;
import rebound.text.encodings.detection.TextEncodingDetector;
import rebound.text.encodings.detection.detectors.StandardTextEncodingDetection;
import rebound.util.objectutil.BasicObjectUtilities;

public class TextIOUtilities {
    public static String readAllText(InputStream in, String encoding) throws IOException {
        return TextIOUtilities.readAllText(in, Charset.forName(encoding));
    }

    public static String readAllText(InputStream in, Charset encoding) throws IOException {
        if (encoding == null) {
            encoding = Charset.defaultCharset();
        }
        CharsetDecoder decoder = encoding.newDecoder();
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        return new String(TextIOUtilities.readAll(new InputStreamReader(in, decoder)));
    }

    public static String readAllText(InputStream in, TextEncodingDetector encodingDetector) throws IOException {
        int headSize = encodingDetector.headSize();
        HeadReopenableInputStream headReopenable = new HeadReopenableInputStream(in, headSize);
        Charset encoding = encodingDetector.detectEncoding(headReopenable::openNewHeadStream);
        return TextIOUtilities.readAllText(headReopenable.stream(), encoding == null ? StandardCharsets.UTF_8 : encoding);
    }

    public static String readAllText(InputStream in) throws IOException {
        return TextIOUtilities.readAllText(in, StandardTextEncodingDetection.certain());
    }

    public static long pump(Reader in, Writer out) throws IOException {
        return TextIOUtilities.pump(in, out, 4096);
    }

    public static long pumpFixed(Reader in, Writer out, long length) throws IOException {
        return TextIOUtilities.pumpFixed(in, out, length, 4096);
    }

    public static long pump(Reader in, Writer out, int bufferSize) throws IOException {
        long total = 0L;
        char[] buffer = new char[bufferSize];
        int amt = in.read(buffer);
        while (amt >= 0) {
            total += (long)amt;
            out.write(buffer, 0, amt);
            amt = in.read(buffer);
        }
        return total;
    }

    public static long pumpFixed(Reader in, Writer out, long length, int bufferSize) throws IOException {
        if (length > 0L) {
            char[] buffer = new char[bufferSize];
            int amt = 0;
            long curr = 0L;
            while (curr < length) {
                amt = in.read(buffer, 0, Math.min(bufferSize, (int)(length - curr)));
                if (amt < 0) {
                    return curr;
                }
                curr += (long)amt;
                out.write(buffer, 0, amt);
            }
            return curr;
        }
        return 0L;
    }

    public static long pump(UCS4Reader in, UCS4Writer out) throws IOException {
        return TextIOUtilities.pump(in, out, 4096);
    }

    public static long pumpFixed(UCS4Reader in, UCS4Writer out, long length) throws IOException {
        return TextIOUtilities.pumpFixed(in, out, length, 4096);
    }

    public static long pump(UCS4Reader in, UCS4Writer out, int bufferSize) throws IOException {
        long total = 0L;
        int[] buffer = new int[bufferSize];
        int amt = in.read(buffer);
        while (amt >= 0) {
            total += (long)amt;
            out.write(buffer, 0, amt);
            amt = in.read(buffer);
        }
        return total;
    }

    public static long pumpFixed(UCS4Reader in, UCS4Writer out, long length, int bufferSize) throws IOException {
        if (length > 0L) {
            int[] buffer = new int[bufferSize];
            int amt = 0;
            long curr = 0L;
            while (curr < length) {
                amt = in.read(buffer, 0, Math.min(bufferSize, (int)(length - curr)));
                if (amt < 0) {
                    return curr;
                }
                curr += (long)amt;
                out.write(buffer, 0, amt);
            }
            return curr;
        }
        return 0L;
    }

    public static long discard(Reader in, long amount) throws IOException {
        long skipped = 0L;
        long c = 0L;
        while (skipped < amount) {
            c = in.skip(amount - skipped);
            if (c == -1L) {
                return skipped;
            }
            skipped += c;
        }
        return skipped;
    }

    public static long discard(Reader in) throws IOException {
        long skipped = 0L;
        long c = 0L;
        while ((c = in.skip(65536L)) != 0L) {
            skipped += c;
        }
        return skipped;
    }

    public static long discardByReading(Reader in, long amount) throws IOException {
        char[] dummyBuff = new char[1024];
        long skipped = 0L;
        long c = 0L;
        while (skipped < amount) {
            c = in.read(dummyBuff, 0, (int)Math.min((long)dummyBuff.length, amount - skipped));
            if (c == -1L) {
                return skipped;
            }
            skipped += c;
        }
        return skipped;
    }

    public static long discardByReading(Reader in) throws IOException {
        char[] dummyBuff = new char[1024];
        long skipped = 0L;
        long c = 0L;
        while ((c = (long)in.read(dummyBuff, 0, dummyBuff.length)) != -1L) {
            skipped += c;
        }
        return skipped;
    }

    public static void forceRead(Reader in, char[] buff, int offset, int len) throws EOFException, IOException {
        int read = 0;
        int r = 0;
        do {
            if ((r = in.read(buff, offset + read, len - read)) >= 0) continue;
            throw new EOFException("Premature EOF");
        } while ((read += r) < len);
    }

    public static void forceRead(Reader in, char[] buff) throws EOFException, IOException {
        TextIOUtilities.forceRead(in, buff, 0, buff.length);
    }

    public static char[] forceReadToNew(Reader in, int length) throws EOFException, IOException {
        char[] c = new char[length];
        TextIOUtilities.forceRead(in, c);
        return c;
    }

    public static int readAsMuchAsPossible(Reader in, char[] buff, int offset, int len) throws IOException {
        int read = 0;
        int r = 0;
        while ((r = in.read(buff, offset + read, len - read)) >= 0 && (read += r) < len) {
        }
        return read;
    }

    public static int readAsMuchAsPossible(Reader in, char[] buff) throws IOException {
        return TextIOUtilities.readAsMuchAsPossible(in, buff, 0, buff.length);
    }

    public static String readAllToString(Reader in) throws IOException {
        StringWriter buff = new StringWriter();
        TextIOUtilities.pump(in, buff);
        return buff.toString();
    }

    public static char[] readAll(Reader in) throws IOException {
        CharArrayWriter buff = new CharArrayWriter();
        TextIOUtilities.pump(in, buff);
        return buff.toCharArray();
    }

    public static int[] readAll(UCS4Reader in) throws IOException {
        UCS4ArrayWriter buff = new UCS4ArrayWriter();
        TextIOUtilities.pump(in, buff);
        return buff.toIntArray();
    }

    public static void tryClose(Reader s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void tryClose(Writer s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static char read1(Reader in) throws EOFException, IOException {
        int v = in.read();
        if (v == -1) {
            throw new EOFException();
        }
        return (char)v;
    }

    public static void closeWithoutError(Reader stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeWithoutError(Writer stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static BufferedReader ensureBufferedReader(Reader in) {
        return in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
    }

    public static BufferedWriter ensureBufferedWriter(Writer in) {
        return in instanceof BufferedWriter ? (BufferedWriter)in : new BufferedWriter(in);
    }

    public static void writeTextToBinaryProperly(OutputStream out, Charset encoding, PureTextWritingBody body) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(Objects.requireNonNull(out), encoding);
        if (BasicObjectUtilities.eq((Object)encoding, (Object)StandardCharsets.UTF_16)) {
            throw new IllegalArgumentException("You gotta say which endian it is, little or big!");
        }
        if (BasicObjectUtilities.eq((Object)encoding, (Object)StandardCharsets.UTF_16LE)) {
            out.write(255);
            out.write(254);
        } else if (BasicObjectUtilities.eq((Object)encoding, (Object)StandardCharsets.UTF_16BE)) {
            out.write(254);
            out.write(255);
        }
        body.run(w, encoding.name());
        ((Writer)w).flush();
    }
}

