/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.simplecomp;

import rebound.exceptions.UnexpectedHardcodedEnumValueException;
import rebound.exceptions.UnreachableCodeException;
import rebound.util.ExceptionUtilities;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.simplecomp.SimpleCachingState;
import rebound.util.simplecomp.SimpleComputation;
import rebound.util.simplecomp.SimpleComputationFactory;
import rebound.util.simplecomp.SimpleNullaryComputorFactory;

public class SimpleComputationUtilities {
    public static <Input, Output> FunctionInterfaces.NullaryFunction<Output> bindSimpleComputor(final FunctionInterfaces.UnaryFunction<Input, Output> computor, final Input input) {
        return new FunctionInterfaces.NullaryFunction<Output>(){

            @Override
            public Output f() {
                return computor.f(input);
            }
        };
    }

    public static <Input, Output> SimpleNullaryComputorFactory<Input, Output> makeIndirectionMaker(final FunctionInterfaces.UnaryFunction<Input, Output> computor) {
        return new SimpleNullaryComputorFactory<Input, Output>(){

            @Override
            public FunctionInterfaces.NullaryFunction<Output> newComputor(final Input input) {
                return new FunctionInterfaces.NullaryFunction<Output>(){

                    @Override
                    public Output f() throws RuntimeException {
                        return computor.f(input);
                    }
                };
            }
        };
    }

    public static <Input, Output> FunctionInterfaces.UnaryFunction<Input, Output> makeDeindirector(final SimpleNullaryComputorFactory<Input, Output> maker) {
        return new FunctionInterfaces.UnaryFunction<Input, Output>(){

            @Override
            public Output f(Input input) throws RuntimeException {
                return maker.newComputor(input).f();
            }
        };
    }

    public static <Input, Output> FunctionInterfaces.UnaryFunction<Input, Output> makeDeindirector(final SimpleComputationFactory<Input, Output> maker) {
        return new FunctionInterfaces.UnaryFunction<Input, Output>(){

            @Override
            public Output f(Input input) throws RuntimeException {
                return maker.newComputation(input).get();
            }
        };
    }

    public static <Output> SimpleComputation<Output> makeCacher(final FunctionInterfaces.NullaryFunction<Output> computor) {
        return new SimpleCacherImplThingy<Output>(){

            @Override
            protected Output uncachedCompute() throws RuntimeException {
                return computor.f();
            }
        };
    }

    public static <Input, Output> SimpleComputation<Output> makeCacher(final FunctionInterfaces.UnaryFunction<Input, Output> computor, final Input input) {
        return new SimpleCacherImplThingy<Output>(){

            @Override
            protected Output uncachedCompute() throws RuntimeException {
                return computor.f(input);
            }
        };
    }

    public static <Input, Output> SimpleComputationFactory<Input, Output> makeCacherMaker(final SimpleNullaryComputorFactory<Input, Output> maker) {
        return new SimpleComputationFactory<Input, Output>(){

            @Override
            public SimpleComputation<Output> newComputation(Input input) {
                return SimpleComputationUtilities.makeCacher(maker.newComputor(input));
            }
        };
    }

    public static <Input, Output> SimpleComputationFactory<Input, Output> makeCacherMaker(final FunctionInterfaces.UnaryFunction<Input, Output> computor) {
        return new SimpleComputationFactory<Input, Output>(){

            @Override
            public SimpleComputation<Output> newComputation(Input input) {
                return SimpleComputationUtilities.makeCacher(computor, input);
            }
        };
    }

    protected static abstract class SimpleCacherImplThingy<Output>
    implements SimpleComputation<Output> {
        protected SimpleCachingState isCaching;
        protected Object cache;

        protected SimpleCacherImplThingy() {
        }

        @Override
        public SimpleCachingState isCaching() {
            return this.isCaching;
        }

        @Override
        public Output get() throws RuntimeException {
            if (this.isCaching == null) {
                Output successfulResult = null;
                try {
                    successfulResult = this.uncachedCompute();
                }
                catch (Exception exc) {
                    this.isCaching = SimpleCachingState.ERROR;
                    this.cache = exc;
                    ExceptionUtilities.throwGeneralThrowableAttemptingUnverifiedThrow(exc);
                    throw new UnreachableCodeException();
                }
                this.isCaching = SimpleCachingState.SUCCESS;
                this.cache = successfulResult;
                return successfulResult;
            }
            if (this.isCaching == SimpleCachingState.SUCCESS) {
                return (Output)this.cache;
            }
            if (this.isCaching == SimpleCachingState.ERROR) {
                ExceptionUtilities.throwGeneralThrowableAttemptingUnverifiedThrow((Throwable)this.cache);
                throw new UnreachableCodeException();
            }
            throw new UnexpectedHardcodedEnumValueException((Object)this.isCaching);
        }

        @Override
        public boolean dropCache(SimpleCachingState onlyIf) {
            boolean applies;
            boolean bl = applies = onlyIf == null || this.isCaching == onlyIf;
            if (applies) {
                this.isCaching = null;
                this.cache = null;
                return true;
            }
            return false;
        }

        protected abstract Output uncachedCompute() throws RuntimeException;
    }
}

