/*
 * Decompiled with CFR 0.152.
 */
package rebound.text.lexing.apis.tokenstream.util;

import rebound.text.lexing.apis.tokenstream.util.AbstractWherefulToken;
import rebound.text.parsing.apis.tokenstream.SimpleTokenWithLineAndColumnNumbers;
import rebound.text.parsing.apis.tokenstream.WherefulToken;

public abstract class AbstractWherefulTokenForOnlyMasked
extends AbstractWherefulToken
implements WherefulToken,
SimpleTokenWithLineAndColumnNumbers {
    protected final int startingCharacterIndexInSource;
    protected final int startingLineNumberInSource1Based;
    protected final int startingColumnNumberInSource1Based;
    protected final String maskedSource;

    public AbstractWherefulTokenForOnlyMasked(int startingCharacterIndexInSource, String maskedSource) {
        this(startingCharacterIndexInSource, -1, -1, maskedSource);
    }

    public AbstractWherefulTokenForOnlyMasked(int startingCharacterIndexInSource, int startingLineNumberInSource1Based, int startingColumnNumberInSource1Based, String maskedSource) {
        if (startingCharacterIndexInSource < -1) {
            throw new IllegalArgumentException();
        }
        if (startingLineNumberInSource1Based < -1) {
            throw new IllegalArgumentException();
        }
        if (startingColumnNumberInSource1Based < -1) {
            throw new IllegalArgumentException();
        }
        if (startingLineNumberInSource1Based == 0) {
            throw new IllegalArgumentException();
        }
        if (startingColumnNumberInSource1Based == 0) {
            throw new IllegalArgumentException();
        }
        this.startingCharacterIndexInSource = startingCharacterIndexInSource;
        this.startingLineNumberInSource1Based = startingLineNumberInSource1Based;
        this.startingColumnNumberInSource1Based = startingColumnNumberInSource1Based;
        this.maskedSource = maskedSource;
    }

    @Override
    public boolean isSimpleTokenWithLineAndColumnNumbers() {
        return this.startingLineNumberInSource1Based != -1 && this.startingColumnNumberInSource1Based != -1;
    }

    @Override
    public int getStartingCharacterIndexInSource() {
        return this.startingCharacterIndexInSource;
    }

    @Override
    public int getStartingLineNumberInSource1Based() {
        return this.startingLineNumberInSource1Based;
    }

    @Override
    public int getStartingColumnNumberInSource1Based() {
        return this.startingColumnNumberInSource1Based;
    }

    @Override
    public int getLengthOfMaskedSource() {
        return this.maskedSource.length();
    }

    @Override
    public String getMaskedSource() {
        return this.maskedSource;
    }

    @Override
    public char getCharacterInMaskedSource(int index) {
        return this.maskedSource.charAt(index);
    }
}

