/*
 * Decompiled with CFR 0.152.
 */
package rebound.text;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Signed;
import rebound.GlobalCodeMetastuffContext;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.annotations.semantic.simpledata.ActuallyUnsigned;
import rebound.annotations.semantic.simpledata.Positive;
import rebound.applied.calendars.GregorianCalendarCode;
import rebound.bits.DataEncodingUtilities;
import rebound.bits.InvalidInputCharacterException;
import rebound.bits.Unsigned;
import rebound.dataformats.texttable.csv.impls.CSVImplementation_Rebound;
import rebound.dataformats.texttable.rcsv.RCSV;
import rebound.exceptions.NotYetImplementedException;
import rebound.exceptions.OverflowException;
import rebound.exceptions.TextSyntaxCheckedException;
import rebound.exceptions.TextSyntaxException;
import rebound.exceptions.UnsupportedOptionException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.math.ArithmeticIntegerInterval;
import rebound.math.MathUtilities;
import rebound.math.PolyInteger;
import rebound.math.Rational;
import rebound.math.RationalOrInteger;
import rebound.math.RealNumeric;
import rebound.math.SmallIntegerMathUtilities;
import rebound.text.CalendarUtilities;
import rebound.text.DatePatternAndIntervalSize;
import rebound.text.DatePatternCodeAndIntervalSize;
import rebound.text.SingletonWithUID;
import rebound.text.StringUtilities;
import rebound.util.NIOBufferUtilities;
import rebound.util.Primitives;
import rebound.util.collections.ArrayUtilities;
import rebound.util.collections.CollectionUtilities;
import rebound.util.collections.PairOrdered;
import rebound.util.collections.PairOrderedImmutable;
import rebound.util.collections.SimpleTable;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.JavaNamespace;
import rebound.util.uid.UID;
import rebound.util.uid.UIDUtilities;

public class FormattingUtilities
implements JavaNamespace {
    protected static final DecimalFormat STRAIGHT_INTEGER_FORMAT = new DecimalFormat("#");
    @ReadonlyValue
    protected static final SimpleDateFormat Timestamp_Format_RPStandard_toMillis_UTCShorthand = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'z'");
    @ReadonlyValue
    protected static final SimpleDateFormat Timestamp_Format_RPStandard_toSeconds_UTCShorthand = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss 'z'");
    @ReadonlyValue
    protected static final SimpleDateFormat Timestamp_Format_RPStandard_toMinutes_UTCShorthand = new SimpleDateFormat("yyyy-MM-dd HH:mm 'z'");
    @ReadonlyValue
    protected static final SimpleDateFormat Timestamp_Format_RPStandard_toHours_UTCShorthand = new SimpleDateFormat("yyyy-MM-dd HH 'z'");
    @ReadonlyValue
    protected static final SimpleDateFormat Timestamp_Format_RPStandard_toDayofmonth_UTCShorthand = new SimpleDateFormat("yyyy-MM-dd 'z'");
    @ReadonlyValue
    protected static final SimpleDateFormat Timestamp_Format_Pattern_RPStandard_toMillis_FullySpecifiedTimezone = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
    @ReadonlyValue
    protected static final SimpleDateFormat Timestamp_Format_Pattern_RPStandard_toSeconds_FullySpecifiedTimezone = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    @ReadonlyValue
    protected static final SimpleDateFormat Timestamp_Format_Pattern_RPStandard_toDayofmonth_FullySpecifiedTimezone = new SimpleDateFormat("yyyy-MM-dd Z");
    public static final Map<String, TimeZone> TimeZonesByOurAndJREIds = Collections.unmodifiableMap(CollectionUtilities.unionMaps(CollectionUtilities.mapof("z", CalendarUtilities.UTC, "Z", CalendarUtilities.UTC, "USET", CalendarUtilities.getTimeZoneFailingIfInvalid("US/Eastern"), "USCT", CalendarUtilities.getTimeZoneFailingIfInvalid("US/Central"), "USMT", CalendarUtilities.getTimeZoneFailingIfInvalid("US/Mountain"), "USPT", CalendarUtilities.getTimeZoneFailingIfInvalid("US/Pacific")), CollectionUtilities.maptodictSameKeys(TimeZone::getTimeZone, CollectionUtilities.asList(TimeZone.getAvailableIDs()))));
    @ReadonlyValue
    protected static final List<DatePatternAndIntervalSize> ParsingFormatsUTCShorthand = CollectionUtilities.mapToList(p -> p.parse(), FormattingUtilities.getAllStandardDateParsingPatterns(TimeZoneSpecifierType.UTCShorthand));
    @ReadonlyValue
    protected static final List<DatePatternAndIntervalSize> ParsingFormatsFullySpecifiedTimezone = CollectionUtilities.mapToList(p -> p.parse(), FormattingUtilities.getAllStandardDateParsingPatterns(TimeZoneSpecifierType.FullySpecified));
    protected static final DatePatternAndIntervalSize BasicISO8601FormatUTC = new DatePatternAndIntervalSize("yyyy-MM-dd'T'HH:mm:ss'Z'", 1000L);
    protected static final DatePatternAndIntervalSize MillisecondsISO8601FormatUTC = new DatePatternAndIntervalSize("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", 1L);
    public static final List<String> WesternMonthNames = Collections.unmodifiableList(CollectionUtilities.listof("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"));
    public static final List<String> WesternMonthNamesLC = Collections.unmodifiableList(CollectionUtilities.mapToList(String::toLowerCase, WesternMonthNames));
    public static final List<String> WesternMonthNamesFirst3 = Collections.unmodifiableList(CollectionUtilities.mapToList(n -> n.substring(0, 3), WesternMonthNames));
    public static final List<String> WesternMonthNamesFirst3LC = Collections.unmodifiableList(CollectionUtilities.mapToList(String::toLowerCase, WesternMonthNamesFirst3));

    public FormattingUtilities() {
        Timestamp_Format_RPStandard_toMillis_UTCShorthand.setTimeZone(CalendarUtilities.UTC);
        Timestamp_Format_RPStandard_toDayofmonth_UTCShorthand.setTimeZone(CalendarUtilities.UTC);
        for (DatePatternAndIntervalSize p : ParsingFormatsUTCShorthand) {
            p.getPattern().setTimeZone(CalendarUtilities.UTC);
        }
        BasicISO8601FormatUTC.getPattern().setTimeZone(CalendarUtilities.UTC);
        MillisecondsISO8601FormatUTC.getPattern().setTimeZone(CalendarUtilities.UTC);
    }

    public static String xmlEscape(String raw) {
        StringBuilder buff = new StringBuilder();
        String esc = null;
        char c = '\u0000';
        int i = 0;
        while (i < raw.length()) {
            c = raw.charAt(i);
            esc = FormattingUtilities.getXMLEntityReference(c);
            if (esc == null) {
                buff.append(c);
            } else {
                buff.append(esc);
            }
            ++i;
        }
        return buff.toString();
    }

    public static void xmlEscape(Reader r, Writer w) throws IOException {
        int s = 0;
        char c = '\u0000';
        String esc = null;
        while ((s = r.read()) != -1) {
            c = (char)s;
            esc = FormattingUtilities.getXMLEntityReference(c);
            if (esc == null) {
                w.write(c);
                continue;
            }
            w.write(esc);
        }
        return;
    }

    public static String getXMLEntityReference(char c) {
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
        }
        return null;
    }

    public static double getBinarySignificand(long raw) {
        if (raw < 0L) {
            return Unsigned.divideU64(raw, 0x1000000000000000L);
        }
        if (raw >= 0x1000000000000000L) {
            return (double)raw / 1.152921504606847E18;
        }
        if (raw >= 0x4000000000000L) {
            return (double)raw / 1.125899906842624E15;
        }
        if (raw >= 0x10000000000L) {
            return (double)raw / 1.099511627776E12;
        }
        if (raw >= 0x40000000L) {
            return (double)raw / 1.073741824E9;
        }
        if (raw >= 0x100000L) {
            return (double)raw / 1048576.0;
        }
        if (raw >= 1024L) {
            return (double)raw / 1024.0;
        }
        return raw;
    }

    public static long getBinaryMultiplier(long raw) {
        if (raw >= 0x1000000000000000L || raw < 0L) {
            return 0x1000000000000000L;
        }
        if (raw >= 0x4000000000000L) {
            return 0x4000000000000L;
        }
        if (raw >= 0x10000000000L) {
            return 0x10000000000L;
        }
        if (raw >= 0x40000000L) {
            return 0x40000000L;
        }
        if (raw >= 0x100000L) {
            return 0x100000L;
        }
        if (raw >= 1024L) {
            return 1024L;
        }
        return 1L;
    }

    public static double getSIMultiplier(double raw) {
        if (raw == 0.0) {
            return 1.0;
        }
        if (Math.abs(raw) >= 1.0E24) {
            return 1.0E24;
        }
        if (Math.abs(raw) >= 1.0E21) {
            return 1.0E21;
        }
        if (Math.abs(raw) >= 1.0E18) {
            return 1.0E18;
        }
        if (Math.abs(raw) >= 1.0E15) {
            return 1.0E15;
        }
        if (Math.abs(raw) >= 1.0E12) {
            return 1.0E12;
        }
        if (Math.abs(raw) >= 1.0E9) {
            return 1.0E9;
        }
        if (Math.abs(raw) >= 1000000.0) {
            return 1000000.0;
        }
        if (Math.abs(raw) >= 1000.0) {
            return 1000.0;
        }
        if (Math.abs(raw) < 1.0E-21) {
            return 1.0E-24;
        }
        if (Math.abs(raw) < 1.0E-18) {
            return 1.0E-21;
        }
        if (Math.abs(raw) < 1.0E-15) {
            return 1.0E-18;
        }
        if (Math.abs(raw) < 1.0E-12) {
            return 1.0E-15;
        }
        if (Math.abs(raw) < 1.0E-9) {
            return 1.0E-12;
        }
        if (Math.abs(raw) < 1.0E-6) {
            return 1.0E-9;
        }
        if (Math.abs(raw) < 0.001) {
            return 1.0E-6;
        }
        if (Math.abs(raw) < 1.0) {
            return 0.001;
        }
        return 1.0;
    }

    public static String getBinaryMultiplierString(long multiplier) throws IllegalArgumentException {
        if (multiplier == 0x1000000000000000L) {
            return "Ei";
        }
        if (multiplier == 0x4000000000000L) {
            return "Pi";
        }
        if (multiplier == 0x10000000000L) {
            return "Ti";
        }
        if (multiplier == 0x40000000L) {
            return "Gi";
        }
        if (multiplier == 0x100000L) {
            return "Mi";
        }
        if (multiplier == 1024L) {
            return "ki";
        }
        throw new IllegalArgumentException();
    }

    public static char getSIMultiplierCharacter(double multiplier) throws IllegalArgumentException {
        if (multiplier == 1.0E24) {
            return 'Y';
        }
        if (multiplier == 1.0E21) {
            return 'Z';
        }
        if (multiplier == 1.0E18) {
            return 'E';
        }
        if (multiplier == 1.0E15) {
            return 'P';
        }
        if (multiplier == 1.0E12) {
            return 'T';
        }
        if (multiplier == 1.0E9) {
            return 'G';
        }
        if (multiplier == 1000000.0) {
            return 'M';
        }
        if (multiplier == 1000.0) {
            return 'k';
        }
        if (multiplier == 1.0E-24) {
            return 'y';
        }
        if (multiplier == 1.0E-21) {
            return 'z';
        }
        if (multiplier == 1.0E-18) {
            return 'a';
        }
        if (multiplier == 1.0E-15) {
            return 'f';
        }
        if (multiplier == 1.0E-12) {
            return 'p';
        }
        if (multiplier == 1.0E-9) {
            return 'n';
        }
        if (multiplier == 1.0E-6) {
            return '\u03bc';
        }
        if (multiplier == 0.001) {
            return 'm';
        }
        throw new IllegalArgumentException();
    }

    public static char getSIMultiplierCharacterForExponent(int multiplierExponent) throws IllegalArgumentException {
        int e = multiplierExponent;
        if (e == 24) {
            return 'Y';
        }
        if (e == 21) {
            return 'Z';
        }
        if (e == 18) {
            return 'E';
        }
        if (e == 15) {
            return 'P';
        }
        if (e == 12) {
            return 'T';
        }
        if (e == 9) {
            return 'G';
        }
        if (e == 6) {
            return 'M';
        }
        if (e == 3) {
            return 'k';
        }
        if (e == -24) {
            return 'y';
        }
        if (e == -21) {
            return 'z';
        }
        if (e == -18) {
            return 'a';
        }
        if (e == -15) {
            return 'f';
        }
        if (e == -12) {
            return 'p';
        }
        if (e == -9) {
            return 'n';
        }
        if (e == -6) {
            return '\u03bc';
        }
        if (e == -3) {
            return 'm';
        }
        throw new IllegalArgumentException();
    }

    public static int getBase10ExponentForSIMultiplierCharacter(char c) throws IllegalArgumentException {
        if (c == 'Y') {
            return 24;
        }
        if (c == 'Z') {
            return 21;
        }
        if (c == 'E') {
            return 18;
        }
        if (c == 'P') {
            return 15;
        }
        if (c == 'T') {
            return 12;
        }
        if (c == 'G') {
            return 9;
        }
        if (c == 'M') {
            return 6;
        }
        if (c == 'k') {
            return 3;
        }
        if (c == 'y') {
            return -24;
        }
        if (c == 'z') {
            return -21;
        }
        if (c == 'a') {
            return -18;
        }
        if (c == 'f') {
            return -15;
        }
        if (c == 'p') {
            return -12;
        }
        if (c == 'n') {
            return -9;
        }
        if (c == '\u03bc') {
            return -6;
        }
        if (c == 'u') {
            return -6;
        }
        if (c == 'm') {
            return -3;
        }
        throw new IllegalArgumentException();
    }

    public static String formatBinaryPrefixedValue(long raw, int sigfigs) {
        long multiplier = FormattingUtilities.getBinaryMultiplier(raw);
        if (multiplier == 1L) {
            return String.valueOf(String.valueOf(raw)) + ' ';
        }
        double significand = FormattingUtilities.getBinarySignificand(raw);
        String mulchar = FormattingUtilities.getBinaryMultiplierString(multiplier);
        return String.valueOf(FormattingUtilities.formatDecimal(significand, sigfigs)) + ' ' + mulchar;
    }

    public static String formatSIPrefixedValue(double raw, int sigfigs) {
        double multiplier = FormattingUtilities.getSIMultiplier(raw);
        if (multiplier == 1.0) {
            return String.valueOf(FormattingUtilities.formatDecimal(raw, sigfigs)) + ' ';
        }
        double significand = raw / multiplier;
        char mulchar = FormattingUtilities.getSIMultiplierCharacter(multiplier);
        return String.valueOf(FormattingUtilities.formatDecimal(significand, sigfigs)) + ' ' + mulchar;
    }

    public static String formatSIPrefixedValue(double raw) {
        double multiplier = FormattingUtilities.getSIMultiplier(raw);
        if (multiplier == 1.0) {
            return String.valueOf(String.valueOf(raw)) + ' ';
        }
        double significand = raw / multiplier;
        char mulchar = FormattingUtilities.getSIMultiplierCharacter(multiplier);
        return String.valueOf(String.valueOf(significand)) + ' ' + mulchar;
    }

    public static String fixdec(double value, int numberOfDigitsAfterDecimalPoint) {
        return FormattingUtilities.formatFixedPointDecimalBase10Rounding(value, numberOfDigitsAfterDecimalPoint);
    }

    public static String formatDecimal(double value, int sigfigs) {
        if (sigfigs < 1) {
            throw new IllegalArgumentException("sigfigs cannot be < 1: " + sigfigs);
        }
        if (value == 0.0) {
            if (sigfigs == 1) {
                return "0.";
            }
            StringBuilder buff = new StringBuilder("0.");
            int i = 0;
            while (i < sigfigs - 1) {
                buff.append('0');
                ++i;
            }
            return buff.toString();
        }
        boolean negative = value < 0.0;
        value = Math.abs(value);
        int log = (int)Math.floor(Math.log10(value));
        double normalizedValue = value * Math.pow(10.0, sigfigs - 1 - log);
        normalizedValue = Math.floor(normalizedValue + 0.5);
        String digits = STRAIGHT_INTEGER_FORMAT.format(normalizedValue);
        StringBuilder buff = new StringBuilder();
        if (negative) {
            buff.append('-');
        }
        if (log > sigfigs - 1) {
            buff.append(digits);
            int i = 0;
            while (i < log - (sigfigs - 1)) {
                buff.append('0');
                ++i;
            }
        } else if (log == sigfigs - 1) {
            buff.append(digits);
            if (digits.endsWith("0")) {
                buff.append('.');
            }
        } else if (log >= 0) {
            buff.append(digits.substring(0, log + 1));
            buff.append('.');
            buff.append(digits.substring(log + 1));
        } else {
            buff.append("0.");
            int i = 0;
            while (i < -log - 1) {
                buff.append('0');
                ++i;
            }
            buff.append(digits);
        }
        return buff.toString();
    }

    public static String formatFixedPointDecimal(@Signed long value, @Nonnegative int numberOfDigitsAfterDecimalPoint, @Positive int radix, boolean includePlusSignIfPositive) {
        if (numberOfDigitsAfterDecimalPoint == 0) {
            StringBuilder b = new StringBuilder();
            if (value < 0L) {
                b.append("-");
            } else if (includePlusSignIfPositive) {
                b.append("+");
            }
            b.append(Long.toString(value, radix));
            b.append('.');
            return b.toString();
        }
        if (numberOfDigitsAfterDecimalPoint < 0) {
            throw new IllegalArgumentException();
        }
        if (radix <= 0) {
            throw new IllegalArgumentException();
        }
        long divisor = SmallIntegerMathUtilities.pow((long)radix, (long)numberOfDigitsAfterDecimalPoint);
        long integerPart = value / divisor;
        long fractionPart = Math.abs(value % divisor);
        StringBuilder b = new StringBuilder();
        if (value < 0L) {
            b.append("-");
        } else if (includePlusSignIfPositive) {
            b.append("+");
        }
        b.append(Long.toString(integerPart, radix));
        b.append('.');
        String fractionalPartString = Long.toString(fractionPart, radix);
        int numZerosPadding = numberOfDigitsAfterDecimalPoint - fractionalPartString.length();
        int i = 0;
        while (i < numZerosPadding) {
            b.append('0');
            ++i;
        }
        b.append(fractionalPartString);
        return b.toString();
    }

    public static String formatFixedPointDecimalBase10(@Signed long value, @Nonnegative int numberOfDigitsAfterDecimalPoint, boolean includePlusSignIfPositive) {
        return FormattingUtilities.formatFixedPointDecimal(value, numberOfDigitsAfterDecimalPoint, 10, includePlusSignIfPositive);
    }

    public static String formatFixedPointDecimalBase10(@Signed long value, @Nonnegative int numberOfDigitsAfterDecimalPoint) {
        return FormattingUtilities.formatFixedPointDecimalBase10(value, numberOfDigitsAfterDecimalPoint, false);
    }

    public static String formatFixedPointDecimalBase10Rounding(@Signed double value, @Nonnegative int numberOfDigitsAfterDecimalPoint, boolean includePlusSignIfPositive) {
        return FormattingUtilities.formatFixedPointDecimalBase10(Math.round(value * (double)SmallIntegerMathUtilities.pow(10, numberOfDigitsAfterDecimalPoint)), numberOfDigitsAfterDecimalPoint, includePlusSignIfPositive);
    }

    public static String formatFixedPointDecimalBase10Rounding(@Signed double value, @Nonnegative int numberOfDigitsAfterDecimalPoint) {
        return FormattingUtilities.formatFixedPointDecimalBase10(Math.round(value * (double)SmallIntegerMathUtilities.pow(10, numberOfDigitsAfterDecimalPoint)), numberOfDigitsAfterDecimalPoint, false);
    }

    public static int parseFixedPointS32(String s, int numberOfDigitsAfterDecimalPoint, int radix) throws NumberFormatException {
        int a = s.indexOf(46);
        if (a == -1) {
            int mul = SmallIntegerMathUtilities.pow(radix, numberOfDigitsAfterDecimalPoint);
            return Integer.parseInt(s, radix) * mul;
        }
        int b = s.indexOf(46, a + 1);
        if (b == -1) {
            String part0 = s.substring(0, a);
            String part1 = s.substring(a + 1);
            int l1 = part1.length();
            if (l1 > numberOfDigitsAfterDecimalPoint) {
                throw TextSyntaxException.inst();
            }
            int mulI = SmallIntegerMathUtilities.pow(radix, numberOfDigitsAfterDecimalPoint);
            int mulD = SmallIntegerMathUtilities.pow(radix, numberOfDigitsAfterDecimalPoint - l1);
            boolean negative = part0.startsWith("-");
            int partInt = Integer.parseInt(part0);
            int partDec = Integer.parseInt(part1);
            return partInt * mulI + (negative ? -1 : 1) * partDec * mulD;
        }
        throw new NumberFormatException("It had two or more decimal points!");
    }

    public static String formatNumberIntoBracketedScientificNotation(double value, int minSignificantDigits, int bracketSize, int base, String separator) {
        throw new NotYetImplementedException();
    }

    public static String formatNumberIntoBracketedScientificNotationRPConventions(double value, int minSignificantDigits) {
        return FormattingUtilities.formatNumberIntoBracketedScientificNotation(value, minSignificantDigits, 5, 10, " e");
    }

    public static String formatTimestamp(String pattern, long timestampMSUX, TimeZone timezone) {
        SimpleDateFormat f = new SimpleDateFormat(pattern);
        f.setTimeZone(timezone);
        return f.format(new Date(timestampMSUX));
    }

    public static String formatTimestampUTC(String pattern, long timestampMSUX) {
        return FormattingUtilities.formatTimestamp(pattern, timestampMSUX, CalendarUtilities.UTC);
    }

    public static String formatTimestampLocalTime(String pattern, long timestampMSUX) {
        return FormattingUtilities.formatTimestamp(pattern, timestampMSUX, TimeZone.getDefault());
    }

    public static String formatTimestampIntervalRPStandardUTC(ArithmeticIntegerInterval timestampIntervalMSUX) {
        long sizeMS = timestampIntervalMSUX.getSize();
        assert (sizeMS >= 0L);
        if (sizeMS <= 1L) {
            return FormattingUtilities.formatTimestampRPStandardMillisUTC(timestampIntervalMSUX.getStart());
        }
        if (sizeMS == 1000L) {
            return FormattingUtilities.formatTimestampRPStandardSecondsUTC(timestampIntervalMSUX.getStart());
        }
        if (sizeMS == 60000L) {
            return FormattingUtilities.formatTimestampRPStandardMinutesUTC(timestampIntervalMSUX.getStart());
        }
        if (sizeMS == 3600000L) {
            return FormattingUtilities.formatTimestampRPStandardHoursUTC(timestampIntervalMSUX.getStart());
        }
        if (sizeMS == 86400000L) {
            return FormattingUtilities.formatTimestampRPStandardDayofmonthUTC(timestampIntervalMSUX.getStart());
        }
        return "[" + FormattingUtilities.formatTimestampRPStandardMillisUTC(timestampIntervalMSUX.getStart()) + ", " + FormattingUtilities.formatTimestampRPStandardMillisUTC(timestampIntervalMSUX.getPastEnd()) + ")";
    }

    public static String formatTimestampRPStandardMillisUTC(long timestampMSUX) {
        return Timestamp_Format_RPStandard_toMillis_UTCShorthand.format(new Date(timestampMSUX));
    }

    public static String formatTimestampRPStandardMillisUTC_Now() {
        return FormattingUtilities.formatTimestampRPStandardMillisUTC(System.currentTimeMillis());
    }

    public static String formatTimestampRPStandardSecondsUTC(long timestampMSUX) {
        return Timestamp_Format_RPStandard_toSeconds_UTCShorthand.format(new Date(timestampMSUX));
    }

    public static String formatTimestampRPStandardSecondsUTC_Now() {
        return FormattingUtilities.formatTimestampRPStandardSecondsUTC(System.currentTimeMillis());
    }

    public static String formatTimestampRPStandardMinutesUTC(long timestampMSUX) {
        return Timestamp_Format_RPStandard_toMinutes_UTCShorthand.format(new Date(timestampMSUX));
    }

    public static String formatTimestampRPStandardMinutesUTC_Now() {
        return FormattingUtilities.formatTimestampRPStandardMinutesUTC(System.currentTimeMillis());
    }

    public static String formatTimestampRPStandardHoursUTC(long timestampMSUX) {
        return Timestamp_Format_RPStandard_toHours_UTCShorthand.format(new Date(timestampMSUX));
    }

    public static String formatTimestampRPStandardHoursUTC_Now() {
        return FormattingUtilities.formatTimestampRPStandardHoursUTC(System.currentTimeMillis());
    }

    public static String formatTimestampRPStandardDayofmonthUTC(long timestampMSUX) {
        return Timestamp_Format_RPStandard_toDayofmonth_UTCShorthand.format(new Date(timestampMSUX));
    }

    public static String formatTimestampRPStandardDayofmonthUTC_Now() {
        return FormattingUtilities.formatTimestampRPStandardDayofmonthUTC(System.currentTimeMillis());
    }

    public static String formatTimestampRPStandardMillisFullTimezone(long timestampMSUX, TimeZone timezone) {
        SimpleDateFormat f = Timestamp_Format_Pattern_RPStandard_toMillis_FullySpecifiedTimezone;
        f.setTimeZone(timezone);
        return f.format(new Date(timestampMSUX));
    }

    public static String formatTimestampRPStandardMillisFullTimezone_Now(TimeZone timezone) {
        return FormattingUtilities.formatTimestampRPStandardMillisFullTimezone(System.currentTimeMillis(), timezone);
    }

    public static String formatTimestampRPStandardDayofmonthFullTimezone(long timestampMSUX, TimeZone timezone) {
        SimpleDateFormat f = Timestamp_Format_Pattern_RPStandard_toDayofmonth_FullySpecifiedTimezone;
        f.setTimeZone(timezone);
        return f.format(new Date(timestampMSUX));
    }

    public static String formatTimestampRPStandardDayofmonthFullTimezone_Now(TimeZone timezone) {
        return FormattingUtilities.formatTimestampRPStandardDayofmonthFullTimezone(System.currentTimeMillis(), timezone);
    }

    @Nonnull
    public static Date parseDateInLinearTimeFormats(String s) throws TextSyntaxCheckedException {
        return new Date(FormattingUtilities.parseDateIntervalInLinearTimeFormats(s).getStart());
    }

    @Nullable
    public static Date parseDateInLinearTimeFormatsOrReturnNull(String s) {
        ArithmeticIntegerInterval r = FormattingUtilities.parseDateIntervalInLinearTimeFormatsOrReturnNull(s);
        return r == null ? null : new Date(r.getStart());
    }

    @Nonnull
    public static ArithmeticIntegerInterval parseDateIntervalInLinearTimeFormats(String s) throws TextSyntaxCheckedException {
        ArithmeticIntegerInterval r = FormattingUtilities.parseDateIntervalInLinearTimeFormatsOrReturnNull(s);
        if (r == null) {
            throw TextSyntaxCheckedException.inst();
        }
        return r;
    }

    @Nullable
    public static ArithmeticIntegerInterval parseDateIntervalInLinearTimeFormatsOrReturnNull(String s) {
        if (s.length() < 4) {
            return null;
        }
        if ((s = s.trim()).length() > 3) {
            String p = s.substring(0, 3);
            if (p.equalsIgnoreCase("UTC")) {
                return FormattingUtilities.parseLinearTimestampIntervalWithoutPrefix(s.substring(3), -3);
            }
            if (p.equalsIgnoreCase("TAI")) {
                throw new NotYetImplementedException();
            }
        }
        return null;
    }

    @Nonnull
    public static PairOrdered<String, TimeZone> parseOurTimeZoneSpecifierAndCanonicalizeWhitespaceAndTrim(String encodedDateString) {
        encodedDateString = StringUtilities.canonicalizeWhitespace(encodedDateString.trim());
        for (Map.Entry<String, TimeZone> e : TimeZonesByOurAndJREIds.entrySet()) {
            String s = e.getKey();
            if (!encodedDateString.endsWith(s)) continue;
            return new PairOrderedImmutable<String, TimeZone>(encodedDateString.substring(0, encodedDateString.length() - s.length()).trim(), e.getValue());
        }
        return new PairOrderedImmutable<String, Object>(encodedDateString, null);
    }

    @Nullable
    public static TimeZone parseOurTimeZoneSpecifierOrNull(String encodedDateString) {
        return FormattingUtilities.parseOurTimeZoneSpecifierAndCanonicalizeWhitespaceAndTrim(encodedDateString).getB();
    }

    @Nonnull
    public static TimeZone parseOurTimeZoneSpecifierOrThrow(String encodedDateString) {
        TimeZone t = FormattingUtilities.parseOurTimeZoneSpecifierOrNull(encodedDateString);
        if (t == null) {
            throw new IllegalArgumentException(StringUtilities.repr(encodedDateString));
        }
        return t;
    }

    @Nonnull
    public static Date parseDateInStandardFormatsExplicitTimezone(String s) throws TextSyntaxCheckedException {
        return new Date(FormattingUtilities.parseDateIntervalInImplicitStandardFormatsExplicitTimezone(s).getStart());
    }

    @Nonnull
    public static ArithmeticIntegerInterval parseDateIntervalInStandardFormatsExplicitTimezone(String s) throws TextSyntaxCheckedException {
        String[] p = StringUtilities.splitonce(s, ',');
        if (p.length == 2) {
            boolean highInclusive;
            boolean lowInclusive;
            String lowS = p[0];
            String highS = p[1];
            lowS = StringUtilities.trim(lowS);
            highS = StringUtilities.trim(highS);
            if (lowS.isEmpty()) {
                throw TextSyntaxCheckedException.inst();
            }
            char c = lowS.charAt(0);
            if (c == '(') {
                lowInclusive = false;
            } else if (c == '[') {
                lowInclusive = true;
            } else {
                throw TextSyntaxCheckedException.inst();
            }
            lowS = lowS.substring(1);
            if (highS.isEmpty()) {
                throw TextSyntaxCheckedException.inst();
            }
            char c2 = highS.charAt(highS.length() - 1);
            if (c2 == ')') {
                highInclusive = false;
            } else if (c2 == ']') {
                highInclusive = true;
            } else {
                throw TextSyntaxCheckedException.inst();
            }
            highS = highS.substring(0, highS.length() - 1);
            lowS = StringUtilities.trim(lowS);
            highS = StringUtilities.trim(highS);
            ArithmeticIntegerInterval low = FormattingUtilities.parseDateIntervalInImplicitStandardFormatsExplicitTimezone(lowS);
            ArithmeticIntegerInterval high = FormattingUtilities.parseDateIntervalInImplicitStandardFormatsExplicitTimezone(highS);
            Objects.requireNonNull(low);
            Objects.requireNonNull(high);
            return MathUtilities.intervalByIntervalExplicitBounds(low, lowInclusive, high, highInclusive);
        }
        return FormattingUtilities.parseDateIntervalInImplicitStandardFormatsExplicitTimezone(s);
    }

    @Nonnull
    public static ArithmeticIntegerInterval parseDateIntervalInImplicitStandardFormatsExplicitTimezone(String s) throws TextSyntaxCheckedException {
        ArithmeticIntegerInterval r = FormattingUtilities.parseDateIntervalInLinearTimeFormatsOrReturnNull(s = StringUtilities.canonicalizeWhitespace(s.trim()));
        if (r != null) {
            return r;
        }
        String u = s.toUpperCase();
        for (DatePatternAndIntervalSize f : ParsingFormatsFullySpecifiedTimezone) {
            try {
                return MathUtilities.intervalByPointAndSize(f.getPattern().parse(u).getTime(), f.getSizeInMilliseconds());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        for (DatePatternAndIntervalSize f : ParsingFormatsUTCShorthand) {
            try {
                return MathUtilities.intervalByPointAndSize(f.getPattern().parse(u).getTime(), f.getSizeInMilliseconds());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        PairOrdered<String, TimeZone> st = FormattingUtilities.parseOurTimeZoneSpecifierAndCanonicalizeWhitespaceAndTrim(s);
        s = st.getA();
        TimeZone tz = st.getB();
        if (tz == null) {
            throw TextSyntaxCheckedException.inst("Missing timezone!!: " + StringUtilities.repr(s));
        }
        for (DatePatternCodeAndIntervalSize f : FormattingUtilities.makeAllStandardDateParsingPatterns("")) {
            SimpleDateFormat df = new SimpleDateFormat(f.getPattern());
            df.setTimeZone(tz);
            try {
                return MathUtilities.intervalByPointAndSize(df.parse(u).getTime(), f.getSizeInMilliseconds());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        throw TextSyntaxCheckedException.inst("Not in a standard date/time format!!: " + StringUtilities.repr(s));
    }

    public static long parseLinearTimestampWithoutPrefix(String s, int destinationMultiplierExponent) throws NumberFormatException, OverflowException {
        return FormattingUtilities.parseLinearTimestampIntervalWithoutPrefix(s, destinationMultiplierExponent).getStart();
    }

    public static ArithmeticIntegerInterval parseLinearTimestampIntervalWithoutPrefix(String s, int destinationMultiplierExponent) throws NumberFormatException, OverflowException {
        int multiplierExponent;
        String p = s.trim();
        if (p.endsWith("s") || p.endsWith("S")) {
            if ((p = p.substring(0, p.length() - 1)).length() > 0) {
                char mc = p.charAt(p.length() - 1);
                if (Character.isDigit(mc)) {
                    multiplierExponent = 0;
                } else {
                    try {
                        int e;
                        multiplierExponent = e = FormattingUtilities.getBase10ExponentForSIMultiplierCharacter(mc);
                        p = p.substring(0, p.length() - 1).trim();
                    }
                    catch (IllegalArgumentException exc) {
                        multiplierExponent = 0;
                        p = p.trim();
                    }
                }
            } else {
                multiplierExponent = 0;
            }
        } else {
            multiplierExponent = 0;
        }
        if (p.indexOf(46) == -1) {
            long linearCount = Long.parseLong(p, 10);
            if (multiplierExponent < destinationMultiplierExponent) {
                double d = (double)linearCount / Math.pow(10.0, destinationMultiplierExponent - multiplierExponent);
                long t = Math.round(d);
                return MathUtilities.intervalByPointAndSize(t, 1L);
            }
            long multiplier = SmallIntegerMathUtilities.pow(10L, (long)(multiplierExponent - destinationMultiplierExponent));
            return MathUtilities.intervalByPointAndSize(SmallIntegerMathUtilities.safe_mul_s64(linearCount, multiplier), multiplier);
        }
        double linearCount = Double.parseDouble(p);
        double d = linearCount / Math.pow(10.0, destinationMultiplierExponent - multiplierExponent);
        long t = Math.round(d);
        return MathUtilities.intervalByPointAndSize(t, 1L);
    }

    public static Date parseDateISO8601(String s) throws ParseException {
        try {
            return BasicISO8601FormatUTC.getPattern().parse(s);
        }
        catch (ParseException exc) {
            return MillisecondsISO8601FormatUTC.getPattern().parse(s);
        }
    }

    public static String formatDateISO8601(Date d) {
        return BasicISO8601FormatUTC.getPattern().format(d);
    }

    public static String formatDateISO8601Millis(Date d) {
        return MillisecondsISO8601FormatUTC.getPattern().format(d);
    }

    @Nullable
    public static Date parseDateISO8601OrPassNull(@Nullable String s) throws ParseException {
        return s == null ? null : FormattingUtilities.parseDateISO8601(s);
    }

    @Nullable
    public static String formatDateISO8601OrPassNull(@Nullable Date d) {
        return d == null ? null : FormattingUtilities.formatDateISO8601(d);
    }

    @Nullable
    public static String formatDateISO8601MillisOrPassNull(@Nullable Date d) {
        return d == null ? null : FormattingUtilities.formatDateISO8601Millis(d);
    }

    public static String formatGregorianDayNumberToYMMDD(int dayNumber) {
        int[] r = GregorianCalendarCode.convertADGregorianDayNumberToYearMonthDayofmonth(dayNumber);
        return String.valueOf(r[0]) + "-" + StringUtilities.toTwoDigitStringWithLeadingZeroPad(r[1]) + "-" + StringUtilities.toTwoDigitStringWithLeadingZeroPad(r[2]);
    }

    public static List<DatePatternCodeAndIntervalSize> getAllStandardDateParsingPatterns(TimeZoneSpecifierType timeZoneSpecifierType) {
        ArrayList<DatePatternCodeAndIntervalSize> dateParsingPatterns = new ArrayList<DatePatternCodeAndIntervalSize>();
        if (timeZoneSpecifierType == TimeZoneSpecifierType.FullySpecified) {
            FormattingUtilities.addAllStandardDateParsingPatterns(" Z", dateParsingPatterns);
        } else if (timeZoneSpecifierType == TimeZoneSpecifierType.UTCShorthand) {
            FormattingUtilities.addAllStandardDateParsingPatterns(" 'Z'", dateParsingPatterns);
            FormattingUtilities.addAllStandardDateParsingPatterns("'Z'", dateParsingPatterns);
        }
        return dateParsingPatterns;
    }

    protected static void addAllStandardDateParsingPatterns(String timezoneSuffix, @WritableValue List<DatePatternCodeAndIntervalSize> patterns) {
        long[] SizesByDepth = new long[]{86400000L, 3600000L, 60000L, 1000L, 1L};
        String[] stringArray = new String[]{"G yyyy-MM-dd", "yyyy-MM-dd"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String datePart = stringArray[n2];
            int depth = 4;
            while (depth >= 0) {
                long sizeInMillis = SizesByDepth[depth];
                if (depth > 0) {
                    StringBuilder t = new StringBuilder();
                    if (depth > 0) {
                        t.append("HH");
                    }
                    if (depth > 1) {
                        t.append(":mm");
                    }
                    if (depth > 2) {
                        t.append(":ss");
                    }
                    if (depth > 3) {
                        t.append(".SSS");
                    }
                    String timePart = t.toString();
                    String[] stringArray2 = new String[]{" ", "'T'"};
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String separator = stringArray2[n4];
                        patterns.add(new DatePatternCodeAndIntervalSize(String.valueOf(datePart) + separator + timePart + timezoneSuffix, sizeInMillis));
                        ++n4;
                    }
                } else {
                    patterns.add(new DatePatternCodeAndIntervalSize(String.valueOf(datePart) + timezoneSuffix, sizeInMillis));
                }
                --depth;
            }
            ++n2;
        }
    }

    protected static List<DatePatternCodeAndIntervalSize> makeAllStandardDateParsingPatterns(String timezoneSuffix) {
        ArrayList<DatePatternCodeAndIntervalSize> r = new ArrayList<DatePatternCodeAndIntervalSize>();
        FormattingUtilities.addAllStandardDateParsingPatterns(timezoneSuffix, r);
        return r;
    }

    public static String truncateWithEllipsis(String s, int maxLengthIncl) {
        if (s.length() <= maxLengthIncl) {
            return s;
        }
        return String.valueOf(s.substring(0, maxLengthIncl - 3)) + "...";
    }

    public static Writer newIndentingWriter(final Writer underlying, boolean startingOnLineStart, final int indentAmount, final char indentChar) {
        return new Writer(startingOnLineStart){
            protected boolean onLineStart;
            {
                this.onLineStart = bl;
            }

            @Override
            public void write(char[] chars, int offset, int length) throws IOException {
                int i = 0;
                while (i < length) {
                    this.write(chars[i + offset]);
                    ++i;
                }
            }

            @Override
            public void write(int c) throws IOException {
                if (this.onLineStart) {
                    int i = 0;
                    while (i < indentAmount) {
                        underlying.write(indentChar);
                        ++i;
                    }
                }
                underlying.write(c);
                this.onLineStart = c == 10;
            }

            @Override
            public void flush() throws IOException {
                underlying.flush();
            }

            @Override
            public void close() throws IOException {
                underlying.close();
            }
        };
    }

    public static Writer newIndentingWriter(Writer underlying, boolean startingOnLineStart) {
        return FormattingUtilities.newIndentingWriter(underlying, startingOnLineStart, 1, '\t');
    }

    public static PrintWriter newIndentingPrintWriter(Writer underlying, boolean startingOnLineStart) {
        return new PrintWriter(FormattingUtilities.newIndentingWriter(underlying, startingOnLineStart, 1, '\t'));
    }

    public static String formatSimpleTableTextthings2DArray(Object[] table, int horizontalPadding) {
        int n;
        int l;
        int columnCount = ArrayUtilities.getAndValidateAllSameLengthSkippingNonarrays(table);
        int[] maxWidthsPerColumn = new int[columnCount];
        int totalTableWidth = 0;
        if (columnCount == -1) {
            totalTableWidth = 1;
        } else {
            int greatestLength;
            int columnIndex = 0;
            while (columnIndex < columnCount) {
                greatestLength = 0;
                Object[] objectArray = table;
                int n2 = table.length;
                int n3 = 0;
                while (n3 < n2) {
                    Object rowU = objectArray[n3];
                    if (rowU != null && !(rowU instanceof TableDividerLine)) {
                        Object[] row = (Object[])rowU;
                        int n4 = l = row[columnIndex] != null ? StringUtilities.getLength(row[columnIndex]) : 4;
                        if (l > greatestLength) {
                            greatestLength = l;
                        }
                    }
                    ++n3;
                }
                maxWidthsPerColumn[columnIndex] = greatestLength;
                ++columnIndex;
            }
            int[] nArray = maxWidthsPerColumn;
            n = maxWidthsPerColumn.length;
            greatestLength = 0;
            while (greatestLength < n) {
                int maxWidthForColumn = nArray[greatestLength];
                totalTableWidth += maxWidthForColumn + horizontalPadding;
                ++greatestLength;
            }
        }
        StringBuilder s = new StringBuilder();
        Object[] objectArray = table;
        int n5 = table.length;
        n = 0;
        while (n < n5) {
            Object rowU = objectArray[n];
            if (rowU != null) {
                if (rowU instanceof TableDividerLine) {
                    s.append(StringUtilities.mulnn(((TableDividerLine)rowU).getCharacter(), totalTableWidth));
                } else {
                    Object[] row = (Object[])rowU;
                    int columnIndex = 0;
                    while (columnIndex < columnCount) {
                        l = row[columnIndex] != null ? StringUtilities.getLength(row[columnIndex]) : 4;
                        StringUtilities.appendTextthing(s, row[columnIndex]);
                        s.append(StringUtilities.mulnn(' ', maxWidthsPerColumn[columnIndex] + horizontalPadding - l));
                        ++columnIndex;
                    }
                }
            }
            s.append('\n');
            ++n;
        }
        return s.toString();
    }

    public static Double parseDoubleOrNull(String s) {
        return s == null || s.isEmpty() ? null : Double.valueOf(Double.parseDouble(s));
    }

    public static Float parseFloatOrNull(String s) {
        return s == null || s.isEmpty() ? null : Float.valueOf(Float.parseFloat(s));
    }

    public static Long parseLongOrNull(String s) {
        return s == null || s.isEmpty() ? null : Long.valueOf(Long.parseLong(s));
    }

    public static Integer parseIntOrNull(String s) {
        return s == null || s.isEmpty() ? null : Integer.valueOf(Integer.parseInt(s));
    }

    public static Boolean parseBoolOrNull(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (s.equals("false")) {
            return false;
        }
        if (s.equals("true")) {
            return true;
        }
        throw TextSyntaxException.inst("Expected 'true' or 'false' but got : " + StringUtilities.repr(s));
    }

    public static boolean parseBool(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (s.equals("false")) {
            return false;
        }
        if (s.equals("true")) {
            return true;
        }
        throw TextSyntaxException.inst("Expected 'true' or 'false' but got : " + StringUtilities.repr(s));
    }

    public static int parseIntStandardSyntaxes(String s) throws NumberFormatException {
        if ((s = s.replace("_", "")).startsWith("0x")) {
            return Integer.parseUnsignedInt(s.substring(2), 16);
        }
        if (s.startsWith("-0x")) {
            return -Integer.parseUnsignedInt(s.substring(3), 16);
        }
        if (s.startsWith("0b")) {
            return Integer.parseUnsignedInt(s.substring(2), 2);
        }
        if (s.startsWith("-0b")) {
            return -Integer.parseUnsignedInt(s.substring(3), 2);
        }
        return Integer.parseInt(s, 10);
    }

    public static long parseLongStandardSyntaxes(String s) throws NumberFormatException {
        if ((s = s.replace("_", "")).startsWith("0x")) {
            return Long.parseUnsignedLong(s.substring(2), 16);
        }
        if (s.startsWith("-0x")) {
            return -Long.parseUnsignedLong(s.substring(3), 16);
        }
        if (s.startsWith("0b")) {
            return Long.parseUnsignedLong(s.substring(2), 2);
        }
        if (s.startsWith("-0b")) {
            return -Long.parseUnsignedLong(s.substring(3), 2);
        }
        return Long.parseLong(s, 10);
    }

    @ActuallyUnsigned
    public static int parseUIntStandardSyntaxes(String s) throws NumberFormatException {
        if (s.startsWith("0x")) {
            return Integer.parseUnsignedInt(s.substring(2), 16);
        }
        if (s.startsWith("-0x")) {
            return -Integer.parseUnsignedInt(s.substring(3), 16);
        }
        if (s.startsWith("0b")) {
            return Integer.parseUnsignedInt(s.substring(2), 2);
        }
        if (s.startsWith("-0b")) {
            return -Integer.parseUnsignedInt(s.substring(3), 2);
        }
        return Integer.parseUnsignedInt(s, 10);
    }

    @ActuallyUnsigned
    public static long parseULongStandardSyntaxes(String s) throws NumberFormatException {
        if (s.startsWith("0x")) {
            return Long.parseUnsignedLong(s.substring(2), 16);
        }
        if (s.startsWith("-0x")) {
            return -Long.parseUnsignedLong(s.substring(3), 16);
        }
        if (s.startsWith("0b")) {
            return Long.parseUnsignedLong(s.substring(2), 2);
        }
        if (s.startsWith("-0b")) {
            return -Long.parseUnsignedLong(s.substring(3), 2);
        }
        return Long.parseUnsignedLong(s, 10);
    }

    public static String byteToHexPair(int b) {
        char[] a = new char[]{Character.toUpperCase(Character.forDigit((b & 0xF0) >> 4, 16)), Character.toUpperCase(Character.forDigit(b & 0xF, 16))};
        return new String(a);
    }

    @PolyInteger
    public static Object parseIntegerStandardSyntaxes(String s) throws NumberFormatException {
        if ((s = s.replace("_", "")).startsWith("0x")) {
            return new BigInteger(s.substring(2), 16);
        }
        if (s.startsWith("-0x")) {
            return new BigInteger(s.substring(3), 16).negate();
        }
        if (s.startsWith("0b")) {
            return new BigInteger(s.substring(2), 2);
        }
        if (s.startsWith("-0b")) {
            return new BigInteger(s.substring(3), 2).negate();
        }
        return MathUtilities.parsePolyInteger(s);
    }

    @RationalOrInteger
    public static Object parseRationalOrIntegerStandardSyntaxes(String s) throws NumberFormatException {
        if (StringUtilities.contains(s = s.replace("_", ""), '.') || StringUtilities.contains(s, 'e') || StringUtilities.contains(s, 'E') || StringUtilities.contains(s, 'd') || StringUtilities.contains(s, 'D') || StringUtilities.contains(s, '/')) {
            return MathUtilities.parseRationalOrInteger(s);
        }
        return FormattingUtilities.parseIntegerStandardSyntaxes(s);
    }

    @RealNumeric
    public static Object parseRealNumberStandardSyntaxes(String s) throws NumberFormatException {
        if (StringUtilities.contains(s = s.replace("_", ""), '.') || StringUtilities.contains(s, 'e') || StringUtilities.contains(s, 'E') || StringUtilities.contains(s, 'd') || StringUtilities.contains(s, 'D')) {
            return Double.parseDouble(s);
        }
        if (StringUtilities.contains(s, '/')) {
            return MathUtilities.parseRationalOrInteger(s);
        }
        return FormattingUtilities.parseIntegerStandardSyntaxes(s);
    }

    public static Object defaultDecodeFromText(String valueTextForm, Class destClass) throws TextSyntaxException {
        if (valueTextForm == null) {
            if (destClass.isPrimitive()) {
                throw new NullPointerException();
            }
            return null;
        }
        if (destClass == String.class || destClass == CharSequence.class) {
            return valueTextForm;
        }
        if (destClass == char[].class) {
            return valueTextForm.toCharArray();
        }
        if (destClass == byte[].class || destClass == PrimitiveCollections.ImmutableByteArrayList.class || destClass == ByteBuffer.class) {
            byte[] b;
            try {
                b = DataEncodingUtilities.decodeHex(valueTextForm, 0);
            }
            catch (EOFException | InvalidInputCharacterException exc) {
                throw TextSyntaxException.inst(exc);
            }
            if (destClass == byte[].class) {
                return b;
            }
            if (destClass == PrimitiveCollections.ImmutableByteArrayList.class) {
                return PrimitiveCollections.ImmutableByteArrayList.newLIVE(b);
            }
            if (destClass == ByteBuffer.class) {
                return ByteBuffer.wrap(b);
            }
            throw new AssertionError();
        }
        if (Primitives.isIntegerPrimitiveOrWrapperClass(destClass) || destClass == BigInteger.class) {
            String v = valueTextForm.trim();
            if (Primitives.isIntegerPrimitiveWrapperClass(destClass) && (v.isEmpty() || BasicObjectUtilities.eq((Object)v.toLowerCase(), (Object)"null"))) {
                return null;
            }
            return FormattingUtilities.defaultDecodeIntegerFromText(v, destClass);
        }
        if (Primitives.isFloatingPrimitiveOrWrapperClass(destClass)) {
            String v = valueTextForm.trim();
            if (Primitives.isFloatingPrimitiveWrapperClass(destClass) && (v.isEmpty() || BasicObjectUtilities.eq((Object)v.toLowerCase(), (Object)"null"))) {
                return null;
            }
            return FormattingUtilities.defaultDecodeFloatFromText(valueTextForm, destClass);
        }
        if (destClass == Boolean.TYPE || destClass == Boolean.class) {
            String v = valueTextForm.trim();
            if (destClass == Boolean.class && (v.isEmpty() || BasicObjectUtilities.eq((Object)v.toLowerCase(), (Object)"null"))) {
                return null;
            }
            Boolean b = StringUtilities.parseBooleanLeniently(v);
            if (b == null) {
                throw TextSyntaxException.inst("Couldn't parse as boolean!:  " + StringUtilities.repr(valueTextForm));
            }
            return b;
        }
        if (destClass == Character.TYPE || destClass == Character.class) {
            String v = valueTextForm.trim();
            if (destClass == Character.class && (v.isEmpty() || BasicObjectUtilities.eq((Object)v.toLowerCase(), (Object)"null"))) {
                return null;
            }
            int n = valueTextForm.length();
            if (n != 1) {
                throw TextSyntaxException.inst("String was not a single character!!: it was " + n + " characters!:  " + StringUtilities.repr(valueTextForm));
            }
            return Character.valueOf(valueTextForm.charAt(0));
        }
        if (destClass == Date.class) {
            try {
                return FormattingUtilities.parseDateInStandardFormatsExplicitTimezone(valueTextForm);
            }
            catch (TextSyntaxCheckedException exc) {
                throw exc.toSyntaxRuntimeException();
            }
        }
        if (destClass.isEnum()) {
            return FormattingUtilities.defaultDecodeEnumFromText(valueTextForm, destClass);
        }
        if (destClass == Set.class || destClass == List.class || destClass == Collection.class || destClass == Iterable.class) {
            SimpleTable csvTable;
            SimpleTable<Object> simpleTable = csvTable = valueTextForm.isEmpty() ? CollectionUtilities.emptyTable() : CSVImplementation_Rebound.I.parse(valueTextForm);
            if (csvTable.getNumberOfRows() > 1) {
                throw TextSyntaxException.inst("Multiple lines encountered for what should just be a collection!!");
            }
            AbstractCollection collection = destClass == Set.class ? new HashSet() : new ArrayList();
            int columnCount = csvTable.getNumberOfColumns();
            int columnIndex = 0;
            while (columnIndex < columnCount) {
                String e = (String)csvTable.getCellContents(columnIndex, 0);
                e = e.trim();
                collection.add(e);
                ++columnIndex;
            }
            return collection;
        }
        throw new UnsupportedOptionException("Cannot infer decoding/parsing scheme (solely) from the destination Class " + destClass.getName());
    }

    public static Object defaultDecodeEnumFromText(String valueTextForm, Class<? extends Enum> destClass) throws TextSyntaxException {
        block13: {
            PrimitiveCollections.ImmutableByteArrayList uid;
            if ((valueTextForm = valueTextForm.trim()).isEmpty()) {
                return null;
            }
            valueTextForm = valueTextForm.toLowerCase();
            Enum[] enumArray = destClass.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum e = enumArray[n2];
                if (valueTextForm.equals(e.toString().trim().toLowerCase())) {
                    return e;
                }
                ++n2;
            }
            try {
                uid = UIDUtilities.parseString(valueTextForm);
            }
            catch (TextSyntaxException exc) {
                uid = null;
            }
            if (uid == null) break block13;
            if (SingletonWithUID.class.isAssignableFrom(destClass)) {
                Enum[] enumArray2 = destClass.getEnumConstants();
                int n3 = enumArray2.length;
                n = 0;
                while (n < n3) {
                    Enum e = enumArray2[n];
                    if (BasicObjectUtilities.eq((Object)uid, (Object)((SingletonWithUID)((Object)e)).getUID())) {
                        return e;
                    }
                    ++n;
                }
            } else {
                Field[] fieldArray = destClass.getFields();
                int n4 = fieldArray.length;
                n = 0;
                while (n < n4) {
                    PrimitiveCollections.ImmutableByteArrayList up;
                    UID u;
                    Field f = fieldArray[n];
                    if (f.isEnumConstant() && (u = f.getAnnotation(UID.class)) != null && BasicObjectUtilities.eq((Object)uid, (Object)(up = UIDUtilities.parseAnnotation(u)))) {
                        try {
                            return f.get(null);
                        }
                        catch (IllegalAccessException exc) {
                            throw new WrappedThrowableRuntimeException(exc);
                        }
                    }
                    ++n;
                }
            }
        }
        throw TextSyntaxException.inst("Didn't match (case-sensitively!) to any of the enum members of " + destClass.getName() + "!:  " + StringUtilities.repr(valueTextForm));
    }

    public static String defaultEncodeEnumToText(Object value) throws TextSyntaxException {
        Objects.requireNonNull(value);
        if (value instanceof SingletonWithUID) {
            return UIDUtilities.formatString(((SingletonWithUID)value).getUID());
        }
        if (value instanceof Enum) {
            Field[] fieldArray = value.getClass().getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (f.isEnumConstant()) {
                    Object v;
                    try {
                        v = f.get(null);
                    }
                    catch (IllegalAccessException exc) {
                        throw new WrappedThrowableRuntimeException(exc);
                    }
                    if (v == value) {
                        UID u = f.getAnnotation(UID.class);
                        if (u != null) {
                            PrimitiveCollections.ImmutableByteArrayList up = UIDUtilities.parseAnnotation(u);
                            return UIDUtilities.formatString(up);
                        }
                        return v.toString();
                    }
                }
                ++n2;
            }
            GlobalCodeMetastuffContext.logBug("Enum instance not found in its own class' fields!!:  Class=" + value.getClass().getName() + "  Instance=" + value);
        }
        return value.toString();
    }

    public static Object defaultDecodeIntegerFromText(String valueTextForm, Class destClass) throws TextSyntaxException {
        valueTextForm = valueTextForm.trim();
        try {
            if (Primitives.isIntegerPrimitiveOrWrapperClass(destClass)) {
                valueTextForm = valueTextForm.replace('\u2212', '-');
                long valueInt = Long.parseLong(valueTextForm);
                return Primitives.typeMassageAmongstIntegerPrimitives(valueInt, destClass, false);
            }
            if (destClass == BigInteger.class) {
                return new BigInteger(valueTextForm);
            }
            throw new UnsupportedOptionException("Destination type: " + destClass.getName());
        }
        catch (NumberFormatException exc) {
            throw TextSyntaxException.inst(exc);
        }
    }

    public static Object defaultDecodeFloatFromText(String valueTextForm, Class destClass) throws TextSyntaxException {
        valueTextForm = valueTextForm.trim();
        try {
            if (destClass == Double.class || destClass == Double.TYPE) {
                return Double.parseDouble(valueTextForm);
            }
            if (destClass == Float.class || destClass == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(valueTextForm));
            }
            throw new UnsupportedOptionException("Destination type: " + destClass.getName());
        }
        catch (NumberFormatException exc) {
            throw TextSyntaxException.inst(exc);
        }
    }

    public static String defaultEncodeToText(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number || value instanceof Rational || value instanceof CharSequence || value instanceof Boolean || value instanceof Character || value instanceof Enum) {
            return value.toString();
        }
        if (value instanceof Enum) {
            return FormattingUtilities.defaultEncodeEnumToText(value);
        }
        if (value instanceof byte[] || value instanceof PrimitiveCollections.ImmutableByteArrayList || value instanceof ByteBuffer) {
            int length;
            int offset;
            byte[] b;
            if (value instanceof ByteBuffer) {
                ByteBuffer valueC = (ByteBuffer)value;
                if (valueC.hasArray()) {
                    b = valueC.array();
                    offset = valueC.arrayOffset();
                    length = valueC.remaining();
                } else {
                    b = NIOBufferUtilities.copyToNewArray(valueC);
                    offset = 0;
                    length = b.length;
                }
            } else {
                if (value instanceof byte[]) {
                    b = (byte[])value;
                } else if (value instanceof PrimitiveCollections.ImmutableByteArrayList) {
                    b = ((PrimitiveCollections.ImmutableByteArrayList)value).getREADONLYLiveWholeArrayBackingUNSAFE();
                } else {
                    throw new AssertionError();
                }
                offset = 0;
                length = b.length;
            }
            return DataEncodingUtilities.encodeHexNoDelimiter(b, offset, length, 7);
        }
        if (value instanceof Date) {
            return FormattingUtilities.formatTimestampRPStandardMillisUTC(((Date)value).getTime());
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            int n = collection.size();
            SimpleTable<String> csvTable = CollectionUtilities.newTableNullfilled(n, 1);
            int i = 0;
            for (Object e : collection) {
                if (!(e instanceof CharSequence)) {
                    throw new UnsupportedOptionException("Cannot infer encoding scheme (solely) from the contents of the source collection\u2014they're not all strings!!   (source object was: " + StringUtilities.repr(value) + ")");
                }
                String s = ((CharSequence)e).toString();
                csvTable.setCellContents(i, 0, s);
                ++i;
            }
            return RCSV.serializeRCSV(csvTable);
        }
        throw new UnsupportedOptionException("Cannot infer encoding scheme (solely) from the source Class " + value.getClass().getName() + "   (source object was: " + StringUtilities.repr(value) + ")");
    }

    public static boolean isIntegerParseable(String s) {
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException exc) {
            return false;
        }
        return true;
    }

    public static boolean isRationalParseable(String s) {
        try {
            MathUtilities.parseRationalOrInteger(s);
        }
        catch (NumberFormatException exc) {
            return false;
        }
        return true;
    }

    public static int westernMonthNameToIndex(String n) {
        return WesternMonthNamesLC.indexOf(n.toLowerCase());
    }

    public static String westernIndexToMonthName(int i) throws IndexOutOfBoundsException {
        return WesternMonthNames.get(i);
    }

    public static int westernMonthNameToIndexThreeCharAbv(String n) {
        return WesternMonthNamesFirst3LC.indexOf(n.toLowerCase());
    }

    public static String westernIndexToMonthNameThreeCharAbv(int i) throws IndexOutOfBoundsException {
        return WesternMonthNamesFirst3.get(i);
    }

    public static int[] parseCalendarDate_MonthFullName_DayOfMonth_Year(String s) throws TextSyntaxCheckedException {
        int y;
        int d;
        String[] parts = StringUtilities.split(s, c -> Character.isWhitespace(c) || c == '-' || c == ',' || c == ':', -1, StringUtilities.WhatToDoWithEmpties.LeaveOutEmpties);
        if (parts.length != 3) {
            throw TextSyntaxCheckedException.inst();
        }
        int m = FormattingUtilities.westernMonthNameToIndex(parts[0]);
        try {
            d = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException exc) {
            throw TextSyntaxCheckedException.inst(exc);
        }
        try {
            y = Integer.parseInt(parts[2]);
        }
        catch (NumberFormatException exc) {
            throw TextSyntaxCheckedException.inst(exc);
        }
        return new int[]{y, m, d};
    }

    public static String formatCalendarDateYMD(int y, int m0based, int d1based) {
        return String.valueOf(y) + "-" + StringUtilities.toTwoDigitStringWithLeadingZeroPad(m0based + 1) + "-" + StringUtilities.toTwoDigitStringWithLeadingZeroPad(d1based);
    }

    public static String expandCapsedOrCamelCaseNameToWords(String n) {
        return StringUtilities.joinStrings(StringUtilities.splitBeforeEachChar(n, Character::isUpperCase), ' ');
    }

    public static class DefaultEnumDecoder<E> {
        protected final Map<String, E> decodingMap = new HashMap<String, E>();
        protected final StringUtilities.CaseSensitivity caseSensitivity;

        public DefaultEnumDecoder(StringUtilities.CaseSensitivity caseSensitivity, Class<? extends Enum> ... enumClasses) {
            this.caseSensitivity = caseSensitivity;
            Class<? extends Enum>[] classArray = enumClasses;
            int n = enumClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends Enum> enumClass = classArray[n2];
                Enum[] enumArray = enumClass.getEnumConstants();
                int n3 = enumArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Enum e = enumArray[n4];
                    String v = e.toString();
                    if (caseSensitivity == StringUtilities.CaseSensitivity.CaseINsensitive) {
                        v = v.toLowerCase();
                    }
                    this.decodingMap.put(v, e);
                    ++n4;
                }
                ++n2;
            }
        }

        @Nullable
        public E decode(String s) {
            if (this.caseSensitivity == StringUtilities.CaseSensitivity.CaseINsensitive) {
                s = s.toLowerCase();
            }
            return this.decodingMap.get(s);
        }

        @Nullable
        public E decodeMandatory(String s) throws TextSyntaxException {
            E e = this.decode(s);
            if (e == null) {
                throw TextSyntaxException.inst("Didn't match (case-sensitively!) to any of the enum members!:  " + StringUtilities.repr(s) + "  (Expected one of: " + StringUtilities.reprListContentsSingleLine(CollectionUtilities.sorted(this.decodingMap.keySet())) + ")");
            }
            return e;
        }
    }

    public static enum RoundedTextJustification {
        LEFT,
        RIGHT,
        CENTER_ERRINGON_LEFT,
        CENTER_ERRINGON_RIGHT,
        CENTER_ERRINGON_UNSPECIFIED;

    }

    public static class TableDividerLine {
        protected final char c;

        public TableDividerLine(char c) {
            this.c = c;
        }

        public char getCharacter() {
            return this.c;
        }
    }

    public static enum TextJustification {
        LEFT,
        RIGHT,
        CENTER;

    }

    public static enum TimeZoneSpecifierType {
        UTCShorthand,
        FullySpecified;

    }
}

