/*
 * Decompiled with CFR 0.152.
 */
package rebound.io.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class UniversalNewlineReader
extends FilterReader {
    protected boolean closed;
    protected boolean eof;
    protected boolean hasPush = false;
    protected char pushback;

    protected UniversalNewlineReader(Reader in) {
        super(in);
    }

    public static UniversalNewlineReader wrap(Reader in) {
        return in instanceof UniversalNewlineReader ? (UniversalNewlineReader)in : new UniversalNewlineReader(in);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream has already been closed.");
        }
        if (this.eof) {
            return -1;
        }
        int c1 = 0;
        if (this.hasPush) {
            c1 = this.pushback;
            this.hasPush = false;
        } else {
            c1 = this.in.read();
            if (c1 == -1) {
                this.eof = true;
                return -1;
            }
        }
        if (c1 == 13) {
            int c2 = this.in.read();
            if (c2 == -1) {
                this.eof = true;
                return 10;
            }
            if (c2 == 10) {
                return 10;
            }
            this.hasPush = true;
            this.pushback = (char)c2;
            return 10;
        }
        return c1;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream has already been closed.");
        }
        int c = 0;
        int i = 0;
        while (i < len) {
            c = this.read();
            if (c == -1) {
                return i == 0 ? -1 : i;
            }
            cbuf[off + i] = (char)c;
            ++i;
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException("Stream has already been closed.");
        }
        long i = 0L;
        while (i < n) {
            if (this.eof) {
                return i;
            }
            this.read();
            ++i;
        }
        return n;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            super.close();
        }
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

