/*
 * Decompiled with CFR 0.152.
 */
package rebound.dataformats.texttable.rcsv.impls;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Objects;
import rebound.dataformats.texttable.TextTableFormatImplementation;
import rebound.exceptions.NonrectangularException;
import rebound.exceptions.TextSyntaxException;
import rebound.util.collections.CollectionUtilities;
import rebound.util.collections.SimpleTable;

public enum RCSVImplementation_Rebound implements TextTableFormatImplementation
{
    I;


    @Override
    public void serializeToStream(SimpleTable<String> table, Appendable out) throws IOException {
        char delimiter = ',';
        int w = table.getNumberOfColumns();
        int h = table.getNumberOfRows();
        int rowIndex = 0;
        while (rowIndex < h) {
            int columnIndex = 0;
            while (columnIndex < w) {
                String cell = table.getCellContents(columnIndex, rowIndex);
                if (cell == null) {
                    throw new NullPointerException("Null cell at column " + columnIndex + ", row " + rowIndex + "  (zero-based indexes)");
                }
                out.append('\"');
                int n = cell.length();
                int i = 0;
                while (i < n) {
                    char c = cell.charAt(i);
                    if (c == '\"') {
                        out.append("\"\"");
                    } else {
                        out.append(c);
                    }
                    ++i;
                }
                out.append('\"');
                if (columnIndex < w - 1) {
                    out.append(delimiter);
                }
                ++columnIndex;
            }
            out.append('\n');
            ++rowIndex;
        }
    }

    @Override
    public SimpleTable<String> parseFromStream(Reader in) throws IOException, TextSyntaxException {
        block18: {
            boolean StateStart = false;
            boolean StateInsideCell = true;
            int StateInsideCellAfterOneDoubleQuoteEncountered = 2;
            int state = 0;
            StringBuilder cellBuffer = new StringBuilder();
            ArrayList<String> firstRow = new ArrayList<String>();
            SimpleTable<String> table = null;
            int width = 0;
            int column = 0;
            int row = 0;
            while (true) {
                int v;
                if ((v = in.read()) == -1) {
                    if (state == 0) {
                        if (firstRow == null) {
                            return Objects.requireNonNull(table);
                        }
                        if (firstRow.isEmpty()) {
                            return CollectionUtilities.newTable();
                        }
                        table = CollectionUtilities.newTableNullfilled(firstRow.size(), 1);
                        table.setRowFromList(0, firstRow);
                        return table;
                    }
                    throw TextSyntaxException.inst("Unexpected EOF!");
                }
                char c = (char)v;
                if (state == 0) {
                    if (c == '\"') {
                        state = 1;
                        continue;
                    }
                    throw TextSyntaxException.inst("Expected a '\"'");
                }
                if (state == 1) {
                    if (c == '\"') {
                        state = 2;
                        continue;
                    }
                    cellBuffer.append(c);
                    continue;
                }
                if (state != 2) break block18;
                if (c == '\"') {
                    cellBuffer.append('\"');
                    state = 1;
                    continue;
                }
                if (c != ',' && c != '\n') break;
                String cell = cellBuffer.toString();
                cellBuffer.setLength(0);
                if (firstRow != null) {
                    firstRow.add(cell);
                } else {
                    if (column >= width) {
                        throw TextSyntaxException.inst("Non-rectangular table encountered!  Row[" + row + "] has > " + width + " cells!!");
                    }
                    if (column == 0) {
                        table.appendEmptyRow();
                    }
                    table.setCellContents(column, row, cell);
                    ++column;
                }
                if (c == '\n') {
                    if (firstRow != null) {
                        width = firstRow.size();
                        table = CollectionUtilities.newTableNullfilled(width, 1);
                        table.setRowFromList(0, firstRow);
                        firstRow = null;
                    } else if (column != width) {
                        throw new NonrectangularException();
                    }
                    ++row;
                    column = 0;
                }
                state = 0;
            }
            throw TextSyntaxException.inst("Expected  '\"'  ','  or  '\\n'");
        }
        throw new AssertionError();
    }
}

