/*
 * Decompiled with CFR 0.152.
 */
package rebound.concurrency.threads;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import rebound.annotations.hints.IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser;
import rebound.annotations.hints.IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser;
import rebound.annotations.semantic.SignalType;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.annotations.semantic.temporal.concurrencyprimitives.threadspecification.AnyThreads;
import rebound.concurrency.threads.QueueIsShutdownException;
import rebound.util.BasicExceptionUtilities;
import rebound.util.functional.FunctionInterfaces;

@AnyThreads
@ThreadSafe
public interface GenericEventQueue {
    @AnyThreads
    public boolean isDispatchThread();

    @AnyThreads
    public void invokeLater(Runnable var1) throws QueueIsShutdownException;

    @AnyThreads
    @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
    default public void invokeLaterIfNotDispatchThreadOrRightNowIfSo(Runnable task) throws QueueIsShutdownException {
        if (this.isDispatchThread()) {
            task.run();
        } else {
            this.invokeLater(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThreads
    default public void invokeAndWaitOrFailIfDispatchThread(Runnable task) throws InvocationTargetException, QueueIsShutdownException {
        if (this.isDispatchThread()) {
            throw new IllegalStateException("This is the dispatch thread!!");
        }
        Object lock = new Object();
        boolean[] _complete = new boolean[1];
        Throwable[] _thrown = new Throwable[1];
        Object object = lock;
        synchronized (object) {
            this.invokeLater(() -> {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    throwableArray[0] = t;
                }
                Object object2 = lock;
                synchronized (object2) {
                    blArray[0] = true;
                    lock.notify();
                }
            });
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        while (true) {
            object = lock;
            synchronized (object) {
                if (!_complete[0]) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    break;
                }
            }
        }
        Throwable thrown = _thrown[0];
        if (thrown != null) {
            throw new InvocationTargetException(thrown);
        }
    }

    @AnyThreads
    default public void invokeAndWaitIfNotDispatchThreadOrRightNowIfSo(Runnable task) throws InvocationTargetException, QueueIsShutdownException {
        if (this.isDispatchThread()) {
            try {
                task.run();
            }
            catch (Throwable exc) {
                throw new InvocationTargetException(exc);
            }
        } else {
            this.invokeAndWaitOrFailIfDispatchThread(task);
        }
    }

    @SignalType
    public static interface ShutdownableQueue
    extends GenericEventQueue {
        public static final FunctionInterfaces.UnaryProcedure<List<Runnable>> DefaultRemnantsHandler = remnants -> {
            if (remnants != null) {
                for (Runnable task : remnants) {
                    try {
                        task.run();
                    }
                    catch (Throwable exc) {
                        BasicExceptionUtilities.rethrowIfFatalError(exc);
                        exc.printStackTrace();
                    }
                }
            }
        };

        @ReadonlyValue
        @ThrowAwayValue
        @Nullable
        @AnyThreads
        public List<Runnable> shutdown();

        @AnyThreads
        public boolean isShutdown();

        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        @AnyThreads
        default public void queueToShutdown(@Nonnull FunctionInterfaces.UnaryProcedure<List<Runnable>> callback) throws QueueIsShutdownException {
            Objects.requireNonNull(callback);
            this.invokeLater(() -> callback.f(this.shutdown()));
        }

        @AnyThreads
        default public void queueToShutdownIfNotDispatchThreadOrRightNowIfSo(@Nonnull FunctionInterfaces.UnaryProcedure<List<Runnable>> callback) throws QueueIsShutdownException {
            Objects.requireNonNull(callback);
            if (this.isDispatchThread()) {
                callback.f(this.shutdown());
            } else {
                this.queueToShutdown(callback);
            }
        }
    }
}

