/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Objects;
import javax.annotation.Nonnull;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.util.cli.ConsoleUtilities;
import rebound.util.functional.ContinueSignal;
import rebound.util.functional.FunctionInterfaces;

public class ConsoleLineReaderThread
extends Thread {
    protected final BufferedReader lineReader;
    @Nonnull
    protected final FunctionInterfaces.UnaryFunction<String, ContinueSignal> lineObserverInThisThread;

    public ConsoleLineReaderThread(@Nonnull BufferedReader lineReader, @Nonnull FunctionInterfaces.UnaryFunction<String, ContinueSignal> lineObserverInThisThread) {
        this.lineReader = Objects.requireNonNull(lineReader);
        this.lineObserverInThisThread = Objects.requireNonNull(lineObserverInThisThread);
        this.setDaemon(true);
        this.setName("Console Input Reader");
    }

    public ConsoleLineReaderThread(@Nonnull FunctionInterfaces.UnaryProcedure<String> lineObserverInThisThread) {
        this((String l) -> {
            lineObserverInThisThread.f((String)l);
            return ContinueSignal.Continue;
        });
    }

    public ConsoleLineReaderThread(@Nonnull FunctionInterfaces.UnaryFunction<String, ContinueSignal> lineObserverInThisThread) {
        this(ConsoleUtilities.newLineReaderForSTDIN(), lineObserverInThisThread);
    }

    public BufferedReader getLineReader() {
        return this.lineReader;
    }

    @Override
    public void run() {
        ContinueSignal s;
        String line;
        do {
            try {
                line = this.lineReader.readLine();
            }
            catch (IOException exc) {
                throw new WrappedThrowableRuntimeException(exc);
            }
        } while (line != null && (s = this.lineObserverInThisThread.f(line)) != ContinueSignal.Stop);
    }

    public static void startDaemonForShuttingDownAppUponAnyInput(Runnable shutdown) {
        new ConsoleLineReaderThread(l -> {
            shutdown.run();
            return ContinueSignal.Stop;
        }).start();
    }

    public static void waitInThisThreadUntilAnyInput() {
        try {
            new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }
}

