/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray;

import java.io.IOException;
import java.util.List;
import rebound.exceptions.ImpossibleException;
import rebound.jagent.lib.caos2pray.scanner.CosParser;
import rebound.text.StringUtilities;

public class CaosUtilitiesForJagent {
    protected static final String Delimiter = "\n\n******\n\n";

    public static CaosAndRemoveScript parse(String caos) {
        CosParser parser = new CosParser(caos);
        StringBuilder removeScript = new StringBuilder();
        StringBuilder otherCaos = new StringBuilder();
        while (true) {
            CosParser.Token t;
            try {
                t = parser.next();
            }
            catch (IOException exc) {
                throw new ImpossibleException(exc);
            }
            if (t == null) break;
            if (t.getType() == CosParser.TokenType.CAOS && t.getText().toLowerCase().contains("rscr")) {
                String beforeRemoveScriptPart = null;
                String removeScriptPart = null;
                String text = t.getText();
                int rscrPos = text.toLowerCase().indexOf("rscr");
                beforeRemoveScriptPart = text.substring(0, rscrPos);
                removeScriptPart = text.substring(rscrPos + 4);
                otherCaos.append(beforeRemoveScriptPart);
                removeScript.append(removeScriptPart);
                break;
            }
            otherCaos.append(t.getOriginalText());
        }
        return new CaosAndRemoveScript(removeScript.toString(), otherCaos.toString());
    }

    public static String mergeCaos(String a, String b) {
        return String.valueOf(a) + Delimiter + b;
    }

    public static String mergeCaosen(List<String> a) {
        return StringUtilities.joinStrings(a, (CharSequence)Delimiter);
    }

    public static class CaosAndRemoveScript {
        public final String removeScript;
        public final String otherCaos;

        public CaosAndRemoveScript(String removeScript, String otherCaos) {
            this.removeScript = removeScript;
            this.otherCaos = otherCaos;
        }
    }
}

