/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.caos2pray.scanner;

import java.io.IOException;
import java.util.ArrayList;
import rebound.jagent.lib.caos2pray.TemplateConverter;
import rebound.jagent.lib.caos2pray.exc.C2PSyntaxException;
import rebound.jagent.lib.caos2pray.exc.NotIntegerTagException;
import rebound.jagent.lib.caos2pray.scanner.C2PCosFile;
import rebound.jagent.lib.caos2pray.scanner.CosParser;

public class C2PParser {
    public static final char DIRECTIVE_INITIATOR = '#';
    protected CosParser parser;
    protected C2PCosFile c2p;

    public C2PParser() {
    }

    public C2PParser(CosParser p) {
        this();
        this.init(p);
    }

    public void init(CosParser rawparser) {
        this.parser = rawparser;
        this.c2p = new C2PCosFile();
    }

    public void scan() throws IOException, NotIntegerTagException, C2PSyntaxException {
        CosParser.Token t;
        while ((t = this.parser.next()) != null) {
            CosParser.Token first;
            if (t.getType() == CosParser.TokenType.COMMENT) {
                String val = t.getText();
                if (val.length() < 1 || val.charAt(0) != '#') continue;
                this.handleDirective(val.substring(1));
                continue;
            }
            if (t.getType() != CosParser.TokenType.CAOS || !t.getText().toLowerCase().contains("rscr")) continue;
            String removeScriptPart = null;
            int rscrPos = t.getText().toLowerCase().indexOf("rscr");
            removeScriptPart = t.getText().substring(rscrPos + 4);
            StringBuilder rscr = new StringBuilder();
            CosParser.Token n = first = new CosParser.Token(CosParser.TokenType.CAOS, removeScriptPart);
            while (n != null) {
                if (n.getType() != CosParser.TokenType.COMMENT) {
                    int endmPos;
                    if (n.getType() == CosParser.TokenType.CAOS && (endmPos = n.getText().toLowerCase().indexOf("endm")) != -1) {
                        String leftover = n.getText().substring(0, endmPos);
                        rscr.append(leftover);
                        break;
                    }
                    rscr.append(n.getOriginalText());
                }
                n = this.parser.next();
            }
            this.c2p.setCAOSRemoveScript(rscr.toString().trim());
            break;
        }
    }

    protected void handleDirective(String directive) throws NotIntegerTagException, C2PSyntaxException {
        if ((directive = directive.trim()).length() >= 3) {
            String cmd = TemplateConverter.getCommand(directive);
            if (cmd != null) {
                String[] args = C2PParser.parseCommandArgs(directive, cmd.length());
                this.c2p.addCommand(cmd, args);
            } else {
                int mid = directive.indexOf("=");
                if (mid == -1) {
                    throw new C2PSyntaxException("Tag directive is missing '=':    *#" + directive);
                }
                if (mid > 0 && mid < directive.length() - 1) {
                    String name = directive.substring(0, mid).trim();
                    String val = directive.substring(mid + 1).trim();
                    if (val.length() > 0) {
                        char post = val.charAt(0);
                        if (post == '\"') {
                            if (val.length() < 2) {
                                throw new C2PSyntaxException("Missing end quote at:    *#" + directive);
                            }
                            if (val.charAt(val.length() - 1) != '\"') {
                                throw new C2PSyntaxException("Missing end quote at:    *#" + directive);
                            }
                            this.c2p.addStringTag(name, C2PParser.descapeQuotedString(val.substring(1, val.length() - 1)));
                        } else {
                            try {
                                this.c2p.addIntegerTag(name, Integer.parseInt(val));
                            }
                            catch (NumberFormatException exc) {
                                throw new NotIntegerTagException(name);
                            }
                        }
                    }
                }
            }
        }
    }

    protected static String[] parseCommandArgs(String directive, int offset) throws C2PSyntaxException {
        ArrayList<String> args = new ArrayList<String>();
        char[] cd = directive.toCharArray();
        int i = offset;
        while (true) {
            int start;
            if (i < cd.length && Character.isWhitespace(cd[i])) {
                ++i;
                continue;
            }
            if (i >= cd.length) break;
            if (cd[i] == '\"') {
                start = ++i;
                while (true) {
                    if (i >= cd.length) {
                        throw new C2PSyntaxException("You left off the end quote of the last quoted-argument at:    *#" + directive);
                    }
                    if (cd[i] == '\\') {
                        i += 2;
                        continue;
                    }
                    if (cd[i] == '\"') break;
                    ++i;
                }
                String raw = new String(cd, start, ++i - start - 1);
                String descaped = C2PParser.descapeQuotedString(raw);
                args.add(descaped);
                continue;
            }
            start = i;
            while (i < cd.length && !Character.isWhitespace(cd[i])) {
                ++i;
            }
            args.add(new String(cd, start, i - start));
        }
        return args.toArray(new String[args.size()]);
    }

    protected static String descapeQuotedString(String raw) {
        char c = '\u0000';
        StringBuilder prettyVal = new StringBuilder();
        int i = 0;
        i = 0;
        while (i < raw.length()) {
            c = raw.charAt(i);
            if (c == '\\' && i < raw.length() - 1) {
                if ((c = raw.charAt(++i)) == 'n') {
                    prettyVal.append('\n');
                } else {
                    prettyVal.append(c);
                }
            } else {
                prettyVal.append(c);
            }
            ++i;
        }
        return prettyVal.toString();
    }

    public C2PCosFile getC2PCosFile() {
        return this.c2p;
    }
}

