/*
 * Decompiled with CFR 0.152.
 */
package rebound.dataformats.texttable;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.TextSyntaxException;
import rebound.util.collections.SimpleTable;

public interface TextTableFormatImplementation {
    @ThrowAwayValue
    public SimpleTable<String> parseFromStream(Reader var1) throws IOException, TextSyntaxException;

    public void serializeToStream(@ReadonlyValue SimpleTable<String> var1, Appendable var2) throws IOException;

    @ThrowAwayValue
    default public SimpleTable<String> parse(String encoded) throws TextSyntaxException {
        try {
            return this.parseFromStream(new StringReader(encoded));
        }
        catch (IOException exc) {
            throw new ImpossibleException(exc);
        }
    }

    default public String serialize(@ReadonlyValue SimpleTable<String> table) {
        try {
            StringWriter out = new StringWriter();
            this.serializeToStream(table, out);
            return ((Object)out).toString();
        }
        catch (IOException exc) {
            throw new ImpossibleException(exc);
        }
    }

    @ThrowAwayValue
    default public SimpleTable<String> parseFromStreamUTF8(InputStream in) throws TextSyntaxException, IOException {
        return this.parseFromStream(new InputStreamReader(in));
    }

    default public void serializeToStreamUTF8(@ReadonlyValue SimpleTable<String> table, OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        this.serializeToStream(table, w);
        ((Writer)w).flush();
    }

    @ThrowAwayValue
    default public SimpleTable<String> parseFromFileUTF8(File encoded) throws TextSyntaxException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream in = new FileInputStream(encoded);){
            return this.parseFromStreamUTF8(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    default public void serializeToFileUTF8(@ReadonlyValue SimpleTable<String> table, File out) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream in = new FileOutputStream(out);){
            this.serializeToStreamUTF8(table, in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

